/*
 * Copyright 1999 by Brown University Computer Science
 * 115 Waterman Street, 4th Floor, Providence, Rhode Island, 02906, U.S.A
 * All rights reserved.
 *
 * Permission is hereby granted for free use and modification of this
 * software.  However, this copyright must remain at all times.
 * Re-distribution is restricted to those with the express written consent
 * of the copyright holder.  Permission can be obtained by mailing
 * cs015headtas@cs.brown.edu.  
 */

package NGP.Components;

import javax.swing.JMenuItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;


/**
  * An item in an NGP.Components.Menu.  It is a subclass of the Swing JMenuItem
  * class.  Easily add MenuItems to an NGP.Components.Menu by simply creating
  * them in the menu's constructor and passing that menu to the item's 
  * constructor.
  *
  * @see NGP.Components.Menu
  * @see NGP.Components.MenuBar
  * @see <a href="http://java.sun.com/products/jdk/1.2/docs/api/javax/swing/JMenuItem.html">javax.swing.JMenuItem</a>
  *
  * @author Brent Shields (<a href="mailto:bshields@cs.brown.edu">bshields</a>)
  */

public class MenuItem extends JMenuItem implements NGP.Component {

  /**
    * Create the menu item.
    *
    * @param menu the menu in which this menu item will appear
    * @param name the string that will appear on the menu as the name of this item
    */
  public MenuItem(NGP.Components.Menu menu, String name) {
    super(name);

    this.addActionListener(new ItemListener());
    
    menu.add(this);
  }

  /**
    * Set the preferred dimensions of this Component.
    *
    * @param d the <code>Dimension</code> for this <code>Component</code>.
    * @see #getDimension() getDimension
    */
  public void setDimension(java.awt.Dimension d) {
    this.setPreferredSize(d);
  }

  /**
    * Get the preferred dimensions of this Component.
    *
    * @return the preferred <code>Dimension</code> of this
    * <code>Component</code>.
    * @see #setDimension(java.awt.Dimension) setDimension
    */
  public java.awt.Dimension getDimension() {
    return this.getPreferredSize();
  }

  /**
    * Called when this item is selected from its menu.  Override this method 
    * to make it do something useful.
    */
  public void itemSelected() { }

  /**
    * This inner-class is a listener for the menu item. It detects when the 
    * user clicks over the menu item and then calls the {@link itemSelected() itemSelected} 
    * method of this menu item.
    */
  private class ItemListener implements ActionListener {
    public void actionPerformed(ActionEvent e) {
      itemSelected();
    }
  }
}
