/*
 * Copyright 1999 by Brown University Computer Science
 * 115 Waterman Street, 4th Floor, Providence, Rhode Island, 02906, U.S.A
 * All rights reserved.
 *
 * Permission is hereby granted for free use and modification of this
 * software.  However, this copyright must remain at all times.
 * Re-distribution is restricted to those with the express written consent
 * of the copyright holder.  Permission can be obtained by mailing
 * cs015headtas@cs.brown.edu.  
 */

package NGP.Components;

//an import statement means I can refer to a class as if I specified the
//whole package
import javax.swing.JLabel;

/**
 * A simple text label.  It is a subclass of the Swing JLabel with
 * the only addition being that it immediately knows about its container.
 * Use this when you simply need a text label.
 *
 * @see <a href="http://java.sun.com/products/jdk/1.2/docs/api/javax/swing/JLabel.html">javax.swing.JLabel</a>
 *
 * @author Matt Chotin (<a href="mailto:mhc@cs.brown.edu">mhc</a>)
 */

public class Label extends JLabel implements NGP.Component {

  /**
   * This creates the label.
   * @param container the graphical container for the label
   * @param label the string for the label to display
   */
  public Label(NGP.Container container, String label) {
    super(label);

    container.add(this);
  }

  //Added By Brent Shields 6-11-99

  /**
    * This creates a blank label.
    * @param container the graphical container for the label
    */
  public Label(NGP.Container container) {
    super();
    
    container.add(this);
  }

  /**
   * Set the preferred dimensions of this Component.
   *
   * @param d the <code>Dimension</code> for this <code>Component</code>.
   * @see #getDimension() getDimension
   */
  public void setDimension(java.awt.Dimension d) {
    this.setPreferredSize(d);
  }

  /**
   * Get the preferred dimensions of this Component.
   *
   * @return the preferred <code>Dimension</code> of this
   * <code>Component</code>.
   * @see #setDimension(java.awt.Dimension) setDimension
   */
  public java.awt.Dimension getDimension() {
    return this.getPreferredSize();
  }
}


