/*
 * Copyright 1999 by Brown University Computer Science
 * 115 Waterman Street, 4th Floor, Providence, Rhode Island, 02906, U.S.A
 * All rights reserved.
 *
 * Permission is hereby granted for free use and modification of this
 * software.  However, this copyright must remain at all times.
 * Re-distribution is restricted to those with the express written consent
 * of the copyright holder.  Permission can be obtained by mailing
 * cs015headtas@cs.brown.edu.  
 */

package NGP;

/**
 * Specifies that all implementing classes can have their locations and
 * dimensions accessed and modified, plus control whether they are
 * enabled or disabled.  A Component is generally an object like a
 * button or a slider, not a Graphic which draws itself in a
 * DrawingPanel.
 *
 * @author Matt Chotin (<a href="mailto:mhc@cs.brown.edu">mhc</a>)
 */

public interface Component extends Locatable, Sizeable {

  /**
   * Indicates whether the <code>Component</code> should be enabled
   * or disabled.
   *
   * @param enabled <code>true</code> if you want this enabled, <code>
   * false</code> otherwise
   */
  public void setEnabled(boolean enabled);

}
