/*
 * Decompiled with CFR 0.152.
 */
package ogi.diom.util;

import java.io.BufferedInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.MalformedURLException;
import java.net.URL;

public class URLRetriever {
    URL url;
    String contents = "initial";

    public URLRetriever(String string) throws MalformedURLException {
        this.url = new URL(string);
    }

    public URLRetriever(URL uRL) {
        this.url = uRL;
    }

    public String getBody() {
        this.retrieve();
        this.stripHeader();
        this.stripFooter();
        return this.contents;
    }

    public String getContents() {
        if (this.contents.equals("initial")) {
            return this.retrieve();
        }
        return this.contents;
    }

    public static void main(String[] stringArray) {
        try {
            URLRetriever uRLRetriever = new URLRetriever(new URL("http://altavista.digital.com"));
            System.out.println("before:\n" + uRLRetriever.getContents() + "\n");
            System.out.println("after:\n\n" + uRLRetriever.retrieve());
            System.out.println("after strip all:\n\n" + uRLRetriever.stripAll());
        }
        catch (MalformedURLException malformedURLException) {
            System.out.println("Error: " + malformedURLException);
        }
    }

    public String retrieve() {
        try {
            StringBuffer stringBuffer = new StringBuffer(4096);
            BufferedInputStream bufferedInputStream = new BufferedInputStream((InputStream)this.url.getContent());
            InputStreamReader inputStreamReader = new InputStreamReader(bufferedInputStream);
            LineNumberReader lineNumberReader = new LineNumberReader(inputStreamReader);
            String string = lineNumberReader.readLine();
            while (string != null) {
                stringBuffer.append(String.valueOf(string) + "\n");
                string = lineNumberReader.readLine();
            }
            this.contents = stringBuffer.toString();
            lineNumberReader.close();
            inputStreamReader.close();
            ((FilterInputStream)bufferedInputStream).close();
        }
        catch (IOException iOException) {
            System.out.println("Error in URLRetriever.retrieve: " + iOException);
        }
        return this.contents;
    }

    public String stripAll() {
        this.stripHeader();
        this.stripFooter();
        this.stripImages();
        this.stripMaps();
        return this.contents;
    }

    public String stripFooter() {
        int n = this.contents.indexOf("</body>");
        int n2 = this.contents.indexOf("</BODY>");
        if (n2 > n) {
            n = n2;
        }
        if (n < 0) {
            System.out.println("\nWarning -- no footer ----\n");
            return this.contents;
        }
        this.contents = this.contents.substring(0, n);
        return this.contents;
    }

    public String stripHeader() {
        int n = this.contents.indexOf("</HEAD>");
        int n2 = this.contents.indexOf("</head>");
        n = n2 > n ? n2 + 7 : (n += 7);
        if (n < 0) {
            System.out.println("\nWarning -- no header----\n");
            return this.contents;
        }
        this.contents = this.contents.substring(n);
        n = this.contents.indexOf("<BODY");
        n2 = this.contents.indexOf("<body");
        if (n2 > n) {
            n = n2;
        }
        if (n < 0) {
            System.out.println("\n\n\n\n\n\n\n\n\n\nWarning -- no header----\n\n\n\n");
            return this.contents;
        }
        n2 = this.contents.indexOf(">", n);
        if (n2 < 0) {
            return this.contents;
        }
        this.contents = String.valueOf(this.contents.substring(0, n)) + this.contents.substring(n2 + 1);
        return this.contents;
    }

    public String stripIframe() {
        int n = this.contents.indexOf("<iframe");
        int n2 = this.contents.indexOf("<IFRAME");
        if (n2 > n) {
            n = n2;
        }
        while (n >= 0) {
            int n3;
            n2 = this.contents.indexOf("</iframe>", n);
            int n4 = Math.min(n2, n3 = this.contents.indexOf("</IFRAME>", n));
            if (n4 < 0 && (n4 = Math.max(n2, n3)) < 0) break;
            this.contents = String.valueOf(this.contents.substring(0, n)) + this.contents.substring(n4 + 9);
            n = this.contents.indexOf("<iframe");
            n2 = this.contents.indexOf("<IFRAME");
            if (n2 <= n) continue;
            n = n2;
        }
        return this.contents;
    }

    public String stripImages() {
        int n = this.contents.indexOf("<IMG");
        int n2 = this.contents.indexOf("<img");
        if (n2 > n) {
            n = n2;
        }
        while (n >= 0) {
            n2 = this.contents.indexOf(">", n);
            if (n2 < 0) break;
            this.contents = String.valueOf(this.contents.substring(0, n)) + this.contents.substring(n2 + 1);
            n = this.contents.indexOf("<IMG");
            n2 = this.contents.indexOf("<img");
            if (n2 <= n) continue;
            n = n2;
        }
        return this.contents;
    }

    public String stripMaps() {
        int n = this.contents.indexOf("<MAP");
        int n2 = this.contents.indexOf("<map");
        if (n2 > n) {
            n = n2;
        }
        while (n >= 0) {
            int n3;
            n2 = this.contents.indexOf("</MAP>", n);
            int n4 = Math.min(n2, n3 = this.contents.indexOf("</map>", n));
            if (n4 < 0 && (n4 = Math.max(n2, n3)) < 0) break;
            this.contents = String.valueOf(this.contents.substring(0, n)) + this.contents.substring(n4 + 6);
            n = this.contents.indexOf("<MAP");
            n2 = this.contents.indexOf("<map");
            if (n2 <= n) continue;
            n = n2;
        }
        return this.contents;
    }
}

