/*
 * Decompiled with CFR 0.152.
 */
package ogi.diom.util;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import ogi.diom.router.SourceProfile;
import ogi.diom.util.Utils;

public class SourceLoader {
    Hashtable profileSet;
    Hashtable relationSet;
    Hashtable attributeMap;
    Hashtable constraintMap;
    String servletURLString;
    String SourceProfileServer;
    int SourceProfilePort;
    int state;
    int method;
    public static final int EMPTY = 1;
    public static final int PROFILES_LOADED = 2;
    public static final int SOURCES_LOADED = 3;
    public static final int BOTH_LOADED = 4;
    public static final int LOADED = 4;
    public static final int UNKNOWN = 0;
    public static final int SERVLET = 1;
    public static final int SOCKET = 2;
    public static final PrintStream o = System.out;
    static final String rtrQryString = new String("SELECT id, name, type, pointer, keywords FROM demo_repos_list ORDER BY id");
    private String[][] srcTable = null;
    private boolean[] srcCheck;
    private boolean[] srcManualCheck;
    private int id_col_num = 0;
    private int kwd_col_num = 0;
    private String log;

    public SourceLoader() {
        this.state = 1;
        this.method = 0;
    }

    public SourceLoader(String string) {
        this.servletURLString = String.valueOf(string) + "/router";
        this.state = 1;
        this.method = 1;
        this.newLog();
    }

    public SourceLoader(String string, String string2) {
        this.SourceProfileServer = new String(string);
        this.SourceProfilePort = Integer.parseInt(string2);
        this.state = 1;
        this.method = 2;
        this.newLog();
    }

    void addSource(String string) {
        SourceProfile sourceProfile = SourceProfile.decode((String)string);
        if (this.profileSet == null) {
            this.profileSet = new Hashtable();
        }
        this.profileSet.put(sourceProfile.getID(), sourceProfile);
        this.log = String.valueOf(this.log) + "2\tAdded profile: " + sourceProfile.getCategory() + "\n";
    }

    public String getLog() {
        return this.log;
    }

    public int getMethod() {
        return this.method;
    }

    public Hashtable getProfiles() {
        return this.profileSet;
    }

    public String[][] getSrcTable() {
        return this.srcTable;
    }

    public int getState() {
        return this.state;
    }

    public boolean isLoaded() {
        return this.state == 4;
    }

    public void loadSourceInformation() {
        try {
            this.newSrcTable();
            this.log = String.valueOf(this.log) + "3Source information completed loading\n";
            this.state = this.state == 2 ? 4 : 3;
        }
        catch (Exception exception) {}
    }

    public void loadSources() {
        Object object;
        String string = new String();
        if (this.method == 2) {
            try {
                this.log = String.valueOf(this.log) + "1\tLoading source profiles\n";
                object = new Socket(this.SourceProfileServer, this.SourceProfilePort);
                if (object == null) {
                    o.println("null socket");
                }
                DataInputStream dataInputStream = new DataInputStream(((Socket)object).getInputStream());
                DataOutputStream dataOutputStream = new DataOutputStream(((Socket)object).getOutputStream());
                dataOutputStream.writeBytes("read sources\n");
                try {
                    while (true) {
                        byte[] byArray = new byte[1];
                        dataInputStream.readFully(byArray);
                        string = String.valueOf(string) + (char)byArray[0];
                    }
                }
                catch (Exception exception) {
                    dataInputStream.close();
                    dataOutputStream.close();
                    ((Socket)object).close();
                    this.log = String.valueOf(this.log) + "3Source profiles completed loading\n";
                    this.state = this.state == 3 ? 4 : 2;
                    this.loadSourceInformation();
                }
            }
            catch (UnknownHostException unknownHostException) {
                System.exit(1);
            }
            catch (IOException iOException) {}
        } else {
            this.log = String.valueOf(this.log) + "1\tLoading source profiles\n";
            string = Utils.readData(this.servletURLString, "read_sources\n");
            this.log = String.valueOf(this.log) + "3Source profiles completed loading\n";
            object = Utils.readData(this.servletURLString, "source_table\n");
            this.log = String.valueOf(this.log) + "3Source repository information completed loading\n";
            this.srcTable = Utils.stringToTable((String)object);
            this.log = String.valueOf(this.log) + "4Source repository information converted to table\n";
        }
        new String();
        object = new StringTokenizer(string, "|");
        while (((StringTokenizer)object).hasMoreTokens()) {
            this.addSource(((StringTokenizer)object).nextToken());
        }
    }

    public void newLog() {
        this.log = new String("0Source Loader Log Information\n");
    }

    public void newSrcParameters() {
        this.newSrcTable();
        this.setColNums();
    }

    public void newSrcTable() {
        if (this.srcTable == null) {
            this.srcTable = Utils.getCGIData(Utils.cgiURLString, rtrQryString);
        }
    }

    public void setColNums() {
        if (this.srcTable == null || this.srcTable.length == 0 || this.srcTable[0] == null) {
            return;
        }
        this.log = String.valueOf(this.log) + "2\t\tSearching for appropriate fields in Repositories\n";
        this.id_col_num = Utils.findKwdColumn(this.srcTable, "ID");
        this.kwd_col_num = Utils.findKwdColumn(this.srcTable, "KEYWORD");
        this.log = String.valueOf(this.log) + "3\t\t\tID field number " + this.id_col_num + "\n";
        this.log = String.valueOf(this.log) + "3\t\t\tKEYWORD field number " + this.kwd_col_num + "\n";
    }
}

