/*
 * Decompiled with CFR 0.152.
 */
package ogi.cq.util;

import java.io.File;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.Date;

public class WebServerHealthMonitor {
    public static final int SECOND = 1000;
    public static final int MINUTE = 60000;
    public static final int FIVE_MINUTES = 300000;

    public static void main(String[] stringArray) {
        if (stringArray.length != 4) {
            WebServerHealthMonitor.usage();
            System.exit(0);
        }
        URL uRL = null;
        try {
            uRL = new URL(stringArray[0]);
            System.out.println(uRL);
        }
        catch (Exception exception) {
            System.out.println("Invalid URL: " + stringArray[0]);
            System.out.println(exception);
            WebServerHealthMonitor.usage();
            System.exit(0);
        }
        int n = 0;
        try {
            n = Integer.parseInt(stringArray[1]);
        }
        catch (Exception exception) {
            System.out.println("Invalid timeout value: " + stringArray[1]);
            System.out.println(exception);
            WebServerHealthMonitor.usage();
            System.exit(0);
        }
        File file = null;
        try {
            file = new File(stringArray[2]);
        }
        catch (Exception exception) {
            System.out.println("Invalid shutdown script: " + stringArray[2]);
            System.out.println(exception);
            WebServerHealthMonitor.usage();
            System.exit(0);
        }
        File file2 = null;
        try {
            file2 = new File(stringArray[3]);
        }
        catch (Exception exception) {
            System.out.println("Invalid shutdown script: " + stringArray[3]);
            System.out.println(exception);
            WebServerHealthMonitor.usage();
            System.exit(0);
        }
        boolean bl = true;
        int n2 = 0;
        while (bl && n2 < 10) {
            ++n2;
            try {
                URLConnection uRLConnection = uRL.openConnection();
                System.out.println("Content length:" + uRLConnection.getContentLength());
                uRLConnection.getContent();
                System.out.println(String.valueOf(uRL.toString()) + "  running at: " + new Date());
                bl = false;
            }
            catch (Exception exception) {
                Object object;
                System.out.println(String.valueOf(uRL.toString()) + "  did not respond at: " + new Date());
                try {
                    Thread.sleep(n);
                }
                catch (Exception exception2) {}
                try {
                    object = uRL.openConnection();
                    ((URLConnection)object).getContentLength();
                    ((URLConnection)object).getContent();
                    bl = false;
                    System.out.println(String.valueOf(uRL.toString()) + "  running (2nd try) at: " + new Date());
                }
                catch (Exception exception3) {
                    System.out.println(String.valueOf(uRL.toString()) + "  did not respond (2nd try) at: " + new Date());
                    try {
                        object = Runtime.getRuntime();
                        Process process = ((Runtime)object).exec(file.toString());
                        LineNumberReader lineNumberReader = new LineNumberReader(new InputStreamReader(process.getInputStream()));
                        String string = lineNumberReader.readLine();
                        while (string != null) {
                            System.out.println("Kill " + uRL + ": " + string);
                            string = lineNumberReader.readLine();
                        }
                        System.out.println(String.valueOf(uRL.toString()) + "  killed at: " + new Date());
                        Process process2 = ((Runtime)object).exec(file2.toString());
                        LineNumberReader lineNumberReader2 = new LineNumberReader(new InputStreamReader(process2.getInputStream()));
                        string = lineNumberReader2.readLine();
                        while (string != null) {
                            System.out.println("Start " + uRL + ": " + string);
                            string = lineNumberReader.readLine();
                        }
                        System.out.println(String.valueOf(uRL.toString()) + "  restarted at: " + new Date());
                    }
                    catch (Exception exception4) {
                        System.out.println("Error in killing/restarting webserver: " + exception);
                    }
                }
            }
        }
        if (n2 >= 10) {
            System.out.println("Failed after 10 trys.  Giving up");
        }
    }

    public static void usage() {
        System.out.println("usage: java ogi.cq.util.WebServerHealthMonitor <url> <timeout> <shutdown script> <startup script>");
    }
}

