/*
 * Decompiled with CFR 0.152.
 */
package ogi.cq.timedaemon;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import java.util.Vector;
import ogi.cq.time.Time;
import ogi.cq.timedaemon.FileDaemon;
import ogi.cq.timedaemon.FileListener;
import ogi.cq.timedaemon.Job;

public class TimeDaemon
implements Runnable,
Time,
FileListener {
    Vector jobList;
    FileDaemon fileDaemon;
    int timeout = 1000;
    private Properties properties;
    public static final int DEFAULT_TIMEOUT = 1000;
    public static final String DEFAULT_PROPERTY_FILE = "config.ini";

    public TimeDaemon(String string) {
        String string2;
        if (string == null || string.trim().equals("")) {
            string = DEFAULT_PROPERTY_FILE;
        }
        this.properties = TimeDaemon.loadProperties(string);
        if (this.properties == null) {
            System.exit(1);
        }
        if ((string2 = this.properties.getProperty("time.refresh.timeout")) != null && !string2.trim().equals("")) {
            try {
                this.timeout = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        this.jobList = new Vector();
        this.fileDaemon = new FileDaemon(this.properties);
        this.fileDaemon.addFileListener(this);
        this.fileDaemon.start();
    }

    public Properties getProperties() {
        return this.properties;
    }

    public static Properties loadProperties(String string) {
        Properties properties = null;
        try {
            properties = new Properties(System.getProperties());
            properties.load(new BufferedInputStream(new FileInputStream(string)));
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("ERROR:  Could not open: " + string);
            return null;
        }
        catch (IOException iOException) {
            System.out.println("loadProperties " + iOException);
            return null;
        }
        return properties;
    }

    public static void main(String[] stringArray) {
        String string = "before ";
        try {
            if (stringArray.length != 1) {
                TimeDaemon.usage();
                System.exit(1);
            }
            TimeDaemon timeDaemon = new TimeDaemon(stringArray[0]);
            Thread thread = new Thread(timeDaemon);
            string = "after ";
            thread.start();
        }
        catch (Throwable throwable) {
            System.err.println("Exception occurred in main() of TimeDaemon");
            System.err.println(String.valueOf(string) + "starting thread");
            throwable.printStackTrace(System.out);
        }
    }

    public void newJobList(FileDaemon fileDaemon, Vector vector) {
        this.jobList = vector;
    }

    public void run() {
        Vector<Thread> vector = new Vector<Thread>();
        while (true) {
            Vector vector2;
            Vector vector3 = this.jobList;
            synchronized (vector3) {
                vector2 = (Vector)this.jobList.clone();
            }
            vector.removeAllElements();
            System.gc();
            long l = System.currentTimeMillis();
            int n = 0;
            while (n < vector2.size()) {
                Job job = (Job)vector2.elementAt(n);
                if (l - job.getLastExecution() > job.getPeriod() && !job.isRunning()) {
                    vector.addElement(new Thread(job));
                    job.setRunning(true);
                }
                ++n;
            }
            n = 0;
            while (n < vector.size()) {
                ((Thread)vector.elementAt(n)).start();
                ++n;
            }
            try {
                Thread.sleep(this.timeout);
                continue;
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public static void usage() {
        System.out.println("Usage: TimeDaemon <property file>");
        System.out.println("Where <property file> is the file containing the properties");
        System.out.println("this program needs to run.");
        System.out.println("");
        System.out.println("Necessary Properties:");
        System.out.println("host:    chinook.cse.ogi.edu");
        System.out.println("port:    10299");
        System.out.println("servlet: CQCluster");
        System.out.println("proxy host:    jambi.cse.ogi.edu");
        System.out.println("port:    6060");
    }
}

