/*
 * Decompiled with CFR 0.152.
 */
package ogi.cq.timedaemon;

import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.StringTokenizer;
import java.util.Vector;
import ogi.cq.time.Time;
import ogi.cq.timedaemon.JobListener;

public class Job
implements Runnable,
Time {
    public static final int FILE = 0;
    public static final int WEB = 1;
    public static final int JAVA = 2;
    private long period = 1471228928L;
    private long lastExecution = -1L;
    private String action;
    private int actionType = -1;
    private String ID;
    private PrintWriter out;
    private PrintWriter err;
    private Vector jobListeners = new Vector();
    private boolean running;
    public static final String[] UNITS = new String[]{"MS", "SEC", "MIN", "HR", "DAY", "WEEK", "YEAR"};
    public static final long[] UNIT_VALUE = new long[]{1L, 1000L, 60000L, 3600000L, 86400000L, 604800000L, 1471228928L};
    static Class class$java$lang$String;

    public Job() {
        this.out = new PrintWriter(System.out);
        this.err = new PrintWriter(System.err);
    }

    public Job(String string) {
        this();
        if (string == null) {
            throw new IllegalArgumentException("String cannot be null");
        }
        if ((string = string.trim()).equals("")) {
            throw new IllegalArgumentException("String cannot be empty");
        }
        int n = string.indexOf(" ");
        this.setID(string.substring(0, n));
        string = string.substring(n).trim();
        if (string.equals("")) {
            throw new IllegalArgumentException("period unit missing");
        }
        int n2 = string.indexOf(" ");
        String string2 = string.substring(0, n2);
        int n3 = Integer.parseInt(string2);
        string = string.substring(n2).trim();
        n2 = string.indexOf(" ");
        string2 = string.substring(0, n2).trim();
        boolean bl = false;
        int n4 = 0;
        while (n4 < UNITS.length) {
            if (string2.equalsIgnoreCase(UNITS[n4])) {
                this.setPeriod((long)n3 * UNIT_VALUE[n4]);
                bl = true;
                break;
            }
            ++n4;
        }
        if (!bl) {
            System.out.println("period not found, default to day");
            this.setPeriod(n3 * 86400000);
        }
        if ((string = string.substring(n2).trim()).equals("")) {
            throw new IllegalArgumentException("action missing");
        }
        if (string.startsWith("java:")) {
            string = string.substring("java:".length());
            this.actionType = 2;
        }
        this.setAction(string);
    }

    public synchronized void addJobListener(JobListener jobListener) {
        if (jobListener == null) {
            return;
        }
        if (this.jobListeners.contains(jobListener)) {
            return;
        }
        this.jobListeners.addElement(jobListener);
    }

    protected void fireJobFinished() {
        Vector vector;
        Job job = this;
        synchronized (job) {
            vector = (Vector)this.jobListeners.clone();
        }
        int n = vector.size();
        if (n == 0) {
            return;
        }
        int n2 = 0;
        while (n2 < n) {
            JobListener jobListener = (JobListener)vector.elementAt(n2);
            if (jobListener != null) {
                jobListener.jobFinished(this);
            }
            ++n2;
        }
    }

    public String getAction() {
        return this.action;
    }

    public PrintWriter getErr() {
        return this.err;
    }

    public String getID() {
        return this.ID;
    }

    public long getLastExecution() {
        return this.lastExecution;
    }

    public PrintWriter getOut() {
        return this.out;
    }

    public long getPeriod() {
        return this.period;
    }

    public boolean getRunning() {
        return this.running;
    }

    public boolean isRunning() {
        return this.running;
    }

    public synchronized void removeJobListener(JobListener jobListener) {
        this.jobListeners.removeElement(jobListener);
    }

    public void run() {
        if (this.action == null) {
            this.out.println("null action for Job: " + this.getID());
            return;
        }
        if (this.actionType == 1) {
            this.runHttp();
        } else if (this.actionType == 0) {
            this.runFile();
        } else if (this.actionType == 2) {
            this.runJava();
        } else if (this.action.toLowerCase().trim().startsWith("http://")) {
            this.runHttp();
        } else if (this.action.toLowerCase().trim().startsWith("java:")) {
            this.runJava();
        } else {
            this.runFile();
        }
        if (this.getLastExecution() < 0L) {
            this.setLastExecution(System.currentTimeMillis());
        } else {
            this.setLastExecution(this.getLastExecution() + this.getPeriod());
        }
        this.fireJobFinished();
        this.setRunning(false);
    }

    public void runFile() {
        Vector<String> vector = new Vector<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(this.action, " ");
        while (stringTokenizer.hasMoreTokens()) {
            vector.addElement(stringTokenizer.nextToken());
        }
        if (vector.size() == 0) {
            this.out.println("action is empty for Job: " + this.getID());
            return;
        }
        String[] stringArray = new String[vector.size()];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = (String)vector.elementAt(n);
            ++n;
        }
        FilterInputStream filterInputStream = null;
        InputStreamReader inputStreamReader = null;
        try {
            int n2;
            this.out.println("\nStarting Command: " + this.action + "...\n");
            Process process = Runtime.getRuntime().exec(stringArray);
            filterInputStream = new DataInputStream(process.getInputStream());
            inputStreamReader = new InputStreamReader(filterInputStream);
            char[] cArray = new char[4096];
            while ((n2 = inputStreamReader.read(cArray)) != -1) {
                this.out.write(cArray, 0, n2);
            }
            this.out.println("\nFinished Command: " + this.action + "\n\n");
        }
        catch (IOException iOException) {
            System.err.println("SubProcess: run: " + iOException);
        }
        try {
            if (filterInputStream != null) {
                filterInputStream.close();
            }
        }
        catch (IOException iOException) {
            System.err.println("SubProcess:  Trying to close datainput");
        }
    }

    public void runHttp() {
        URL uRL = null;
        try {
            uRL = new URL(this.action);
        }
        catch (MalformedURLException malformedURLException) {
            this.out.println("Error in URL for Job: " + this.getID());
        }
        if (uRL == null) {
            this.out.println("action is empty for Job: " + this.getID());
            return;
        }
        try {
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.setDoOutput(true);
            uRLConnection.setDoInput(true);
            uRLConnection.setUseCaches(false);
            uRLConnection.setAllowUserInteraction(true);
            InputStreamReader inputStreamReader = new InputStreamReader(uRLConnection.getInputStream());
            LineNumberReader lineNumberReader = new LineNumberReader(inputStreamReader);
            String string = lineNumberReader.readLine();
            while (string != null) {
                this.out.println(string);
                string = lineNumberReader.readLine();
            }
            inputStreamReader.close();
        }
        catch (Exception exception) {
            System.out.println("Error in retrieving URL: " + exception);
        }
        this.out.println("\nFinished Command: " + this.action + "\n\n");
    }

    public void runJava() {
        Vector<String> vector = new Vector<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(this.action, " ");
        while (stringTokenizer.hasMoreTokens()) {
            vector.addElement(stringTokenizer.nextToken());
        }
        if (vector.size() == 0) {
            this.out.println("action is empty for Job: " + this.getID());
            return;
        }
        String string = (String)vector.elementAt(0);
        Object[] objectArray = new String[vector.size() - 1];
        int n = 1;
        while (n < objectArray.length + 1) {
            objectArray[n - 1] = (String)vector.elementAt(n);
            ++n;
        }
        try {
            Class<?> clazz = Class.forName(string);
            Class[] classArray = new Class[objectArray.length];
            int n2 = 0;
            while (n2 < objectArray.length) {
                Class<?> clazz2 = class$java$lang$String;
                if (clazz2 == null) {
                    try {
                        clazz2 = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[n2] = clazz2;
                ++n2;
            }
            Constructor<?> constructor = clazz.getConstructor(classArray);
            Runnable runnable = (Runnable)constructor.newInstance(objectArray);
            runnable.run();
        }
        catch (Throwable throwable) {
            System.err.println("SubProcess: run Java class: " + throwable);
        }
    }

    public void setAction(String string) {
        this.action = string;
    }

    public void setErr(PrintWriter printWriter) {
        this.err = printWriter;
    }

    public void setID(String string) {
        this.ID = string;
    }

    public void setLastExecution(long l) {
        this.lastExecution = l;
    }

    public void setOut(PrintWriter printWriter) {
        this.out = printWriter;
    }

    public void setPeriod(long l) {
        this.period = l;
    }

    public void setRunning(boolean bl) {
        this.running = bl;
    }
}

