/*
 * Decompiled with CFR 0.152.
 */
package ogi.cq.timedaemon;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import ogi.cq.time.Time;
import ogi.cq.timedaemon.FileListener;
import ogi.cq.timedaemon.Job;

public class FileDaemon
implements Runnable,
Time {
    public static final String DEFAULT_FILE_NAME = "time.cron";
    public static final long DEFAULT_TIMEOUT = 1000L;
    String fileName;
    int timeout = 1000;
    private Vector fileListeners = new Vector();
    private Thread myThread;
    Vector jobList;
    Hashtable idList;

    public FileDaemon(Properties properties) {
        String string;
        this.fileName = properties.getProperty("time.cron.file");
        if (this.fileName == null || this.fileName.trim().equals("")) {
            this.fileName = DEFAULT_FILE_NAME;
        }
        if ((string = properties.getProperty("time.file.timeout")) != null && !string.trim().equals("")) {
            try {
                this.timeout = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        this.myThread = new Thread(this);
        this.jobList = new Vector();
        this.idList = new Hashtable();
    }

    public synchronized void addFileListener(FileListener fileListener) {
        if (fileListener == null) {
            return;
        }
        if (this.fileListeners.contains(fileListener)) {
            return;
        }
        this.fileListeners.addElement(fileListener);
    }

    protected void fireNewJobList(Vector vector) {
        Vector vector2;
        System.out.println("found new job list");
        FileDaemon fileDaemon = this;
        synchronized (fileDaemon) {
            vector2 = (Vector)this.fileListeners.clone();
        }
        int n = vector2.size();
        if (n == 0) {
            return;
        }
        int n2 = 0;
        while (n2 < n) {
            FileListener fileListener = (FileListener)vector2.elementAt(n2);
            if (fileListener != null) {
                fileListener.newJobList(this, vector);
            }
            ++n2;
        }
    }

    public synchronized void removeFileListener(FileListener fileListener) {
        this.fileListeners.removeElement(fileListener);
    }

    public void run() {
        long l = -1L;
        while (true) {
            this.idList.clear();
            File file = new File(this.fileName);
            if (file.lastModified() > l) {
                try {
                    Vector<Job> vector = new Vector<Job>();
                    FileReader fileReader = new FileReader(file);
                    LineNumberReader lineNumberReader = new LineNumberReader(fileReader);
                    String string = lineNumberReader.readLine();
                    while (string != null) {
                        Job job = new Job(string);
                        if (this.idList.get(job.getID()) == null) {
                            vector.addElement(job);
                            this.idList.put(job.getID(), "");
                        } else {
                            System.out.println("error in job file: non-unique id:\n" + string);
                        }
                        string = lineNumberReader.readLine();
                    }
                    this.updateJobList(vector);
                    this.fireNewJobList(this.jobList);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    System.out.println("could not find time cron file: " + fileNotFoundException);
                }
                catch (IOException iOException) {
                    System.out.println("error in reading time cron file: " + iOException);
                }
                l = file.lastModified();
            }
            System.gc();
            try {
                Thread.sleep(this.timeout);
            }
            catch (InterruptedException interruptedException) {}
            System.gc();
        }
    }

    public void start() {
        this.myThread.start();
    }

    private void updateJobList(Vector vector) {
        boolean[] blArray = new boolean[vector.size()];
        int n = 0;
        while (n < this.jobList.size()) {
            boolean bl = false;
            Job job = (Job)this.jobList.elementAt(n);
            int n2 = 0;
            while (n2 < vector.size()) {
                Job job2 = (Job)vector.elementAt(n2);
                if (job2.getID().equals(job.getID())) {
                    blArray[n2] = true;
                    job.setPeriod(job2.getPeriod());
                    job.setAction(job2.getAction());
                    bl = true;
                    break;
                }
                ++n2;
            }
            if (!bl) {
                this.jobList.removeElement(job);
                if (n == this.jobList.size()) break;
                --n;
            }
            ++n;
        }
        n = 0;
        while (n < blArray.length) {
            if (!blArray[n]) {
                this.jobList.addElement(vector.elementAt(n));
            }
            ++n;
        }
    }
}

