/*
 * Decompiled with CFR 0.152.
 */
package ogi.cq.query;

import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import ogi.cq.query.ContentQuery;

public abstract class CQ
implements Serializable {
    String cqName = "";
    String sql = "";
    String selectString = "";
    String fromString = "";
    String whereString = "";
    String groupbyString = "";
    String orderbyString = "";
    String stopYear = "";
    String stopMonth = "";
    String stopDay = "";
    String stopHour = "";
    String stopMinute = "";
    String userID;
    String password;
    int stopValue;
    int stopUnit;
    public static final int MINUTE = 1;
    public static final int HOUR = 2;
    public static final int DAY = 3;
    public static final int WEEK = 4;
    public static final int MONTH = 5;
    public static final int YEAR = 6;
    public static final String[] unitChoice = new String[]{"minute(s)", "hour(s)", "day(s)", "week(s)", "month(s)", "year(s)"};
    public static String CQcgi = "http://chinook.cse.ogi.edu:8080/CQ/cgi-bin/";
    public static String ContentQueryCGI = "http://chinook.cse.ogi.edu:8080/OpenCQDev/cgi-bin/installCQ_step2.cgi";
    private String notifyConfig;
    private boolean contentTrigger;
    private String source = "";

    public CQ() {
    }

    public CQ(String[] stringArray, String[] stringArray2, String string, String string2, String string3) {
        try {
            int n;
            StringBuffer stringBuffer;
            if (stringArray.length == 1 && stringArray[0].equals("*")) {
                this.sql = String.valueOf(this.sql) + "* ";
                this.selectString = "*";
            } else {
                stringBuffer = new StringBuffer();
                n = 0;
                while (n < stringArray.length - 1) {
                    stringBuffer.append(stringArray[n]);
                    stringBuffer.append(", ");
                    ++n;
                }
                stringBuffer.append(stringArray[stringArray.length - 1]);
                this.selectString = stringBuffer.toString();
            }
            stringBuffer = new StringBuffer();
            n = 0;
            while (n < stringArray2.length - 1) {
                stringBuffer.append(stringArray2[n]);
                stringBuffer.append(", ");
                ++n;
            }
            stringBuffer.append(stringArray2[stringArray2.length - 1]);
            this.fromString = stringBuffer.toString();
            this.whereString = string;
            if (string2 != null && !string2.equals("")) {
                this.orderbyString = string2;
            }
            if (string3 != null && !string3.equals("")) {
                this.groupbyString = string3;
            }
            this.updateSQL();
        }
        catch (Exception exception) {
            System.out.println("StandardQuery.new error: " + exception);
        }
    }

    public CQ(String string, String[] stringArray, String string2, String string3, String string4) {
        try {
            this.selectString = string.trim();
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while (n < stringArray.length - 1) {
                stringBuffer.append(stringArray[n]);
                stringBuffer.append(", ");
                ++n;
            }
            stringBuffer.append(stringArray[stringArray.length - 1]);
            this.fromString = stringBuffer.toString();
            this.whereString = string2;
            if (string3 != null && !string3.equals("")) {
                this.orderbyString = string3;
            }
            if (string4 != null && !string4.equals("")) {
                this.groupbyString = string4;
            }
            this.updateSQL();
        }
        catch (Exception exception) {
            System.out.println("StandardQuery.new error: " + exception);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ContentQuery contentQuery = (ContentQuery)object;
        if (this.sql != null && !this.sql.equals(contentQuery.getSQL())) {
            return false;
        }
        if (this.sql == null && contentQuery.getSQL() != null) {
            return false;
        }
        if (this.getTrigger() != null && !this.getTrigger().equals(contentQuery.getTrigger())) {
            return false;
        }
        if (this.getTrigger() == null && contentQuery.getTrigger() != null) {
            return false;
        }
        if (!this.stopYear.equals(contentQuery.getStopYear())) {
            return false;
        }
        if (!this.stopMonth.equals(contentQuery.getStopMonth())) {
            return false;
        }
        if (!this.stopDay.equals(contentQuery.getStopDay())) {
            return false;
        }
        if (!this.stopHour.equals(contentQuery.getStopHour())) {
            return false;
        }
        return this.stopMinute.equals(contentQuery.getStopMinute());
    }

    public String getContent() {
        String string = null;
        try {
            if (this.source == null) {
                this.source = "";
            }
            if (this.userID == null) {
                this.userID = "";
            }
            if (this.stopYear == null) {
                this.stopYear = "";
            }
            if (this.stopMonth == null) {
                this.stopMonth = "";
            }
            if (this.stopDay == null) {
                this.stopDay = "";
            }
            if (this.stopHour == null) {
                this.stopHour = "";
            }
            if (this.stopMinute == null) {
                this.stopMinute = "";
            }
            if (this.selectString == null) {
                this.selectString = "";
            }
            if (this.fromString == null) {
                this.fromString = "";
            }
            if (this.whereString == null) {
                this.whereString = "";
            }
            if (this.groupbyString == null) {
                this.groupbyString = "";
            }
            if (this.orderbyString == null) {
                this.orderbyString = "";
            }
            if (this.notifyConfig == null) {
                this.notifyConfig = "";
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("user=");
            stringBuffer.append(this.userID);
            stringBuffer.append("&passwd=");
            stringBuffer.append(URLEncoder.encode(this.password));
            stringBuffer.append("&datasrc=");
            stringBuffer.append(this.source);
            stringBuffer.append("&cqname=");
            stringBuffer.append(URLEncoder.encode(this.cqName));
            if (this.contentTrigger) {
                stringBuffer.append("&trigger_type=C");
            } else {
                stringBuffer.append("&trigger_type=T");
            }
            stringBuffer.append(this.getTriggerContent());
            stringBuffer.append("&stop_year=");
            stringBuffer.append(URLEncoder.encode(this.stopYear));
            stringBuffer.append("&stop_month=");
            stringBuffer.append(URLEncoder.encode(this.stopMonth));
            stringBuffer.append("&stop_day=");
            stringBuffer.append(URLEncoder.encode(this.stopDay));
            stringBuffer.append("&stop_hour=");
            stringBuffer.append(URLEncoder.encode(this.stopHour));
            stringBuffer.append("&stop_min=");
            stringBuffer.append(URLEncoder.encode(this.stopMinute));
            stringBuffer.append("&select=");
            stringBuffer.append(URLEncoder.encode(this.selectString));
            stringBuffer.append("&from=");
            stringBuffer.append(URLEncoder.encode(this.fromString));
            stringBuffer.append("&where=");
            stringBuffer.append(URLEncoder.encode(this.whereString));
            stringBuffer.append("&groupby=");
            stringBuffer.append(URLEncoder.encode(this.groupbyString));
            stringBuffer.append("&orderby=");
            stringBuffer.append(URLEncoder.encode(this.orderbyString));
            stringBuffer.append("&timezone=");
            stringBuffer.append(Math.abs(Calendar.getInstance().getTimeZone().getRawOffset() / 3600000));
            if (this.notifyConfig == null || this.notifyConfig.trim().equals("")) {
                stringBuffer.append("&ntype=n_trigger");
                stringBuffer.append("&nmode=email");
                stringBuffer.append("&nconfig=");
            } else {
                System.out.println("ntype=N_trigger");
                stringBuffer.append("&ntype=n_trigger");
                stringBuffer.append("&nmode=external");
                stringBuffer.append("&nconfig=");
                stringBuffer.append(URLEncoder.encode(this.notifyConfig));
            }
            string = stringBuffer.toString();
        }
        catch (Exception exception) {
            System.out.println("error in ContentQuery.getContent: " + exception);
        }
        return string;
    }

    public boolean getContentTrigger() {
        return this.contentTrigger;
    }

    public static String getCQNotificationConfiguration(Hashtable hashtable) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<NCONF USECQ=1>\n");
        stringBuffer.append("  <MODE URL=");
        stringBuffer.append("\"http://chinook.cse.ogi.edu:10399/ALP/notify\"");
        stringBuffer.append(" CALL=\"POST\"");
        stringBuffer.append(" SUCCESS=\"done\"> ");
        stringBuffer.append("EXTERNAL\n");
        stringBuffer.append("  </MODE>");
        stringBuffer.append("\n");
        stringBuffer.append("  <PARAMETER>\n");
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = (String)hashtable.get(string);
            stringBuffer.append("\n      <PARAM name=");
            stringBuffer.append(string);
            stringBuffer.append(">\n");
            stringBuffer.append(string2);
            stringBuffer.append("\n      </PARAM>\n");
        }
        stringBuffer.append("  </PARAMETER>");
        stringBuffer.append("</NCONF>\t\t\t");
        return stringBuffer.toString();
    }

    public String getFrom() {
        return this.fromString;
    }

    public String getGroupby() {
        return this.groupbyString;
    }

    public String getName() {
        return this.cqName;
    }

    public String getNotifyConfig() {
        return this.notifyConfig;
    }

    public String getOrderby() {
        return this.orderbyString;
    }

    public String getPassword() {
        return this.password;
    }

    public String getSelect() {
        return this.selectString;
    }

    public String getSource() {
        return this.source;
    }

    public String getSQL() {
        return this.sql;
    }

    public String getStopDay() {
        return this.stopDay;
    }

    public String getStopHour() {
        return this.stopHour;
    }

    public String getStopMinute() {
        return this.stopMinute;
    }

    public String getStopMonth() {
        return this.stopMonth;
    }

    public int getStopUnit() {
        return this.stopUnit;
    }

    public int getStopValue() {
        return this.stopValue;
    }

    public String getStopYear() {
        return this.stopYear;
    }

    public abstract String getTrigger();

    public abstract String getTriggerContent();

    public URL getURL() {
        URL uRL = null;
        try {
            String string = String.valueOf(ContentQueryCGI) + "?" + this.getContent();
            try {
                uRL = new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                System.out.println("bad URL in time query: " + malformedURLException);
            }
        }
        catch (Exception exception) {
            System.out.println("error in getting URL in TimeQuery: " + exception);
        }
        return uRL;
    }

    public String getURLString() {
        String string = null;
        return string;
    }

    public String getUser() {
        return this.userID;
    }

    public String getWhere() {
        return this.whereString;
    }

    public int hashCode() {
        int n = this.sql.hashCode();
        n = 37 * n + this.getTrigger().hashCode();
        n = 37 * n + this.stopValue;
        n = 37 * n + this.stopUnit;
        return n;
    }

    public static void main(String[] stringArray) {
        ContentQuery contentQuery = new ContentQuery();
        contentQuery.setUser("Dave");
        contentQuery.setSelect("*");
        contentQuery.setWhere("(owner <> 'dave') AND src_id = 1");
        contentQuery.setFrom("BIB_INFO");
        contentQuery.setStop("1997&11&27&&11&50");
        contentQuery.setTrigger("&&&&&&&&0");
        contentQuery.setGroupby("owner");
        contentQuery.setOrderby("category");
        System.out.println(contentQuery);
        System.out.println("\n\n\n-----------------------------\n\n\n");
        ContentQuery contentQuery2 = new ContentQuery();
        contentQuery2.setUser("Dave");
        contentQuery2.setSelect("*");
        contentQuery2.setFrom("BIB_INFO");
        contentQuery2.setWhere("(owner <> 'dave') AND src_id = 1");
        contentQuery2.setGroupby("owner");
        contentQuery2.setOrderby("category");
        Calendar calendar = Calendar.getInstance();
        contentQuery2.setStop("" + (calendar.get(1) + 1900) + "&" + (calendar.get(2) + 1) + "&" + calendar.get(5) + "&" + calendar.get(10) + "&" + calendar.get(12));
        contentQuery2.setTrigger("EVERY&10&minute(s)");
        System.out.println(contentQuery2);
        System.out.println("\n\n\n-----------------------------\n\n\n");
        ContentQuery contentQuery3 = new ContentQuery();
        contentQuery3.setUser("Dave");
        contentQuery3.setSelect("*");
        contentQuery3.setFrom("BIB_INFO");
        contentQuery3.setWhere("(owner <> 'dave') AND src_id = 1");
        contentQuery3.setGroupby("owner");
        contentQuery3.setOrderby("category");
        contentQuery3.setStop("" + (calendar.get(1) + 1900) + "&" + (calendar.get(2) + 1) + "&" + calendar.get(5) + "&" + calendar.get(10) + "&" + calendar.get(12));
        contentQuery3.setTrigger("CRON&30&8&&&&&");
        System.out.println(contentQuery3);
        System.out.println(contentQuery3.getContent());
    }

    public void setContentTrigger(boolean bl) {
        this.contentTrigger = bl;
    }

    public void setFrom(String[] stringArray) {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while (n < stringArray.length - 1) {
                stringBuffer.append(stringArray[n]);
                stringBuffer.append(", ");
                ++n;
            }
            stringBuffer.append(stringArray[stringArray.length - 1]);
            this.fromString = stringBuffer.toString().replace('\n', ' ');
            this.updateSQL();
        }
        catch (Exception exception) {
            System.out.println("standard query.setfrom([]) error: " + exception);
        }
    }

    public void setFrom(String string) {
        this.fromString = string.replace('\n', ' ').trim();
        this.updateSQL();
    }

    public void setGroupby(String string) {
        this.groupbyString = string.replace('\n', ' ').trim();
        this.updateSQL();
    }

    public void setName(String string) {
        this.cqName = string == null ? "" : string.replace('\n', ' ').trim();
    }

    public void setNotifyConfig(String string) {
        this.notifyConfig = string;
    }

    public void setOrderby(String string) {
        this.orderbyString = string.replace('\n', ' ').trim();
        this.updateSQL();
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public void setSelect(String[] stringArray) {
        try {
            if (stringArray.length == 1 && stringArray[0].equals("*")) {
                this.sql = String.valueOf(this.sql) + "* ";
                this.selectString = "*";
            } else {
                StringBuffer stringBuffer = new StringBuffer();
                int n = 0;
                while (n < stringArray.length - 1) {
                    stringBuffer.append(stringArray[n]);
                    stringBuffer.append(", ");
                    ++n;
                }
                stringBuffer.append(stringArray[stringArray.length - 1]);
                this.selectString = stringBuffer.toString().replace('\n', ' ');
            }
            this.updateSQL();
        }
        catch (Exception exception) {
            System.out.println("standard query.setSelect([]) error: " + exception);
        }
    }

    public void setSelect(String string) {
        this.selectString = string.trim().replace('\n', ' ');
        this.updateSQL();
    }

    public void setSource(String string) {
        this.source = string;
    }

    public void setStop(String string) {
        String string2;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "&-:");
        if (stringTokenizer.hasMoreTokens()) {
            this.stopMonth = string2 = stringTokenizer.nextToken();
        }
        if (stringTokenizer.hasMoreTokens()) {
            this.stopDay = string2 = stringTokenizer.nextToken();
        }
        if (stringTokenizer.hasMoreTokens()) {
            this.stopYear = string2 = stringTokenizer.nextToken();
        }
        if (stringTokenizer.hasMoreTokens()) {
            this.stopHour = string2 = stringTokenizer.nextToken();
        }
        if (stringTokenizer.hasMoreTokens()) {
            this.stopMinute = string2 = stringTokenizer.nextToken();
        }
    }

    public void setStopDay(String string) {
        this.stopDay = string.replace('\n', ' ');
    }

    public void setStopHour(String string) {
        this.stopHour = string.replace('\n', ' ');
    }

    public void setStopMinute(String string) {
        this.stopMinute = string.replace('\n', ' ');
    }

    public void setStopMonth(String string) {
        this.stopMonth = string.replace('\n', ' ');
    }

    public void setStopString(String string) {
        block21: {
            int n;
            String string2;
            String string3;
            block20: {
                string3 = null;
                string2 = null;
                String string4 = null;
                n = 0;
                try {
                    StringTokenizer stringTokenizer = new StringTokenizer(string, "&");
                    if (!stringTokenizer.hasMoreTokens()) break block20;
                    string3 = stringTokenizer.nextToken();
                    if (string3.equalsIgnoreCase("CRON")) {
                        if (stringTokenizer.hasMoreTokens()) {
                            this.stopYear = stringTokenizer.nextToken();
                        }
                        if (stringTokenizer.hasMoreTokens()) {
                            this.stopMonth = stringTokenizer.nextToken();
                        }
                        if (stringTokenizer.hasMoreTokens()) {
                            this.stopDay = stringTokenizer.nextToken();
                        }
                        if (stringTokenizer.hasMoreTokens()) {
                            this.stopHour = stringTokenizer.nextToken();
                        }
                        if (stringTokenizer.hasMoreTokens()) {
                            this.stopMinute = stringTokenizer.nextToken();
                        }
                        break block20;
                    }
                    if (string3.equalsIgnoreCase("AFTER")) {
                        int n2;
                        if (stringTokenizer.hasMoreTokens()) {
                            string2 = stringTokenizer.nextToken();
                            n2 = 1;
                            try {
                                n2 = Integer.parseInt(string2);
                            }
                            catch (Exception exception) {}
                            string2 = String.valueOf(n2);
                        }
                        if (!stringTokenizer.hasMoreTokens()) break block20;
                        string4 = stringTokenizer.nextToken();
                        n2 = 0;
                        while (n2 < unitChoice.length) {
                            if (string4.equalsIgnoreCase(unitChoice[n2])) {
                                n = n2;
                                break block20;
                            }
                            ++n2;
                        }
                        break block20;
                    }
                    System.out.println("Error in setting Stop condition: bad type");
                }
                catch (Exception exception) {
                    System.out.println("Stop.setStopCondition error: " + exception);
                }
            }
            try {
                long l = 60000L;
                long l2 = 3600000L;
                long l3 = l2 * 24L;
                long l4 = l3 * 7L;
                long l5 = l4 * 4L;
                long l6 = l3 * 365L;
                if (string3.equalsIgnoreCase("AFTER")) {
                    Date date = null;
                    int n3 = 1;
                    try {
                        n3 = Integer.parseInt(string2);
                    }
                    catch (Exception exception) {
                        System.out.println("null numberField: " + exception);
                    }
                    if (n3 < 1) {
                        n3 = 1;
                    }
                    date = n == 0 ? new Date(System.currentTimeMillis() + l * (long)n3) : (n == 1 ? new Date(System.currentTimeMillis() + l2 * (long)n3) : (n == 2 ? new Date(System.currentTimeMillis() + l3 * (long)n3) : (n == 3 ? new Date(System.currentTimeMillis() + l4 * (long)n3) : (n == 4 ? new Date(System.currentTimeMillis() + l5 * (long)n3) : (n == 5 ? new Date(System.currentTimeMillis() + l6 * (long)n3) : new Date(System.currentTimeMillis() + l6))))));
                    this.stopMonth = String.valueOf(date.getMonth() + 1);
                    this.stopDay = String.valueOf(date.getDate());
                    this.stopYear = String.valueOf(date.getYear() + 1900);
                    this.stopHour = String.valueOf(date.getHours());
                    this.stopMinute = String.valueOf(date.getMinutes());
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append(this.stopMonth).append("-");
                    stringBuffer.append(this.stopDay).append("-");
                    stringBuffer.append(this.stopYear).append("&&");
                    stringBuffer.append(this.stopHour).append(":");
                    stringBuffer.append(this.stopMinute).append(":00");
                    stringBuffer.toString();
                    break block21;
                }
                this.setStop(string);
            }
            catch (Exception exception) {
                System.out.println("Error in StopPanel.getStopString: " + exception);
            }
        }
    }

    public void setStopYear(String string) {
        this.stopYear = string.replace('\n', ' ');
    }

    public abstract void setTrigger(String var1);

    public void setUser(String string) {
        this.userID = string.trim().replace('\n', ' ');
    }

    public void setWhere(String string) {
        this.whereString = string.trim().replace('\n', ' ');
        this.updateSQL();
    }

    public String toString() {
        String string = String.valueOf(this.sql) + "\n" + this.getTrigger() + "\n" + this.stopYear + "\n" + this.stopMonth + "\n" + this.stopDay + "\n" + this.stopHour + "\n" + this.stopMinute + "\n" + this.notifyConfig;
        return string;
    }

    private void updateSQL() {
        try {
            StringBuffer stringBuffer = new StringBuffer("SELECT ");
            if (this.selectString != null) {
                stringBuffer.append(this.selectString);
            }
            stringBuffer.append(" FROM ");
            if (this.fromString != null) {
                stringBuffer.append(this.fromString);
            }
            if (this.whereString != null && !this.whereString.equals("")) {
                stringBuffer.append(" WHERE ");
                stringBuffer.append(this.whereString);
            }
            if (this.orderbyString != null && !this.orderbyString.equals("")) {
                stringBuffer.append(" ORDERBY ");
                stringBuffer.append(this.orderbyString);
            }
            if (this.groupbyString != null && !this.groupbyString.equals("")) {
                stringBuffer.append(" GROUPBY ");
                stringBuffer.append(this.groupbyString);
            }
            this.sql = stringBuffer.toString();
        }
        catch (Exception exception) {
            System.out.println("standardQuery updateSQL error: " + exception);
        }
    }
}

