/*
 * Decompiled with CFR 0.152.
 */
package ogi.cq.plugin.gui.demo;

import com.sun.java.swing.AbstractButton;
import com.sun.java.swing.BorderFactory;
import com.sun.java.swing.Box;
import com.sun.java.swing.BoxLayout;
import com.sun.java.swing.ButtonGroup;
import com.sun.java.swing.DefaultListModel;
import com.sun.java.swing.JButton;
import com.sun.java.swing.JCheckBox;
import com.sun.java.swing.JComboBox;
import com.sun.java.swing.JLabel;
import com.sun.java.swing.JList;
import com.sun.java.swing.JPanel;
import com.sun.java.swing.JScrollPane;
import com.sun.java.swing.JTabbedPane;
import com.sun.java.swing.JTextField;
import com.sun.java.swing.JTextPane;
import com.sun.java.swing.event.CaretEvent;
import com.sun.java.swing.event.CaretListener;
import com.sun.java.swing.event.ListSelectionEvent;
import com.sun.java.swing.event.ListSelectionListener;
import com.sun.java.swing.text.AttributeSet;
import com.sun.java.swing.text.Document;
import com.sun.java.swing.text.MutableAttributeSet;
import com.sun.java.swing.text.Style;
import com.sun.java.swing.text.StyleConstants;
import com.sun.java.swing.text.StyleContext;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.StringTokenizer;
import java.util.Vector;
import ogi.cq.gui.GenericStatePanel;
import ogi.cq.gui.Manager;
import ogi.cq.log.Log;
import ogi.cq.plugin.gui.ITriggerPanel;
import ogi.cq.plugin.gui.demo.PluginState;
import ogi.cq.plugin.gui.demo.TestTriggerState;
import ogi.cq.util.Pair;
import ogi.diom.util.GUI;

public class TriggerPanel
extends GenericStatePanel
implements ITriggerPanel,
ItemListener,
ActionListener,
ListSelectionListener,
CaretListener {
    private Log logger;
    private PluginState manager;
    boolean tableValueChanging = false;
    int currentState;
    Vector stateHistory;
    JPanel cardPanel;
    JPanel timePanel;
    JPanel contentPanel;
    JCheckBox contentCheckbox;
    JCheckBox timeCheckbox;
    ButtonGroup triggerGroup;
    JLabel contentLabel;
    protected JPanel selectionPanel;
    protected JComboBox groupChoice;
    protected JButton avgButton;
    protected JButton sumButton;
    protected JButton minButton;
    protected JButton maxButton;
    protected JButton countButton;
    protected DefaultListModel tableModel;
    protected JList tableList;
    protected DefaultListModel columnModel;
    protected JList columnList;
    protected DefaultListModel operatorModel;
    protected JList operatorList;
    protected JTextField valueField;
    protected JButton whereButton;
    protected JButton andButton;
    protected JButton orButton;
    protected JButton notButton;
    protected JButton backButton;
    protected JButton clearButton;
    protected JTextPane contentTriggerField;
    protected boolean updated = false;
    protected Vector cTriggerVec;
    JTabbedPane tabPanel;
    JCheckBox periodicCheckbox;
    JCheckBox cronCheckbox;
    ButtonGroup timeGroup;
    JPanel NLPanel;
    JComboBox NLChoice;
    JPanel examplePanel;
    JLabel minLabel;
    JLabel hourLabel;
    JLabel dayLabel;
    JLabel weekdayLabel;
    JLabel monthLabel;
    JComboBox examplePanelChoice;
    JTextField minField;
    JTextField hourField;
    JTextField dayField;
    JTextField weekdayField;
    JTextField monthField;
    JPanel cronPanel;
    JLabel cronminLabel;
    JLabel cronhourLabel;
    JLabel crondayLabel;
    JLabel cronweekdayLabel;
    JLabel cronmonthLabel;
    JTextField cronMinField;
    JTextField cronHourField;
    JTextField cronDayField;
    JTextField cronWeekdayField;
    JTextField cronMonthField;
    boolean epChoiceEvent = false;
    boolean nlChoiceEvent = false;
    boolean selectingExampleChoice = false;
    private static final int DEFAULT_EXAMPLE = 3;
    private static final int MINUTES = 0;
    private static final int HOURS = 1;
    private static final int DAYS = 2;
    private static final int MONTHS = 3;
    private static final int NL_PANEL = 0;
    private static final int EXAMPLE_PANEL = 1;
    private static final int CRON_PANEL = 2;

    public TriggerPanel(PluginState pluginState, Log log) {
        this(pluginState, log, null, null);
    }

    public TriggerPanel(PluginState pluginState, Log log, Color color, Font font) {
        this.manager = pluginState;
        this.logger = log;
        this.localFont = font;
        this.backgroundColor = color;
        this.cTriggerVec = new Vector();
        this.stateHistory = new Vector();
        this.currentState = 1;
        this.init();
    }

    public void actionPerformed(ActionEvent actionEvent) {
    }

    public void caretUpdate(CaretEvent caretEvent) {
        if (caretEvent.getSource() != this.valueField) {
            return;
        }
        String string = this.valueField.getText();
        Pair pair = null;
        pair = this.cTriggerVec.size() > 0 ? (Pair)this.cTriggerVec.elementAt(this.cTriggerVec.size() - 1) : new Pair(null, null);
        if (pair.getLeft() == ITriggerPanel.VALUE) {
            pair.setRight(string);
        } else {
            int n = ITriggerPanel.stateChange[this.currentState][6];
            if (n == 0) {
                return;
            }
            this.stateHistory.addElement(new Integer(this.currentState));
            this.currentState = n;
            pair = new Pair(ITriggerPanel.VALUE, string);
            this.cTriggerVec.addElement(pair);
        }
        this.updateContentTriggerField();
    }

    void contentCheckbox_Clicked(ActionEvent actionEvent) {
        this.contentCheckbox.setSelected(true);
        CardLayout cardLayout = (CardLayout)this.cardPanel.getLayout();
        cardLayout.show((Container)this.cardPanel, "content");
    }

    private JPanel createContentPanel() {
        this.contentPanel = new JPanel();
        this.contentPanel.setLayout((LayoutManager)new BoxLayout((Container)this.contentPanel, 1));
        this.contentPanel.setBorder(BorderFactory.createEtchedBorder());
        this.contentPanel.add((Component)this.createGroupContentPanel());
        this.contentPanel.add((Component)this.getSelectionPanel());
        JPanel jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new BoxLayout((Container)jPanel, 0));
        this.contentPanel.add((Component)jPanel);
        this.whereButton = new JButton("WHERE");
        this.whereButton.addActionListener((ActionListener)this);
        jPanel.add((Component)this.whereButton);
        jPanel.add(Box.createHorizontalGlue());
        this.andButton = new JButton("AND");
        this.andButton.addActionListener((ActionListener)this);
        jPanel.add((Component)this.andButton);
        this.orButton = new JButton("OR");
        this.orButton.addActionListener((ActionListener)this);
        jPanel.add((Component)this.orButton);
        this.notButton = new JButton("NOT");
        this.notButton.addActionListener((ActionListener)this);
        jPanel.add((Component)this.notButton);
        jPanel.add(Box.createHorizontalGlue());
        this.backButton = new JButton("<");
        this.backButton.setBackground(Color.yellow);
        this.backButton.addActionListener((ActionListener)this);
        jPanel.add((Component)this.backButton);
        this.clearButton = new JButton("Clear");
        this.clearButton.setBackground(Color.yellow);
        this.clearButton.addActionListener((ActionListener)this);
        jPanel.add((Component)this.clearButton);
        this.contentTriggerField = this.createTextPane();
        this.contentTriggerField.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane((Component)this.contentTriggerField);
        this.contentPanel.add((Component)jScrollPane);
        return this.contentPanel;
    }

    private JPanel createGroupContentPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new BoxLayout((Container)jPanel, 0));
        JLabel jLabel = new JLabel("Group Func. ");
        jLabel.setForeground(Color.black);
        jLabel.setAlignmentY(0.5f);
        jPanel.add((Component)jLabel);
        this.countButton = new JButton("Count");
        this.countButton.addActionListener((ActionListener)this);
        this.countButton.setAlignmentY(0.5f);
        jPanel.add((Component)this.countButton);
        this.minButton = new JButton("MIN");
        this.minButton.addActionListener((ActionListener)this);
        this.minButton.setAlignmentY(0.5f);
        jPanel.add((Component)this.minButton);
        this.maxButton = new JButton("MAX");
        this.maxButton.addActionListener((ActionListener)this);
        this.maxButton.setAlignmentY(0.5f);
        jPanel.add((Component)this.maxButton);
        this.sumButton = new JButton("SUM");
        this.sumButton.addActionListener((ActionListener)this);
        this.sumButton.setAlignmentY(0.5f);
        jPanel.add((Component)this.sumButton);
        this.avgButton = new JButton("AVG");
        this.avgButton.addActionListener((ActionListener)this);
        this.avgButton.setAlignmentY(0.5f);
        jPanel.add((Component)this.avgButton);
        jPanel.add(Box.createHorizontalGlue());
        return jPanel;
    }

    private JTextPane createTextPane() {
        JTextPane jTextPane = new JTextPane();
        Style style = StyleContext.getDefaultStyleContext().getStyle("default");
        Style style2 = jTextPane.addStyle("regular", style);
        StyleConstants.setFontSize((MutableAttributeSet)style, (int)14);
        StyleConstants.setFontFamily((MutableAttributeSet)style, (String)"SansSerif");
        Style style3 = jTextPane.addStyle("italic", style2);
        StyleConstants.setItalic((MutableAttributeSet)style3, (boolean)true);
        style3 = jTextPane.addStyle("bold", style2);
        StyleConstants.setBold((MutableAttributeSet)style3, (boolean)true);
        style3 = jTextPane.addStyle("small", style2);
        StyleConstants.setFontSize((MutableAttributeSet)style3, (int)10);
        style3 = jTextPane.addStyle("blue", style2);
        StyleConstants.setBold((MutableAttributeSet)style3, (boolean)true);
        StyleConstants.setForeground((MutableAttributeSet)style3, (Color)Color.blue);
        style3 = jTextPane.addStyle("red", style2);
        StyleConstants.setBold((MutableAttributeSet)style3, (boolean)true);
        StyleConstants.setForeground((MutableAttributeSet)style3, (Color)Color.red);
        style3 = jTextPane.addStyle("large", style2);
        StyleConstants.setFontSize((MutableAttributeSet)style3, (int)16);
        return jTextPane;
    }

    private JPanel createTimePanel() {
        this.timePanel = new JPanel();
        this.timePanel.setLayout(new GridBagLayout());
        this.timePanel.setBorder(BorderFactory.createEtchedBorder());
        this.tabPanel = new JTabbedPane();
        GUI.addComponent((Container)this.timePanel, (Component)this.tabPanel, 1, 1, 10, 10, 1, 10, 100.0, 100.0);
        this.NLPanel = new JPanel();
        this.NLPanel.setLayout(new GridBagLayout());
        this.NLChoice = new JComboBox();
        this.NLChoice.setFont(this.localFont);
        this.NLChoice.setBackground(Color.white);
        this.NLChoice.setForeground(Color.blue);
        int n = 0;
        while (n < ITriggerPanel.EXAMPLES.length) {
            this.NLChoice.addItem((Object)ITriggerPanel.EXAMPLES[n][0]);
            ++n;
        }
        this.NLChoice.addItemListener((ItemListener)this);
        GUI.addComponent((Container)this.NLPanel, (Component)this.NLChoice, 3, 1, 2, 1, 2, 10, 5.0, 1.0);
        this.examplePanel = new JPanel();
        this.examplePanel.setLayout(new GridBagLayout());
        this.examplePanelChoice = new JComboBox();
        n = 0;
        while (n < ITriggerPanel.EXAMPLES.length) {
            this.examplePanelChoice.addItem((Object)ITriggerPanel.EXAMPLES[n][0]);
            ++n;
        }
        this.examplePanelChoice.setFont(this.localFont);
        this.examplePanelChoice.setBackground(Color.white);
        this.examplePanelChoice.setForeground(Color.blue);
        this.examplePanelChoice.addItemListener((ItemListener)this);
        GUI.addComponent((Container)this.examplePanel, (Component)this.examplePanelChoice, 1, 1, 4, 1, 2, 17, 1.0, 1.0);
        this.minLabel = new JLabel("Min (0-59):");
        this.minLabel.setForeground(Color.black);
        this.minLabel.setFont(this.localFont);
        GUI.addComponent((Container)this.examplePanel, (Component)this.minLabel, 2, 2, 1, 1, 0, 17, 1.0, 1.0);
        this.minField = new JTextField("");
        this.minField.setFont(this.localFont);
        this.minField.setBackground(Color.white);
        this.minField.setForeground(Color.blue);
        GUI.addComponent((Container)this.examplePanel, (Component)this.minField, 3, 2, 1, 1, 2, 17, 10.0, 1.0);
        this.hourLabel = new JLabel("Hour (0-23):");
        this.hourLabel.setForeground(Color.black);
        this.hourLabel.setFont(this.localFont);
        GUI.addComponent((Container)this.examplePanel, (Component)this.hourLabel, 2, 3, 1, 1, 0, 17, 1.0, 1.0);
        this.hourField = new JTextField("");
        this.hourField.setFont(this.localFont);
        this.hourField.setBackground(Color.white);
        this.hourField.setForeground(Color.blue);
        GUI.addComponent((Container)this.examplePanel, (Component)this.hourField, 3, 3, 1, 1, 2, 17, 10.0, 1.0);
        this.weekdayLabel = new JLabel("Day of Week (0-6):");
        this.weekdayLabel.setForeground(Color.black);
        this.weekdayLabel.setFont(this.localFont);
        GUI.addComponent((Container)this.examplePanel, (Component)this.weekdayLabel, 2, 4, 1, 1, 0, 17, 1.0, 1.0);
        this.weekdayField = new JTextField("");
        this.weekdayField.setFont(this.localFont);
        this.weekdayField.setBackground(Color.white);
        this.weekdayField.setForeground(Color.blue);
        GUI.addComponent((Container)this.examplePanel, (Component)this.weekdayField, 3, 4, 1, 1, 2, 17, 10.0, 1.0);
        this.dayLabel = new JLabel("Day of Month (1-31):");
        this.dayLabel.setForeground(Color.black);
        this.dayLabel.setFont(this.localFont);
        GUI.addComponent((Container)this.examplePanel, (Component)this.dayLabel, 2, 5, 1, 1, 0, 17, 1.0, 1.0);
        this.dayField = new JTextField("");
        this.dayField.setFont(this.localFont);
        this.dayField.setBackground(Color.white);
        this.dayField.setForeground(Color.blue);
        GUI.addComponent((Container)this.examplePanel, (Component)this.dayField, 3, 5, 1, 1, 2, 17, 10.0, 1.0);
        this.monthLabel = new JLabel("Month (1-12):");
        this.monthLabel.setForeground(Color.black);
        this.monthLabel.setFont(this.localFont);
        GUI.addComponent((Container)this.examplePanel, (Component)this.monthLabel, 2, 6, 1, 1, 0, 17, 1.0, 1.0);
        this.monthField = new JTextField("");
        this.monthField.setFont(this.localFont);
        this.monthField.setBackground(Color.white);
        this.monthField.setForeground(Color.blue);
        GUI.addComponent((Container)this.examplePanel, (Component)this.monthField, 3, 6, 1, 1, 2, 17, 10.0, 1.0);
        this.cronPanel = new JPanel();
        this.cronPanel.setLayout(new GridBagLayout());
        this.cronminLabel = new JLabel("Min (0-59):");
        this.cronminLabel.setForeground(Color.black);
        this.cronminLabel.setFont(this.localFont);
        GUI.addComponent((Container)this.cronPanel, (Component)this.cronminLabel, 2, 2, 1, 1, 0, 17, 1.0, 1.0);
        this.cronMinField = new JTextField("");
        this.cronMinField.setFont(this.localFont);
        this.cronMinField.setBackground(Color.white);
        this.cronMinField.setForeground(Color.blue);
        GUI.addComponent((Container)this.cronPanel, (Component)this.cronMinField, 3, 2, 1, 1, 2, 17, 10.0, 1.0);
        this.cronhourLabel = new JLabel("Hour (0-23):");
        this.cronhourLabel.setForeground(Color.black);
        this.cronhourLabel.setFont(this.localFont);
        GUI.addComponent((Container)this.cronPanel, (Component)this.cronhourLabel, 2, 3, 1, 1, 0, 17, 1.0, 1.0);
        this.cronHourField = new JTextField("");
        this.cronHourField.setFont(this.localFont);
        this.cronHourField.setBackground(Color.white);
        this.cronHourField.setForeground(Color.blue);
        GUI.addComponent((Container)this.cronPanel, (Component)this.cronHourField, 3, 3, 1, 1, 2, 17, 10.0, 1.0);
        this.cronweekdayLabel = new JLabel("Day of Week (0-6):");
        this.cronweekdayLabel.setForeground(Color.black);
        this.cronweekdayLabel.setFont(this.localFont);
        GUI.addComponent((Container)this.cronPanel, (Component)this.cronweekdayLabel, 2, 4, 1, 1, 0, 17, 1.0, 1.0);
        this.cronWeekdayField = new JTextField("");
        this.cronWeekdayField.setFont(this.localFont);
        this.cronWeekdayField.setBackground(Color.white);
        this.cronWeekdayField.setForeground(Color.blue);
        GUI.addComponent((Container)this.cronPanel, (Component)this.cronWeekdayField, 3, 4, 1, 1, 2, 17, 10.0, 1.0);
        this.crondayLabel = new JLabel("Day of Month (1-31):");
        this.crondayLabel.setForeground(Color.black);
        this.crondayLabel.setFont(this.localFont);
        GUI.addComponent((Container)this.cronPanel, (Component)this.crondayLabel, 2, 5, 1, 1, 0, 17, 1.0, 1.0);
        this.cronDayField = new JTextField("");
        this.cronDayField.setFont(this.localFont);
        this.cronDayField.setBackground(Color.white);
        this.cronDayField.setForeground(Color.blue);
        GUI.addComponent((Container)this.cronPanel, (Component)this.cronDayField, 3, 5, 1, 1, 2, 17, 10.0, 1.0);
        this.cronmonthLabel = new JLabel("Month (1-12):");
        this.cronmonthLabel.setFont(this.localFont);
        this.cronmonthLabel.setForeground(Color.black);
        GUI.addComponent((Container)this.cronPanel, (Component)this.cronmonthLabel, 2, 6, 1, 1, 0, 17, 1.0, 1.0);
        this.cronMonthField = new JTextField("");
        this.cronMonthField.setFont(this.localFont);
        this.cronMonthField.setBackground(Color.white);
        this.cronMonthField.setForeground(Color.blue);
        GUI.addComponent((Container)this.cronPanel, (Component)this.cronMonthField, 3, 6, 1, 1, 2, 17, 10.0, 1.0);
        JLabel jLabel = new JLabel("");
        GUI.addComponent((Container)this.cronPanel, (Component)jLabel, 2, 7, 2, 1, 2, 17, 10.0, 1.0);
        JLabel jLabel2 = new JLabel("See the examples for the syntax of CRON expressions");
        jLabel2.setForeground(Color.black);
        this.cronMonthField.setFont(this.localFont);
        GUI.addComponent((Container)this.cronPanel, (Component)jLabel2, 2, 8, 2, 1, 2, 17, 10.0, 1.0);
        JLabel jLabel3 = new JLabel("");
        GUI.addComponent((Container)this.cronPanel, (Component)jLabel3, 2, 9, 2, 1, 2, 17, 10.0, 1.0);
        this.exampleChoice_Selected(3);
        this.tabPanel.add("Natural Language Examples", (Component)this.NLPanel);
        this.tabPanel.add("Examples", (Component)this.examplePanel);
        this.tabPanel.add("CRON", (Component)this.cronPanel);
        this.tabPanel.setSelectedComponent((Component)this.examplePanel);
        return this.timePanel;
    }

    private void exampleChoice_Selected(int n) {
        String string;
        StringTokenizer stringTokenizer;
        if (n > ITriggerPanel.EXAMPLES.length) {
            System.out.println("error: example number too high");
            return;
        }
        if (!this.selectingExampleChoice) {
            this.selectingExampleChoice = true;
            this.NLChoice.setSelectedIndex(n);
            this.examplePanelChoice.setSelectedIndex(n);
            this.selectingExampleChoice = false;
        }
        if ((stringTokenizer = new StringTokenizer(ITriggerPanel.EXAMPLES[n][1], "&")).hasMoreTokens()) {
            string = stringTokenizer.nextToken();
            this.minField.setText(string);
            this.cronMinField.setText(string);
        }
        if (stringTokenizer.hasMoreTokens()) {
            string = stringTokenizer.nextToken();
            this.hourField.setText(string);
            this.cronHourField.setText(string);
        }
        if (stringTokenizer.hasMoreTokens()) {
            string = stringTokenizer.nextToken();
            this.dayField.setText(string);
            this.cronDayField.setText(string);
        }
        if (stringTokenizer.hasMoreTokens()) {
            string = stringTokenizer.nextToken();
            this.monthField.setText(string);
            this.cronMonthField.setText(string);
        }
        if (stringTokenizer.hasMoreTokens()) {
            string = stringTokenizer.nextToken();
            this.weekdayField.setText(string);
            this.cronWeekdayField.setText(string);
        }
    }

    public boolean getContentTrigger() {
        if (this.contentCheckbox != null) {
            return this.contentCheckbox.isSelected();
        }
        return true;
    }

    private Vector getOperators() {
        Vector vector;
        if (this.manager == null) {
            vector = new Vector();
            int n = 0;
            while (n < ITriggerPanel.OPERATORS.length) {
                vector.addElement(ITriggerPanel.OPERATORS[n]);
                ++n;
            }
        } else {
            vector = this.manager.getTriggerOperators();
        }
        return vector;
    }

    private JPanel getSelectionPanel() {
        if (this.selectionPanel == null) {
            this.selectionPanel = new JPanel();
            this.selectionPanel.setLayout((LayoutManager)new BoxLayout((Container)this.selectionPanel, 0));
            this.contentPanel.add((Component)this.selectionPanel);
            JPanel jPanel = new JPanel();
            jPanel.setLayout((LayoutManager)new BoxLayout((Container)jPanel, 1));
            this.selectionPanel.add((Component)jPanel);
            JLabel jLabel = new JLabel("Object Type");
            jLabel.setAlignmentX(0.0f);
            jLabel.setForeground(Color.black);
            jPanel.add((Component)jLabel);
            this.tableList = new JList(this.manager.getRelations());
            this.tableList.setForeground(Color.blue);
            this.tableList.addListSelectionListener((ListSelectionListener)this);
            JScrollPane jScrollPane = new JScrollPane((Component)this.tableList);
            jScrollPane.setAlignmentX(0.0f);
            jPanel.add((Component)jScrollPane);
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout((LayoutManager)new BoxLayout((Container)jPanel2, 1));
            this.selectionPanel.add((Component)jPanel2);
            JLabel jLabel2 = new JLabel("Object Property");
            jLabel2.setAlignmentX(0.0f);
            jLabel2.setForeground(Color.black);
            jPanel2.add((Component)jLabel2);
            this.columnList = new JList();
            this.columnList.setForeground(Color.blue);
            this.columnList.addListSelectionListener((ListSelectionListener)this);
            JScrollPane jScrollPane2 = new JScrollPane((Component)this.columnList);
            jScrollPane2.setAlignmentX(0.0f);
            jPanel2.add((Component)jScrollPane2);
            JPanel jPanel3 = new JPanel();
            jPanel3.setLayout((LayoutManager)new BoxLayout((Container)jPanel3, 1));
            this.selectionPanel.add(Box.createRigidArea((Dimension)new Dimension(10, 0)));
            this.selectionPanel.add((Component)jPanel3);
            JLabel jLabel3 = new JLabel("Operator");
            jLabel3.setAlignmentX(0.0f);
            jLabel3.setForeground(Color.black);
            jPanel3.add((Component)jLabel3);
            this.operatorList = new JList(this.getOperators());
            this.operatorList.setForeground(Color.blue);
            this.operatorList.addListSelectionListener((ListSelectionListener)this);
            this.operatorList.setSelectionMode(0);
            JScrollPane jScrollPane3 = new JScrollPane((Component)this.operatorList);
            jScrollPane3.setAlignmentX(0.0f);
            jPanel3.add((Component)jScrollPane3);
            JPanel jPanel4 = new JPanel();
            jPanel4.setLayout((LayoutManager)new BoxLayout((Container)jPanel4, 1));
            this.selectionPanel.add(Box.createRigidArea((Dimension)new Dimension(10, 0)));
            this.selectionPanel.add((Component)jPanel4);
            this.selectionPanel.add(Box.createHorizontalGlue());
            JLabel jLabel4 = new JLabel("Value");
            jLabel4.setAlignmentX(0.0f);
            jLabel4.setForeground(Color.black);
            jPanel4.add((Component)jLabel4);
            this.valueField = new JTextField("");
            this.valueField.setForeground(Color.blue);
            this.valueField.setAlignmentX(0.0f);
            this.valueField.addCaretListener((CaretListener)this);
            this.valueField.setMaximumSize(new Dimension(this.valueField.getMaximumSize().width, this.valueField.getFontMetrics(this.valueField.getFont()).getHeight() * 2));
            jPanel4.add((Component)this.valueField);
            jPanel4.add(Box.createVerticalGlue());
        }
        return this.selectionPanel;
    }

    public String getTitle() {
        return "Specify Trigger condition";
    }

    public String getTriggerString() {
        String string = "";
        if (this.timeCheckbox.isSelected()) {
            if (this.tabPanel.getSelectedComponent() == this.examplePanel || this.tabPanel.getSelectedComponent() == this.NLPanel) {
                string = this.minField.getText().trim();
                string = String.valueOf(string) + "&&" + this.hourField.getText().trim();
                string = String.valueOf(string) + "&&" + this.dayField.getText().trim();
                string = String.valueOf(string) + "&&" + this.monthField.getText().trim();
                string = String.valueOf(string) + "&&" + this.weekdayField.getText().trim();
                return string;
            }
            if (this.tabPanel.getSelectedComponent() == this.cronPanel) {
                string = this.cronMinField.getText().trim();
                string = String.valueOf(string) + "&&" + this.cronHourField.getText().trim();
                string = String.valueOf(string) + "&&" + this.cronDayField.getText().trim();
                string = String.valueOf(string) + "&&" + this.cronMonthField.getText().trim();
                string = String.valueOf(string) + "&&" + this.cronWeekdayField.getText().trim();
                return string;
            }
            string = "&&&&&&0&&";
            return string;
        }
        if (this.contentCheckbox.isSelected()) {
            return this.contentTriggerField.getText();
        }
        string = "&&&&&&0&&";
        return string;
    }

    protected void init() {
        try {
            if (this.localFont == null) {
                this.localFont = new Font("timesRoman", 0, 14);
            }
            if (this.backgroundColor == null) {
                this.backgroundColor = Color.lightGray;
            }
            ((Container)((Object)this)).setLayout((LayoutManager)new BoxLayout((Container)((Object)this), 1));
            this.setBackground(this.backgroundColor);
            this.titleLabel = new JLabel("Specify Trigger condition");
            Font font = new Font("timesRoman", 1, 20);
            this.titleLabel.setFont(font);
            this.titleLabel.setForeground(Color.black);
            JPanel jPanel = new JPanel();
            jPanel.setLayout((LayoutManager)new BoxLayout((Container)jPanel, 0));
            jPanel.add(Box.createHorizontalGlue());
            jPanel.add((Component)this.titleLabel);
            jPanel.add(Box.createHorizontalGlue());
            ((Container)((Object)this)).add((Component)jPanel);
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout((LayoutManager)new BoxLayout((Container)jPanel2, 0));
            jPanel2.setBackground(new Color(253, 253, 180));
            jPanel2.setBorder(BorderFactory.createEtchedBorder());
            ((Container)((Object)this)).add((Component)jPanel2);
            this.triggerGroup = new ButtonGroup();
            this.contentCheckbox = new JCheckBox("Content based triggering", true);
            this.contentCheckbox.setBackground(new Color(253, 253, 180));
            this.triggerGroup.add((AbstractButton)this.contentCheckbox);
            this.contentCheckbox.setFont(this.localFont);
            this.contentCheckbox.addActionListener((ActionListener)this);
            this.contentCheckbox.setEnabled(false);
            jPanel2.add((Component)this.contentCheckbox);
            this.timeCheckbox = new JCheckBox("Time based triggering", false);
            this.timeCheckbox.setBackground(new Color(253, 253, 180));
            this.triggerGroup.add((AbstractButton)this.timeCheckbox);
            this.timeCheckbox.setFont(this.localFont);
            this.timeCheckbox.addActionListener((ActionListener)this);
            this.timeCheckbox.setEnabled(false);
            jPanel2.add((Component)this.timeCheckbox);
            jPanel2.add(Box.createHorizontalGlue());
            this.cardPanel = new JPanel();
            CardLayout cardLayout = new CardLayout();
            this.cardPanel.setLayout(cardLayout);
            this.cardPanel.setBackground(this.backgroundColor);
            ((Container)((Object)this)).add((Component)this.cardPanel);
            this.createContentPanel();
            this.cardPanel.add("content", (Component)this.contentPanel);
            this.createTimePanel();
            this.cardPanel.add("time", (Component)this.timePanel);
        }
        catch (Exception exception) {
            System.out.println("error in init TriggerPanel: " + exception);
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
    }

    public static void main(String[] stringArray) {
        try {
            Manager manager = new Manager(null, new TestTriggerState(), "Installing Continual Query");
            manager.show();
        }
        catch (Exception exception) {
            System.out.println("exception: " + exception);
        }
    }

    public void reset() {
        this.tabPanel.setSelectedIndex(0);
        this.exampleChoice_Selected(0);
        this.currentState = 1;
        this.stateHistory.removeAllElements();
        this.cTriggerVec.removeAllElements();
        this.updateContentTriggerField();
    }

    public void setContentTrigger(String string) {
        try {
            this.contentCheckbox_Clicked(null);
            this.contentTriggerField.setText(string);
        }
        catch (Exception exception) {
            System.out.println("Trigger.setContentTrigger error: " + exception);
        }
    }

    public void setExample(Object[] objectArray) {
        this.cTriggerVec = new Vector();
        this.stateHistory = new Vector();
        int n = 1;
        int n2 = 0;
        try {
            String string = (String)objectArray[13];
            Object[] objectArray2 = (Object[])objectArray[14];
            if (string.trim().equalsIgnoreCase("T") || string.trim().equalsIgnoreCase("EVERY") || string.trim().equalsIgnoreCase("CRON")) {
                this.timeCheckbox_Clicked(null);
                this.setTimeTrigger((String)objectArray2[0]);
            } else {
                this.contentCheckbox_Clicked(null);
                int n3 = 0;
                while (n3 < objectArray2.length) {
                    Object object = objectArray2[n3];
                    if (objectArray2.length <= n3 + 1) break;
                    String string2 = (String)objectArray2[++n3];
                    if (object == ITriggerPanel.TABLE) {
                        n2 = ITriggerPanel.stateChange[n][1];
                    } else if (object == ITriggerPanel.GROUP) {
                        n2 = ITriggerPanel.stateChange[n][0];
                    } else if (object == ITriggerPanel.OPERATOR) {
                        n2 = string2.trim().equalsIgnoreCase("CHANGES") ? 7 : ITriggerPanel.stateChange[n][2];
                        string2 = " " + string2 + " ";
                    } else if (object == ITriggerPanel.VALUE) {
                        n2 = ITriggerPanel.stateChange[n][6];
                    } else if (object == ITriggerPanel.LOGIC) {
                        n2 = ITriggerPanel.stateChange[n][3];
                        string2 = String.valueOf(ITriggerPanel.NEW_LINE) + "    " + string2 + " ";
                    } else if (object == ITriggerPanel.WHERE) {
                        n2 = ITriggerPanel.stateChange[n][4];
                        string2 = String.valueOf(ITriggerPanel.NEW_LINE) + "    " + string2 + " ";
                    }
                    if (n2 != 0) {
                        this.stateHistory.addElement(new Integer(n));
                        n = n2;
                        Pair pair = new Pair(object, string2);
                        this.cTriggerVec.addElement(pair);
                    }
                    ++n3;
                }
                this.updateContentTriggerField();
            }
        }
        catch (Exception exception) {
            System.out.println("error in setting example in trigger:" + exception);
        }
    }

    public void setLocalFont(Font font) {
        if (font == null) {
            return;
        }
        super.setFont(font);
        this.contentCheckbox.setFont(this.localFont);
        this.timeCheckbox.setFont(this.localFont);
        this.contentLabel.setFont(this.localFont);
        this.periodicCheckbox.setFont(this.localFont);
        this.cronCheckbox.setFont(this.localFont);
        this.NLChoice.setFont(this.localFont);
        this.minLabel.setFont(this.localFont);
        this.hourLabel.setFont(this.localFont);
        this.dayLabel.setFont(this.localFont);
        this.weekdayLabel.setFont(this.localFont);
        this.monthLabel.setFont(this.localFont);
        this.minField.setFont(this.localFont);
        this.hourField.setFont(this.localFont);
        this.dayField.setFont(this.localFont);
        this.weekdayField.setFont(this.localFont);
        this.monthField.setFont(this.localFont);
        this.cronminLabel.setFont(this.localFont);
        this.cronhourLabel.setFont(this.localFont);
        this.crondayLabel.setFont(this.localFont);
        this.cronweekdayLabel.setFont(this.localFont);
        this.cronmonthLabel.setFont(this.localFont);
        this.cronMinField.setFont(this.localFont);
        this.cronHourField.setFont(this.localFont);
        this.cronDayField.setFont(this.localFont);
        this.cronWeekdayField.setFont(this.localFont);
        this.cronMonthField.setFont(this.localFont);
    }

    public void setTimeTrigger(String string) {
        block46: {
            try {
                CharSequence charSequence;
                StringTokenizer stringTokenizer = new StringTokenizer(string, "&");
                if (!stringTokenizer.hasMoreTokens()) break block46;
                String string2 = stringTokenizer.nextToken();
                if (string2.equalsIgnoreCase("EVERY")) {
                    int n;
                    int n2;
                    this.tabPanel.setSelectedIndex(2);
                    charSequence = new StringBuffer();
                    int n3 = 1;
                    if (stringTokenizer.hasMoreTokens()) {
                        String string3 = stringTokenizer.nextToken();
                        try {
                            n3 = Integer.parseInt(string3);
                        }
                        catch (Exception exception) {}
                    }
                    int n4 = 1;
                    if (stringTokenizer.hasMoreTokens()) {
                        String string4 = stringTokenizer.nextToken();
                        if (string4.trim().equalsIgnoreCase("minutes")) {
                            n4 = 0;
                        } else if (string4.trim().equalsIgnoreCase("minute(s)")) {
                            n4 = 0;
                        } else if (string4.trim().equalsIgnoreCase("hour(s)")) {
                            n4 = 1;
                        } else if (string4.trim().equalsIgnoreCase("day(s)")) {
                            n4 = 2;
                        } else if (string4.trim().equalsIgnoreCase("month(s)")) {
                            n4 = 3;
                        }
                    }
                    if (n4 == 0) {
                        int n5 = n3;
                        n2 = n5 / 60;
                        if (n2 <= 0) {
                            if ((n5 %= 60) < 5) {
                                n5 = 5;
                            }
                            n = 0;
                            while (n < 60) {
                                ((StringBuffer)charSequence).append(n).append(",");
                                n += n5;
                            }
                            ((StringBuffer)charSequence).setLength(((StringBuffer)charSequence).length() - 1);
                            ((StringBuffer)charSequence).append("&&&&&&&&");
                        } else {
                            n3 = n2;
                            n4 = 1;
                        }
                    }
                    if (n4 == 1) {
                        int n6 = n3;
                        n2 = n6 / 24;
                        if (n2 <= 0) {
                            if ((n6 %= 24) < 1) {
                                n6 = 1;
                            }
                            ((StringBuffer)charSequence).append("0&");
                            n = 0;
                            while (n < 24) {
                                ((StringBuffer)charSequence).append(n).append(",");
                                n += n6;
                            }
                            ((StringBuffer)charSequence).setLength(((StringBuffer)charSequence).length() - 1);
                            ((StringBuffer)charSequence).append("&&&&&&");
                        } else {
                            n3 = n2;
                            n4 = 2;
                        }
                    }
                    if (n4 == 2) {
                        int n7 = n3;
                        n2 = n7 / 31;
                        if (n2 > 0) {
                            n3 = n2;
                            n4 = 3;
                        }
                        if ((n7 %= 31) < 1) {
                            n7 = 1;
                        }
                        ((StringBuffer)charSequence).append("0&0&");
                        n = 1;
                        while (n < 31) {
                            ((StringBuffer)charSequence).append(n).append(",");
                            n += n7;
                        }
                        ((StringBuffer)charSequence).setLength(((StringBuffer)charSequence).length() - 1);
                        ((StringBuffer)charSequence).append("&&&&");
                    }
                    if (n4 == 3) {
                        int n8 = n3;
                        n2 = n8 / 12;
                        if (n2 > 0) {
                            n8 = 11;
                        }
                        if (n8 < 1) {
                            n8 = 1;
                        }
                        ((StringBuffer)charSequence).append("0&0&1&");
                        n = 1;
                        while (n < 12) {
                            ((StringBuffer)charSequence).append(n).append(",");
                            n += n8;
                        }
                        ((StringBuffer)charSequence).setLength(((StringBuffer)charSequence).length() - 1);
                        ((StringBuffer)charSequence).append("&&");
                    }
                    string2 = "CRON";
                    stringTokenizer = new StringTokenizer(((StringBuffer)charSequence).toString(), "&");
                }
                if (string2.equalsIgnoreCase("CRON")) {
                    this.tabPanel.setSelectedIndex(2);
                    if (stringTokenizer.hasMoreTokens()) {
                        charSequence = stringTokenizer.nextToken();
                        this.cronMinField.setText((String)charSequence);
                    } else {
                        this.cronMinField.setText("");
                    }
                    if (stringTokenizer.hasMoreTokens()) {
                        charSequence = stringTokenizer.nextToken();
                        this.cronHourField.setText((String)charSequence);
                    } else {
                        this.cronHourField.setText("");
                    }
                    if (stringTokenizer.hasMoreTokens()) {
                        charSequence = stringTokenizer.nextToken();
                        this.cronDayField.setText((String)charSequence);
                    } else {
                        this.cronDayField.setText("");
                    }
                    if (stringTokenizer.hasMoreTokens()) {
                        charSequence = stringTokenizer.nextToken();
                        this.cronWeekdayField.setText((String)charSequence);
                    } else {
                        this.cronWeekdayField.setText("");
                    }
                    if (stringTokenizer.hasMoreTokens()) {
                        charSequence = stringTokenizer.nextToken();
                        this.cronMonthField.setText((String)charSequence);
                    } else {
                        this.cronMonthField.setText("");
                    }
                } else {
                    System.out.println("Error in Trigger condition: bad type");
                }
            }
            catch (Exception exception) {
                System.out.println("Trigger.setTriggerCondition error: " + exception);
            }
        }
    }

    public void setTriggerCondition(String string) {
        try {
            int n = Integer.parseInt(string);
            this.exampleChoice_Selected(n);
        }
        catch (Exception exception) {
            System.out.println("Trigger.setTriggerCondition error: " + exception);
        }
    }

    void timeCheckbox_Clicked(ActionEvent actionEvent) {
        this.timeCheckbox.setSelected(true);
        CardLayout cardLayout = (CardLayout)this.cardPanel.getLayout();
        cardLayout.show((Container)this.cardPanel, "time");
    }

    private void updateContentTriggerField() {
        StringBuffer stringBuffer = new StringBuffer();
        this.contentTriggerField.setText(stringBuffer.toString());
        Document document = this.contentTriggerField.getDocument();
        try {
            document.remove(0, document.getLength());
            this.cTriggerVec.size();
            int n = 0;
            while (n < this.cTriggerVec.size()) {
                Pair pair = (Pair)this.cTriggerVec.elementAt(n);
                if (pair.getLeft() == ITriggerPanel.WHERE) {
                    document.insertString(document.getLength(), (String)pair.getRight(), (AttributeSet)this.contentTriggerField.getStyle(ITriggerPanel.initStyles[5]));
                } else if (pair.getLeft() == ITriggerPanel.GROUP) {
                    document.insertString(document.getLength(), (String)pair.getRight(), (AttributeSet)this.contentTriggerField.getStyle(ITriggerPanel.initStyles[5]));
                } else if (pair.getLeft() == ITriggerPanel.OPERATOR) {
                    document.insertString(document.getLength(), (String)pair.getRight(), (AttributeSet)this.contentTriggerField.getStyle(ITriggerPanel.initStyles[6]));
                } else if (pair.getLeft() == ITriggerPanel.LOGIC) {
                    document.insertString(document.getLength(), (String)pair.getRight(), (AttributeSet)this.contentTriggerField.getStyle(ITriggerPanel.initStyles[5]));
                } else {
                    document.insertString(document.getLength(), (String)pair.getRight(), (AttributeSet)this.contentTriggerField.getStyle(ITriggerPanel.initStyles[1]));
                }
                ++n;
            }
            if (!this.updated) {
                ((Container)((Object)this)).invalidate();
                ((Container)((Object)this)).validate();
                ((Component)((Object)this)).repaint();
                this.updated = true;
            }
        }
        catch (Exception exception) {
            System.out.println("Error in updating query field: " + exception);
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
    }
}

