/*
 * Decompiled with CFR 0.152.
 */
package ogi.cq.plugin.gui.demo;

import Zql.ParseException;
import Zql.ZQuery;
import com.sun.java.swing.JFrame;
import java.util.Vector;
import ogi.cq.gui.InvalidStateChangeException;
import ogi.cq.gui.Manager;
import ogi.cq.gui.StatePanel;
import ogi.cq.log.CQLog;
import ogi.cq.log.Log;
import ogi.cq.plugin.IContinualQueryPlugin;
import ogi.cq.plugin.gui.demo.Examples;
import ogi.cq.plugin.gui.demo.PluginState;
import ogi.cq.plugin.gui.demo.QueryManager;
import ogi.cq.plugin.gui.demo.QueryPanel;

public class PluginQueryManager
extends PluginState
implements QueryManager {
    IContinualQueryPlugin plugin;
    private String userid;
    private String password;
    ZQuery query;
    private Examples examples;
    String[] args;
    String host;
    String port;
    String service;
    protected QueryPanel queryPanel;
    public static final boolean DEBUG = true;
    public static final int QUERY_PANEL = 0;
    public static final int PANEL_LENGTH = 1;
    public static final int TIMEOUT = 500;
    private String source;

    public PluginQueryManager(IContinualQueryPlugin iContinualQueryPlugin, String string, Examples examples) {
        this(iContinualQueryPlugin, string, examples, null);
    }

    public PluginQueryManager(IContinualQueryPlugin iContinualQueryPlugin, String string, Examples examples, Log log) {
        this.plugin = iContinualQueryPlugin;
        this.source = string;
        this.examples = examples;
        this.logger = log == null ? new CQLog() : log;
        this.init();
    }

    public void begin(String string) {
        this.source = string;
        this.manager = new Manager(this.userid, this, this.logger, "Query UI");
        if (this.manager != null) {
            this.setTitle(this.manager.getFrame());
        }
        this.manager.getFrame().setSize(700, 500);
        this.manager.show();
        this.disableNext();
    }

    protected void changeStateAfter() {
        if (this.currentPanel != 0) {
            this.manager.stopSpinner();
        }
    }

    protected void changeStateBefore() throws InvalidStateChangeException {
        if (this.currentPanel == 0) {
            this.manager.setStatus("");
            try {
                this.query = this.queryPanel.getQuery();
            }
            catch (Exception exception) {
                this.manager.setStatus(exception.getMessage());
                System.out.println("error in formulating query: " + exception);
                this.manager.stopSpinner();
                throw new InvalidStateChangeException(exception.getMessage());
            }
        }
    }

    public void finishButton() {
        this.nextButton();
    }

    public Vector getAttributes(String string) {
        try {
            return this.plugin.getAttributes(this.source, string);
        }
        catch (Exception exception) {
            return new Vector();
        }
    }

    public Examples getExamples() {
        return this.examples;
    }

    public Vector getQueryOperators() {
        try {
            return this.plugin.getQueryOperators();
        }
        catch (Exception exception) {
            System.out.println("error in GUIManager.getQueryOperators: " + exception);
            return new Vector();
        }
    }

    public Vector getRelations() {
        try {
            return this.plugin.getRelations(this.source);
        }
        catch (Exception exception) {
            System.out.println("error in GUIManager.getRelations: " + exception);
            return new Vector();
        }
    }

    public String getSource() {
        return this.source;
    }

    public Vector getTriggerOperators() {
        return new Vector();
    }

    public void init() {
        if (this.plugin == null) {
            return;
        }
        try {
            this.logger = new CQLog("Install CQ Log");
            this.logger.setDebug(true);
            this.panels = new StatePanel[1];
            this.queryPanel = new QueryPanel(this, this.examples, this.logger);
            this.panels[0] = this.queryPanel;
            this.panels[0].switchTo();
            this.currentPanel = 0;
        }
        catch (Exception exception) {
            System.out.println("plugin QueryManager.init error: " + exception);
        }
        if (this.manager != null) {
            this.setTitle(this.manager.getFrame());
        }
    }

    public void nextButton() {
        this.manager.startSpinner();
        this.manager.setStatus("Submitting Query...");
        try {
            this.query = this.queryPanel.getQuery();
            this.query();
        }
        catch (Exception exception) {
            this.manager.setStatus(exception.getMessage());
            System.out.println("error in formulating query: " + exception);
            this.manager.stopSpinner();
        }
    }

    public void previousButton() {
        this.manager.stopSpinner();
        super.previousButton();
    }

    private void query() {
        this.manager.startSpinner();
        String string = this.queryPanel.getSELECT();
        String string2 = this.queryPanel.getFROM();
        String string3 = this.queryPanel.getPredicates();
        String string4 = this.queryPanel.getGroupby();
        String string5 = this.queryPanel.getOrderby();
        try {
            System.out.println("pluginQueryManager query()");
            String string6 = this.plugin.formQuery(this.source, string, string2, string3, string4, string5);
            this.getBrowser(string6).show();
        }
        catch (ParseException parseException) {
            this.logger.log("Invalid Query, please check syntax");
            this.setStatus("Invalid Query, please check syntax");
        }
        this.manager.stopSpinner();
        this.manager.setStatus("");
    }

    public void reset() {
        super.reset();
        this.manager.enableFinish();
        this.manager.disablePrevious();
        this.manager.disableStart();
        this.manager.setStatus("");
    }

    public void setExample(Object[] objectArray) {
        this.setInExample(true);
        this.queryPanel.setExample(objectArray);
    }

    public void setPort(String string) {
        this.port = string;
    }

    public void setServer(String string) {
        this.host = string;
    }

    public void setService(String string) {
        this.service = string;
    }

    public void setSource(String string) {
        this.source = string;
    }

    public void setTitle(JFrame jFrame) {
        jFrame.setTitle("Query Entry Form");
    }
}

