/*
 * Decompiled with CFR 0.152.
 */
package ogi.cq.plugin.gui.demo;

import Zql.ZQuery;
import com.sun.java.swing.ImageIcon;
import com.sun.java.swing.JFrame;
import com.sun.java.swing.UIManager;
import java.awt.Frame;
import java.util.Vector;
import ogi.cq.gui.InvalidStateChangeException;
import ogi.cq.gui.Manager;
import ogi.cq.gui.StatePanel;
import ogi.cq.log.CQLog;
import ogi.cq.log.Log;
import ogi.cq.log.OutLog;
import ogi.cq.plugin.CQNotInstalledException;
import ogi.cq.plugin.ContinualQueryPlugin;
import ogi.cq.plugin.IContinualQueryPlugin;
import ogi.cq.plugin.InvalidCQException;
import ogi.cq.plugin.gui.demo.Examples;
import ogi.cq.plugin.gui.demo.JTAVExamples;
import ogi.cq.plugin.gui.demo.LogPanel;
import ogi.cq.plugin.gui.demo.NotifyPanel;
import ogi.cq.plugin.gui.demo.PluginState;
import ogi.cq.plugin.gui.demo.QueryManager;
import ogi.cq.plugin.gui.demo.QueryPanel;
import ogi.cq.plugin.gui.demo.StopPanel;
import ogi.cq.plugin.gui.demo.TriggerPanel;

public class PluginCQManager
extends PluginState
implements QueryManager {
    IContinualQueryPlugin plugin;
    private String userid;
    private String password;
    ZQuery query;
    String trigger;
    String stop;
    String notify;
    boolean submitted = false;
    private Examples examples;
    String[] args;
    String host;
    String port;
    String service;
    protected QueryPanel queryPanel;
    protected TriggerPanel triggerPanel;
    protected StopPanel stopPanel;
    protected NotifyPanel notifyPanel;
    protected LogPanel logPanel;
    ImageIcon treeClosedIcon;
    ImageIcon treeOpenIcon;
    ImageIcon treeLeafIcon;
    ImageIcon queryIcon;
    ImageIcon wrapperIcon;
    ImageIcon urlIcon;
    public static final boolean DEBUG = true;
    public static final int QUERY_PANEL = 0;
    public static final int TRIGGER_PANEL = 1;
    public static final int STOP_PANEL = 2;
    public static final int NOTIFY_PANEL = 3;
    public static final int LOG_PANEL = 4;
    public static final int PANEL_LENGTH = 5;
    public static final int CQ_SYSTEM_PANEL = 6;
    public static final int SINGLE_CQ_PANEL = 7;
    public static final int TIMEOUT = 500;
    private String source;

    public PluginCQManager(IContinualQueryPlugin iContinualQueryPlugin, String string, Examples examples) {
        this(iContinualQueryPlugin, string, examples, null);
    }

    public PluginCQManager(IContinualQueryPlugin iContinualQueryPlugin, String string, Examples examples, Log log) {
        this.plugin = iContinualQueryPlugin;
        this.source = string;
        this.examples = examples;
        this.logger = log == null ? new CQLog() : log;
        this.init();
    }

    public void begin(String string, String string2, String string3) {
        this.source = string;
        this.userid = string2;
        this.password = string3;
        this.manager = new Manager(this.userid, this, this.logger, "Continual Query UI");
        if (this.manager != null) {
            this.setTitle(this.manager.getFrame());
        }
        this.manager.getFrame().setSize(700, 550);
        this.manager.show();
        this.queryPanel.setSelectedTab(3);
    }

    protected void changeStateAfter() {
        if (this.currentPanel != 0) {
            if (this.currentPanel == 1) {
                this.manager.stopSpinner();
            } else if (this.currentPanel == 2) {
                this.manager.stopSpinner();
            } else if (this.currentPanel == 3) {
                this.manager.disableNext();
                this.manager.stopSpinner();
            } else if (this.currentPanel == 4) {
                if (!this.submitted) {
                    if (this.userid == null) {
                        this.logPanel.log("\nNull User ID: cannot install query");
                        return;
                    }
                    this.submitted = true;
                    this.manager.setStatus("Installing query, please be patient...");
                    String string = this.queryPanel.getCQName();
                    String string2 = this.queryPanel.getSELECT();
                    String string3 = this.queryPanel.getFROM();
                    String string4 = this.queryPanel.getPredicates();
                    String string5 = this.queryPanel.getGroupby();
                    String string6 = this.queryPanel.getOrderby();
                    String string7 = this.triggerPanel.getTriggerString();
                    String string8 = this.notifyPanel.getNotifyConfig();
                    System.out.println(string8);
                    String string9 = this.stopPanel.getStopString();
                    if (string != null && !string.equals("")) {
                        this.logPanel.log("\n<br><b>CQ Name</b>: " + string);
                    }
                    if (string2 != null && !string2.equals("")) {
                        this.logPanel.log("\n<br><b>SELECT</b> " + string2);
                    }
                    if (string3 != null && !string3.equals("")) {
                        this.logPanel.log("\n<br><b>FROM</b> " + string3);
                    }
                    if (string4 != null && !string4.equals("")) {
                        this.logPanel.log("\n<br><b>WHERE </b>" + string4);
                    }
                    if (string5 != null && !string5.equals("")) {
                        this.logPanel.log("\n<br><b>Group by </b>" + string5);
                    }
                    if (string6 != null && !string6.equals("")) {
                        this.logPanel.log("\n<br><b>Order by </b>" + string6);
                    }
                    if (string7 != null && !string7.equals("")) {
                        this.logPanel.log("\n\n<br><br><b>Trigger Condition: </b>" + string7);
                    }
                    if (string9 != null && !string9.equals("")) {
                        this.logPanel.log("\n<br><b>Stop Condition: </b>" + string9);
                    }
                    if (string8 != null && !string8.equals("")) {
                        this.logPanel.log("\n<br><b>Notification Configuration: </b>\n" + string8);
                    }
                    this.logPanel.log("<br>\n---\n<br>");
                    this.logPanel.log("\nConnecting to cluster at:<br> ");
                    this.logPanel.log(this.plugin.getHost());
                    this.logPanel.log(":");
                    this.logPanel.log(this.plugin.getPort());
                    this.logPanel.log("...\n\n<br><br>");
                    Runnable runnable = new Runnable(this){
                        /* synthetic */ PluginCQManager this$0;

                        public void run() {
                            PluginCQManager.access$installCQ(this.this$0);
                        }
                        {
                            this.this$0 = pluginCQManager;
                        }
                    };
                    Thread thread = new Thread(runnable);
                    thread.start();
                } else {
                    this.manager.setStatus("<h2>Query already submitted</h2>");
                }
            } else {
                this.manager.stopSpinner();
            }
        }
    }

    protected void changeStateBefore() throws InvalidStateChangeException {
        if (this.currentPanel == 0) {
            this.manager.setStatus("");
            try {
                this.query = this.queryPanel.getQuery();
            }
            catch (Exception exception) {
                this.manager.setStatus(exception.getMessage());
                System.out.println("error in formulating query: " + exception);
                this.manager.stopSpinner();
                throw new InvalidStateChangeException(exception.getMessage());
            }
        } else if (this.currentPanel == 1) {
            try {
                this.trigger = this.triggerPanel.getTriggerString();
            }
            catch (Exception exception) {
                this.manager.setStatus(exception.toString());
                System.out.println("error in formulating trigger: " + exception);
                exception.printStackTrace();
            }
        } else if (this.currentPanel == 2) {
            try {
                this.stop = this.stopPanel.getStopString();
            }
            catch (Exception exception) {
                this.manager.setStatus(exception.toString());
                System.out.println("error in formulating stop: " + exception);
                exception.printStackTrace();
            }
        } else if (this.currentPanel == 3) {
            try {
                this.notify = this.notifyPanel.getNotifyConfig();
            }
            catch (Exception exception) {
                this.manager.setStatus(exception.toString());
                System.out.println("error in formulating notify: " + exception);
                exception.printStackTrace();
            }
        } else if (this.currentPanel == 4) {
            this.manager.startSpinner();
        } else {
            System.out.println("current panel number is in a strange state");
            this.manager.stopSpinner();
        }
    }

    public void finishButton() {
        super.finishButton();
        String string = this.getFinishURL();
        if (string == null) {
            return;
        }
        this.showURL(string);
    }

    public Vector getAttributes(String string) {
        try {
            return this.plugin.getAttributes(this.source, string);
        }
        catch (Exception exception) {
            return new Vector();
        }
    }

    public Examples getExamples() {
        return this.examples;
    }

    public Vector getQueryOperators() {
        try {
            return this.plugin.getQueryOperators();
        }
        catch (Exception exception) {
            System.out.println("error in GUIManager.getQueryOperators: " + exception);
            return new Vector();
        }
    }

    public Vector getRelations() {
        try {
            return this.plugin.getRelations(this.source);
        }
        catch (Exception exception) {
            System.out.println("error in GUIManager.getRelations: " + exception);
            return new Vector();
        }
    }

    public String getSource() {
        return this.source;
    }

    public Vector getTriggerOperators() {
        try {
            return this.plugin.getTriggerOperators();
        }
        catch (Exception exception) {
            System.out.println("error in GUIManager.getQueryOperators: " + exception);
            return new Vector();
        }
    }

    public void init() {
        if (this.plugin == null) {
            return;
        }
        try {
            this.logger = new CQLog("Install CQ Log");
            this.logger.setDebug(true);
            this.panels = new StatePanel[5];
            this.queryPanel = new QueryPanel(this, this.examples, this.logger);
            this.panels[0] = this.queryPanel;
            this.triggerPanel = new TriggerPanel(this, this.logger);
            this.panels[1] = this.triggerPanel;
            this.stopPanel = new StopPanel(this, this.logger);
            this.panels[2] = this.stopPanel;
            this.notifyPanel = new NotifyPanel(this, this.logger);
            this.panels[3] = this.notifyPanel;
            this.logPanel = new LogPanel(this, this.logger);
            this.panels[4] = this.logPanel;
            this.panels[0].switchTo();
            this.currentPanel = 0;
            this.triggerPanel.setContentTrigger("ammunition.qty_di CHANGES ");
        }
        catch (Exception exception) {
            System.out.println("plugin GUIManager.init error: " + exception);
        }
        if (this.manager != null) {
            this.setTitle(this.manager.getFrame());
        }
    }

    private void installCQ() {
        this.manager.startSpinner();
        if (this.userid == null) {
            this.logPanel.log("\nNull User ID: cannot install query");
            return;
        }
        String string = this.queryPanel.getCQName();
        String string2 = this.queryPanel.getSELECT();
        String string3 = this.queryPanel.getFROM();
        String string4 = this.queryPanel.getPredicates();
        String string5 = this.queryPanel.getGroupby();
        String string6 = this.queryPanel.getOrderby();
        String string7 = this.triggerPanel.getTriggerString();
        String string8 = this.notifyPanel.getNotifyConfig();
        String string9 = this.stopPanel.getStopString();
        try {
            System.out.println("pluginGUIManager installCQ()");
            this.plugin.installCQ(this.logPanel, this.source, this.userid, this.password, string, string2, string3, string4, string5, string6, string7, this.triggerPanel.getContentTrigger(), string8, string9);
        }
        catch (InvalidCQException invalidCQException) {
            this.logPanel.log("\n<br>Invalid CQ:" + invalidCQException.toString());
        }
        catch (CQNotInstalledException cQNotInstalledException) {
            this.logPanel.log("\n<br>CQ Not Installed:" + cQNotInstalledException.toString());
        }
        this.manager.stopSpinner();
    }

    public static void main(String[] stringArray) {
        try {
            System.out.println(System.getProperty("os.name"));
            UIManager.setLookAndFeel((String)UIManager.getCrossPlatformLookAndFeelClassName());
            OutLog outLog = new OutLog();
            ContinualQueryPlugin continualQueryPlugin = new ContinualQueryPlugin();
            continualQueryPlugin.initialize(stringArray);
            PluginCQManager pluginCQManager = new PluginCQManager(continualQueryPlugin, "jtav", new JTAVExamples(), outLog);
            pluginCQManager.begin("jtav", "dave", "test");
        }
        catch (Exception exception) {
            System.out.println("Plugin GUI Manager.main exception: " + exception);
            exception.printStackTrace();
        }
    }

    public void nextButton() {
        this.manager.startSpinner();
        this.manager.setStatus("");
        super.nextButton();
    }

    public void previousButton() {
        this.manager.stopSpinner();
        super.previousButton();
    }

    public void reset() {
        super.reset();
        this.submitted = false;
        this.manager.enableNext();
        this.manager.enableFinish();
        this.manager.disablePrevious();
        this.manager.disableStart();
        this.manager.setStatus("");
        this.setFinishURL(null);
    }

    public void setExample(Object[] objectArray) {
        this.setInExample(true);
        this.queryPanel.setExample(objectArray);
        this.triggerPanel.setExample(objectArray);
        this.stopPanel.setExample(objectArray);
    }

    public void setPort(String string) {
        this.port = string;
    }

    public void setQueryIcon(ImageIcon imageIcon) {
        this.queryIcon = imageIcon;
    }

    public void setServer(String string) {
        this.host = string;
    }

    public void setService(String string) {
        this.service = string;
    }

    public void setSource(String string) {
        this.source = string;
    }

    public void setTitle(JFrame jFrame) {
        jFrame.setTitle("Continual Query Entry Form");
    }

    public void setTitle(Frame frame) {
        frame.setTitle("Continual Query Entry Form");
    }

    public void setTreeClosedIcon(ImageIcon imageIcon) {
        this.treeClosedIcon = imageIcon;
    }

    public void setTreeLeafIcon(ImageIcon imageIcon) {
        this.treeLeafIcon = imageIcon;
    }

    public void setTreeOpenIcon(ImageIcon imageIcon) {
        this.treeOpenIcon = imageIcon;
    }

    public void setURLIcon(ImageIcon imageIcon) {
        this.urlIcon = imageIcon;
    }

    public void setWrapperIcon(ImageIcon imageIcon) {
        this.wrapperIcon = imageIcon;
    }

    static void access$installCQ(PluginCQManager pluginCQManager) {
        pluginCQManager.installCQ();
    }
}

