/*
 * Decompiled with CFR 0.152.
 */
package ogi.cq.plugin.gui;

import com.sun.java.swing.BorderFactory;
import com.sun.java.swing.Box;
import com.sun.java.swing.BoxLayout;
import com.sun.java.swing.DefaultListModel;
import com.sun.java.swing.JButton;
import com.sun.java.swing.JComboBox;
import com.sun.java.swing.JFrame;
import com.sun.java.swing.JLabel;
import com.sun.java.swing.JList;
import com.sun.java.swing.JPanel;
import com.sun.java.swing.JScrollPane;
import com.sun.java.swing.JTextArea;
import com.sun.java.swing.JTextField;
import com.sun.java.swing.ListModel;
import com.sun.java.swing.Timer;
import com.sun.java.swing.event.ListSelectionEvent;
import com.sun.java.swing.event.ListSelectionListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.Vector;
import ogi.cq.gui.Spinner;
import ogi.cq.log.CQLog;
import ogi.cq.log.CQLogView;
import ogi.cq.log.Log;
import ogi.cq.log.RollingLogModel;
import ogi.cq.plugin.IContinualQueryPlugin;
import ogi.cq.plugin.gui.BrowserFrame;
import ogi.cq.time.Time;
import ogi.diom.util.URLUtils;

public class UpdateFrame
extends JFrame
implements ActionListener,
Time,
ListSelectionListener {
    IContinualQueryPlugin plugin;
    JPanel titlePanel;
    JPanel sourcePanel;
    JComboBox sourceSelector;
    JButton tableButton;
    JPanel tablePanel;
    JList tableList;
    JList attributeList;
    JTextField tableField;
    JTextField idField;
    JTextField valueField;
    JButton idSelectButton;
    JButton valueSelectButton;
    JPanel intervalPanel;
    JComboBox intervalSelector;
    JTextField idLengthField;
    int idLength = 10;
    JPanel buttonPanel;
    JButton startButton;
    JButton endButton;
    JButton closeButton;
    JPanel statusPanel;
    JButton helpButton;
    JButton logButton;
    JTextField status;
    Spinner spinner;
    JFrame helpFrame;
    JButton helpCloseButton;
    Log logger;
    Timer updateTimer;
    String ID;
    boolean updating;
    int updateCount;
    private String server;
    private String port;
    private String proxy;
    private int proxyPort;
    boolean tableValueChanging;
    BrowserFrame browser;
    public static final long[] interval = new long[]{60000L, 300000L, 600000L, 1800000L, 3600000L};
    public static final String[] intervalString = new String[]{"Every Minute", "Every 5 Minutes", "Every 10 Minutes", "Every 30 Minutes", "Every Hour"};
    public static final int DEFAULT_ID_LENGTH = 5;
    public static final String NEW_LINE = System.getProperty("line.separator");
    public static final String DEFAULT_LOCATION = "http://www.cse.ogi.edu/DISC/CQ";

    public UpdateFrame(IContinualQueryPlugin iContinualQueryPlugin) {
        this(iContinualQueryPlugin, "Date Update");
    }

    public UpdateFrame(IContinualQueryPlugin iContinualQueryPlugin, String string) {
        super(string);
        this.plugin = iContinualQueryPlugin;
        this.initGUI();
        RollingLogModel rollingLogModel = new RollingLogModel();
        CQLogView cQLogView = new CQLogView(rollingLogModel, "Data update log", Color.lightGray);
        this.logger = new CQLog(rollingLogModel, cQLogView);
        ((Frame)((Object)cQLogView)).setTitle("Data update log");
        ((Component)((Object)this)).setSize(640, 480);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.helpButton) {
            System.out.println("help");
            this.getHelp().setVisible(true);
        } else if (actionEvent.getSource() == this.helpCloseButton) {
            this.getHelp().setVisible(false);
        } else if (actionEvent.getSource() == this.closeButton) {
            ((Component)((Object)this)).setVisible(false);
        } else if (actionEvent.getSource() == this.logButton) {
            this.logger.show();
        } else if (actionEvent.getSource() == this.startButton) {
            this.startUpdate();
        } else if (actionEvent.getSource() == this.endButton) {
            this.endUpdate();
        } else if (actionEvent.getSource() == this.tableButton) {
            this.getTables();
        } else if (actionEvent.getSource() == this.idSelectButton) {
            if (this.attributeList.getSelectedIndex() >= 0) {
                String string = (String)this.attributeList.getSelectedValue();
                this.logger.log(3, "Select ID attribute: " + string);
                this.idField.setText(string);
            }
        } else if (actionEvent.getSource() == this.valueSelectButton && this.attributeList.getSelectedIndex() >= 0) {
            String string = (String)this.attributeList.getSelectedValue();
            this.logger.log(3, "Select value attribute: " + string);
            this.valueField.setText(string);
        }
    }

    private void endUpdate() {
        this.spinner.startSpinning();
        Runnable runnable = new Runnable(this){
            /* synthetic */ UpdateFrame this$0;

            public void run() {
                UpdateFrame.access$endUpdate0(this.this$0);
            }
            {
                this.this$0 = updateFrame;
            }
        };
        Thread thread = new Thread(runnable);
        thread.start();
        this.spinner.stopSpinning();
    }

    private void endUpdate0() {
        try {
            this.status.setText("End data update script");
            this.startButton.setEnabled(true);
            this.idSelectButton.setEnabled(true);
            this.valueSelectButton.setEnabled(true);
            this.endButton.setEnabled(false);
            this.updating = false;
            String string = "http://" + this.server + ":" + this.port + "/" + this.getUpdateServlet() + "?action=endUpdate&id=" + this.ID + "&source=" + this.sourceSelector.getSelectedItem() + "&table=" + this.tableField.getText() + "&idField=" + this.idField.getText() + "&valueField=" + this.valueField.getText();
            URL uRL = new URL(string);
            if (this.proxy != null && this.proxyPort > 0) {
                URLUtils.get(uRL, this.proxy, this.proxyPort);
            } else {
                URLUtils.get(uRL);
            }
        }
        catch (Exception exception) {
            System.out.println("Error in ending update: " + exception);
        }
        this.updateTimer.stop();
        this.logger.log(0, "END update");
    }

    public void exit() {
        if (this.updating) {
            this.endUpdate0();
        }
    }

    private BrowserFrame getBrowserFrame() {
        if (this.browser == null) {
            this.getBrowserFrame(DEFAULT_LOCATION);
        }
        return this.browser;
    }

    private BrowserFrame getBrowserFrame(String string) {
        if (this.browser == null) {
            this.browser = new BrowserFrame(string);
            ((Component)this.browser).setSize(800, 600);
        } else {
            this.browser.setLocation(string);
        }
        return this.browser;
    }

    protected JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new JPanel();
            this.buttonPanel.setLayout((LayoutManager)new BoxLayout((Container)this.buttonPanel, 0));
            this.buttonPanel.add(Box.createRigidArea((Dimension)new Dimension(5, 5)));
            this.startButton = new JButton("Start Update");
            this.startButton.setBackground(Color.blue);
            this.startButton.setForeground(Color.white);
            this.startButton.addActionListener((ActionListener)this);
            this.buttonPanel.add((Component)this.startButton);
            this.endButton = new JButton("End Update");
            this.endButton.setBackground(Color.blue);
            this.endButton.setForeground(Color.white);
            this.endButton.addActionListener((ActionListener)this);
            this.buttonPanel.add((Component)this.endButton);
            this.buttonPanel.add(Box.createHorizontalGlue());
            this.closeButton = new JButton("Close");
            this.closeButton.setBackground(Color.red);
            this.closeButton.addActionListener((ActionListener)this);
            this.buttonPanel.add((Component)this.closeButton);
        }
        return this.buttonPanel;
    }

    public JFrame getHelp() {
        if (this.helpFrame == null) {
            String string = "Help -- Data Update Window";
            this.helpFrame = new JFrame(string);
            JPanel jPanel = (JPanel)this.helpFrame.getContentPane();
            jPanel.setLayout((LayoutManager)new BoxLayout((Container)jPanel, 1));
            Font font = new Font("timesRoman", 1, 20);
            JLabel jLabel = new JLabel(string);
            jLabel.setFont(font);
            jLabel.setForeground(Color.blue);
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new FlowLayout());
            jPanel2.add((Component)jLabel);
            jPanel.add((Component)jPanel2);
            jPanel.add(Box.createRigidArea((Dimension)new Dimension(20, 20)));
            JTextArea jTextArea = new JTextArea();
            jTextArea.setEditable(false);
            jTextArea.append("This window allows users to automatically update data in selected CQ sources.");
            jTextArea.append(NEW_LINE);
            jTextArea.append(NEW_LINE);
            jTextArea.append("To run the update feature, follow these steps: ");
            jTextArea.append(NEW_LINE);
            jTextArea.append("1) Select the source you want to update and click \"Get Tables\" ");
            jTextArea.append(NEW_LINE);
            jTextArea.append("2) Select the table you want to update from the object list. ");
            jTextArea.append(NEW_LINE);
            jTextArea.append("3) Select the column to use as an ID column and click \"Select ID Attribute\" ");
            jTextArea.append(" NOTE: The id column MUST be of VARCHAR or string type.");
            jTextArea.append(NEW_LINE);
            jTextArea.append("4) Select the column to use as the value column and click \"Select Value Attribute\" ");
            jTextArea.append(" NOTE: The value column MUST be of numeric type.");
            jTextArea.append(NEW_LINE);
            jTextArea.append("5) set the size of the ID length to be less than the size of the ID column.  THIS IS IMPORTANT. ");
            jTextArea.append("If the size is too large, the updates will fail ");
            jTextArea.append(NEW_LINE);
            jTextArea.append("6) Select the interval you want the updates to occur at ");
            jTextArea.append(NEW_LINE);
            jTextArea.append("7) Click the \"Start Update\" button to start the updates. ");
            jTextArea.append(NEW_LINE);
            jTextArea.append("8) Click the \"End Update\" button to stop the updates. ");
            jTextArea.append(NEW_LINE);
            jTextArea.append(NEW_LINE);
            jTextArea.append("The update script works by inserting a new row into the target table when the script starts. ");
            jTextArea.append("Then, after each interval passes, the script updates the row by incrementing the value field. ");
            jTextArea.append("When the script is stopped, the row is deleted from the table. ");
            jTextArea.append(NEW_LINE);
            jTextArea.append("The inserted row has a random string in the id column.  The string length is defined by the user. ");
            jTextArea.append("The row starts with a value of 0 in the value column and is incremented by 1 on each update. ");
            jTextArea.append("All other columns are empty or 0 ");
            jTextArea.setLineWrap(true);
            jTextArea.setWrapStyleWord(true);
            JScrollPane jScrollPane = new JScrollPane((Component)jTextArea);
            jScrollPane.setVerticalScrollBarPolicy(22);
            jScrollPane.setHorizontalScrollBarPolicy(31);
            jScrollPane.setPreferredSize(new Dimension(250, 250));
            jPanel.add((Component)jScrollPane);
            Font font2 = new Font("timesRoman", 0, 15);
            jTextArea.setFont(font2);
            JPanel jPanel3 = new JPanel();
            jPanel3.setLayout(new FlowLayout());
            this.helpCloseButton = new JButton("Close");
            this.helpCloseButton.setBackground(Color.red);
            this.helpCloseButton.addActionListener((ActionListener)this);
            jPanel3.add((Component)this.helpCloseButton);
            jPanel.add((Component)jPanel3);
            this.helpFrame.setSize(640, 480);
        }
        return this.helpFrame;
    }

    private String getID() {
        int n = 5;
        try {
            n = Integer.parseInt(this.idLengthField.getText());
        }
        catch (NumberFormatException numberFormatException) {}
        if (this.ID == null || n != this.idLength) {
            this.idLength = Math.abs(n);
            long l = 10L;
            int n2 = 1;
            while (n2 < this.idLength) {
                l *= 10L;
                ++n2;
            }
            this.ID = String.valueOf(Math.round(Math.random() * (double)l));
        }
        return this.ID;
    }

    protected JPanel getIntervalPanel() {
        if (this.intervalPanel == null) {
            this.intervalPanel = new JPanel();
            this.intervalPanel.setLayout((LayoutManager)new BoxLayout((Container)this.intervalPanel, 1));
            this.intervalPanel.add(Box.createRigidArea((Dimension)new Dimension(5, 5)));
            JPanel jPanel = new JPanel();
            jPanel.setLayout((LayoutManager)new BoxLayout((Container)jPanel, 0));
            this.intervalPanel.add((Component)jPanel);
            jPanel.add((Component)new JLabel("Update Interval: "));
            this.intervalSelector = new JComboBox();
            int n = 0;
            while (n < intervalString.length) {
                this.intervalSelector.addItem((Object)intervalString[n]);
                ++n;
            }
            this.intervalSelector.setSelectedIndex(0);
            this.intervalSelector.addActionListener((ActionListener)this);
            jPanel.add(Box.createRigidArea((Dimension)new Dimension(5, 5)));
            jPanel.add((Component)this.intervalSelector);
            jPanel.add(Box.createHorizontalGlue());
            this.intervalPanel.add(Box.createRigidArea((Dimension)new Dimension(5, 5)));
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout((LayoutManager)new BoxLayout((Container)jPanel2, 0));
            this.intervalPanel.add((Component)jPanel2);
            jPanel2.add((Component)new JLabel("max ID length: "));
            this.idLengthField = new JTextField(String.valueOf(5));
            this.idLengthField.setMaximumSize(new Dimension(this.idLengthField.getMaximumSize().width, this.idLengthField.getFontMetrics(this.idLengthField.getFont()).getHeight() * 2));
            jPanel2.add(Box.createRigidArea((Dimension)new Dimension(5, 5)));
            jPanel2.add((Component)this.idLengthField);
            jPanel2.add(Box.createHorizontalGlue());
        }
        return this.intervalPanel;
    }

    public String getPort() {
        return this.port;
    }

    public String getProxy() {
        return this.proxy;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public String getServer() {
        return this.server;
    }

    private String getSource() {
        return (String)this.sourceSelector.getSelectedItem();
    }

    protected JPanel getSourcePanel() {
        if (this.sourcePanel == null) {
            this.sourcePanel = new JPanel();
            this.sourcePanel.setLayout((LayoutManager)new BoxLayout((Container)this.sourcePanel, 0));
            this.sourcePanel.add(Box.createRigidArea((Dimension)new Dimension(5, 5)));
            this.sourceSelector = new JComboBox();
            this.sourceSelector.addActionListener((ActionListener)this);
            this.sourcePanel.add(Box.createRigidArea((Dimension)new Dimension(5, 5)));
            this.sourcePanel.add((Component)new JLabel("Select source: "));
            this.sourcePanel.add((Component)this.sourceSelector);
            this.sourcePanel.add(Box.createHorizontalGlue());
            if (this.plugin != null) {
                Vector vector = this.plugin.getSources();
                int n = 0;
                while (n < vector.size()) {
                    this.sourceSelector.addItem(vector.elementAt(n));
                    ++n;
                }
            }
            this.tableButton = new JButton("Get Tables");
            this.tableButton.setBackground(Color.orange);
            this.tableButton.addActionListener((ActionListener)this);
            this.sourcePanel.add((Component)this.tableButton);
        }
        return this.sourcePanel;
    }

    protected JPanel getStatusPanel() {
        if (this.statusPanel == null) {
            this.statusPanel = new JPanel();
            this.statusPanel.setLayout((LayoutManager)new BoxLayout((Container)this.statusPanel, 0));
            this.helpButton = new JButton("Help");
            this.helpButton.setBackground(Color.green);
            this.helpButton.addActionListener((ActionListener)this);
            this.helpButton.setAlignmentY(0.5f);
            this.statusPanel.add((Component)this.helpButton);
            this.logButton = new JButton("Log");
            this.logButton.addActionListener((ActionListener)this);
            this.logButton.setAlignmentY(0.5f);
            this.statusPanel.add((Component)this.logButton);
            this.status = new JTextField("Status");
            this.status.setForeground(Color.blue);
            this.status.setBackground(Color.lightGray);
            this.status.setEditable(false);
            this.status.setAlignmentY(0.5f);
            this.status.setMaximumSize(new Dimension(this.status.getMaximumSize().width, this.status.getFontMetrics(this.status.getFont()).getHeight() * 2));
            this.statusPanel.add((Component)this.status);
            this.spinner = new Spinner();
            this.spinner.setAlignmentY(0.5f);
            this.statusPanel.add((Component)((Object)this.spinner));
        }
        return this.statusPanel;
    }

    protected JPanel getTablePanel() {
        if (this.tablePanel == null) {
            this.tablePanel = new JPanel();
            this.tablePanel.setLayout((LayoutManager)new BoxLayout((Container)this.tablePanel, 1));
            this.tablePanel.add(Box.createRigidArea((Dimension)new Dimension(5, 5)));
            JPanel jPanel = new JPanel();
            jPanel.setLayout((LayoutManager)new BoxLayout((Container)jPanel, 0));
            this.tablePanel.add((Component)jPanel);
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout((LayoutManager)new BoxLayout((Container)jPanel2, 1));
            jPanel.add((Component)jPanel2);
            jPanel.add(Box.createRigidArea((Dimension)new Dimension(15, 15)));
            JLabel jLabel = new JLabel("Object");
            jLabel.setForeground(Color.black);
            jPanel2.add((Component)jLabel);
            this.tableList = new JList();
            this.tableList.setModel((ListModel)new DefaultListModel());
            this.tableList.addListSelectionListener((ListSelectionListener)this);
            JScrollPane jScrollPane = new JScrollPane((Component)this.tableList);
            jPanel2.add((Component)jScrollPane);
            JPanel jPanel3 = new JPanel();
            jPanel3.setLayout((LayoutManager)new BoxLayout((Container)jPanel3, 1));
            jPanel.add((Component)jPanel3);
            JLabel jLabel2 = new JLabel("Object Attributes");
            jLabel2.setForeground(Color.black);
            jPanel3.add((Component)jLabel2);
            this.attributeList = new JList();
            this.attributeList.setModel((ListModel)new DefaultListModel());
            this.attributeList.addListSelectionListener((ListSelectionListener)this);
            JScrollPane jScrollPane2 = new JScrollPane((Component)this.attributeList);
            jPanel3.add((Component)jScrollPane2);
            JPanel jPanel4 = new JPanel();
            jPanel4.setLayout((LayoutManager)new BoxLayout((Container)jPanel4, 0));
            JPanel jPanel5 = new JPanel();
            jPanel5.setLayout((LayoutManager)new BoxLayout((Container)jPanel5, 1));
            JPanel jPanel6 = new JPanel();
            jPanel6.setLayout((LayoutManager)new BoxLayout((Container)jPanel6, 1));
            JPanel jPanel7 = new JPanel();
            jPanel7.setLayout((LayoutManager)new BoxLayout((Container)jPanel7, 1));
            JLabel jLabel3 = new JLabel("Selected Table");
            jLabel3.setMaximumSize(new Dimension(jLabel3.getMaximumSize().width, jLabel3.getFontMetrics(jLabel3.getFont()).getHeight() * 2));
            jPanel5.add((Component)jLabel3);
            this.tableField = new JTextField("");
            this.tableField.setMaximumSize(new Dimension(this.tableField.getMaximumSize().width, this.tableField.getFontMetrics(this.tableField.getFont()).getHeight() * 2));
            jPanel6.add((Component)this.tableField);
            JLabel jLabel4 = new JLabel("ID Column");
            jPanel5.add((Component)jLabel4);
            jLabel4.setMaximumSize(new Dimension(jLabel4.getMaximumSize().width, jLabel4.getFontMetrics(jLabel4.getFont()).getHeight() * 2));
            this.idField = new JTextField("");
            this.idField.setMaximumSize(new Dimension(this.idField.getMaximumSize().width, this.idField.getFontMetrics(this.idField.getFont()).getHeight() * 2));
            jPanel6.add((Component)this.idField);
            this.idSelectButton = new JButton("Select ID attribute");
            this.idSelectButton.addActionListener((ActionListener)this);
            this.idSelectButton.setMaximumSize(new Dimension(this.idSelectButton.getMaximumSize().width, this.idSelectButton.getFontMetrics(this.idSelectButton.getFont()).getHeight() * 2));
            jPanel7.add((Component)this.idSelectButton);
            JLabel jLabel5 = new JLabel("Value Column");
            jLabel5.setMaximumSize(new Dimension(jLabel5.getMaximumSize().width, jLabel5.getFontMetrics(jLabel5.getFont()).getHeight() * 2));
            jPanel5.add((Component)jLabel5);
            this.valueField = new JTextField("");
            this.valueField.setMaximumSize(new Dimension(this.valueField.getMaximumSize().width, this.valueField.getFontMetrics(this.valueField.getFont()).getHeight() * 2));
            jPanel6.add((Component)this.valueField);
            this.valueSelectButton = new JButton("Select value attribute");
            this.valueSelectButton.setMaximumSize(new Dimension(this.valueSelectButton.getMaximumSize().width, this.valueSelectButton.getFontMetrics(this.valueSelectButton.getFont()).getHeight() * 2));
            this.valueSelectButton.addActionListener((ActionListener)this);
            jPanel7.add((Component)this.valueSelectButton);
            jPanel4.add((Component)jPanel5);
            jPanel4.add((Component)jPanel6);
            jPanel4.add((Component)jPanel7);
            this.tablePanel.add((Component)jPanel4);
        }
        return this.tablePanel;
    }

    private void getTables() {
        Vector vector = this.plugin.getRelations(this.getSource());
        DefaultListModel defaultListModel = (DefaultListModel)this.tableList.getModel();
        defaultListModel.clear();
        this.tableValueChanging = true;
        int n = 0;
        while (n < vector.size()) {
            defaultListModel.addElement(vector.elementAt(n));
            ++n;
        }
        this.tableValueChanging = false;
    }

    protected JPanel getTitlePanel() {
        if (this.titlePanel == null) {
            this.titlePanel = new JPanel();
            this.titlePanel.setLayout(new FlowLayout());
            JLabel jLabel = new JLabel("Automated update script");
            Font font = new Font("serif", 1, 20);
            jLabel.setFont(font);
            jLabel.setForeground(Color.red);
            this.titlePanel.add((Component)jLabel);
        }
        return this.titlePanel;
    }

    public String getUpdateServlet() {
        return System.getProperties().getProperty("cq.url.updateServlet");
    }

    private void initGUI() {
        JPanel jPanel = (JPanel)this.getContentPane();
        jPanel.setLayout((LayoutManager)new BoxLayout((Container)jPanel, 1));
        jPanel.setBorder(BorderFactory.createEtchedBorder());
        jPanel.add((Component)this.getTitlePanel());
        jPanel.add((Component)this.getSourcePanel());
        jPanel.add((Component)this.getTablePanel());
        jPanel.add((Component)this.getIntervalPanel());
        jPanel.add((Component)this.getButtonPanel());
        jPanel.add((Component)this.getStatusPanel());
    }

    public void setPort(String string) {
        this.port = string;
    }

    public void setProxy(String string) {
        this.proxy = string;
    }

    public void setProxyPort(int n) {
        this.proxyPort = n;
    }

    public void setServer(String string) {
        this.server = string;
    }

    private void setValueID(String string, String string2, Vector vector) {
        Vector vector2 = this.plugin.getAttributeTypes(string, string2);
        String string3 = "";
        int n = 0;
        while (n < vector2.size()) {
            System.out.println(vector2.elementAt(n));
            if (vector2.elementAt(n).toString().toUpperCase().startsWith("VARCHAR")) {
                string3 = vector.elementAt(n).toString();
            }
            ++n;
        }
        if (string3.equals("")) {
            n = 0;
            while (n < vector2.size()) {
                if (vector2.elementAt(n).toString().equalsIgnoreCase("String")) {
                    string3 = vector.elementAt(n).toString();
                }
                ++n;
            }
        }
        String string4 = "";
        int n2 = 0;
        while (n2 < vector2.size()) {
            if (vector2.elementAt(n2).toString().equalsIgnoreCase("numeric")) {
                string4 = vector.elementAt(n2).toString();
            }
            ++n2;
        }
        if (string4.equals("")) {
            n2 = 0;
            while (n2 < vector2.size()) {
                if (vector2.elementAt(n2).toString().equalsIgnoreCase("integer")) {
                    string4 = vector.elementAt(n2).toString();
                }
                ++n2;
            }
        }
        if (string4.equals("")) {
            n2 = 0;
            while (n2 < vector2.size()) {
                if (vector2.elementAt(n2).toString().equalsIgnoreCase("number")) {
                    string4 = vector.elementAt(n2).toString();
                }
                ++n2;
            }
        }
        System.out.println("ID:" + string3);
        this.idField.setText(string3);
        System.out.println("VALUE:" + string4);
        this.valueField.setText(string4);
    }

    private void startUpdate() {
        this.spinner.startSpinning();
        this.status.setText("Running data update script");
        this.startButton.setEnabled(false);
        this.idSelectButton.setEnabled(false);
        this.valueSelectButton.setEnabled(false);
        this.endButton.setEnabled(true);
        this.updating = true;
        this.getID();
        long l = interval[this.intervalSelector.getSelectedIndex()];
        if (this.updateTimer == null) {
            this.updateTimer = new Timer((int)l, new ActionListener(this){
                /* synthetic */ UpdateFrame this$0;

                public void actionPerformed(ActionEvent actionEvent) {
                    if (this.this$0.updating) {
                        UpdateFrame.access$update(this.this$0);
                    }
                }
                {
                    this.this$0 = updateFrame;
                }
            });
        } else {
            this.updateTimer.setDelay((int)l);
        }
        this.updateTimer.start();
        this.logger.log(0, "START update");
        this.update();
    }

    private void update() {
        Runnable runnable = new Runnable(this){
            /* synthetic */ UpdateFrame this$0;

            public void run() {
                UpdateFrame.access$update0(this.this$0);
            }
            {
                this.this$0 = updateFrame;
            }
        };
        Thread thread = new Thread(runnable);
        thread.start();
    }

    private void update0() {
        Object object;
        ++this.updateCount;
        String string = "http://" + this.server + ":" + this.port + "/" + this.getUpdateServlet() + "?action=update&id=" + this.ID + "&source=" + this.sourceSelector.getSelectedItem() + "&table=" + this.tableField.getText() + "&idField=" + this.idField.getText() + "&valueField=" + this.valueField.getText();
        this.logger.log(1, "Update request " + this.updateCount + " sent");
        try {
            object = new URL(string);
            if (this.proxy != null && this.proxyPort > 0) {
                URLUtils.get((URL)object, this.proxy, this.proxyPort);
            } else {
                URLUtils.get((URL)object);
            }
        }
        catch (Exception exception) {
            System.out.println("Error in update: " + exception);
        }
        object = "http://" + this.server + ":" + this.port + "/" + this.getUpdateServlet() + "?action=refresh&id=" + this.ID + "&source=" + this.sourceSelector.getSelectedItem() + "&table=" + this.tableField.getText() + "&idField=" + this.idField.getText() + "&valueField=" + this.valueField.getText();
        this.getBrowserFrame((String)object).setLocation((String)object);
        this.getBrowserFrame((String)object).reload();
        if (!this.getBrowserFrame().isVisible()) {
            ((Component)this.getBrowserFrame()).setVisible(true);
        }
        this.logger.log(2, "Refresh browser");
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        int n = listSelectionEvent.getFirstIndex();
        if (listSelectionEvent.getSource() == this.tableList) {
            if (n >= 0) {
                if (!this.tableValueChanging) {
                    String string = (String)this.tableList.getModel().getElementAt(n);
                    if (!this.updating) {
                        this.tableField.setText(string);
                    }
                    DefaultListModel defaultListModel = (DefaultListModel)this.attributeList.getModel();
                    defaultListModel.removeAllElements();
                    Vector vector = this.plugin.getAttributes(this.getSource(), string);
                    int n2 = 0;
                    while (n2 < vector.size()) {
                        defaultListModel.addElement(vector.elementAt(n2));
                        ++n2;
                    }
                    this.setValueID(this.getSource(), string, vector);
                }
            } else {
                this.tableField.setText("");
                DefaultListModel defaultListModel = (DefaultListModel)this.attributeList.getModel();
                defaultListModel.removeAllElements();
            }
        }
    }

    static void access$update(UpdateFrame updateFrame) {
        updateFrame.update();
    }

    static void access$endUpdate0(UpdateFrame updateFrame) {
        updateFrame.endUpdate0();
    }

    static void access$update0(UpdateFrame updateFrame) {
        updateFrame.update0();
    }
}

