/*
 * Decompiled with CFR 0.152.
 */
package ogi.cq.plugin.gui;

import com.sun.java.swing.BorderFactory;
import com.sun.java.swing.Box;
import com.sun.java.swing.BoxLayout;
import com.sun.java.swing.JApplet;
import com.sun.java.swing.JButton;
import com.sun.java.swing.JComboBox;
import com.sun.java.swing.JFrame;
import com.sun.java.swing.JLabel;
import com.sun.java.swing.JPanel;
import com.sun.java.swing.JScrollPane;
import com.sun.java.swing.JTextArea;
import com.sun.java.swing.JTextField;
import com.sun.java.swing.SwingUtilities;
import com.sun.java.swing.Timer;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import ogi.cq.gui.Spinner;
import ogi.cq.log.CQLog;
import ogi.cq.log.Log;
import ogi.cq.plugin.gui.PluginApplet;
import ogi.diom.util.URLUtils;

public class UpdateApplet
extends JApplet
implements ActionListener {
    public static boolean DEBUG = true;
    protected Log logger;
    JButton startUpdateButton;
    JButton endUpdateButton;
    JButton chartButton;
    JButton resetButton;
    JButton helpButton;
    JButton closeButton;
    JFrame help;
    JComboBox intervalChoice;
    private String server;
    private String port;
    private String servlet;
    JButton browseCQButton;
    JButton registerButton;
    JButton queryButton;
    JButton cqHomeButton;
    JTextField status;
    Spinner spinner;
    boolean showExecutionHistory;
    public static final String NEW_LINE = System.getProperty("line.separator");
    public static final String browseCQURL = "http://chinook.cse.ogi.edu:8080/OpenCQ/html/browseCQ.html";
    public static final String registerURL = "http://chinook.cse.ogi.edu:8080/OpenCQ/html/register.html";
    public static final String queryURL = "http://chinook.cse.ogi.edu:8080/OpenCQ/html/jtav/query.html";
    public static final String cqHomeURL = "http://www.cse.ogi.edu/DISC/CQ/";
    public static final int SECOND = 1000;
    public static final int MINUTE = 60000;
    public static final int HOUR = 3600000;
    public static final String[] INTERVAL_DESC = new String[]{"Every Minute", "Every 5 Minutes", "Every 10 Minutes", "Every 30 Minutes", "Every Hour"};
    public static final int DEFAULT_INTERVAL_CHOICE = 1;
    public static final int[] INTERVAL = new int[]{60000, 300000, 600000, 1800000, 3600000};
    Timer updateTimer;
    Timer refreshTimer;
    boolean updating;
    String ID;

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.helpButton) {
            this.getHelp().setVisible(true);
        } else if (actionEvent.getSource() == this.closeButton) {
            this.help.setVisible(false);
        } else if (actionEvent.getSource() == this.resetButton) {
            this.reset();
        } else if (actionEvent.getSource() == this.startUpdateButton) {
            this.startUpdate();
        } else if (actionEvent.getSource() == this.endUpdateButton) {
            this.endUpdate();
        } else if (actionEvent.getSource() == this.intervalChoice) {
            int n = this.intervalChoice.getSelectedIndex();
            System.out.println(n);
            this.intervalChoice.setSelectedIndex(n);
        } else if (actionEvent.getSource() == this.browseCQButton) {
            try {
                URL uRL = new URL(browseCQURL);
                ((Applet)((Object)this)).getAppletContext().showDocument(uRL, "_bottom");
            }
            catch (Exception exception) {
                System.out.println("Error in showing external doc: " + exception);
            }
        } else if (actionEvent.getSource() == this.registerButton) {
            try {
                URL uRL = new URL(registerURL);
                ((Applet)((Object)this)).getAppletContext().showDocument(uRL, "_bottom");
            }
            catch (Exception exception) {
                System.out.println("Error in showing external doc: " + exception);
            }
        } else if (actionEvent.getSource() == this.queryButton) {
            try {
                URL uRL = new URL(queryURL);
                ((Applet)((Object)this)).getAppletContext().showDocument(uRL, "_bottom");
            }
            catch (Exception exception) {
                System.out.println("Error in showing external doc: " + exception);
            }
        } else if (actionEvent.getSource() == this.cqHomeButton) {
            try {
                URL uRL = new URL(cqHomeURL);
                ((Applet)((Object)this)).getAppletContext().showDocument(uRL, "_bottom");
            }
            catch (Exception exception) {
                System.out.println("Error in showing external doc: " + exception);
            }
        }
    }

    public void destroy() {
        this.reset();
    }

    private void endUpdate() {
        this.spinner.startSpinning();
        this.status.setText("End data update script");
        this.startUpdateButton.setEnabled(true);
        this.endUpdateButton.setEnabled(false);
        this.updating = false;
        this.updateTimer.stop();
        this.refreshTimer.stop();
        Runnable runnable = new Runnable(this){
            /* synthetic */ UpdateApplet this$0;

            public void run() {
                UpdateApplet.access$endUpdate0(this.this$0);
            }
            {
                this.this$0 = updateApplet;
            }
        };
        Thread thread = new Thread(runnable);
        thread.start();
        this.spinner.stopSpinning();
    }

    private void endUpdate0() {
        this.startUpdateButton.setEnabled(true);
        this.endUpdateButton.setEnabled(false);
        this.updating = false;
        String string = "http://" + this.server + ":" + this.port + "/" + this.servlet + "?action=endUpdate&id=" + this.ID;
        try {
            URL uRL = new URL(string);
            URLUtils.get(uRL);
        }
        catch (Exception exception) {
            System.out.println("Error in ending update: " + exception);
        }
        this.updateTimer.stop();
        this.refreshTimer.stop();
    }

    public JFrame getHelp() {
        if (this.help == null) {
            String string = "Help -- CQ_JTAV Update Applet";
            this.help = new JFrame(string);
            JPanel jPanel = (JPanel)this.help.getContentPane();
            jPanel.setLayout(new BorderLayout());
            Font font = new Font("timesRoman", 1, 20);
            JLabel jLabel = new JLabel(string);
            jLabel.setFont(font);
            jLabel.setForeground(Color.blue);
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new FlowLayout());
            jPanel2.add((Component)jLabel);
            jPanel.add("North", (Component)jPanel2);
            JTextArea jTextArea = new JTextArea();
            jTextArea.setBackground(Color.lightGray);
            jTextArea.setEditable(false);
            jTextArea.append("This applet allows you to artificially modify the database. ");
            jTextArea.append("CQ's installed over the modified table/column (AMMUNITION / QTY_DI) ");
            jTextArea.append("should notice the changes and report them. If the CQ is installed as ");
            jTextArea.append("under the userid of jtav, the updates will be shown here.");
            jTextArea.append(NEW_LINE);
            jTextArea.append("Start Update");
            jTextArea.append(NEW_LINE);
            jTextArea.append("When you click the Start Update button, the applet will send update ");
            jTextArea.append("messages to the database.  It will also refresh a browser screen so ");
            jTextArea.append("you can see all tests currently being performed.  Whenever one of ");
            jTextArea.append("the CQ's is activated because of the changes, the browser screen will");
            jTextArea.append("show the id's of the activated CQ as well as the table. ");
            jTextArea.append(NEW_LINE);
            jTextArea.append(NEW_LINE);
            jTextArea.append("End Update");
            jTextArea.append(NEW_LINE);
            jTextArea.append("The End Update button stops the update script.");
            jTextArea.append(NEW_LINE);
            jTextArea.append(NEW_LINE);
            jTextArea.append("Register");
            jTextArea.append(NEW_LINE);
            jTextArea.append("To register, simply click the register button on the applet.  Fill in the HTML form ");
            jTextArea.append("and submit it.  ");
            jTextArea.append("That is it.  You will then be registered -- you can install CQ\u2019s and ");
            jTextArea.append("receive notifications for the updates you specify.");
            jTextArea.append(NEW_LINE);
            jTextArea.append(NEW_LINE);
            jTextArea.append("Browse CQ's");
            jTextArea.append(NEW_LINE);
            jTextArea.append("Click the 'Browse CQ' button to view the raw definition of the CQ's you have access to. This will take you to an HTML ");
            jTextArea.append("page that displays all of your CQ's in a table. ");
            jTextArea.append(NEW_LINE);
            jTextArea.append("Second, you can view CQ statistics, click on an individual CQ and press ");
            jTextArea.append("the View CQ Definition button.  This will display the selected CQ in a form. ");
            jTextArea.append(NEW_LINE);
            jTextArea.append(NEW_LINE);
            jTextArea.append("Query");
            jTextArea.append(NEW_LINE);
            jTextArea.append("If you just want to query the data and not install a CQ, click the Query button ");
            jTextArea.append(NEW_LINE);
            jTextArea.append(NEW_LINE);
            jTextArea.append("CQ Home");
            jTextArea.append(NEW_LINE);
            jTextArea.append("Return to the CQ Home page by pressing the CQ Home button. ");
            jTextArea.setLineWrap(true);
            jTextArea.setWrapStyleWord(true);
            JScrollPane jScrollPane = new JScrollPane((Component)jTextArea);
            jScrollPane.setVerticalScrollBarPolicy(22);
            jScrollPane.setHorizontalScrollBarPolicy(31);
            jScrollPane.setPreferredSize(new Dimension(250, 250));
            jPanel.add("Center", (Component)jScrollPane);
            Font font2 = new Font("timesRoman", 0, 15);
            jTextArea.setFont(font2);
            JPanel jPanel3 = new JPanel();
            jPanel3.setLayout(new FlowLayout());
            this.closeButton = new JButton("Close");
            this.closeButton.setBackground(Color.red);
            this.closeButton.addActionListener((ActionListener)this);
            jPanel3.add((Component)this.closeButton);
            jPanel.add("South", (Component)jPanel3);
            this.help.setSize(640, 480);
        }
        return this.help;
    }

    private void getID() {
        this.status.setText("Retriving ID");
        Runnable runnable = new Runnable(this){
            /* synthetic */ UpdateApplet this$0;

            public void run() {
                UpdateApplet.access$getID0(this.this$0);
            }
            {
                this.this$0 = updateApplet;
            }
        };
        Thread thread = new Thread(runnable);
        thread.start();
    }

    private void getID0() {
        String string = "http://" + this.server + ":" + this.port + "/" + this.servlet + "?action=getID";
        try {
            URL uRL = new URL(string);
            this.ID = URLUtils.get(uRL);
        }
        catch (Exception exception) {
            System.out.println("Error in getting ID: " + exception);
        }
    }

    public String getPort() {
        if (this.port == null) {
            this.port = ((Applet)((Object)this)).getParameter("port");
        }
        return this.port;
    }

    public String getServer() {
        if (this.server == null) {
            this.server = ((Applet)((Object)this)).getParameter("server");
        }
        return this.server;
    }

    public String getServlet() {
        if (this.servlet == null) {
            this.servlet = ((Applet)((Object)this)).getParameter("servlet");
        }
        return this.servlet;
    }

    public void init() {
        this.logger = new CQLog();
        this.logger.setDebug(DEBUG);
        this.initGUI();
        this.logger.debug("finished GUI init");
        Runnable runnable = new Runnable(this){
            /* synthetic */ UpdateApplet this$0;

            public void run() {
                this.this$0.initConnection();
            }
            {
                this.this$0 = updateApplet;
            }
        };
        SwingUtilities.invokeLater((Runnable)runnable);
    }

    public void initConnection() {
        this.status.setText("Initializing applet");
        this.spinner.startSpinning();
        this.server = this.getServer();
        this.port = this.getPort();
        this.servlet = this.getServlet();
        this.getID();
        this.spinner.stopSpinning();
        this.status.setText("");
    }

    public void initGUI() {
        JPanel jPanel = (JPanel)this.getContentPane();
        jPanel.setLayout((LayoutManager)new BoxLayout((Container)jPanel, 1));
        jPanel.setBorder(BorderFactory.createEtchedBorder());
        jPanel.add(Box.createGlue());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new BoxLayout((Container)jPanel2, 1));
        jPanel.add((Component)jPanel2);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new BoxLayout((Container)jPanel3, 0));
        jPanel2.add((Component)jPanel3);
        JLabel jLabel = new JLabel("Update Interval: ");
        jLabel.setForeground(Color.black);
        jPanel3.add((Component)jLabel);
        this.intervalChoice = new JComboBox();
        int n = 0;
        while (n < INTERVAL_DESC.length) {
            this.intervalChoice.addItem((Object)INTERVAL_DESC[n]);
            ++n;
        }
        this.intervalChoice.setSelectedIndex(1);
        this.intervalChoice.setForeground(Color.blue);
        this.intervalChoice.setBackground(Color.white);
        this.intervalChoice.addActionListener((ActionListener)this);
        jPanel3.add((Component)this.intervalChoice);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new BoxLayout((Container)jPanel4, 0));
        jPanel2.add((Component)jPanel4);
        this.startUpdateButton = new JButton("Start Update");
        this.startUpdateButton.setBackground(Color.yellow);
        this.startUpdateButton.addActionListener((ActionListener)this);
        jPanel4.add(Box.createHorizontalGlue());
        jPanel4.add((Component)this.startUpdateButton);
        this.endUpdateButton = new JButton("End Update");
        this.endUpdateButton.setBackground(Color.yellow);
        this.endUpdateButton.addActionListener((ActionListener)this);
        this.endUpdateButton.setEnabled(false);
        jPanel4.add((Component)this.endUpdateButton);
        jPanel4.add(Box.createHorizontalGlue());
        jPanel.add(Box.createVerticalGlue());
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new BoxLayout((Container)jPanel5, 0));
        this.registerButton = new JButton("Register");
        this.registerButton.addActionListener((ActionListener)this);
        jPanel5.add(Box.createHorizontalGlue());
        jPanel5.add((Component)this.registerButton);
        jPanel5.add(Box.createHorizontalGlue());
        this.browseCQButton = new JButton("Browse CQ's");
        this.browseCQButton.addActionListener((ActionListener)this);
        jPanel5.add((Component)this.browseCQButton);
        jPanel5.add(Box.createHorizontalGlue());
        this.queryButton = new JButton("Query");
        this.queryButton.addActionListener((ActionListener)this);
        jPanel5.add((Component)this.queryButton);
        jPanel5.add(Box.createHorizontalGlue());
        this.cqHomeButton = new JButton("CQ Home");
        this.cqHomeButton.addActionListener((ActionListener)this);
        jPanel5.add((Component)this.cqHomeButton);
        jPanel5.add(Box.createHorizontalGlue());
        jPanel.add((Component)jPanel5);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new BoxLayout((Container)jPanel6, 0));
        jPanel.add((Component)jPanel6);
        this.status = new JTextField("Status");
        this.status.setForeground(Color.blue);
        this.status.setBackground(Color.lightGray);
        this.status.setEditable(false);
        this.status.setAlignmentY(0.5f);
        jPanel6.add((Component)this.status);
        this.spinner = new Spinner();
        this.spinner.setAlignmentY(0.5f);
        jPanel6.add((Component)((Object)this.spinner));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new BoxLayout((Container)jPanel7, 0));
        jPanel.add((Component)jPanel7);
        this.helpButton = new JButton("Help");
        this.helpButton.setBackground(Color.green);
        this.helpButton.addActionListener((ActionListener)this);
        this.helpButton.setAlignmentY(0.5f);
        jPanel7.add((Component)this.helpButton);
        jPanel7.add(Box.createHorizontalGlue());
        this.chartButton = new JButton("Graph Updates");
        this.chartButton.setBackground(Color.blue);
        this.chartButton.setForeground(Color.white);
        this.chartButton.addActionListener((ActionListener)this);
        this.chartButton.setAlignmentY(0.5f);
        jPanel7.add(Box.createHorizontalGlue());
        this.resetButton = new JButton("Reset");
        this.resetButton.setBackground(Color.orange);
        this.resetButton.addActionListener((ActionListener)this);
        this.resetButton.setAlignmentY(0.5f);
        jPanel7.add((Component)this.resetButton);
    }

    public static void main(String[] stringArray) {
        PluginApplet pluginApplet = new PluginApplet();
        JFrame jFrame = new JFrame();
        jFrame.getContentPane().add((Component)((Object)pluginApplet));
        jFrame.pack();
        jFrame.setSize(640, 480);
        jFrame.setVisible(true);
    }

    private void refresh() {
        String string = "http://" + this.server + ":" + this.port + "/" + this.servlet + "?action=refresh&id=" + this.ID;
        try {
            URL uRL = new URL(string);
            ((Applet)((Object)this)).getAppletContext().showDocument(uRL, "refresh");
        }
        catch (Exception exception) {
            System.out.println("Error in refresh: " + exception);
        }
    }

    public void reset() {
        Runnable runnable = new Runnable(this){
            /* synthetic */ UpdateApplet this$0;

            public void run() {
                UpdateApplet.access$reset0(this.this$0);
            }
            {
                this.this$0 = updateApplet;
            }
        };
        SwingUtilities.invokeLater((Runnable)runnable);
    }

    private void reset0() {
        this.status.setText("");
        this.browseCQButton.setEnabled(true);
        this.registerButton.setEnabled(true);
        this.queryButton.setEnabled(true);
        this.cqHomeButton.setEnabled(true);
        this.startUpdateButton.setEnabled(true);
        this.endUpdateButton.setEnabled(false);
        this.intervalChoice.setSelectedIndex(1);
        this.status.setText("");
    }

    private void startUpdate() {
        this.spinner.startSpinning();
        this.status.setText("Running data update script");
        this.startUpdateButton.setEnabled(false);
        this.endUpdateButton.setEnabled(true);
        this.updating = true;
        int n = this.intervalChoice.getSelectedIndex();
        if (this.updateTimer == null) {
            this.updateTimer = new Timer(INTERVAL[n], new ActionListener(this){
                /* synthetic */ UpdateApplet this$0;

                public void actionPerformed(ActionEvent actionEvent) {
                    if (this.this$0.updating) {
                        UpdateApplet.access$update(this.this$0);
                    }
                }
                {
                    this.this$0 = updateApplet;
                }
            });
        }
        this.updateTimer.setDelay(INTERVAL[n]);
        this.updateTimer.start();
        if (this.refreshTimer == null) {
            this.refreshTimer = new Timer(30000, new ActionListener(this){
                /* synthetic */ UpdateApplet this$0;

                public void actionPerformed(ActionEvent actionEvent) {
                    if (this.this$0.updating) {
                        UpdateApplet.access$refresh(this.this$0);
                    }
                }
                {
                    this.this$0 = updateApplet;
                }
            });
        }
        this.refreshTimer.setDelay(INTERVAL[n]);
        this.refreshTimer.start();
        this.update();
        this.refresh();
    }

    public void stop() {
        this.reset();
    }

    private void update() {
        Runnable runnable = new Runnable(this){
            /* synthetic */ UpdateApplet this$0;

            public void run() {
                UpdateApplet.access$update0(this.this$0);
            }
            {
                this.this$0 = updateApplet;
            }
        };
        Thread thread = new Thread(runnable);
        thread.start();
    }

    private void update0() {
        String string = "http://" + this.server + ":" + this.port + "/" + this.servlet + "?action=update&id=" + this.ID;
        try {
            URL uRL = new URL(string);
            URLUtils.get(uRL);
        }
        catch (Exception exception) {
            System.out.println("Error in update: " + exception);
        }
    }

    static void access$refresh(UpdateApplet updateApplet) {
        updateApplet.refresh();
    }

    static void access$endUpdate0(UpdateApplet updateApplet) {
        updateApplet.endUpdate0();
    }

    static void access$getID0(UpdateApplet updateApplet) {
        updateApplet.getID0();
    }

    static void access$reset0(UpdateApplet updateApplet) {
        updateApplet.reset0();
    }

    static void access$update(UpdateApplet updateApplet) {
        updateApplet.update();
    }

    static void access$update0(UpdateApplet updateApplet) {
        updateApplet.update0();
    }
}

