/*
 * Decompiled with CFR 0.152.
 */
package ogi.cq.plugin.gui;

import com.sun.java.swing.BorderFactory;
import com.sun.java.swing.Box;
import com.sun.java.swing.BoxLayout;
import com.sun.java.swing.JButton;
import com.sun.java.swing.JCheckBox;
import com.sun.java.swing.JFrame;
import com.sun.java.swing.JLabel;
import com.sun.java.swing.JPanel;
import com.sun.java.swing.JScrollPane;
import com.sun.java.swing.JTabbedPane;
import com.sun.java.swing.JTable;
import com.sun.java.swing.JTextArea;
import com.sun.java.swing.JTextField;
import com.sun.java.swing.SwingUtilities;
import com.sun.java.swing.event.ListSelectionEvent;
import com.sun.java.swing.event.ListSelectionListener;
import com.sun.java.swing.event.TableModelListener;
import com.sun.java.swing.table.TableCellRenderer;
import com.sun.java.swing.table.TableModel;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Serializable;
import java.net.URL;
import java.net.URLConnection;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Vector;
import javachart.chart.AxisInterface;
import javachart.chart.Background;
import javachart.chart.Chart;
import javachart.chart.DAreaChart;
import javachart.chart.Dataset;
import javachart.chart.DateAxis;
import javachart.chart.DateLineChart;
import javachart.chart.Gc;
import ogi.cq.gui.Spinner;
import ogi.cq.log.Log;
import ogi.cq.plugin.CQArchiveInfo;
import ogi.cq.plugin.CQInfo;
import ogi.cq.plugin.IContinualQueryPlugin;
import ogi.cq.plugin.gui.CQDefinitionPanel;
import ogi.cq.plugin.gui.CQHistoryPanel;
import ogi.cq.plugin.gui.CQInfoTableModel;
import ogi.cq.plugin.gui.CQInfoTableRenderer;
import ogi.cq.plugin.gui.GraphPanel;
import ogi.cq.plugin.gui.TableSorter;
import ogi.cq.time.Time;
import ogi.cq.util.Pair;

public class StatFrame
extends JFrame
implements ActionListener,
ListSelectionListener,
Time {
    protected Log logger;
    protected IContinualQueryPlugin plugin;
    protected JTabbedPane tabPanel;
    protected JPanel currentPanel;
    protected JPanel historyPanel;
    protected JLabel currentLabel;
    protected JLabel historyLabel;
    protected JButton closeButton;
    protected JButton helpButton;
    protected String title;
    protected Color backgroundColor;
    protected Font localFont;
    protected CQInfoTableModel tableModel;
    protected TableSorter tableSorter;
    protected JTable cqInfoList;
    protected Vector cqinfo;
    protected JButton individualButton;
    protected JButton definitionButton;
    protected Hashtable definitionList;
    protected JPanel infoPanel;
    protected CardLayout infoPanelLayout;
    protected Hashtable infoPanelList;
    protected Vector historyInfo;
    protected Vector activeCQHistory;
    protected Vector installCQHistory;
    protected Vector endCQHistory;
    protected JFrame historyHelp;
    protected JButton hhCloseButton;
    protected JFrame currentHelp;
    protected JButton chCloseButton;
    protected JCheckBox threeDCheckbox;
    protected JButton colorButton;
    protected Date startDate;
    protected Date endDate;
    protected JTextField status;
    protected Spinner spinner;
    protected JButton refreshButton;
    protected GraphPanel endCQHistoryChart;
    protected GraphPanel installHistoryChart;
    protected GraphPanel activeHistoryChart;
    protected GraphPanel[] chartArray;
    protected JTextField countTextField;
    public static final String NEW_LINE = System.getProperty("line.separator");
    protected boolean twoD;
    protected int currentColor;
    public static final Color[] colors = new Color[]{Color.blue, Color.green, Color.black, Color.yellow, Color.pink, Color.orange, Color.red, Color.magenta, Color.cyan, Color.gray};
    public static final int DEFAULT_HISTORY_COUNT = 500;
    static Class class$java$lang$String;

    public StatFrame(IContinualQueryPlugin iContinualQueryPlugin, Log log, Color color, Font font, String string) {
        super(string);
        this.plugin = iContinualQueryPlugin;
        this.logger = log;
        this.backgroundColor = color;
        this.localFont = font;
        this.title = string;
        this.init();
    }

    public StatFrame(IContinualQueryPlugin iContinualQueryPlugin, Log log, String string) {
        this(iContinualQueryPlugin, log, null, null, string);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        block5: {
            block12: {
                block11: {
                    block10: {
                        block9: {
                            block8: {
                                block7: {
                                    block6: {
                                        block4: {
                                            if (actionEvent.getSource() != this.closeButton) break block4;
                                            ((Component)((Object)this)).setVisible(false);
                                            break block5;
                                        }
                                        if (actionEvent.getSource() != this.individualButton) break block6;
                                        this.status.setText("Retrieving execution information for selected CQ");
                                        this.spinner.startSpinning();
                                        this.individualButton.setEnabled(false);
                                        Runnable runnable = new Runnable(this){
                                            /* synthetic */ StatFrame this$0;

                                            public void run() {
                                                this.this$0.individualHistoryClicked();
                                            }
                                            {
                                                this.this$0 = statFrame;
                                            }
                                        };
                                        Thread thread = new Thread(runnable);
                                        thread.start();
                                        break block5;
                                    }
                                    if (actionEvent.getSource() != this.refreshButton) break block7;
                                    this.status.setText("Refreshing Statistics...");
                                    this.spinner.startSpinning();
                                    this.refreshButton.setEnabled(false);
                                    Runnable runnable = new Runnable(this){
                                        /* synthetic */ StatFrame this$0;

                                        public void run() {
                                            this.this$0.refresh();
                                        }
                                        {
                                            this.this$0 = statFrame;
                                        }
                                    };
                                    Thread thread = new Thread(runnable);
                                    thread.start();
                                    break block5;
                                }
                                if (actionEvent.getSource() != this.definitionButton) break block8;
                                this.status.setText("Definition of selected CQ");
                                this.definitionClicked();
                                break block5;
                            }
                            if (actionEvent.getSource() != this.helpButton) break block9;
                            if (this.tabPanel.getSelectedComponent() == this.historyPanel) {
                                this.getHistoryHelp().setVisible(true);
                            } else {
                                this.getCurrentHelp().setVisible(true);
                            }
                            break block5;
                        }
                        if (actionEvent.getSource() != this.hhCloseButton) break block10;
                        this.getHistoryHelp().setVisible(false);
                        break block5;
                    }
                    if (actionEvent.getSource() != this.chCloseButton) break block11;
                    this.getCurrentHelp().setVisible(false);
                    break block5;
                }
                if (actionEvent.getSource() != this.colorButton) break block12;
                this.currentColor = (this.currentColor + 1) % colors.length;
                GraphPanel[] graphPanelArray = this.getCharts();
                int n = 0;
                while (n < graphPanelArray.length) {
                    this.setChartColors(graphPanelArray[n].getChart(), Color.black, colors[this.currentColor]);
                    ((Component)((Object)graphPanelArray[n])).repaint();
                    ++n;
                }
                break block5;
            }
            if (actionEvent.getSource() != this.threeDCheckbox) break block5;
            this.twoD = !this.threeDCheckbox.isSelected();
            GraphPanel[] graphPanelArray = this.getCharts();
            int n = 0;
            while (n < graphPanelArray.length) {
                graphPanelArray[n].setThreeD(!this.twoD);
                this.setChartColors(graphPanelArray[n].getChart(), Color.black, colors[this.currentColor]);
                ((Component)((Object)graphPanelArray[n])).repaint();
                ++n;
            }
        }
    }

    public void definitionClicked() {
        int n = this.cqInfoList.getSelectedRow();
        if (n < 0) {
            this.reset();
            return;
        }
        String string = (String)this.tableSorter.getValueAt(n, 1);
        if (string == null) {
            this.reset();
            return;
        }
        if (this.definitionList == null) {
            this.definitionList = new Hashtable();
        }
        JFrame jFrame = null;
        jFrame = (JFrame)this.definitionList.get(string);
        if (jFrame == null) {
            CQInfo cQInfo = this.tableModel.getCQInfo(string);
            jFrame = new CQDefinitionPanel(cQInfo);
            jFrame.setSize(640, 480);
            this.definitionList.put(string, jFrame);
        }
        jFrame.setVisible(true);
        this.spinner.stopSpinning();
        this.reset();
    }

    public GraphPanel getActiveHistoryChart() {
        if (this.activeHistoryChart == null) {
            DAreaChart dAreaChart = new DAreaChart("CQ Execution History");
            dAreaChart.getBackground().setTitleString("Number of Active CQs");
            dAreaChart.setThreeD(false);
            Background background = dAreaChart.getBackground();
            background.setTitleColor(Color.blue);
            this.activeHistoryChart = new GraphPanel((Chart)dAreaChart);
            Gc gc = background.getGc();
            gc.setLineColor(Color.red);
            gc.setMarkerColor(Color.green);
            gc.setFillColor(Color.gray);
            this.updateActiveHistory();
        }
        return this.activeHistoryChart;
    }

    public JPanel getActiveHistoryPanel() {
        if (this.activeCQHistory.size() > 0) {
            return this.getActiveHistoryChart();
        }
        JPanel jPanel = new JPanel();
        jPanel.add((Component)new JLabel("No history available"));
        return jPanel;
    }

    public GraphPanel[] getCharts() {
        if (this.chartArray == null) {
            this.chartArray = new GraphPanel[3];
            this.chartArray[0] = this.getActiveHistoryChart();
            this.chartArray[1] = this.getInstallHistoryChart();
            this.chartArray[2] = this.getEndCQHistoryChart();
        }
        return this.chartArray;
    }

    private JTextField getCountTextField() {
        if (this.countTextField == null) {
            this.countTextField = new JTextField(String.valueOf(500));
        }
        return this.countTextField;
    }

    public JFrame getCurrentHelp() {
        if (this.currentHelp == null) {
            String string = "Help -- CQ Status Window";
            this.currentHelp = new JFrame(string);
            JPanel jPanel = (JPanel)this.currentHelp.getContentPane();
            jPanel.setLayout((LayoutManager)new BoxLayout((Container)jPanel, 1));
            Font font = new Font("timesRoman", 1, 20);
            JLabel jLabel = new JLabel(string);
            jLabel.setFont(font);
            jLabel.setForeground(Color.blue);
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new FlowLayout());
            jPanel2.add((Component)jLabel);
            jPanel.add((Component)jPanel2);
            jPanel.add(Box.createRigidArea((Dimension)new Dimension(20, 20)));
            JTextArea jTextArea = new JTextArea();
            jTextArea.setEditable(false);
            jTextArea.append("These continual queries are currently active ");
            jTextArea.append("in the CQ system.  You may click on any one of ");
            jTextArea.append("the CQ's to view the execution status and ");
            jTextArea.append("statistics of this continual query, including: ");
            jTextArea.append(NEW_LINE);
            jTextArea.append("* the total execution time, ");
            jTextArea.append(NEW_LINE);
            jTextArea.append("* the number of trigger tests completed, ");
            jTextArea.append(NEW_LINE);
            jTextArea.append("* the number of successful trigger tests, ");
            jTextArea.append("namely the number of query executions, and ");
            jTextArea.append(NEW_LINE);
            jTextArea.append("* the number of notifications sent out ");
            jTextArea.append("(when the specified update threshold is reached)");
            jTextArea.append(NEW_LINE);
            jTextArea.append(NEW_LINE);
            jTextArea.append("The color in this list represents the status of the CQ.  CQ's that have an error or have been disabled are displayed in red.  Those that are just installed and have not been initialized are displayed in black.  Running CQ's are blue. ");
            jTextArea.setLineWrap(true);
            jTextArea.setWrapStyleWord(true);
            JScrollPane jScrollPane = new JScrollPane((Component)jTextArea);
            jScrollPane.setVerticalScrollBarPolicy(22);
            jScrollPane.setHorizontalScrollBarPolicy(31);
            jScrollPane.setPreferredSize(new Dimension(250, 250));
            jPanel.add((Component)jScrollPane);
            Font font2 = new Font("timesRoman", 0, 15);
            jTextArea.setFont(font2);
            JPanel jPanel3 = new JPanel();
            jPanel3.setLayout(new FlowLayout());
            this.chCloseButton = new JButton("Close");
            this.chCloseButton.setBackground(Color.red);
            this.chCloseButton.addActionListener((ActionListener)this);
            jPanel3.add((Component)this.chCloseButton);
            jPanel.add((Component)jPanel3);
            this.currentHelp.setSize(640, 480);
        }
        return this.currentHelp;
    }

    public JPanel getCurrentPanel() {
        if (this.currentPanel == null) {
            this.currentPanel = new JPanel();
            this.currentPanel.setLayout((LayoutManager)new BoxLayout((Container)this.currentPanel, 1));
            this.currentPanel.setBackground(this.backgroundColor);
            this.currentLabel = new JLabel("Current Load: ");
            JPanel jPanel = new JPanel();
            jPanel.setLayout((LayoutManager)new BoxLayout((Container)jPanel, 0));
            jPanel.add(Box.createHorizontalGlue());
            jPanel.add((Component)this.currentLabel);
            jPanel.add(Box.createHorizontalGlue());
            this.currentPanel.add((Component)jPanel);
            if (this.plugin != null) {
                this.cqinfo = this.plugin.getCQInfo();
                this.currentLabel.setText(String.valueOf(this.currentLabel.getText()) + this.cqinfo.size());
            } else {
                this.cqinfo = this.getFakeCQInfo();
            }
            this.tableModel = new CQInfoTableModel(this.cqinfo);
            this.tableSorter = new TableSorter((TableModel)this.tableModel);
            this.cqInfoList = new JTable((TableModel)this.tableSorter);
            Class<?> clazz = class$java$lang$String;
            if (clazz == null) {
                try {
                    clazz = class$java$lang$String = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.cqInfoList.setDefaultRenderer((Class)clazz, (TableCellRenderer)new CQInfoTableRenderer());
            this.tableSorter.addMouseListenerToHeaderInTable(this.cqInfoList);
            this.tableModel.addTableModelListener((TableModelListener)this.cqInfoList);
            this.tableModel.addTableModelListener((TableModelListener)this.cqInfoList);
            this.cqInfoList.setBackground(Color.white);
            this.cqInfoList.setForeground(Color.black);
            this.cqInfoList.setSelectionMode(0);
            this.cqInfoList.setShowVerticalLines(true);
            this.cqInfoList.setShowHorizontalLines(true);
            this.cqInfoList.getSelectionModel().addListSelectionListener((ListSelectionListener)this);
            this.cqInfoList.setForeground(Color.blue);
            JScrollPane jScrollPane = new JScrollPane((Component)this.cqInfoList);
            jScrollPane.setBorder(BorderFactory.createBevelBorder((int)1));
            this.currentPanel.add((Component)jScrollPane);
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout((LayoutManager)new BoxLayout((Container)jPanel2, 0));
            this.individualButton = new JButton("Get Execution History");
            this.individualButton.addActionListener((ActionListener)this);
            this.individualButton.setBackground(Color.green);
            jPanel2.add((Component)this.individualButton);
            jPanel2.add(Box.createHorizontalGlue());
            this.definitionButton = new JButton("CQ Definition");
            this.definitionButton.addActionListener((ActionListener)this);
            this.definitionButton.setBackground(Color.blue);
            this.definitionButton.setForeground(Color.white);
            jPanel2.add((Component)this.definitionButton);
            this.currentPanel.add((Component)jPanel2);
            JPanel jPanel3 = new JPanel();
            jPanel3.setLayout(new FlowLayout());
            jPanel3.add((Component)new JLabel("Retrieve at most "));
            jPanel3.add((Component)this.getCountTextField());
            jPanel3.add((Component)new JLabel(" executions of CQ"));
            this.currentPanel.add((Component)jPanel3);
        }
        return this.currentPanel;
    }

    public GraphPanel getEndCQHistoryChart() {
        if (this.endCQHistoryChart == null) {
            DAreaChart dAreaChart = new DAreaChart("CQ Execution History -- End");
            dAreaChart.getBackground().setTitleString("CQ Termination Rate");
            dAreaChart.setThreeD(false);
            Background background = dAreaChart.getBackground();
            background.setTitleColor(Color.blue);
            this.endCQHistoryChart = new GraphPanel((Chart)dAreaChart);
            Gc gc = background.getGc();
            gc.setLineColor(Color.red);
            gc.setMarkerColor(Color.green);
            gc.setFillColor(Color.gray);
            this.updateEndCQHistory();
        }
        return this.endCQHistoryChart;
    }

    public JPanel getEndCQHistoryPanel() {
        if (this.endCQHistory.size() > 0) {
            return this.getEndCQHistoryChart();
        }
        JPanel jPanel = new JPanel();
        jPanel.add((Component)new JLabel("No history available"));
        return jPanel;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    private Vector getFakeCQInfo() {
        Vector<CQInfo> vector = new Vector<CQInfo>();
        int n = 0;
        while (n < 10) {
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            gregorianCalendar.add(1, -1);
            gregorianCalendar.add(5, n);
            GregorianCalendar gregorianCalendar2 = new GregorianCalendar();
            gregorianCalendar2.add(5, n * 100);
            CQInfo cQInfo = new CQInfo();
            cQInfo.setSources("source");
            cQInfo.setName("fake #" + n);
            cQInfo.setId(String.valueOf(n));
            cQInfo.setStartDate(gregorianCalendar.getTime());
            cQInfo.setEndDate(gregorianCalendar2.getTime());
            cQInfo.setInterval(1000);
            vector.addElement(cQInfo);
            ++n;
        }
        return vector;
    }

    public GraphPanel getHistoryChart() {
        Integer n;
        Object object;
        Dataset[] datasetArray;
        DAreaChart dAreaChart = new DAreaChart("CQ Execution History");
        dAreaChart.setThreeD(false);
        Background background = dAreaChart.getBackground();
        background.setTitleColor(Color.blue);
        Gc gc = background.getGc();
        gc.setLineColor(Color.red);
        gc.setMarkerColor(Color.green);
        gc.setFillColor(Color.gray);
        this.getHistoryInfo();
        double[] dArray = new double[this.historyInfo.size()];
        double[] dArray2 = new double[this.historyInfo.size()];
        int n2 = 0;
        while (n2 < this.historyInfo.size()) {
            datasetArray = (Dataset[])this.historyInfo.elementAt(n2);
            object = (Long)datasetArray.getLeft();
            n = (Integer)datasetArray.getRight();
            dArray[n2] = ((Long)object).doubleValue();
            dArray2[n2] = n == null ? 0.0 : n.doubleValue();
            ++n2;
        }
        Dataset dataset = new Dataset("CQ History", dArray, dArray2, dAreaChart.getGlobals());
        dAreaChart.addDataset(dataset);
        datasetArray = dAreaChart.getDatasets();
        if (datasetArray != null) {
            int n3 = 0;
            while (n3 < datasetArray.length) {
                dataset = datasetArray[n3];
                if (dataset != null) {
                    n = dataset.getGc();
                    if (n == null) {
                        n = new Gc(dAreaChart.getGlobals());
                        dataset.setGc((Gc)n);
                    }
                    n.setLineColor(Color.black);
                    n.setMarkerColor(Color.green);
                    n.setFillColor(Color.blue);
                }
                ++n3;
            }
        }
        dAreaChart.getXAxis().setTitleString("Date");
        dAreaChart.getYAxis().setTitleRotated(true);
        dAreaChart.getXAxis().setTitleRotated(true);
        object = new GraphPanel((Chart)dAreaChart);
        return object;
    }

    public GraphPanel getHistoryChart4() {
        Integer n;
        Object object;
        Dataset[] datasetArray;
        DateLineChart dateLineChart = new DateLineChart("CQ Execution History");
        dateLineChart.setThreeD(false);
        Background background = dateLineChart.getBackground();
        background.setTitleColor(Color.blue);
        Gc gc = background.getGc();
        gc.setLineColor(Color.red);
        gc.setMarkerColor(Color.green);
        gc.setFillColor(Color.gray);
        this.getHistoryInfo();
        double[] dArray = new double[this.historyInfo.size()];
        double[] dArray2 = new double[this.historyInfo.size()];
        int n2 = 0;
        while (n2 < this.historyInfo.size()) {
            datasetArray = (Dataset[])this.historyInfo.elementAt(n2);
            object = (Long)datasetArray.getLeft();
            n = (Integer)datasetArray.getRight();
            dArray[n2] = ((Long)object).doubleValue();
            dArray2[n2] = n == null ? 0.0 : n.doubleValue();
            ++n2;
        }
        Dataset dataset = new Dataset("CQ History", dArray, dArray2, dateLineChart.getGlobals());
        dateLineChart.addDataset(dataset);
        datasetArray = dateLineChart.getDatasets();
        if (datasetArray != null) {
            int n3 = 0;
            while (n3 < datasetArray.length) {
                dataset = datasetArray[n3];
                if (dataset != null) {
                    n = dataset.getGc();
                    if (n == null) {
                        n = new Gc(dateLineChart.getGlobals());
                        dataset.setGc((Gc)n);
                    }
                    n.setLineColor(Color.red);
                    n.setMarkerColor(Color.blue);
                    n.setFillColor(Color.yellow);
                }
                ++n3;
            }
        }
        dateLineChart.getXAxis().setTitleString("Date");
        dateLineChart.getYAxis().setTitleString("Number of Active CQs");
        dateLineChart.getYAxis().setTitleRotated(true);
        dateLineChart.getXAxis().setTitleRotated(true);
        object = new GraphPanel((Chart)dateLineChart);
        return object;
    }

    public JFrame getHistoryHelp() {
        if (this.historyHelp == null) {
            try {
                String string = " Help -- CQ Execution History";
                this.historyHelp = new JFrame(string);
                JPanel jPanel = (JPanel)this.historyHelp.getContentPane();
                jPanel.setLayout((LayoutManager)new BoxLayout((Container)jPanel, 1));
                Font font = new Font("timesRoman", 1, 20);
                JLabel jLabel = new JLabel(string);
                jLabel.setFont(font);
                jLabel.setForeground(Color.blue);
                JPanel jPanel2 = new JPanel();
                jPanel2.setLayout(new FlowLayout());
                jPanel2.add((Component)jLabel);
                jPanel.add((Component)jPanel2);
                jPanel.add(Box.createRigidArea((Dimension)new Dimension(20, 20)));
                JTextArea jTextArea = new JTextArea();
                jTextArea.setEditable(false);
                jTextArea.append("These three graphs display ");
                jTextArea.append(NEW_LINE);
                jTextArea.append("(1) the number of ");
                jTextArea.append("continual queries installed on a given date ");
                jTextArea.append(NEW_LINE);
                jTextArea.append("(2) the number of CQ's active on a given date ");
                jTextArea.append(NEW_LINE);
                jTextArea.append("(3) the number of CQ's that ended on a given date ");
                jTextArea.append(NEW_LINE);
                jTextArea.append("The graphs cover the dates between ");
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat();
                jTextArea.append(simpleDateFormat.format(this.startDate));
                jTextArea.append(" and ");
                jTextArea.append(simpleDateFormat.format(this.endDate));
                jTextArea.setLineWrap(true);
                jTextArea.setWrapStyleWord(true);
                JScrollPane jScrollPane = new JScrollPane((Component)jTextArea);
                jScrollPane.setVerticalScrollBarPolicy(22);
                jScrollPane.setHorizontalScrollBarPolicy(31);
                jScrollPane.setPreferredSize(new Dimension(250, 250));
                jPanel.add((Component)jScrollPane);
                Font font2 = new Font("timesRoman", 0, 15);
                jTextArea.setFont(font2);
                JPanel jPanel3 = new JPanel();
                jPanel3.setLayout(new FlowLayout());
                this.hhCloseButton = new JButton("Close");
                this.hhCloseButton.setBackground(Color.red);
                this.hhCloseButton.addActionListener((ActionListener)this);
                jPanel3.add((Component)this.hhCloseButton);
                jPanel.add((Component)jPanel3);
            }
            catch (Exception exception) {
                System.out.println("error in creating help for history info. :" + exception);
            }
            if (this.historyHelp != null) {
                this.historyHelp.setSize(640, 480);
            }
        }
        return this.historyHelp;
    }

    private void getHistoryInfo() {
        block11: {
            block10: {
                long l;
                long l2;
                Serializable serializable;
                if (this.plugin == null || this.historyInfo != null) break block10;
                this.historyInfo = this.plugin.getCQHistory();
                long l3 = Long.MAX_VALUE;
                long l4 = 0L;
                int n = 0;
                while (n < this.historyInfo.size()) {
                    serializable = (CQArchiveInfo)this.historyInfo.elementAt(n);
                    l2 = ((CQArchiveInfo)serializable).getStartDate().getTime();
                    l = ((CQArchiveInfo)serializable).getEndDate().getTime();
                    if (l2 < l3) {
                        l3 = l2;
                    }
                    if (l > l4) {
                        l4 = l;
                    }
                    ++n;
                }
                this.activeCQHistory = new Vector();
                this.installCQHistory = new Vector();
                this.endCQHistory = new Vector();
                GregorianCalendar gregorianCalendar = new GregorianCalendar();
                gregorianCalendar.setTime(new Date(l3));
                serializable = new GregorianCalendar();
                ((Calendar)serializable).setTime(new Date(l3));
                ((Calendar)serializable).add(5, 1);
                l2 = ((Calendar)serializable).getTime().getTime() - gregorianCalendar.getTime().getTime();
                l = l3;
                while (l < l4) {
                    this.activeCQHistory.addElement(new Pair(new Long(l), null));
                    this.installCQHistory.addElement(new Pair(new Long(l), null));
                    this.endCQHistory.addElement(new Pair(new Long(l), null));
                    l += l2;
                }
                int n2 = 0;
                while (n2 < this.activeCQHistory.size()) {
                    int n3 = 0;
                    int n4 = 0;
                    int n5 = 0;
                    Pair pair = (Pair)this.activeCQHistory.elementAt(n2);
                    Pair pair2 = (Pair)this.installCQHistory.elementAt(n2);
                    Pair pair3 = (Pair)this.endCQHistory.elementAt(n2);
                    long l5 = (Long)pair.getLeft();
                    int n6 = 0;
                    while (n6 < this.historyInfo.size()) {
                        CQArchiveInfo cQArchiveInfo = (CQArchiveInfo)this.historyInfo.elementAt(n6);
                        long l6 = cQArchiveInfo.getStartDate().getTime();
                        long l7 = cQArchiveInfo.getEndDate().getTime();
                        if (l6 <= l5 && l7 >= l5) {
                            ++n3;
                        }
                        if (l6 >= l5 && l6 <= l5 + 86400000L) {
                            ++n4;
                        }
                        if (l7 >= l5 && l7 <= l5 + 86400000L) {
                            ++n5;
                        }
                        ++n6;
                    }
                    pair.setRight(new Integer(n3));
                    pair2.setRight(new Integer(n4));
                    pair3.setRight(new Integer(n5));
                    ++n2;
                }
                break block11;
            }
            if (this.historyInfo != null) break block11;
            System.out.println("get history info from random data");
            this.historyInfo = new Vector();
            int n = 0;
            while (n < 100) {
                GregorianCalendar gregorianCalendar = new GregorianCalendar();
                gregorianCalendar.add(1, -1);
                gregorianCalendar.add(5, n);
                this.historyInfo.addElement(new Pair(new Long(gregorianCalendar.getTime().getTime()), new Integer((int)(Math.random() * (double)n))));
                ++n;
            }
        }
    }

    public JPanel getHistoryPanel() {
        if (this.historyPanel == null) {
            SimpleDateFormat simpleDateFormat;
            Object object;
            Object object2;
            this.historyPanel = new JPanel();
            this.historyPanel.setLayout((LayoutManager)new BoxLayout((Container)this.historyPanel, 1));
            this.historyPanel.setBackground(this.backgroundColor);
            JLabel jLabel = new JLabel("CQ Status history graph");
            JPanel jPanel = new JPanel();
            jPanel.setLayout((LayoutManager)new BoxLayout((Container)jPanel, 0));
            jPanel.add(Box.createHorizontalGlue());
            jPanel.add((Component)jLabel);
            jPanel.add(Box.createHorizontalGlue());
            this.historyPanel.add((Component)jPanel);
            JPanel jPanel2 = this.getActiveHistoryPanel();
            JPanel jPanel3 = this.getInstallHistoryPanel();
            JPanel jPanel4 = this.getEndCQHistoryPanel();
            if (this.historyInfo.size() > 0) {
                try {
                    object2 = (CQArchiveInfo)this.historyInfo.elementAt(0);
                    object = (CQArchiveInfo)this.historyInfo.elementAt(this.historyInfo.size() - 1);
                    this.startDate = ((CQArchiveInfo)object2).getStartDate();
                    this.endDate = ((CQArchiveInfo)object).getEndDate();
                    simpleDateFormat = new SimpleDateFormat();
                    JLabel jLabel2 = new JLabel("Start date: " + simpleDateFormat.format(this.startDate));
                    JLabel jLabel3 = new JLabel("End date: " + simpleDateFormat.format(this.endDate));
                    JPanel jPanel5 = new JPanel();
                    jPanel5.setLayout((LayoutManager)new BoxLayout((Container)jPanel5, 0));
                    jPanel5.add(Box.createRigidArea((Dimension)new Dimension(5, 0)));
                    jPanel5.add((Component)jLabel2);
                    jPanel5.add(Box.createHorizontalGlue());
                    jPanel5.add((Component)jLabel3);
                    jPanel5.add(Box.createRigidArea((Dimension)new Dimension(5, 0)));
                    this.historyPanel.add((Component)jPanel5);
                }
                catch (Exception exception) {
                    System.out.println("error in initializing history start/ end dates: " + exception);
                }
            }
            object2 = new JPanel();
            ((Container)object2).setLayout((LayoutManager)new BoxLayout((Container)object2, 0));
            object = new JPanel();
            ((Container)object).setLayout((LayoutManager)new BoxLayout((Container)object, 0));
            ((Container)object2).add((Component)jPanel2);
            ((Container)object).add((Component)jPanel3);
            ((Container)object).add((Component)jPanel4);
            this.historyPanel.add((Component)object2);
            this.historyPanel.add((Component)object);
            simpleDateFormat = new JPanel();
            ((Container)((Object)simpleDateFormat)).setLayout((LayoutManager)new BoxLayout((Container)((Object)simpleDateFormat), 0));
            this.colorButton = new JButton("Color");
            this.colorButton.addActionListener((ActionListener)this);
            ((Container)((Object)simpleDateFormat)).add((Component)this.colorButton);
            this.threeDCheckbox = new JCheckBox("3D");
            this.threeDCheckbox.addActionListener((ActionListener)this);
            ((Container)((Object)simpleDateFormat)).add(Box.createHorizontalGlue());
            ((Container)((Object)simpleDateFormat)).add((Component)this.threeDCheckbox);
            ((Container)((Object)simpleDateFormat)).add(Box.createHorizontalGlue());
            this.historyPanel.add((Component)((Object)simpleDateFormat));
        }
        return this.historyPanel;
    }

    private URL getHistoryURL() {
        try {
            return new URL("http://www.cse.ogi.edu/DISC/CQ/gif/BaseCQ.gif");
        }
        catch (Exception exception) {
            System.out.println("error in getting history graph URL");
            return null;
        }
    }

    public GraphPanel getInstallHistoryChart() {
        if (this.installHistoryChart == null) {
            DAreaChart dAreaChart = new DAreaChart("CQ Execution History");
            dAreaChart.getBackground().setTitleString("CQ Installation Rate");
            dAreaChart.setThreeD(false);
            Background background = dAreaChart.getBackground();
            background.setTitleColor(Color.blue);
            this.installHistoryChart = new GraphPanel((Chart)dAreaChart);
            Gc gc = background.getGc();
            gc.setLineColor(Color.red);
            gc.setMarkerColor(Color.green);
            gc.setFillColor(Color.gray);
            this.updateInstallHistoryChart();
        }
        return this.installHistoryChart;
    }

    public JPanel getInstallHistoryPanel() {
        if (this.installCQHistory.size() > 0) {
            return this.getInstallHistoryChart();
        }
        JPanel jPanel = new JPanel();
        jPanel.add((Component)new JLabel("No history available"));
        return jPanel;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public String getTitle() {
        if (this.title == null) {
            return "CQ System Stats";
        }
        return this.title;
    }

    private String getURLContents(URL uRL) throws IOException {
        URLConnection uRLConnection = uRL.openConnection();
        InputStreamReader inputStreamReader = new InputStreamReader(uRLConnection.getInputStream());
        LineNumberReader lineNumberReader = new LineNumberReader(inputStreamReader);
        StringBuffer stringBuffer = new StringBuffer();
        String string = lineNumberReader.readLine();
        while (string != null) {
            stringBuffer.append(string).append('\n');
            string = lineNumberReader.readLine();
        }
        return stringBuffer.toString();
    }

    public void individualHistoryClicked() {
        int n = this.cqInfoList.getSelectedRow();
        if (n < 0) {
            this.reset();
            return;
        }
        String string = (String)this.tableSorter.getValueAt(n, 1);
        if (string == null) {
            this.reset();
            return;
        }
        if (this.infoPanelList == null) {
            this.infoPanelList = new Hashtable();
        }
        JFrame jFrame = null;
        jFrame = (JFrame)this.infoPanelList.get(string);
        if (jFrame == null) {
            int n2 = 500;
            try {
                n2 = Integer.parseInt(this.getCountTextField().getText());
            }
            catch (NumberFormatException numberFormatException) {}
            jFrame = new JFrame();
            CQInfo cQInfo = this.tableModel.getCQInfo(string);
            new CQHistoryPanel(this.plugin, string, cQInfo, n2, jFrame);
            this.infoPanelList.put(string, jFrame);
        }
        jFrame.setVisible(true);
        this.spinner.stopSpinning();
        this.reset();
    }

    private void init() {
        try {
            this.getHistoryInfo();
            if (this.localFont == null) {
                this.localFont = new Font("timesRoman", 0, 14);
            }
            if (this.backgroundColor == null) {
                this.backgroundColor = Color.lightGray;
            }
            Container container = this.getContentPane();
            container.setLayout((LayoutManager)new BoxLayout(container, 1));
            container.setBackground(this.backgroundColor);
            JLabel jLabel = new JLabel(this.getTitle());
            Font font = new Font("timesRoman", 1, 20);
            jLabel.setFont(font);
            JPanel jPanel = new JPanel();
            jPanel.setLayout((LayoutManager)new BoxLayout((Container)jPanel, 0));
            jPanel.add(Box.createHorizontalGlue());
            jPanel.add((Component)jLabel);
            jPanel.add(Box.createHorizontalGlue());
            container.add((Component)jPanel);
            JPanel jPanel2 = this.getHistoryPanel();
            JPanel jPanel3 = this.getCurrentPanel();
            this.tabPanel = new JTabbedPane();
            this.tabPanel.add("Current Statistics", (Component)jPanel3);
            this.tabPanel.add("Execution History", (Component)jPanel2);
            container.add((Component)this.tabPanel);
            this.tabPanel.setSelectedComponent((Component)jPanel2);
            JPanel jPanel4 = new JPanel();
            jPanel4.setLayout((LayoutManager)new BoxLayout((Container)jPanel4, 0));
            container.add((Component)jPanel4);
            this.status = new JTextField("Status");
            this.status.setForeground(Color.blue);
            this.status.setBackground(Color.lightGray);
            this.status.setMaximumSize(new Dimension(this.status.getMaximumSize().width, this.status.getFontMetrics(this.status.getFont()).getHeight() * 2));
            this.status.setEditable(false);
            jPanel4.add((Component)this.status);
            this.spinner = new Spinner();
            jPanel4.add((Component)((Object)this.spinner));
            JPanel jPanel5 = new JPanel();
            jPanel5.setLayout((LayoutManager)new BoxLayout((Container)jPanel5, 0));
            container.add((Component)jPanel5);
            this.helpButton = new JButton("Help");
            this.helpButton.setBackground(Color.green);
            this.helpButton.addActionListener((ActionListener)this);
            jPanel5.add((Component)this.helpButton);
            this.refreshButton = new JButton("Refresh");
            this.refreshButton.setBackground(Color.orange);
            this.refreshButton.addActionListener((ActionListener)this);
            jPanel5.add(Box.createHorizontalGlue());
            jPanel5.add((Component)this.refreshButton);
            this.closeButton = new JButton("Close");
            this.closeButton.setBackground(Color.red);
            this.closeButton.addActionListener((ActionListener)this);
            jPanel5.add(Box.createHorizontalGlue());
            jPanel5.add((Component)this.closeButton);
            if (this.cqInfoList.getModel().getRowCount() > 0) {
                this.cqInfoList.getSelectionModel().setSelectionInterval(0, 0);
            }
        }
        catch (Exception exception) {
            System.out.println("CQStats error: " + exception);
            exception.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        StatFrame statFrame = new StatFrame(null, null, null, null, "Test Stats");
        ((Window)((Object)statFrame)).pack();
        ((Component)((Object)statFrame)).setVisible(true);
    }

    public void refresh() {
        this.infoPanelList = new Hashtable();
        this.historyInfo = null;
        this.getHistoryInfo();
        this.cqinfo = null;
        this.cqinfo = this.plugin.getCQInfo();
        Runnable runnable = new Runnable(this){
            /* synthetic */ StatFrame this$0;

            public void run() {
                StatFrame.access$refresh0(this.this$0);
            }
            {
                this.this$0 = statFrame;
            }
        };
        SwingUtilities.invokeLater((Runnable)runnable);
    }

    private void refresh0() {
        this.tableModel.setCQInfo(this.cqinfo);
        this.refreshButton.setEnabled(true);
        this.status.setText("");
        this.spinner.stopSpinning();
    }

    public void reset() {
        Runnable runnable = new Runnable(this){
            /* synthetic */ StatFrame this$0;

            public void run() {
                StatFrame.access$reset0(this.this$0);
            }
            {
                this.this$0 = statFrame;
            }
        };
        SwingUtilities.invokeLater((Runnable)runnable);
    }

    private void reset0() {
        this.status.setText("");
        this.individualButton.setEnabled(true);
    }

    private void setChartColors(Chart chart, Color color, Color color2) {
        Dataset[] datasetArray = chart.getDatasets();
        if (datasetArray != null) {
            int n = 0;
            while (n < datasetArray.length) {
                Dataset dataset = datasetArray[n];
                if (dataset != null) {
                    Gc gc = dataset.getGc();
                    if (gc == null) {
                        gc = new Gc(chart.getGlobals());
                        dataset.setGc(gc);
                    }
                    gc.setLineColor(color);
                    gc.setFillColor(color2);
                }
                ++n;
            }
        }
    }

    public void setLocalFont(Font font) {
        if (font == null) {
            return;
        }
        super.setFont(font);
    }

    public void showCurrentStats() {
        if (this.currentPanel != null && this.tabPanel != null) {
            this.tabPanel.setSelectedComponent((Component)this.currentPanel);
        }
    }

    public void showExecutionHistory() {
        this.tabPanel.setSelectedComponent((Component)this.historyPanel);
    }

    private void updateActiveHistory() {
        Dataset[] datasetArray;
        Dataset[] datasetArray2;
        Chart chart = this.getActiveHistoryChart().getChart();
        double[] dArray = new double[this.activeCQHistory.size()];
        double[] dArray2 = new double[this.activeCQHistory.size()];
        int n = 0;
        while (n < this.activeCQHistory.size()) {
            datasetArray2 = (Dataset[])this.activeCQHistory.elementAt(n);
            datasetArray = (Dataset[])datasetArray2.getLeft();
            Integer n2 = (Integer)datasetArray2.getRight();
            dArray[n] = datasetArray.doubleValue();
            dArray2[n] = n2 == null ? 0.0 : n2.doubleValue();
            ++n;
        }
        Dataset dataset = new Dataset("CQ History", dArray, dArray2, chart.getGlobals());
        datasetArray2 = new Dataset[]{dataset};
        chart.getYAxis().setDatasets(datasetArray2);
        chart.getXAxis().setDatasets(datasetArray2);
        chart.addDataset(dataset);
        datasetArray = chart.getDatasets();
        if (datasetArray != null) {
            int n3 = 0;
            while (n3 < datasetArray.length) {
                dataset = datasetArray[n3];
                if (dataset != null) {
                    Gc gc = dataset.getGc();
                    if (gc == null) {
                        gc = new Gc(chart.getGlobals());
                        dataset.setGc(gc);
                    }
                    gc.setLineColor(Color.black);
                    gc.setMarkerColor(Color.green);
                    gc.setFillColor(Color.blue);
                }
                ++n3;
            }
        }
        chart.getXAxis().setTitleString("Date");
        chart.getYAxis().setTitleString("Number of CQs");
        chart.getYAxis().setTitleRotated(true);
        chart.getXAxis().setTitleRotated(true);
    }

    private void updateEndCQHistory() {
        Dataset[] datasetArray;
        Long l;
        Dataset[] datasetArray2;
        Chart chart = this.getEndCQHistoryChart().getChart();
        double[] dArray = new double[this.endCQHistory.size()];
        double[] dArray2 = new double[this.endCQHistory.size()];
        int n = 0;
        while (n < this.endCQHistory.size()) {
            datasetArray2 = (Dataset[])this.endCQHistory.elementAt(n);
            l = (Long)datasetArray2.getLeft();
            datasetArray = (Dataset[])datasetArray2.getRight();
            dArray[n] = l.doubleValue();
            dArray2[n] = datasetArray == null ? 0.0 : datasetArray.doubleValue();
            ++n;
        }
        Dataset dataset = new Dataset("CQ History", dArray, dArray2, chart.getGlobals());
        datasetArray2 = new Dataset[]{dataset};
        l = new DateAxis(datasetArray2, true, chart.getPlotarea());
        chart.setXAxis((AxisInterface)l);
        chart.getYAxis().setDatasets(datasetArray2);
        chart.addDataset(dataset);
        datasetArray = chart.getDatasets();
        if (datasetArray != null) {
            int n2 = 0;
            while (n2 < datasetArray.length) {
                dataset = datasetArray[n2];
                if (dataset != null) {
                    Gc gc = dataset.getGc();
                    if (gc == null) {
                        gc = new Gc(chart.getGlobals());
                        dataset.setGc(gc);
                    }
                    gc.setLineColor(Color.black);
                    gc.setMarkerColor(Color.green);
                    gc.setFillColor(Color.red);
                }
                ++n2;
            }
        }
        chart.getXAxis().setTitleString("Date");
        chart.getYAxis().setTitleString("Number of CQs");
        chart.getYAxis().setTitleRotated(true);
        chart.getXAxis().setTitleRotated(true);
    }

    private void updateInstallHistoryChart() {
        Dataset[] datasetArray;
        Dataset[] datasetArray2;
        Chart chart = this.getInstallHistoryChart().getChart();
        double[] dArray = new double[this.installCQHistory.size()];
        double[] dArray2 = new double[this.installCQHistory.size()];
        int n = 0;
        while (n < this.installCQHistory.size()) {
            datasetArray2 = (Dataset[])this.installCQHistory.elementAt(n);
            datasetArray = (Dataset[])datasetArray2.getLeft();
            Integer n2 = (Integer)datasetArray2.getRight();
            dArray[n] = datasetArray.doubleValue();
            dArray2[n] = n2 == null ? 0.0 : n2.doubleValue();
            ++n;
        }
        Dataset dataset = new Dataset("CQ History", dArray, dArray2, chart.getGlobals());
        datasetArray2 = new Dataset[]{dataset};
        chart.getYAxis().setDatasets(datasetArray2);
        chart.getXAxis().setDatasets(datasetArray2);
        chart.addDataset(dataset);
        datasetArray = chart.getDatasets();
        if (datasetArray != null) {
            int n3 = 0;
            while (n3 < datasetArray.length) {
                dataset = datasetArray[n3];
                if (dataset != null) {
                    Gc gc = dataset.getGc();
                    if (gc == null) {
                        gc = new Gc(chart.getGlobals());
                        dataset.setGc(gc);
                    }
                    gc.setLineColor(Color.green);
                    gc.setMarkerColor(Color.black);
                    gc.setFillColor(Color.blue);
                }
                ++n3;
            }
        }
        chart.getXAxis().setTitleString("Date");
        chart.getYAxis().setTitleString("Number of CQs");
        chart.getYAxis().setTitleRotated(true);
        chart.getXAxis().setTitleRotated(true);
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.individualButton.setEnabled(true);
    }

    static void access$reset0(StatFrame statFrame) {
        statFrame.reset0();
    }

    static void access$refresh0(StatFrame statFrame) {
        statFrame.refresh0();
    }
}

