/*
 * Decompiled with CFR 0.152.
 */
package ogi.cq.plugin.gui;

import Zql.ParseException;
import Zql.ZQuery;
import Zql.ZStatement;
import Zql.ZqlParser;
import com.sun.java.swing.AbstractListModel;
import com.sun.java.swing.Box;
import com.sun.java.swing.BoxLayout;
import com.sun.java.swing.DefaultListModel;
import com.sun.java.swing.JButton;
import com.sun.java.swing.JComboBox;
import com.sun.java.swing.JFrame;
import com.sun.java.swing.JLabel;
import com.sun.java.swing.JList;
import com.sun.java.swing.JPanel;
import com.sun.java.swing.JScrollPane;
import com.sun.java.swing.JSplitPane;
import com.sun.java.swing.JTabbedPane;
import com.sun.java.swing.JTextArea;
import com.sun.java.swing.JTextField;
import com.sun.java.swing.JTextPane;
import com.sun.java.swing.ListModel;
import com.sun.java.swing.event.CaretEvent;
import com.sun.java.swing.event.CaretListener;
import com.sun.java.swing.event.ListSelectionEvent;
import com.sun.java.swing.event.ListSelectionListener;
import com.sun.java.swing.text.AttributeSet;
import com.sun.java.swing.text.Document;
import com.sun.java.swing.text.MutableAttributeSet;
import com.sun.java.swing.text.Style;
import com.sun.java.swing.text.StyleConstants;
import com.sun.java.swing.text.StyleContext;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.DataInputStream;
import java.io.InputStream;
import java.io.StringBufferInputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import ogi.cq.gui.GenericStatePanel;
import ogi.cq.gui.WindowKiller;
import ogi.cq.log.CQLog;
import ogi.cq.log.Log;
import ogi.cq.plugin.gui.Examples;
import ogi.cq.plugin.gui.IQueryPanel;
import ogi.cq.plugin.gui.PluginState;
import ogi.cq.plugin.gui.SingleEntryListModel;
import ogi.cq.plugin.gui.TestTriggerState;
import ogi.cq.util.Pair;
import ogi.diom.util.GUI;

public class QueryPanel
extends GenericStatePanel
implements IQueryPanel,
ItemListener,
ActionListener,
ListSelectionListener,
CaretListener {
    protected PluginState manager;
    protected ZQuery query;
    protected Log logger;
    protected Examples examples;
    protected int currentState;
    protected Vector stateHistory;
    protected JPanel borderPanel;
    protected JTextField cqNameField;
    protected JPanel examplePanel;
    protected JPanel helpPanel;
    protected JPanel selectPanel;
    protected JList selectTableList;
    protected DefaultListModel selectTableModel;
    protected JList selectColumnList;
    protected DefaultListModel selectColumnModel;
    protected JButton selectAddAllButton;
    protected JButton selectAddButton;
    protected JButton selectRemoveButton;
    protected JButton selectRemoveAllButton;
    protected JList selectList;
    protected DefaultListModel selectModel;
    protected JPanel wherePanel;
    protected JList whereTableList;
    protected DefaultListModel whereTableModel;
    protected JList whereColumnList;
    protected DefaultListModel whereColumnModel;
    protected JList operatorList;
    protected DefaultListModel operatorModel;
    protected JTextField valueField;
    protected JButton andButton;
    protected JButton orButton;
    protected JButton notButton;
    protected JButton lpButton;
    protected JButton rpButton;
    protected JButton clearButton;
    protected JButton backButton;
    protected JTextField groupByField;
    protected JTextField orderByField;
    protected JComboBox resultFormatChoice;
    protected JTextPane queryField;
    protected Hashtable fromList;
    protected Vector whereVec;
    protected JComboBox chooseExampleComboBox;
    protected JTextArea queryDescriptionField;
    protected boolean selectTableValueChanging = false;
    protected boolean whereTableValueChanging = false;
    protected boolean updated = false;

    public QueryPanel(PluginState pluginState, Examples examples) {
        this(pluginState, examples, null, null, null);
    }

    public QueryPanel(PluginState pluginState, Examples examples, Log log) {
        this(pluginState, examples, log, null, null);
    }

    public QueryPanel(PluginState pluginState, Examples examples, Log log, Color color, Font font) {
        try {
            this.manager = pluginState;
            this.examples = examples;
            if (log != null) {
                this.logger = log;
            } else {
                this.logger = new CQLog();
                this.logger.setDebug(true);
            }
            this.backgroundColor = color;
            this.localFont = font;
            this.fromList = new Hashtable();
            this.whereVec = new Vector();
            this.stateHistory = new Vector();
            this.init();
            this.currentState = 1;
        }
        catch (Exception exception) {
            this.logger.debug("bibQuery statepanel new error: " + exception);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.andButton || actionEvent.getSource() == this.orButton) {
            String string = String.valueOf(IQueryPanel.NEW_LINE) + "    " + ((JButton)actionEvent.getSource()).getText() + " ";
            Pair pair = null;
            pair = this.whereVec.size() > 0 ? (Pair)this.whereVec.elementAt(this.whereVec.size() - 1) : new Pair(null, null);
            if (pair.getLeft() == IQueryPanel.LOGIC) {
                pair.setRight(string);
            } else {
                int n = IQueryPanel.stateChange[this.currentState][3];
                if (n == 0) {
                    return;
                }
                this.stateHistory.addElement(new Integer(this.currentState));
                this.currentState = n;
                pair = new Pair(IQueryPanel.LOGIC, string);
                this.whereVec.addElement(pair);
            }
            this.updateQueryField();
        } else if (actionEvent.getSource() == this.backButton) {
            if (this.whereVec.size() > 0 && this.stateHistory.size() > 0) {
                this.whereVec.removeElementAt(this.whereVec.size() - 1);
                Integer n = (Integer)this.stateHistory.elementAt(this.stateHistory.size() - 1);
                this.currentState = n;
                this.stateHistory.removeElementAt(this.stateHistory.size() - 1);
                this.updateFromList();
                this.updateQueryField();
            }
        } else if (actionEvent.getSource() == this.clearButton) {
            this.stateHistory = new Vector();
            this.currentState = 1;
            this.whereVec = new Vector();
            this.updateFromList();
            this.updateQueryField();
        } else if (actionEvent.getSource() == this.selectAddAllButton) {
            String string = (String)this.selectTableList.getSelectedValue();
            AbstractListModel abstractListModel = (AbstractListModel)this.selectColumnList.getModel();
            int n = abstractListModel.getSize();
            int n2 = 0;
            while (n2 < n) {
                this.selectModel.addElement((Object)(String.valueOf(string) + "." + (String)abstractListModel.getElementAt(n2)));
                ++n2;
            }
            this.updateFromList();
            this.updateQueryField();
        } else if (actionEvent.getSource() == this.selectAddButton) {
            String string = (String)this.selectTableList.getSelectedValue();
            Object[] objectArray = this.selectColumnList.getSelectedValues();
            int n = 0;
            while (n < objectArray.length) {
                this.selectModel.addElement((Object)(String.valueOf(string) + "." + (String)objectArray[n]));
                ++n;
            }
            this.updateFromList();
            this.updateQueryField();
        } else if (actionEvent.getSource() == this.selectRemoveButton) {
            int n = this.selectList.getSelectedIndex();
            if (n >= 0) {
                this.selectModel.removeElementAt(n);
                this.updateFromList();
                this.updateQueryField();
            }
        } else if (actionEvent.getSource() == this.selectRemoveAllButton) {
            this.selectModel.removeAllElements();
            this.updateFromList();
            this.updateQueryField();
        }
    }

    public void caretUpdate(CaretEvent caretEvent) {
        if (caretEvent.getSource() == this.valueField) {
            String string = this.valueField.getText();
            Pair pair = null;
            pair = this.whereVec.size() > 0 ? (Pair)this.whereVec.elementAt(this.whereVec.size() - 1) : new Pair(null, null);
            if (pair.getLeft() == IQueryPanel.VALUE) {
                pair.setRight(string);
            } else {
                int n = IQueryPanel.stateChange[this.currentState][2];
                if (n == 0) {
                    return;
                }
                this.stateHistory.addElement(new Integer(this.currentState));
                this.currentState = n;
                pair = new Pair(IQueryPanel.VALUE, string);
                this.whereVec.addElement(pair);
            }
            this.updateQueryField();
        }
    }

    protected JTextPane createTextPane() {
        JTextPane jTextPane = new JTextPane();
        Style style = StyleContext.getDefaultStyleContext().getStyle("default");
        Style style2 = jTextPane.addStyle("regular", style);
        StyleConstants.setFontSize((MutableAttributeSet)style, (int)14);
        StyleConstants.setFontFamily((MutableAttributeSet)style, (String)"SansSerif");
        Style style3 = jTextPane.addStyle("italic", style2);
        StyleConstants.setItalic((MutableAttributeSet)style3, (boolean)true);
        style3 = jTextPane.addStyle("bold", style2);
        StyleConstants.setBold((MutableAttributeSet)style3, (boolean)true);
        style3 = jTextPane.addStyle("small", style2);
        StyleConstants.setFontSize((MutableAttributeSet)style3, (int)10);
        style3 = jTextPane.addStyle("blue", style2);
        StyleConstants.setBold((MutableAttributeSet)style3, (boolean)true);
        StyleConstants.setForeground((MutableAttributeSet)style3, (Color)Color.blue);
        style3 = jTextPane.addStyle("red", style2);
        StyleConstants.setBold((MutableAttributeSet)style3, (boolean)true);
        StyleConstants.setForeground((MutableAttributeSet)style3, (Color)Color.red);
        style3 = jTextPane.addStyle("large", style2);
        StyleConstants.setFontSize((MutableAttributeSet)style3, (int)16);
        return jTextPane;
    }

    protected JPanel getExamplePanel() {
        try {
            if (this.examplePanel == null) {
                this.examplePanel = new JPanel();
                this.examplePanel.setLayout((LayoutManager)new BoxLayout((Container)this.examplePanel, 1));
                JPanel jPanel = new JPanel();
                jPanel.setLayout((LayoutManager)new BoxLayout((Container)jPanel, 0));
                JLabel jLabel = new JLabel("Choose Example ");
                jLabel.setForeground(Color.black);
                jPanel.add((Component)jLabel);
                this.chooseExampleComboBox = new JComboBox();
                this.chooseExampleComboBox.addActionListener((ActionListener)this);
                this.chooseExampleComboBox.addItem((Object)"Select an example");
                int n = this.examples.getExampleCount();
                int n2 = 0;
                while (n2 < n) {
                    this.chooseExampleComboBox.addItem(this.examples.getExample(n2)[0]);
                    ++n2;
                }
                this.chooseExampleComboBox.addItemListener((ItemListener)this);
                jPanel.add((Component)this.chooseExampleComboBox);
                jPanel.add(Box.createHorizontalGlue());
                this.examplePanel.add((Component)jPanel);
                JPanel jPanel2 = new JPanel();
                jPanel2.setLayout(new GridBagLayout());
                Font font = new Font("dialog", 1, 14);
                JLabel jLabel2 = new JLabel("Description");
                jLabel2.setForeground(Color.black);
                jLabel2.setFont(font);
                GUI.add((Container)jPanel2, (Component)jLabel2, 2, 1, 5, 1, 1, 10, 50.0, 50.0);
                JLabel jLabel3 = new JLabel("Query: ");
                jLabel3.setForeground(Color.black);
                GUI.add((Container)jPanel2, (Component)jLabel3, 1, 2, 1, 1, 1, 10, 1.0, 50.0);
                this.queryDescriptionField = new JTextArea();
                this.queryDescriptionField.setForeground(Color.blue);
                this.queryDescriptionField.setWrapStyleWord(true);
                this.queryDescriptionField.setLineWrap(true);
                JScrollPane jScrollPane = new JScrollPane((Component)this.queryDescriptionField);
                GUI.add((Container)jPanel2, (Component)jScrollPane, 2, 2, 5, 3, 1, 10, 50.0, 50.0);
                this.examplePanel.add((Component)jPanel2);
            }
        }
        catch (Exception exception) {
            System.out.println("error in getExamplePanel: " + exception);
            exception.printStackTrace();
        }
        catch (Throwable throwable) {
            System.out.println("error in getExamplePanel: " + throwable);
            throwable.printStackTrace();
        }
        return this.examplePanel;
    }

    public String getFROM() {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            Enumeration enumeration = this.fromList.keys();
            while (enumeration.hasMoreElements()) {
                stringBuffer.append((String)enumeration.nextElement());
                stringBuffer.append(", ");
            }
            if (stringBuffer.length() <= 0) {
                return null;
            }
            stringBuffer.setLength(stringBuffer.length() - 2);
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            this.logger.debug("Error in QueryPanel.getFrom: " + exception);
            return null;
        }
    }

    protected JPanel getFullQueryPanel() {
        JLabel jLabel = new JLabel("Full Query: ");
        Font font = new Font("timesRoman", 1, 14);
        jLabel.setFont(font);
        jLabel.setForeground(Color.black);
        this.queryField = this.createTextPane();
        JScrollPane jScrollPane = new JScrollPane((Component)this.queryField);
        JPanel jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new BoxLayout((Container)jPanel, 1));
        jPanel.add(Box.createVerticalStrut((int)10));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new BoxLayout((Container)jPanel2, 0));
        jPanel2.add(Box.createHorizontalGlue());
        jPanel2.add((Component)jLabel);
        jPanel2.add(Box.createHorizontalGlue());
        jPanel.add((Component)jPanel2);
        jPanel.add(Box.createVerticalStrut((int)5));
        jPanel.add((Component)jScrollPane);
        return jPanel;
    }

    public String getGroupby() {
        return null;
    }

    protected JPanel getGroupByPanel() {
        String string = "[Group By]: ";
        JLabel jLabel = new JLabel(string);
        jLabel.setForeground(Color.black);
        jLabel.setFont(this.localFont);
        jLabel.setAlignmentX(0.0f);
        this.groupByField = new JTextField(40);
        this.groupByField.setFont(this.localFont);
        this.groupByField.setForeground(Color.blue);
        this.groupByField.setBackground(Color.white);
        JPanel jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new BoxLayout((Container)jPanel, 0));
        jPanel.add((Component)jLabel);
        jPanel.add((Component)this.groupByField);
        jPanel.add(Box.createGlue());
        return jPanel;
    }

    protected JPanel getHelpPanel() {
        try {
            if (this.helpPanel == null) {
                this.helpPanel = new JPanel();
                this.helpPanel.setLayout(new BorderLayout());
                JTextArea jTextArea = new JTextArea();
                jTextArea.setForeground(Color.blue);
                jTextArea.setWrapStyleWord(true);
                jTextArea.setLineWrap(true);
                JScrollPane jScrollPane = new JScrollPane((Component)jTextArea);
                jScrollPane.setVerticalScrollBarPolicy(22);
                this.helpPanel.add("Center", (Component)jScrollPane);
                jTextArea.append("To specify the data returned for a query:");
                jTextArea.append(IQueryPanel.NEW_LINE);
                jTextArea.append("-----------------------------------------");
                jTextArea.append(IQueryPanel.NEW_LINE);
                jTextArea.append("1) Select an object from the object list.");
                jTextArea.append(IQueryPanel.NEW_LINE);
                jTextArea.append("2) Select relevant attributes from the object property list.");
                jTextArea.append(IQueryPanel.NEW_LINE);
                jTextArea.append("3) Click the \">\" button to confirm your selection.");
                jTextArea.append(IQueryPanel.NEW_LINE);
                jTextArea.append(IQueryPanel.NEW_LINE);
                jTextArea.append(IQueryPanel.NEW_LINE);
                jTextArea.append("To specify the selection conditions for a query:");
                jTextArea.append(IQueryPanel.NEW_LINE);
                jTextArea.append("------------------------------------------------");
                jTextArea.append(IQueryPanel.NEW_LINE);
                jTextArea.append("1) Click the conditions tab.");
                jTextArea.append(IQueryPanel.NEW_LINE);
                jTextArea.append("2) Select relevant attributes from the object property list.");
                jTextArea.append(IQueryPanel.NEW_LINE);
                jTextArea.append("3) Select operator and value for that attribute.");
                jTextArea.append(IQueryPanel.NEW_LINE);
                jTextArea.append("4) For muliple attributes, click the AND button.");
                jTextArea.append(IQueryPanel.NEW_LINE);
                jTextArea.append("To correct a mistake, or change your entry, click the \"<\" button to go back one stage, or click the \"Clear\" button to remove all conditions");
            }
        }
        catch (Exception exception) {
            System.out.println("error in gethelpPanel: " + exception);
            exception.printStackTrace();
        }
        catch (Throwable throwable) {
            System.out.println("error in gethelpPanel: " + throwable);
            throwable.printStackTrace();
        }
        return this.helpPanel;
    }

    protected Vector getOperators() {
        Vector vector;
        if (this.manager == null) {
            vector = new Vector();
            int n = 0;
            while (n < IQueryPanel.OPERATORS.length) {
                vector.addElement(IQueryPanel.OPERATORS[n]);
                ++n;
            }
        } else {
            vector = this.manager.getQueryOperators();
        }
        return vector;
    }

    public String getOrderby() {
        return null;
    }

    protected JPanel getOrderByPanel() {
        String string = "[Order By]: ";
        JLabel jLabel = new JLabel(string);
        jLabel.setForeground(Color.black);
        jLabel.setFont(this.localFont);
        jLabel.setAlignmentX(0.0f);
        this.orderByField = new JTextField(40);
        this.orderByField.setFont(this.localFont);
        this.orderByField.setForeground(Color.blue);
        this.orderByField.setBackground(Color.white);
        JPanel jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new BoxLayout((Container)jPanel, 0));
        jPanel.add((Component)jLabel);
        jPanel.add((Component)this.orderByField);
        jPanel.add(Box.createHorizontalGlue());
        return jPanel;
    }

    public String getPredicates() {
        StringBuffer stringBuffer = new StringBuffer();
        this.whereVec.size();
        int n = 0;
        while (n < this.whereVec.size()) {
            Pair pair = (Pair)this.whereVec.elementAt(n);
            stringBuffer.append((String)pair.getRight());
            ++n;
        }
        return stringBuffer.toString();
    }

    public ZQuery getQuery() throws ParseException {
        if (this.query == null) {
            try {
                StringBuffer stringBuffer = new StringBuffer("SELECT ");
                stringBuffer.append(this.getSELECT());
                stringBuffer.append(" FROM ");
                stringBuffer.append(this.getFROM());
                String string = this.getPredicates();
                if (string != null && !string.trim().equals("")) {
                    stringBuffer.append(" WHERE ");
                    stringBuffer.append(string);
                }
                stringBuffer.append(";");
                ZqlParser zqlParser = null;
                zqlParser = new ZqlParser((InputStream)new DataInputStream(new StringBufferInputStream(stringBuffer.toString())));
                ZStatement zStatement = zqlParser.readStatement();
                this.query = (ZQuery)zStatement;
            }
            catch (ParseException parseException) {
                throw new ParseException("Invalid Query: please check syntax for missing or malformed clauses");
            }
        }
        return this.query;
    }

    public String getSELECT() {
        StringBuffer stringBuffer = new StringBuffer();
        AbstractListModel abstractListModel = (AbstractListModel)this.selectList.getModel();
        int n = abstractListModel.getSize();
        int n2 = 0;
        while (n2 < n) {
            String string = (String)abstractListModel.getElementAt(n2);
            stringBuffer.append(string);
            stringBuffer.append(", ");
            ++n2;
        }
        if (n > 0) {
            stringBuffer.setLength(stringBuffer.length() - 2);
        }
        return stringBuffer.toString();
    }

    protected JPanel getSelectPanel() {
        if (this.selectPanel == null) {
            String string = "SELECT:";
            JLabel jLabel = new JLabel(string);
            jLabel.setForeground(Color.black);
            jLabel.setFont(this.localFont);
            jLabel.setAlignmentX(0.0f);
            JPanel jPanel = new JPanel();
            jPanel.setLayout((LayoutManager)new BoxLayout((Container)jPanel, 0));
            jPanel.add((Component)jLabel);
            jPanel.add(Box.createHorizontalGlue());
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout((LayoutManager)new BoxLayout((Container)jPanel2, 1));
            JLabel jLabel2 = new JLabel("Object Type");
            jLabel2.setAlignmentX(0.0f);
            jLabel2.setForeground(Color.black);
            jPanel2.add((Component)jLabel2);
            this.selectTableList = new JList(this.manager.getRelations());
            this.selectTableList.setFont(this.localFont);
            this.selectTableList.setForeground(Color.blue);
            this.selectTableList.setBackground(Color.white);
            this.selectTableList.setSelectionMode(0);
            this.selectTableList.addListSelectionListener((ListSelectionListener)this);
            JScrollPane jScrollPane = new JScrollPane((Component)this.selectTableList);
            jScrollPane.setAlignmentX(0.0f);
            jPanel2.add((Component)jScrollPane);
            JPanel jPanel3 = new JPanel();
            jPanel3.setLayout((LayoutManager)new BoxLayout((Container)jPanel3, 1));
            JLabel jLabel3 = new JLabel("Object Property");
            jLabel3.setAlignmentX(0.0f);
            jLabel3.setForeground(Color.black);
            jPanel3.add((Component)jLabel3);
            this.selectColumnList = new JList();
            this.selectColumnList.setForeground(Color.blue);
            this.selectColumnList.addListSelectionListener((ListSelectionListener)this);
            JScrollPane jScrollPane2 = new JScrollPane((Component)this.selectColumnList);
            jScrollPane2.setAlignmentX(0.0f);
            jPanel3.add((Component)jScrollPane2);
            JPanel jPanel4 = new JPanel();
            jPanel4.setLayout((LayoutManager)new BoxLayout((Container)jPanel4, 1));
            JLabel jLabel4 = new JLabel("Confirm");
            jLabel4.setAlignmentX(0.0f);
            jLabel4.setForeground(Color.black);
            jPanel4.add((Component)jLabel4);
            JPanel jPanel5 = new JPanel();
            jPanel5.setLayout(new GridLayout(4, 1));
            this.selectAddAllButton = new JButton(">>");
            this.selectAddAllButton.addActionListener((ActionListener)this);
            this.selectAddButton = new JButton(">");
            this.selectAddButton.addActionListener((ActionListener)this);
            this.selectRemoveButton = new JButton("<");
            this.selectRemoveButton.addActionListener((ActionListener)this);
            this.selectRemoveAllButton = new JButton("<<");
            this.selectRemoveAllButton.addActionListener((ActionListener)this);
            jPanel5.add((Component)this.selectAddButton);
            jPanel5.add((Component)this.selectAddAllButton);
            jPanel5.add((Component)this.selectRemoveButton);
            jPanel5.add((Component)this.selectRemoveAllButton);
            jPanel5.setAlignmentX(0.0f);
            jPanel4.add((Component)jPanel5);
            JPanel jPanel6 = new JPanel();
            jPanel6.setLayout((LayoutManager)new BoxLayout((Container)jPanel6, 1));
            JLabel jLabel5 = new JLabel(" ");
            jLabel5.setForeground(Color.black);
            jPanel6.add((Component)jLabel5);
            this.selectList = new JList();
            this.selectModel = new SingleEntryListModel();
            this.selectList.setModel((ListModel)this.selectModel);
            this.selectList.setFont(this.localFont);
            this.selectList.setForeground(Color.blue);
            this.selectList.setBackground(Color.white);
            JScrollPane jScrollPane3 = new JScrollPane((Component)this.selectList);
            jPanel6.add((Component)jScrollPane3);
            JPanel jPanel7 = new JPanel();
            jPanel7.setLayout((LayoutManager)new BoxLayout((Container)jPanel7, 0));
            jPanel7.add((Component)jPanel2);
            jPanel7.add((Component)jPanel3);
            jPanel7.add((Component)jPanel4);
            jPanel7.add((Component)jPanel6);
            this.selectPanel = new JPanel();
            this.selectPanel.setLayout((LayoutManager)new BoxLayout((Container)this.selectPanel, 1));
            this.selectPanel.add((Component)jPanel7);
        }
        return this.selectPanel;
    }

    public String getTitle() {
        return "Specify Query";
    }

    protected JPanel getWherePanel() {
        if (this.wherePanel == null) {
            this.wherePanel = new JPanel();
            this.wherePanel.setLayout((LayoutManager)new BoxLayout((Container)this.wherePanel, 1));
            String string = "[WHERE]: ";
            JLabel jLabel = new JLabel(string);
            jLabel.setForeground(Color.black);
            jLabel.setFont(this.localFont);
            jLabel.setAlignmentX(0.0f);
            JPanel jPanel = new JPanel();
            jPanel.setLayout((LayoutManager)new BoxLayout((Container)jPanel, 0));
            jPanel.add((Component)jLabel);
            jPanel.add(Box.createHorizontalGlue());
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout((LayoutManager)new BoxLayout((Container)jPanel2, 0));
            JPanel jPanel3 = new JPanel();
            jPanel3.setLayout((LayoutManager)new BoxLayout((Container)jPanel3, 1));
            jPanel2.add((Component)jPanel3);
            JLabel jLabel2 = new JLabel("Object Type");
            jLabel2.setAlignmentX(0.0f);
            jLabel2.setForeground(Color.black);
            jPanel3.add((Component)jLabel2);
            this.whereTableList = new JList(this.manager.getRelations());
            this.whereTableList.setForeground(Color.blue);
            this.whereTableList.setAlignmentX(0.0f);
            this.whereTableList.addListSelectionListener((ListSelectionListener)this);
            JScrollPane jScrollPane = new JScrollPane((Component)this.whereTableList);
            jScrollPane.setAlignmentX(0.0f);
            jPanel3.add((Component)jScrollPane);
            JPanel jPanel4 = new JPanel();
            jPanel4.setLayout((LayoutManager)new BoxLayout((Container)jPanel4, 1));
            jPanel2.add(Box.createRigidArea((Dimension)new Dimension(10, 0)));
            jPanel2.add((Component)jPanel4);
            JLabel jLabel3 = new JLabel("Object Property");
            jLabel3.setAlignmentX(0.0f);
            jLabel3.setForeground(Color.black);
            jPanel4.add((Component)jLabel3);
            this.whereColumnList = new JList();
            this.whereColumnList.setForeground(Color.blue);
            this.whereColumnList.setAlignmentX(0.0f);
            this.whereColumnList.addListSelectionListener((ListSelectionListener)this);
            JScrollPane jScrollPane2 = new JScrollPane((Component)this.whereColumnList);
            jScrollPane2.setAlignmentX(0.0f);
            jPanel4.add((Component)jScrollPane2);
            JPanel jPanel5 = new JPanel();
            jPanel5.setLayout((LayoutManager)new BoxLayout((Container)jPanel5, 1));
            jPanel2.add(Box.createRigidArea((Dimension)new Dimension(10, 0)));
            jPanel2.add((Component)jPanel5);
            JLabel jLabel4 = new JLabel("Operator");
            jLabel4.setAlignmentX(0.0f);
            jLabel4.setForeground(Color.black);
            jPanel5.add((Component)jLabel4);
            this.operatorList = new JList(this.getOperators());
            this.operatorList.setForeground(Color.blue);
            this.operatorList.addListSelectionListener((ListSelectionListener)this);
            this.operatorList.setAlignmentX(0.0f);
            JScrollPane jScrollPane3 = new JScrollPane((Component)this.operatorList);
            jScrollPane3.setAlignmentX(0.0f);
            jPanel5.add((Component)jScrollPane3);
            JPanel jPanel6 = new JPanel();
            jPanel6.setLayout((LayoutManager)new BoxLayout((Container)jPanel6, 1));
            jPanel2.add(Box.createRigidArea((Dimension)new Dimension(10, 0)));
            jPanel2.add((Component)jPanel6);
            jPanel2.add(Box.createHorizontalGlue());
            JLabel jLabel5 = new JLabel("Value");
            jLabel5.setAlignmentX(0.0f);
            jLabel5.setForeground(Color.black);
            jPanel6.add((Component)jLabel5);
            this.valueField = new JTextField("");
            this.valueField.setForeground(Color.blue);
            this.valueField.setAlignmentX(0.0f);
            this.valueField.addCaretListener((CaretListener)this);
            jPanel6.add((Component)this.valueField);
            jPanel6.add(Box.createVerticalGlue());
            this.wherePanel.add((Component)jPanel2);
            JPanel jPanel7 = new JPanel();
            jPanel7.setLayout((LayoutManager)new BoxLayout((Container)jPanel7, 0));
            this.lpButton = new JButton("(");
            this.lpButton.addActionListener((ActionListener)this);
            this.lpButton.setEnabled(false);
            jPanel7.add((Component)this.lpButton);
            this.rpButton = new JButton(")");
            this.rpButton.addActionListener((ActionListener)this);
            this.rpButton.setEnabled(false);
            jPanel7.add((Component)this.rpButton);
            jPanel7.add(Box.createHorizontalGlue());
            this.andButton = new JButton("AND");
            this.andButton.addActionListener((ActionListener)this);
            jPanel7.add((Component)this.andButton);
            this.orButton = new JButton("OR");
            this.orButton.addActionListener((ActionListener)this);
            this.orButton.setEnabled(false);
            jPanel7.add((Component)this.orButton);
            this.notButton = new JButton("NOT");
            this.notButton.addActionListener((ActionListener)this);
            this.notButton.setEnabled(false);
            jPanel7.add((Component)this.notButton);
            jPanel7.add(Box.createHorizontalGlue());
            this.backButton = new JButton("<-");
            this.backButton.setBackground(Color.yellow);
            this.backButton.addActionListener((ActionListener)this);
            jPanel7.add((Component)this.backButton);
            this.clearButton = new JButton("Clear");
            this.clearButton.setBackground(Color.yellow);
            this.clearButton.addActionListener((ActionListener)this);
            jPanel7.add((Component)this.clearButton);
            this.wherePanel.add((Component)jPanel7);
        }
        return this.wherePanel;
    }

    protected void init() {
        try {
            super.init();
            ((Container)((Object)this)).setLayout((LayoutManager)new BoxLayout((Container)((Object)this), 1));
            this.setBackground(this.backgroundColor);
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BorderLayout());
            ((Container)((Object)this)).add((Component)jPanel);
            JTabbedPane jTabbedPane = new JTabbedPane();
            jTabbedPane.add("Select", (Component)this.getSelectPanel());
            jTabbedPane.add("Conditions", (Component)this.getWherePanel());
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout((LayoutManager)new BoxLayout((Container)jPanel2, 1));
            jPanel2.add(Box.createVerticalGlue());
            jPanel2.add((Component)this.getGroupByPanel());
            jPanel2.add(Box.createVerticalGlue());
            jPanel2.add((Component)this.getOrderByPanel());
            jPanel2.add(Box.createVerticalGlue());
            jTabbedPane.add("Other", (Component)jPanel2);
            jTabbedPane.addTab("EXAMPLES", (Component)this.getExamplePanel());
            jTabbedPane.setBackgroundAt(3, Color.blue);
            jTabbedPane.setForegroundAt(3, Color.white);
            jTabbedPane.addTab("Help", (Component)this.getHelpPanel());
            jTabbedPane.setBackgroundAt(4, Color.green);
            JSplitPane jSplitPane = new JSplitPane(0, (Component)jTabbedPane, (Component)this.getFullQueryPanel());
            jSplitPane.setAlignmentX(0.0f);
            jPanel.add("Center", (Component)jSplitPane);
        }
        catch (Exception exception) {
            this.logger.debug("QueryPanel init error: " + exception);
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        int n;
        if (itemEvent.getSource() == this.chooseExampleComboBox && (n = this.chooseExampleComboBox.getSelectedIndex()) > 0 && n <= this.examples.getExampleCount()) {
            this.queryDescriptionField.setText((String)this.examples.getExample(--n)[1]);
            this.manager.setExample(this.examples.getExample(n));
        }
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        QueryPanel queryPanel = new QueryPanel(new TestTriggerState(), null);
        jFrame.getContentPane().add("Center", (Component)((Object)queryPanel));
        jFrame.addWindowListener(WindowKiller.get());
        jFrame.pack();
        jFrame.show();
    }

    public void reset() {
        this.cqNameField.setText("");
        this.groupByField.setText("");
        this.orderByField.setText("");
        this.fromList.clear();
        this.whereVec.removeAllElements();
        this.currentState = 1;
        this.stateHistory.removeAllElements();
        this.chooseExampleComboBox.setSelectedIndex(0);
        this.queryDescriptionField.setText("");
        this.selectModel.removeAllElements();
        this.updateFromList();
        this.updateQueryField();
    }

    public void setBackground(Color color) {
        if (color == null) {
            return;
        }
        super.setBackground(color);
        if (this.borderPanel != null) {
            this.borderPanel.setBackground(color);
        }
    }

    public void setExample(Object[] objectArray) {
        this.selectModel.removeAllElements();
        this.fromList.clear();
        String string = (String)objectArray[5];
        this.setFrom(string);
        String string2 = (String)objectArray[4];
        this.setSelect(string2);
        Object[] objectArray2 = (Object[])objectArray[6];
        this.setPredicates(objectArray2);
        String string3 = (String)objectArray[8];
        this.setOrderby(string3);
        String string4 = (String)objectArray[7];
        this.setGroupby(string4);
    }

    public void setFrom(String string) {
        if (string == null || string.trim().equals("")) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreElements()) {
            Object object = stringTokenizer.nextElement();
            this.fromList.put(object, object);
        }
    }

    public void setGroupby(String string) {
    }

    public void setLocalFont(Font font) {
        if (font == null) {
            return;
        }
        super.setFont(font);
    }

    public void setOrderby(String string) {
    }

    public void setPredicates(Object[] objectArray) {
        this.whereVec = new Vector();
        this.stateHistory = new Vector();
        int n = 1;
        int n2 = 0;
        int n3 = 0;
        while (n3 < objectArray.length) {
            Object object = objectArray[n3];
            if (objectArray.length <= n3 + 1) break;
            String string = (String)objectArray[++n3];
            if (object == IQueryPanel.TABLE) {
                n2 = IQueryPanel.stateChange[n][0];
            } else if (object == IQueryPanel.GROUP) {
                n2 = IQueryPanel.stateChange[0][0];
            } else if (object == IQueryPanel.OPERATOR) {
                n2 = IQueryPanel.stateChange[n][1];
                string = " " + string + " ";
            } else if (object == IQueryPanel.VALUE) {
                n2 = IQueryPanel.stateChange[n][2];
            } else if (object == IQueryPanel.LOGIC) {
                n2 = IQueryPanel.stateChange[n][3];
                string = String.valueOf(IQueryPanel.NEW_LINE) + "    " + string + " ";
            } else if (object == IQueryPanel.WHERE) {
                n2 = IQueryPanel.stateChange[0][0];
                string = String.valueOf(IQueryPanel.NEW_LINE) + "    " + string + " ";
            } else if (object == IQueryPanel.LPAREN) {
                n2 = IQueryPanel.stateChange[0][0];
            } else if (object == IQueryPanel.RPAREN) {
                n2 = IQueryPanel.stateChange[0][0];
            } else if (object == IQueryPanel.ALGEBRA) {
                n2 = IQueryPanel.stateChange[n][4];
                string = " " + string + " ";
            }
            if (n2 != 0) {
                this.stateHistory.addElement(new Integer(n));
                n = n2;
                Pair pair = new Pair(object, string);
                this.whereVec.addElement(pair);
            }
            ++n3;
        }
    }

    public void setSelect(String string) {
        if (string == null || string.trim().equals("")) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreElements()) {
            Object object = stringTokenizer.nextElement();
            ((DefaultListModel)this.selectList.getModel()).addElement(object);
        }
        this.updateQueryField();
    }

    public void setWhere(String string) {
    }

    public void switchTo() {
        super.switchTo();
    }

    protected void updateFromList() {
        Object object;
        this.fromList.clear();
        AbstractListModel abstractListModel = (AbstractListModel)this.selectList.getModel();
        int n = abstractListModel.getSize();
        int n2 = 0;
        while (n2 < n) {
            object = (String)abstractListModel.getElementAt(n2);
            int n3 = ((String)object).indexOf(".");
            if (n3 >= 0 && n3 < ((String)object).length()) {
                object = ((String)object).substring(0, n3).trim().toUpperCase();
                this.fromList.put(object, "");
            }
            ++n2;
        }
        n = this.whereVec.size();
        n2 = 0;
        while (n2 < n) {
            String string;
            int n4;
            object = (Pair)this.whereVec.elementAt(n2);
            if (((Pair)object).getLeft() == IQueryPanel.COLUMN && (n4 = (string = (String)((Pair)object).getRight()).indexOf(".")) >= 0 && n4 < string.length()) {
                string = string.substring(0, n4).trim().toUpperCase();
                this.fromList.put(string, "");
            }
            ++n2;
        }
    }

    protected void updateQueryField() {
        Document document = this.queryField.getDocument();
        try {
            document.remove(0, document.getLength());
            document.insertString(0, "SELECT ", (AttributeSet)this.queryField.getStyle(IQueryPanel.initStyles[5]));
            document.insertString(document.getLength(), this.getSELECT(), (AttributeSet)this.queryField.getStyle(IQueryPanel.initStyles[1]));
            document.insertString(document.getLength(), String.valueOf(IQueryPanel.NEW_LINE) + "FROM ", (AttributeSet)this.queryField.getStyle(IQueryPanel.initStyles[5]));
            document.insertString(document.getLength(), this.getFROM(), (AttributeSet)this.queryField.getStyle(IQueryPanel.initStyles[1]));
            document.insertString(document.getLength(), String.valueOf(IQueryPanel.NEW_LINE) + "WHERE ", (AttributeSet)this.queryField.getStyle(IQueryPanel.initStyles[5]));
            this.whereVec.size();
            int n = 0;
            while (n < this.whereVec.size()) {
                Pair pair = (Pair)this.whereVec.elementAt(n);
                if (pair.getLeft() == IQueryPanel.WHERE) {
                    document.insertString(document.getLength(), (String)pair.getRight(), (AttributeSet)this.queryField.getStyle(IQueryPanel.initStyles[5]));
                } else if (pair.getLeft() == IQueryPanel.GROUP) {
                    document.insertString(document.getLength(), (String)pair.getRight(), (AttributeSet)this.queryField.getStyle(IQueryPanel.initStyles[5]));
                } else if (pair.getLeft() == IQueryPanel.OPERATOR) {
                    document.insertString(document.getLength(), (String)pair.getRight(), (AttributeSet)this.queryField.getStyle(IQueryPanel.initStyles[6]));
                } else if (pair.getLeft() == IQueryPanel.LPAREN || pair.getLeft() == IQueryPanel.RPAREN) {
                    document.insertString(document.getLength(), (String)pair.getRight(), (AttributeSet)this.queryField.getStyle(IQueryPanel.initStyles[6]));
                } else if (pair.getLeft() == IQueryPanel.LOGIC) {
                    document.insertString(document.getLength(), (String)pair.getRight(), (AttributeSet)this.queryField.getStyle(IQueryPanel.initStyles[5]));
                } else if (pair.getLeft() == IQueryPanel.ALGEBRA) {
                    document.insertString(document.getLength(), (String)pair.getRight(), (AttributeSet)this.queryField.getStyle(IQueryPanel.initStyles[6]));
                } else {
                    document.insertString(document.getLength(), (String)pair.getRight(), (AttributeSet)this.queryField.getStyle(IQueryPanel.initStyles[1]));
                }
                ++n;
            }
            if (!this.updated) {
                ((Container)((Object)this)).invalidate();
                ((Container)((Object)this)).validate();
                ((Component)((Object)this)).repaint();
                this.updated = true;
            }
        }
        catch (Exception exception) {
            System.out.println("Error in updating query field: " + exception);
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        int n;
        Vector vector;
        Object object;
        String string;
        if (listSelectionEvent.getSource() == this.selectTableList) {
            this.selectTableValueChanging = true;
            string = (String)this.selectTableList.getSelectedValue();
            object = new DefaultListModel();
            this.selectColumnList.setModel((ListModel)object);
            vector = this.manager.getAttributes(string);
            n = 0;
            while (n < vector.size()) {
                object.addElement(vector.elementAt(n));
                ++n;
            }
            this.selectTableValueChanging = false;
            this.getSelectPanel().invalidate();
            this.getSelectPanel().validate();
        } else if (listSelectionEvent.getSource() == this.selectColumnList && !this.selectTableValueChanging) {
            String cfr_ignored_0 = " " + this.selectTableList.getSelectedValue() + "." + this.selectColumnList.getSelectedValue();
        }
        if (listSelectionEvent.getSource() == this.whereTableList) {
            this.whereTableValueChanging = true;
            string = (String)this.whereTableList.getSelectedValue();
            object = new DefaultListModel();
            this.whereColumnList.setModel((ListModel)object);
            vector = this.manager.getAttributes(string);
            n = 0;
            while (n < vector.size()) {
                object.addElement(vector.elementAt(n));
                ++n;
            }
            this.updateFromList();
            this.whereTableValueChanging = false;
        } else if (listSelectionEvent.getSource() == this.whereColumnList) {
            if (!this.whereTableValueChanging) {
                string = " " + this.whereTableList.getSelectedValue() + "." + this.whereColumnList.getSelectedValue();
                object = null;
                object = this.whereVec.size() > 0 ? (Pair)this.whereVec.elementAt(this.whereVec.size() - 1) : new Pair(null, null);
                if (((Pair)object).getLeft() == IQueryPanel.COLUMN) {
                    ((Pair)object).setRight(string);
                } else {
                    int n2 = IQueryPanel.stateChange[this.currentState][0];
                    if (n2 == 0) {
                        return;
                    }
                    this.stateHistory.addElement(new Integer(this.currentState));
                    this.currentState = n2;
                    object = new Pair(IQueryPanel.COLUMN, string);
                    this.whereVec.addElement(object);
                }
                this.updateFromList();
                this.updateQueryField();
            }
        } else if (listSelectionEvent.getSource() == this.operatorList) {
            string = " " + (String)this.operatorList.getSelectedValue() + " ";
            object = null;
            object = this.whereVec.size() > 0 ? (Pair)this.whereVec.elementAt(this.whereVec.size() - 1) : new Pair(null, null);
            if (((Pair)object).getLeft() == IQueryPanel.OPERATOR) {
                ((Pair)object).setRight(string);
            } else {
                int n3 = IQueryPanel.stateChange[this.currentState][1];
                if (n3 == 0) {
                    return;
                }
                this.stateHistory.addElement(new Integer(this.currentState));
                this.currentState = n3;
                object = new Pair(IQueryPanel.OPERATOR, string);
                this.whereVec.addElement(object);
            }
            this.updateQueryField();
        }
    }
}

