/*
 * Decompiled with CFR 0.152.
 */
package ogi.cq.plugin.gui;

import com.sun.java.swing.BorderFactory;
import com.sun.java.swing.Box;
import com.sun.java.swing.BoxLayout;
import com.sun.java.swing.JButton;
import com.sun.java.swing.JPanel;
import com.sun.java.swing.JTextField;
import com.sun.java.swing.Timer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.util.Vector;
import ogi.cq.gui.Spinner;
import ogi.cq.log.CQLog;
import ogi.cq.plugin.CQServletPlugin;
import ogi.cq.plugin.NotInitializedException;
import ogi.cq.plugin.gui.BasePluginGUI;

public class PluginGUI
extends BasePluginGUI {
    private String servlet;
    public static final String DEFAULT_HOST = "129.95.40.15";
    public static final String DEFAULT_PORT = "10299";
    public static final String DEFAULT_SERVLET = "CQCluster";
    Timer updateTimer;

    public PluginGUI(String string, String string2, String string3) {
        this.server = string;
        this.port = string2;
        this.servlet = string3;
        this.init();
        ((Frame)((Object)this)).setTitle("CQ Plugin");
        this.setDefaultProperties();
    }

    public PluginGUI(String string, String string2, String string3, String string4, int n) {
        this.server = string;
        this.port = string2;
        this.servlet = string3;
        this.proxyHost = string4;
        this.proxyPort = n;
        this.init();
        ((Frame)((Object)this)).setTitle("CQ Plugin");
        this.setDefaultProperties();
    }

    public String getServlet() {
        return this.servlet;
    }

    public void init() {
        this.logger = new CQLog();
        this.logger.setDebug(BasePluginGUI.DEBUG);
        this.initGUI();
        this.logger.debug("finished GUI init");
        this.initPlugin();
        Vector vector = this.plugin.getSources();
        int n = -1;
        int n2 = 0;
        while (n2 < vector.size()) {
            if (vector.elementAt(n2).toString().equalsIgnoreCase("jtav")) {
                this.sourceComboBox.addItem((Object)vector.elementAt(n2).toString());
                n = n2;
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < vector.size()) {
            if (n2 != n) {
                this.sourceComboBox.addItem((Object)vector.elementAt(n2).toString());
            }
            ++n2;
        }
    }

    public void initGUI() {
        JPanel jPanel = (JPanel)this.getContentPane();
        jPanel.setLayout((LayoutManager)new BoxLayout((Container)jPanel, 1));
        jPanel.setBorder(BorderFactory.createEtchedBorder());
        jPanel.add((Component)this.getTitlePanel());
        jPanel.add(Box.createGlue());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new BoxLayout((Container)jPanel2, 1));
        jPanel.add((Component)jPanel2);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new BoxLayout((Container)jPanel3, 0));
        jPanel2.add((Component)jPanel3);
        this.statsButton = new JButton("System Status");
        this.statsButton.setBackground(Color.yellow);
        this.statsButton.addActionListener((ActionListener)this);
        jPanel3.add((Component)this.statsButton);
        this.traceButton = new JButton("Track CQ Execution");
        this.traceButton.setBackground(Color.yellow);
        this.traceButton.addActionListener((ActionListener)this);
        jPanel3.add((Component)this.traceButton);
        jPanel.add((Component)this.getCQPanel());
        jPanel.add((Component)this.getControlButtonPanel());
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new BoxLayout((Container)jPanel4, 0));
        jPanel.add((Component)jPanel4);
        this.helpButton = new JButton("Help");
        this.helpButton.setBackground(Color.green);
        this.helpButton.addActionListener((ActionListener)this);
        this.helpButton.setAlignmentY(0.5f);
        jPanel4.add((Component)this.helpButton);
        this.status = new JTextField("Status");
        this.status.setForeground(Color.blue);
        this.status.setBackground(Color.lightGray);
        this.status.setEditable(false);
        this.status.setAlignmentY(0.5f);
        jPanel4.add((Component)this.status);
        this.spinner = new Spinner();
        this.spinner.setAlignmentY(0.5f);
        jPanel4.add((Component)((Object)this.spinner));
    }

    public void initPlugin() {
        try {
            this.plugin = new CQServletPlugin();
            String[] stringArray = null;
            stringArray = this.proxyHost != null && this.proxyPort > 0 ? new String[5] : new String[]{this.getServer(), this.getPort(), this.getServlet()};
            if (this.proxyHost != null && this.proxyPort > 0) {
                stringArray[3] = this.getProxyHost();
                stringArray[4] = String.valueOf(this.getProxyPort());
            }
            this.plugin.initialize(stringArray);
            this.plugin.load(null);
        }
        catch (Exception exception) {
            throw new NotInitializedException(exception.toString());
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 0 || stringArray.length > 5 || stringArray.length == 4) {
            PluginGUI.usage();
            System.exit(1);
        }
        String string = DEFAULT_HOST;
        String string2 = DEFAULT_PORT;
        String string3 = DEFAULT_SERVLET;
        String string4 = null;
        int n = -1;
        if (stringArray.length > 0) {
            string = stringArray[0];
        }
        if (stringArray.length > 1) {
            string2 = stringArray[1];
        }
        if (stringArray.length > 2) {
            string3 = stringArray[2];
        }
        if (stringArray.length > 3) {
            string4 = stringArray[3];
        }
        if (stringArray.length > 4) {
            try {
                n = Integer.parseInt(stringArray[4]);
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println("error in parsing proxy port: " + numberFormatException);
            }
        }
        System.out.println("host: " + string);
        System.out.println("port: " + string2);
        System.out.println("servlet: " + string3);
        System.out.println("proxy: " + string4);
        System.out.println("ProxyPort: " + n);
        PluginGUI pluginGUI = null;
        pluginGUI = stringArray.length > 4 ? new PluginGUI(string, string2, string3, string4, n) : new PluginGUI(string, string2, string3);
        ((Window)((Object)pluginGUI)).pack();
        ((Component)((Object)pluginGUI)).setSize(640, 300);
        ((Component)((Object)pluginGUI)).setVisible(true);
    }

    public void setServlet(String string) {
        this.servlet = string;
    }

    public static void usage() {
        System.out.println("Usage: PluginGUI <host> <port> <Servlet> [<proxy host> <proxy port>]");
        System.out.println("Where <port> is the port of the Servlet interface");
        System.out.println("in which the cluster runs.");
        System.out.println("and <host> is the computer on which the cluster runs.");
        System.out.println("<Servlet> is the name of the servlet to connect to");
        System.out.println("");
        System.out.println("Examples:");
        System.out.println("host:    chinook.cse.ogi.edu");
        System.out.println("port:    10299");
        System.out.println("servlet: CQCluster");
        System.out.println("proxy host:    jambi.cse.ogi.edu");
        System.out.println("port:    6060");
    }
}

