/*
 * Decompiled with CFR 0.152.
 */
package ogi.cq.plugin.gui;

import com.sun.java.swing.BorderFactory;
import com.sun.java.swing.Box;
import com.sun.java.swing.BoxLayout;
import com.sun.java.swing.JApplet;
import com.sun.java.swing.JButton;
import com.sun.java.swing.JFrame;
import com.sun.java.swing.JLabel;
import com.sun.java.swing.JPanel;
import com.sun.java.swing.JPasswordField;
import com.sun.java.swing.JScrollPane;
import com.sun.java.swing.JTextArea;
import com.sun.java.swing.JTextField;
import com.sun.java.swing.SwingUtilities;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import ogi.cq.gui.Spinner;
import ogi.cq.log.CQLog;
import ogi.cq.log.Log;
import ogi.cq.plugin.CQServletPlugin;
import ogi.cq.plugin.IContinualQueryPlugin;
import ogi.cq.plugin.NotInitializedException;
import ogi.cq.plugin.gui.JTAVExamples;
import ogi.cq.plugin.gui.PluginCQManager;
import ogi.cq.plugin.gui.StatFrame;

public class PluginApplet
extends JApplet
implements ActionListener {
    public static boolean DEBUG = true;
    protected Log logger;
    IContinualQueryPlugin plugin;
    StatFrame stats;
    JButton connectButton;
    JButton statsButton;
    JButton traceButton;
    JButton cqButton;
    JButton helpButton;
    JButton closeButton;
    JFrame help;
    JTextField serverField;
    JTextField portField;
    JTextField userField;
    JPasswordField passwordField;
    private String server;
    private String port;
    private String servlet;
    JButton browseCQButton;
    JButton registerButton;
    JButton queryButton;
    JButton cqHomeButton;
    JTextField status;
    Spinner spinner;
    boolean showExecutionHistory;
    public static final String NEW_LINE = System.getProperty("line.separator");
    public static final String browseCQURL = "http://129.95.40.15:8080/OpenCQ/html/browseCQ.html";
    public static final String registerURL = "http://129.95.40.15:8080/OpenCQ/html/register.html";
    public static final String queryURL = "http://129.95.40.15:8080/OpenCQ/html/jtav/query.html";
    public static final String cqHomeURL = "http://www.cse.ogi.edu/DISC/CQ/";
    public static final String SOURCE = "jtav";

    public void actionPerformed(ActionEvent actionEvent) {
        Thread thread;
        Object object;
        if (actionEvent.getSource() == this.connectButton) {
            this.initPlugin();
            this.connectButton.setEnabled(false);
            this.cqButton.setEnabled(true);
            this.statsButton.setEnabled(true);
        } else if (actionEvent.getSource() == this.helpButton) {
            this.getHelp().setVisible(true);
        } else if (actionEvent.getSource() == this.closeButton) {
            this.help.setVisible(false);
        } else if (actionEvent.getSource() == this.cqButton) {
            if (this.userField.getText().trim().equals("")) {
                this.status.setText("MUST set User ID to install CQ");
                return;
            }
            if (this.passwordField.getText().trim().equals("")) {
                this.status.setText("MUST set password to install CQ");
                return;
            }
            this.status.setText("Validating User");
            this.spinner.startSpinning();
            object = new Runnable(this){
                /* synthetic */ PluginApplet this$0;

                public void run() {
                    PluginApplet.access$newQuery(this.this$0);
                }
                {
                    this.this$0 = pluginApplet;
                }
            };
            thread = new Thread((Runnable)object);
            thread.start();
        }
        if (actionEvent.getSource() == this.statsButton) {
            if (this.stats == null) {
                this.statsButton.setEnabled(false);
                this.traceButton.setEnabled(false);
                this.status.setText("Retrieving statistics");
                this.spinner.startSpinning();
                object = new Runnable(this){
                    /* synthetic */ PluginApplet this$0;

                    public void run() {
                        this.this$0.initStats();
                    }
                    {
                        this.this$0 = pluginApplet;
                    }
                };
                thread = new Thread((Runnable)object);
                thread.start();
                this.showExecutionHistory = false;
                return;
            }
            ((Window)((Object)this.stats)).show();
            this.stats.showCurrentStats();
        }
        if (actionEvent.getSource() == this.traceButton) {
            if (this.stats == null) {
                this.statsButton.setEnabled(false);
                this.traceButton.setEnabled(false);
                this.status.setText("Retrieving statistics");
                this.spinner.startSpinning();
                object = new Runnable(this){
                    /* synthetic */ PluginApplet this$0;

                    public void run() {
                        this.this$0.initStats();
                    }
                    {
                        this.this$0 = pluginApplet;
                    }
                };
                thread = new Thread((Runnable)object);
                thread.start();
                this.showExecutionHistory = true;
                return;
            }
            ((Window)((Object)this.stats)).show();
            this.stats.showExecutionHistory();
        }
        if (actionEvent.getSource() == this.browseCQButton) {
            try {
                object = new URL(browseCQURL);
                ((Applet)((Object)this)).getAppletContext().showDocument((URL)object, "_bottom");
            }
            catch (Exception exception) {
                System.out.println("Error in showing external doc: " + exception);
            }
        }
        if (actionEvent.getSource() == this.registerButton) {
            try {
                object = new URL(registerURL);
                ((Applet)((Object)this)).getAppletContext().showDocument((URL)object, "_bottom");
            }
            catch (Exception exception) {
                System.out.println("Error in showing external doc: " + exception);
            }
        }
        if (actionEvent.getSource() == this.queryButton) {
            try {
                object = new URL(queryURL);
                ((Applet)((Object)this)).getAppletContext().showDocument((URL)object, "_bottom");
            }
            catch (Exception exception) {
                System.out.println("Error in showing external doc: " + exception);
            }
        }
        if (actionEvent.getSource() == this.cqHomeButton) {
            try {
                object = new URL(cqHomeURL);
                ((Applet)((Object)this)).getAppletContext().showDocument((URL)object, "_bottom");
            }
            catch (Exception exception) {
                System.out.println("Error in showing external doc: " + exception);
            }
        }
    }

    public JFrame getHelp() {
        if (this.help == null) {
            String string = "Help -- CQ_JTAV Plugin Applet";
            this.help = new JFrame(string);
            JPanel jPanel = (JPanel)this.help.getContentPane();
            jPanel.setLayout(new BorderLayout());
            Font font = new Font("timesRoman", 1, 20);
            JLabel jLabel = new JLabel(string);
            jLabel.setFont(font);
            jLabel.setForeground(Color.blue);
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new FlowLayout());
            jPanel2.add((Component)jLabel);
            jPanel.add("North", (Component)jPanel2);
            JTextArea jTextArea = new JTextArea();
            jTextArea.setBackground(Color.lightGray);
            jTextArea.setEditable(false);
            jTextArea.append("You can install a continual query with the default ");
            jTextArea.append("user name and password, however, if you wish ");
            jTextArea.append("to receive notifications of updates, you must first register and log in with your ");
            jTextArea.append("own CQ System userid.");
            jTextArea.append(NEW_LINE);
            jTextArea.append(NEW_LINE);
            jTextArea.append("System Status");
            jTextArea.append(NEW_LINE);
            jTextArea.append("To view the current CQ system status, click the 'System Status' button. ");
            jTextArea.append("This will display the current number of CQ's in the system, and a list of the active CQ's");
            jTextArea.append(NEW_LINE);
            jTextArea.append(NEW_LINE);
            jTextArea.append("Track CQ Execution");
            jTextArea.append(NEW_LINE);
            jTextArea.append("The history statistics of the CQ system are available via the 'Track CQ Execution' button. ");
            jTextArea.append("This shows graphs depicting the CQ load history");
            jTextArea.append(NEW_LINE);
            jTextArea.append(NEW_LINE);
            jTextArea.append("Install a new CQ");
            jTextArea.append(NEW_LINE);
            jTextArea.append("To install a new CQ, click the 'Install a new CQ' button. ");
            jTextArea.append("This will display a screen that allows you to enter a query and trigger; alternatively, the user interface ");
            jTextArea.append("allows you to directly type in the query and trigger definition. ");
            jTextArea.append(NEW_LINE);
            jTextArea.append(NEW_LINE);
            jTextArea.append("Register");
            jTextArea.append(NEW_LINE);
            jTextArea.append("To register, simply click the register button on the applet.  Fill in the HTML form ");
            jTextArea.append("and submit it.  ");
            jTextArea.append("That is it.  You will then be registered -- you can install CQ\u2019s and ");
            jTextArea.append("receive notifications for the updates you specify.");
            jTextArea.append(NEW_LINE);
            jTextArea.append(NEW_LINE);
            jTextArea.append("Browse CQ's");
            jTextArea.append(NEW_LINE);
            jTextArea.append("Click the 'Browse CQ' button to view the raw definition of the CQ's you have access to. This will take you to an HTML ");
            jTextArea.append("page that displays all of your CQ's in a table. ");
            jTextArea.append(NEW_LINE);
            jTextArea.append("Alternatively, you can view an individual CQ definition from the statistics screen. ");
            jTextArea.append("Click on an individual CQ from the list shown and press ");
            jTextArea.append("the View CQ Definition button.  This will display the selected CQ in a form. ");
            jTextArea.append(NEW_LINE);
            jTextArea.append(NEW_LINE);
            jTextArea.append("Query");
            jTextArea.append(NEW_LINE);
            jTextArea.append("If you just want to query the data and not install a CQ, click the Query button ");
            jTextArea.append(NEW_LINE);
            jTextArea.append(NEW_LINE);
            jTextArea.append("CQ Home");
            jTextArea.append(NEW_LINE);
            jTextArea.append("Return to the CQ Home page by pressing the CQ Home button. ");
            jTextArea.setLineWrap(true);
            jTextArea.setWrapStyleWord(true);
            JScrollPane jScrollPane = new JScrollPane((Component)jTextArea);
            jScrollPane.setVerticalScrollBarPolicy(22);
            jScrollPane.setHorizontalScrollBarPolicy(31);
            jScrollPane.setPreferredSize(new Dimension(250, 250));
            jPanel.add("Center", (Component)jScrollPane);
            Font font2 = new Font("timesRoman", 0, 15);
            jTextArea.setFont(font2);
            JPanel jPanel3 = new JPanel();
            jPanel3.setLayout(new FlowLayout());
            this.closeButton = new JButton("Close");
            this.closeButton.setBackground(Color.red);
            this.closeButton.addActionListener((ActionListener)this);
            jPanel3.add((Component)this.closeButton);
            jPanel.add("South", (Component)jPanel3);
            this.help.setSize(640, 480);
        }
        return this.help;
    }

    private String getPassword() {
        return this.passwordField.getText();
    }

    public String getPort() {
        if (this.port == null) {
            this.port = ((Applet)((Object)this)).getParameter("port");
        }
        return this.port;
    }

    public String getServer() {
        if (this.server == null) {
            this.server = ((Applet)((Object)this)).getParameter("server");
        }
        return this.server;
    }

    public String getServlet() {
        if (this.servlet == null) {
            this.servlet = ((Applet)((Object)this)).getParameter("servlet");
        }
        return this.servlet;
    }

    private String getUser() {
        return this.userField.getText();
    }

    public void init() {
        this.logger = new CQLog();
        this.logger.setDebug(DEBUG);
        this.initGUI();
        this.logger.debug("finished GUI init");
        this.initPlugin();
    }

    public void initGUI() {
        JPanel jPanel = (JPanel)this.getContentPane();
        jPanel.setLayout((LayoutManager)new BoxLayout((Container)jPanel, 1));
        jPanel.setBorder(BorderFactory.createEtchedBorder());
        jPanel.add(Box.createGlue());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new BoxLayout((Container)jPanel2, 1));
        jPanel.add((Component)jPanel2);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new BoxLayout((Container)jPanel3, 0));
        jPanel2.add((Component)jPanel3);
        this.statsButton = new JButton("System Status");
        this.statsButton.setBackground(Color.yellow);
        this.statsButton.addActionListener((ActionListener)this);
        jPanel3.add((Component)this.statsButton);
        this.traceButton = new JButton("Track CQ Execution");
        this.traceButton.setBackground(Color.yellow);
        this.traceButton.addActionListener((ActionListener)this);
        jPanel3.add((Component)this.traceButton);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new BoxLayout((Container)jPanel4, 0));
        jPanel2.add((Component)jPanel4);
        this.cqButton = new JButton("Install a new CQ");
        this.cqButton.setBackground(Color.orange);
        this.cqButton.addActionListener((ActionListener)this);
        jPanel4.add(Box.createHorizontalGlue());
        jPanel4.add((Component)this.cqButton);
        jPanel4.add(Box.createHorizontalGlue());
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new BoxLayout((Container)jPanel5, 0));
        jPanel.add(Box.createRigidArea((Dimension)new Dimension(0, 5)));
        jPanel.add((Component)jPanel5);
        jPanel.add(Box.createRigidArea((Dimension)new Dimension(0, 5)));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new GridLayout(2, 1));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new GridLayout(2, 1));
        JLabel jLabel = new JLabel("User ID: ");
        jPanel6.add((Component)jLabel);
        this.userField = new JTextField("DemoUser", 20);
        jPanel7.add((Component)this.userField);
        jPanel5.add(Box.createRigidArea((Dimension)new Dimension(50, 5)));
        jPanel5.add(Box.createHorizontalGlue());
        jPanel5.add((Component)jPanel6);
        jPanel5.add((Component)jPanel7);
        jPanel5.add(Box.createHorizontalGlue());
        jPanel5.add(Box.createRigidArea((Dimension)new Dimension(150, 5)));
        JLabel jLabel2 = new JLabel("Password: ");
        jPanel6.add((Component)jLabel2);
        this.passwordField = new JPasswordField("demouser");
        jPanel7.add((Component)this.passwordField);
        jPanel.add(Box.createVerticalGlue());
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new BoxLayout((Container)jPanel8, 0));
        this.registerButton = new JButton("Register");
        this.registerButton.addActionListener((ActionListener)this);
        jPanel8.add(Box.createHorizontalGlue());
        jPanel8.add((Component)this.registerButton);
        jPanel8.add(Box.createHorizontalGlue());
        this.browseCQButton = new JButton("Browse CQ's");
        this.browseCQButton.addActionListener((ActionListener)this);
        jPanel8.add((Component)this.browseCQButton);
        jPanel8.add(Box.createHorizontalGlue());
        this.queryButton = new JButton("Query");
        this.queryButton.addActionListener((ActionListener)this);
        jPanel8.add((Component)this.queryButton);
        jPanel8.add(Box.createHorizontalGlue());
        this.cqHomeButton = new JButton("CQ Home");
        this.cqHomeButton.addActionListener((ActionListener)this);
        jPanel8.add((Component)this.cqHomeButton);
        jPanel8.add(Box.createHorizontalGlue());
        jPanel.add((Component)jPanel8);
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout((LayoutManager)new BoxLayout((Container)jPanel9, 0));
        jPanel.add((Component)jPanel9);
        this.helpButton = new JButton("Help");
        this.helpButton.setBackground(Color.green);
        this.helpButton.addActionListener((ActionListener)this);
        this.helpButton.setAlignmentY(0.5f);
        jPanel9.add((Component)this.helpButton);
        this.status = new JTextField("Status");
        this.status.setForeground(Color.blue);
        this.status.setBackground(Color.lightGray);
        this.status.setEditable(false);
        this.status.setAlignmentY(0.5f);
        jPanel9.add((Component)this.status);
        this.spinner = new Spinner();
        this.spinner.setAlignmentY(0.5f);
        jPanel9.add((Component)((Object)this.spinner));
    }

    public void initPlugin() {
        try {
            this.plugin = new CQServletPlugin();
            String[] stringArray = new String[]{this.getServer(), this.getPort(), this.getServlet()};
            this.plugin.initialize(stringArray);
            this.plugin.load(null);
        }
        catch (Exception exception) {
            throw new NotInitializedException(exception.toString());
        }
    }

    public synchronized void initStats() {
        this.stats = new StatFrame(this.plugin, this.logger, "CQ System statistics");
        ((Window)((Object)this.stats)).pack();
        if (((Component)((Object)this.stats)).getSize().height < 480) {
            ((Component)((Object)this.stats)).setSize(new Dimension(Math.max(((Component)((Object)this.stats)).getSize().width, 640), 480));
        }
        if (this.showExecutionHistory) {
            this.stats.showExecutionHistory();
        } else {
            this.stats.showCurrentStats();
        }
        ((Window)((Object)this.stats)).show();
        this.spinner.stopSpinning();
        this.reset();
    }

    public void invalidUser() {
        Runnable runnable = new Runnable(this){
            /* synthetic */ PluginApplet this$0;

            public void run() {
                PluginApplet.access$invalidUser0(this.this$0);
            }
            {
                this.this$0 = pluginApplet;
            }
        };
        SwingUtilities.invokeLater((Runnable)runnable);
    }

    private void invalidUser0() {
        this.reset0();
        this.status.setText("User name/password is invalid");
        this.spinner.stopSpinning();
    }

    public static void main(String[] stringArray) {
        PluginApplet pluginApplet = new PluginApplet();
        JFrame jFrame = new JFrame();
        jFrame.getContentPane().add((Component)((Object)pluginApplet));
        jFrame.pack();
        jFrame.setSize(640, 480);
        jFrame.setVisible(true);
    }

    private void newQuery() {
        if (this.plugin.validateUser(this.getUser(), this.getPassword())) {
            Runnable runnable = new Runnable(this){
                /* synthetic */ PluginApplet this$0;

                public void run() {
                    this.this$0.status.setText("Initializing new CQ installation");
                }
                {
                    this.this$0 = pluginApplet;
                }
            };
            SwingUtilities.invokeLater((Runnable)runnable);
            PluginCQManager pluginCQManager = new PluginCQManager(this.plugin, SOURCE, new JTAVExamples(), this.logger);
            pluginCQManager.setApplet(this);
            pluginCQManager.begin(SOURCE, this.getUser(), this.getPassword());
            this.spinner.stopSpinning();
            this.reset();
        } else {
            this.invalidUser();
        }
    }

    public void reset() {
        Runnable runnable = new Runnable(this){
            /* synthetic */ PluginApplet this$0;

            public void run() {
                PluginApplet.access$reset0(this.this$0);
            }
            {
                this.this$0 = pluginApplet;
            }
        };
        SwingUtilities.invokeLater((Runnable)runnable);
    }

    private void reset0() {
        this.status.setText("");
        this.browseCQButton.setEnabled(true);
        this.registerButton.setEnabled(true);
        this.queryButton.setEnabled(true);
        this.cqHomeButton.setEnabled(true);
        this.statsButton.setEnabled(true);
        this.traceButton.setEnabled(true);
        this.cqButton.setEnabled(true);
    }

    static void access$reset0(PluginApplet pluginApplet) {
        pluginApplet.reset0();
    }

    static void access$newQuery(PluginApplet pluginApplet) {
        pluginApplet.newQuery();
    }

    static void access$invalidUser0(PluginApplet pluginApplet) {
        pluginApplet.invalidUser0();
    }
}

