/*
 * Decompiled with CFR 0.152.
 */
package ogi.cq.plugin.gui;

import com.sun.java.swing.AbstractButton;
import com.sun.java.swing.BorderFactory;
import com.sun.java.swing.Box;
import com.sun.java.swing.BoxLayout;
import com.sun.java.swing.ButtonGroup;
import com.sun.java.swing.JButton;
import com.sun.java.swing.JCheckBox;
import com.sun.java.swing.JComboBox;
import com.sun.java.swing.JLabel;
import com.sun.java.swing.JPanel;
import com.sun.java.swing.JScrollPane;
import com.sun.java.swing.JTable;
import com.sun.java.swing.JTextField;
import com.sun.java.swing.event.ListSelectionEvent;
import com.sun.java.swing.event.ListSelectionListener;
import com.sun.java.swing.event.TableModelListener;
import com.sun.java.swing.table.DefaultTableModel;
import com.sun.java.swing.table.TableModel;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.Vector;
import ogi.cq.gui.GenericStatePanel;
import ogi.cq.gui.ManagerState;
import ogi.cq.log.Log;
import ogi.cq.plugin.gui.TableSorter;

public class NotifyPanel
extends GenericStatePanel
implements ActionListener,
ListSelectionListener {
    private Log logger;
    private ManagerState manager;
    JPanel frequencyPanel;
    JPanel emailPanel;
    JPanel cardPanel;
    JPanel externalPanel;
    JCheckBox everyTriggerCheck;
    JCheckBox multipleTriggerCheck;
    JTextField countField;
    JCheckBox periodicCheck;
    JTextField unitNumberField;
    JComboBox unitChoice;
    JCheckBox emailCheck;
    JCheckBox externalCheck;
    ButtonGroup methodGroup;
    JTextField urlField;
    JTextField nameField;
    JTextField valueField;
    JButton addButton;
    JButton removeButton;
    JTable paramList;
    DefaultTableModel tableModel;
    TableSorter tableSorter;
    boolean inExample = false;
    String notifyConfigString;
    Vector emailComponents;
    Vector externalComponents;
    public static final String[] units = new String[]{"Hour(s)", "Day(s)", "Week(s)", "Month(s)"};
    public static final int NAME = 0;
    public static final int VALUE = 1;

    public NotifyPanel(ManagerState managerState, Log log) {
        this(managerState, log, null, null);
    }

    public NotifyPanel(ManagerState managerState, Log log, Color color, Font font) {
        this.manager = managerState;
        this.logger = log;
        this.backgroundColor = color;
        this.localFont = font;
        this.emailComponents = new Vector();
        this.externalComponents = new Vector();
        this.init();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.emailCheck) {
            this.emailCheckbox_Clicked();
        } else if (actionEvent.getSource() == this.externalCheck) {
            this.externalCheckbox_Clicked();
        } else if (actionEvent.getSource() == this.addButton) {
            String string = this.nameField.getText();
            String string2 = this.valueField.getText();
            if (string != null && !string.trim().equals("") && string2 != null && !string2.trim().equals("")) {
                Object[] objectArray = new Object[]{string, string2};
                this.tableModel.addRow(objectArray);
            }
            this.tableSorter.setModel((TableModel)this.tableModel);
            this.paramList.repaint();
        } else if (actionEvent.getSource() == this.removeButton) {
            int n = this.paramList.getSelectedRow();
            if (n < 0) {
                return;
            }
            n = this.tableSorter.translateIndex(n);
            this.tableModel.removeRow(n);
            this.tableSorter.setModel((TableModel)this.tableModel);
            this.paramList.repaint();
        }
    }

    void emailCheckbox_Clicked() {
        ((CardLayout)this.getCardPanel().getLayout()).first((Container)this.getCardPanel());
    }

    void externalCheckbox_Clicked() {
        ((CardLayout)this.getCardPanel().getLayout()).last((Container)this.getCardPanel());
    }

    private JPanel getCardPanel() {
        if (this.cardPanel == null) {
            this.cardPanel = new JPanel();
            this.cardPanel.setLayout(new CardLayout());
            this.cardPanel.setBackground(this.backgroundColor);
            this.cardPanel.add((Component)new JPanel(), "blank");
            this.cardPanel.add((Component)this.getExternalPanel(), "External");
        }
        return this.cardPanel;
    }

    private JPanel getEmailPanel() {
        if (this.emailPanel == null) {
            this.emailPanel = new JPanel();
            this.emailPanel.setLayout((LayoutManager)new BoxLayout((Container)this.emailPanel, 0));
            this.emailPanel.setBackground(this.backgroundColor);
            this.emailComponents.addElement(this.emailPanel);
            this.emailCheck = new JCheckBox("Email");
            this.emailCheck.setSelected(true);
            this.methodGroup.add((AbstractButton)this.emailCheck);
            this.emailCheck.addActionListener((ActionListener)this);
            this.emailPanel.add((Component)this.emailCheck);
            this.emailPanel.add(Box.createHorizontalGlue());
            this.externalCheck = new JCheckBox("External");
            this.methodGroup.add((AbstractButton)this.externalCheck);
            this.externalCheck.setAlignmentY(0.5f);
            this.externalCheck.addActionListener((ActionListener)this);
            this.emailPanel.add((Component)this.externalCheck);
            this.emailPanel.add(Box.createHorizontalGlue());
        }
        return this.emailPanel;
    }

    private JPanel getExternalPanel() {
        if (this.externalPanel == null) {
            this.externalPanel = new JPanel();
            this.externalPanel.setLayout((LayoutManager)new BoxLayout((Container)this.externalPanel, 1));
            this.externalPanel.setBackground(this.backgroundColor);
            this.externalComponents.addElement(this.externalPanel);
            JPanel jPanel = new JPanel();
            jPanel.setLayout((LayoutManager)new BoxLayout((Container)jPanel, 0));
            this.externalPanel.add((Component)jPanel);
            this.externalComponents.addElement(jPanel);
            JLabel jLabel = new JLabel("URL: ");
            jLabel.setAlignmentY(0.5f);
            jPanel.add((Component)jLabel);
            this.urlField = new JTextField("", 40);
            this.urlField.setAlignmentY(0.5f);
            jPanel.add((Component)this.urlField);
            jPanel.add(Box.createHorizontalGlue());
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout((LayoutManager)new BoxLayout((Container)jPanel2, 0));
            this.externalPanel.add((Component)jPanel2);
            this.externalComponents.addElement(jPanel2);
            JLabel jLabel2 = new JLabel("Parameters: ");
            jLabel2.setAlignmentY(0.5f);
            jLabel2.setAlignmentX(0.0f);
            jPanel2.add((Component)jLabel2);
            jPanel2.add(Box.createHorizontalGlue());
            JPanel jPanel3 = new JPanel();
            jPanel3.setLayout((LayoutManager)new BoxLayout((Container)jPanel3, 0));
            this.externalPanel.add((Component)jPanel3);
            this.externalComponents.addElement(jPanel3);
            JPanel jPanel4 = new JPanel();
            this.externalComponents.addElement(jPanel4);
            jPanel4.setLayout(new FlowLayout());
            jPanel3.add((Component)jPanel4);
            JLabel jLabel3 = new JLabel("Name: ");
            jPanel4.add((Component)jLabel3);
            this.nameField = new JTextField("", 20);
            jPanel4.add((Component)this.nameField);
            JPanel jPanel5 = new JPanel();
            this.externalComponents.addElement(jPanel5);
            jPanel5.setLayout(new FlowLayout());
            jPanel3.add((Component)jPanel5);
            JLabel jLabel4 = new JLabel("Value: ");
            jPanel5.add((Component)jLabel4);
            this.valueField = new JTextField("", 20);
            jPanel5.add((Component)this.valueField);
            this.addButton = new JButton("Add");
            this.addButton.setAlignmentY(0.5f);
            this.addButton.setBackground(Color.green);
            this.addButton.addActionListener((ActionListener)this);
            jPanel3.add(Box.createHorizontalGlue());
            jPanel3.add((Component)this.addButton);
            jPanel3.add(Box.createHorizontalGlue());
            JPanel jPanel6 = new JPanel();
            jPanel6.setLayout((LayoutManager)new BoxLayout((Container)jPanel6, 0));
            this.externalPanel.add((Component)jPanel6);
            this.externalComponents.addElement(jPanel6);
            this.tableModel = new DefaultTableModel();
            this.tableModel.addColumn((Object)"Name", new Vector());
            this.tableModel.addColumn((Object)"Value", new Vector());
            this.tableSorter = new TableSorter((TableModel)this.tableModel);
            this.paramList = new JTable((TableModel)this.tableSorter);
            this.tableSorter.addMouseListenerToHeaderInTable(this.paramList);
            this.tableModel.addTableModelListener((TableModelListener)this.paramList);
            this.tableSorter.addTableModelListener((TableModelListener)this.paramList);
            this.paramList.setBackground(Color.white);
            this.paramList.setForeground(Color.black);
            this.paramList.setSelectionMode(0);
            this.paramList.setShowVerticalLines(true);
            this.paramList.setShowHorizontalLines(true);
            this.paramList.getSelectionModel().addListSelectionListener((ListSelectionListener)this);
            JScrollPane jScrollPane = new JScrollPane((Component)this.paramList);
            jScrollPane.setBorder(BorderFactory.createEtchedBorder());
            jScrollPane.setAlignmentY(0.0f);
            jScrollPane.setVerticalScrollBarPolicy(22);
            jScrollPane.setPreferredSize(new Dimension(700, 100));
            jPanel6.add((Component)jScrollPane);
            jPanel6.add(Box.createHorizontalGlue());
            this.removeButton = new JButton("Remove");
            this.removeButton.setBackground(Color.yellow);
            this.removeButton.addActionListener((ActionListener)this);
            this.removeButton.setAlignmentY(0.0f);
            jPanel6.add((Component)this.removeButton);
            jPanel6.add(Box.createHorizontalGlue());
        }
        return this.externalPanel;
    }

    private JPanel getFrequencyPanel() {
        if (this.frequencyPanel == null) {
            this.frequencyPanel = new JPanel();
            this.frequencyPanel.setLayout((LayoutManager)new BoxLayout((Container)this.frequencyPanel, 1));
            this.frequencyPanel.setBorder(BorderFactory.createEtchedBorder());
            this.frequencyPanel.setBackground(this.backgroundColor);
            this.frequencyPanel.setAlignmentY(0.5f);
            this.frequencyPanel.setAlignmentX(0.0f);
            ButtonGroup buttonGroup = new ButtonGroup();
            this.everyTriggerCheck = new JCheckBox("Same as Trigger Condition");
            this.everyTriggerCheck.setAlignmentY(0.5f);
            this.everyTriggerCheck.setAlignmentX(0.0f);
            this.everyTriggerCheck.setSelected(true);
            buttonGroup.add((AbstractButton)this.everyTriggerCheck);
            this.frequencyPanel.add((Component)this.everyTriggerCheck);
            JPanel jPanel = new JPanel();
            jPanel.setLayout((LayoutManager)new BoxLayout((Container)jPanel, 0));
            jPanel.setBackground(this.backgroundColor);
            jPanel.setAlignmentY(0.5f);
            jPanel.setAlignmentX(0.0f);
            this.frequencyPanel.add((Component)jPanel);
            this.multipleTriggerCheck = new JCheckBox("Every");
            this.multipleTriggerCheck.setAlignmentY(0.5f);
            this.multipleTriggerCheck.setAlignmentX(0.0f);
            buttonGroup.add((AbstractButton)this.multipleTriggerCheck);
            jPanel.add((Component)this.multipleTriggerCheck);
            this.countField = new JTextField("1", 2);
            this.countField.setAlignmentY(0.5f);
            this.countField.setAlignmentX(0.0f);
            this.countField.setMaximumSize(new Dimension(this.countField.getMaximumSize().width, this.countField.getFontMetrics(this.countField.getFont()).getHeight() * 2));
            jPanel.add((Component)this.countField);
            JLabel jLabel = new JLabel(" tests of trigger.  ");
            jLabel.setForeground(Color.black);
            jLabel.setAlignmentY(0.5f);
            jLabel.setAlignmentX(0.0f);
            jPanel.add((Component)jLabel);
            jPanel.add(Box.createHorizontalGlue());
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout((LayoutManager)new BoxLayout((Container)jPanel2, 0));
            jPanel2.setBackground(this.backgroundColor);
            jPanel2.setAlignmentY(0.5f);
            jPanel2.setAlignmentX(0.0f);
            this.frequencyPanel.add((Component)jPanel2);
            this.periodicCheck = new JCheckBox("Every");
            this.periodicCheck.setAlignmentY(0.5f);
            this.periodicCheck.setAlignmentX(0.0f);
            buttonGroup.add((AbstractButton)this.periodicCheck);
            jPanel2.add((Component)this.periodicCheck);
            this.unitNumberField = new JTextField("2", 2);
            this.unitNumberField.setMaximumSize(new Dimension(this.unitNumberField.getMaximumSize().width, this.unitNumberField.getFontMetrics(this.unitNumberField.getFont()).getHeight() * 2));
            this.unitNumberField.setAlignmentY(0.5f);
            this.unitNumberField.setAlignmentX(0.0f);
            jPanel2.add((Component)this.unitNumberField);
            this.unitChoice = new JComboBox();
            this.unitChoice.setAlignmentY(0.5f);
            this.unitChoice.setAlignmentX(0.0f);
            this.unitChoice.setFont(this.localFont);
            this.unitChoice.setBackground(Color.white);
            this.unitChoice.setForeground(Color.blue);
            this.unitChoice.addItem((Object)"Choose time period");
            this.unitChoice.addItem((Object)"hour(s)");
            this.unitChoice.addItem((Object)"day(s)");
            this.unitChoice.addItem((Object)"week(s)");
            this.unitChoice.addItem((Object)"month(s)");
            this.unitChoice.addItem((Object)"year(s)");
            try {
                this.unitChoice.setSelectedIndex(3);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
            jPanel2.add((Component)this.unitChoice);
            jPanel2.add(Box.createHorizontalGlue());
        }
        return this.frequencyPanel;
    }

    public String getNotifyConfig() {
        if (this.externalCheck.isSelected()) {
            if (!this.inExample) {
                URL uRL = null;
                try {
                    uRL = new URL(this.urlField.getText());
                }
                catch (Exception exception) {
                    this.manager.setStatus("Error in URL; please re-enter");
                    return "";
                }
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("<NCONF USECQ=1>\n");
                stringBuffer.append("  <MODE URL=");
                stringBuffer.append("\"");
                stringBuffer.append(uRL.toString());
                stringBuffer.append("\"");
                stringBuffer.append(" CALL=\"POST\"");
                stringBuffer.append(" SUCCESS=\"done\"> ");
                stringBuffer.append("EXTERNAL\n");
                stringBuffer.append("  </MODE>");
                stringBuffer.append("\n");
                stringBuffer.append("  <PARAMETER>\n");
                int n = this.tableModel.getRowCount();
                int n2 = 0;
                while (n2 < n) {
                    String string = (String)this.tableModel.getValueAt(n2, 0);
                    String string2 = (String)this.tableModel.getValueAt(n2, 1);
                    stringBuffer.append("\n      <PARAM name=");
                    stringBuffer.append(string);
                    stringBuffer.append(">\n");
                    stringBuffer.append(string2);
                    stringBuffer.append("\n      </PARAM>\n");
                    ++n2;
                }
                stringBuffer.append("  </PARAMETER>");
                stringBuffer.append("</NCONF>\t\t\t");
                return stringBuffer.toString();
            }
            return this.notifyConfigString;
        }
        return "";
    }

    public String getTitle() {
        return "Specify Notification condition";
    }

    protected void init() {
        try {
            if (this.localFont == null) {
                this.localFont = new Font("timesRoman", 0, 14);
            }
            if (this.backgroundColor == null) {
                this.backgroundColor = Color.lightGray;
            }
            ((Container)((Object)this)).setLayout((LayoutManager)new BoxLayout((Container)((Object)this), 1));
            this.setBackground(this.backgroundColor);
            this.titleLabel = new JLabel(this.getTitle());
            this.titleLabel.setForeground(Color.black);
            Font font = new Font("timesRoman", 1, 20);
            this.titleLabel.setFont(font);
            JPanel jPanel = new JPanel();
            jPanel.setLayout((LayoutManager)new BoxLayout((Container)jPanel, 0));
            jPanel.add(Box.createHorizontalGlue());
            jPanel.add((Component)this.titleLabel);
            jPanel.add(Box.createHorizontalGlue());
            ((Container)((Object)this)).add((Component)jPanel);
            this.methodGroup = new ButtonGroup();
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout((LayoutManager)new BoxLayout((Container)jPanel2, 0));
            jPanel2.add((Component)new JLabel("Frequency"));
            jPanel2.add(Box.createHorizontalGlue());
            jPanel2.setBackground(new Color(253, 253, 180));
            ((Container)((Object)this)).add((Component)jPanel2);
            JPanel jPanel3 = new JPanel();
            jPanel3.setLayout(new BorderLayout());
            jPanel3.add("Center", (Component)this.getFrequencyPanel());
            ((Container)((Object)this)).add((Component)jPanel3);
            ((Container)((Object)this)).add(Box.createRigidArea((Dimension)new Dimension(0, 25)));
            ((Container)((Object)this)).add(Box.createVerticalGlue());
            JPanel jPanel4 = new JPanel();
            jPanel4.setLayout((LayoutManager)new BoxLayout((Container)jPanel4, 0));
            jPanel4.add((Component)new JLabel("Method"));
            jPanel4.setBackground(new Color(253, 253, 180));
            jPanel4.add(Box.createHorizontalGlue());
            ((Container)((Object)this)).add((Component)jPanel4);
            ((Container)((Object)this)).add((Component)this.getEmailPanel());
            ((Container)((Object)this)).add((Component)this.getCardPanel());
        }
        catch (Exception exception) {
            System.out.println("CQStateNotify error: " + exception);
        }
    }

    public void reset() {
        this.emailCheckbox_Clicked();
        this.countField.setText("1");
        this.unitNumberField.setText("1");
        this.unitChoice.setSelectedIndex(0);
    }

    public void setExample(Object[] objectArray) {
        String string = (String)objectArray[16];
        this.setNotifyConfig(string);
    }

    public void setLocalFont(Font font) {
        if (font == null) {
            return;
        }
        super.setFont(font);
    }

    public void setNotifyConfig(String string) {
        this.notifyConfigString = string;
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
    }
}

