/*
 * Decompiled with CFR 0.152.
 */
package ogi.cq.plugin.gui;

import com.sun.java.swing.BorderFactory;
import com.sun.java.swing.Box;
import com.sun.java.swing.BoxLayout;
import com.sun.java.swing.JButton;
import com.sun.java.swing.JComboBox;
import com.sun.java.swing.JFrame;
import com.sun.java.swing.JLabel;
import com.sun.java.swing.JPanel;
import com.sun.java.swing.JPasswordField;
import com.sun.java.swing.JScrollPane;
import com.sun.java.swing.JTextArea;
import com.sun.java.swing.JTextField;
import com.sun.java.swing.SwingUtilities;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import ogi.cq.cluster.CQClusterImpl;
import ogi.cq.gui.Spinner;
import ogi.cq.log.CQLog;
import ogi.cq.plugin.LocalContinualQueryPlugin;
import ogi.cq.plugin.NotInitializedException;
import ogi.cq.plugin.gui.BasePluginGUI;
import ogi.cq.plugin.gui.JTAVExamples;
import ogi.cq.plugin.gui.ModSAFExamples;
import ogi.cq.plugin.gui.PluginCQManager;
import ogi.cq.plugin.gui.StatFrame;

public class LocalPluginGUI
extends BasePluginGUI {
    public LocalPluginGUI() {
        this.init();
        ((Frame)((Object)this)).setTitle("CQ Plugin");
    }

    public LocalPluginGUI(String string) {
        this.propertyFile = string;
        this.init();
        ((Frame)((Object)this)).setTitle("CQ Plugin");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Thread thread;
        Runnable runnable;
        if (actionEvent.getSource() == this.connectButton) {
            this.initPlugin();
            this.connectButton.setEnabled(false);
            this.cqButton.setEnabled(true);
            this.statsButton.setEnabled(true);
        } else if (actionEvent.getSource() == this.helpButton) {
            this.getHelp().setVisible(true);
        } else if (actionEvent.getSource() == this.closeButton) {
            this.help.setVisible(false);
        } else if (actionEvent.getSource() == this.cqButton) {
            if (this.userField.getText().trim().equals("")) {
                this.status.setText("MUST set User ID to install CQ");
                return;
            }
            if (this.passwordField.getText().trim().equals("")) {
                this.status.setText("MUST set password to install CQ");
                return;
            }
            this.status.setText("Validating User");
            this.spinner.startSpinning();
            runnable = new Runnable(this){
                /* synthetic */ LocalPluginGUI this$0;

                public void run() {
                    LocalPluginGUI.access$newQuery(this.this$0);
                }
                {
                    this.this$0 = localPluginGUI;
                }
            };
            thread = new Thread(runnable);
            thread.start();
        }
        if (actionEvent.getSource() == this.statsButton) {
            if (this.stats == null) {
                this.statsButton.setEnabled(false);
                this.traceButton.setEnabled(false);
                this.status.setText("Retrieving statistics");
                this.spinner.startSpinning();
                runnable = new Runnable(this){
                    /* synthetic */ LocalPluginGUI this$0;

                    public void run() {
                        this.this$0.initStats();
                    }
                    {
                        this.this$0 = localPluginGUI;
                    }
                };
                thread = new Thread(runnable);
                thread.start();
                this.showExecutionHistory = false;
                return;
            }
            ((Window)((Object)this.stats)).show();
            this.stats.showCurrentStats();
        }
        if (actionEvent.getSource() == this.traceButton) {
            if (this.stats == null) {
                this.statsButton.setEnabled(false);
                this.traceButton.setEnabled(false);
                this.status.setText("Retrieving statistics");
                this.spinner.startSpinning();
                runnable = new Runnable(this){
                    /* synthetic */ LocalPluginGUI this$0;

                    public void run() {
                        this.this$0.initStats();
                    }
                    {
                        this.this$0 = localPluginGUI;
                    }
                };
                thread = new Thread(runnable);
                thread.start();
                this.showExecutionHistory = true;
                return;
            }
            ((Window)((Object)this.stats)).show();
            this.stats.showExecutionHistory();
        }
    }

    public JFrame getHelp() {
        if (this.help == null) {
            String string = "Help -- CQ_JTAV Plugin Applet";
            this.help = new JFrame(string);
            JPanel jPanel = (JPanel)this.help.getContentPane();
            jPanel.setLayout(new BorderLayout());
            Font font = new Font("timesRoman", 1, 20);
            JLabel jLabel = new JLabel(string);
            jLabel.setFont(font);
            jLabel.setForeground(Color.blue);
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new FlowLayout());
            jPanel2.add((Component)jLabel);
            jPanel.add("North", (Component)jPanel2);
            JTextArea jTextArea = new JTextArea();
            jTextArea.setBackground(Color.lightGray);
            jTextArea.setEditable(false);
            jTextArea.append("You can install a continual query with the default ");
            jTextArea.append("user name and password, however, if you wish ");
            jTextArea.append("to receive notifications of updates, you must first register and log in with your ");
            jTextArea.append("own CQ System userid.");
            jTextArea.append(BasePluginGUI.NEW_LINE);
            jTextArea.append(BasePluginGUI.NEW_LINE);
            jTextArea.append("System Status");
            jTextArea.append(BasePluginGUI.NEW_LINE);
            jTextArea.append("To view the current CQ system status, click the 'System Status' button. ");
            jTextArea.append("This will display the current number of CQ's in the system, and a list of the active CQ's");
            jTextArea.append(BasePluginGUI.NEW_LINE);
            jTextArea.append(BasePluginGUI.NEW_LINE);
            jTextArea.append("Track CQ Execution");
            jTextArea.append(BasePluginGUI.NEW_LINE);
            jTextArea.append("The history statistics of the CQ system are available via the 'Track CQ Execution' button. ");
            jTextArea.append("This shows graphs depicting the CQ load history");
            jTextArea.append(BasePluginGUI.NEW_LINE);
            jTextArea.append(BasePluginGUI.NEW_LINE);
            jTextArea.append("Install a new CQ");
            jTextArea.append(BasePluginGUI.NEW_LINE);
            jTextArea.append("To install a new CQ, click the 'Install a new CQ' button. ");
            jTextArea.append("This will display a screen that allows you to enter a query and trigger; alternatively, the user interface ");
            jTextArea.append("allows you to directly type in the query and trigger definition. ");
            jTextArea.append(BasePluginGUI.NEW_LINE);
            jTextArea.append(BasePluginGUI.NEW_LINE);
            jTextArea.append("Register");
            jTextArea.append(BasePluginGUI.NEW_LINE);
            jTextArea.append("To register, simply click the register button on the applet.  Fill in the HTML form ");
            jTextArea.append("and submit it.  ");
            jTextArea.append("That is it.  You will then be registered -- you can install CQ\u2019s and ");
            jTextArea.append("receive notifications for the updates you specify.");
            jTextArea.append(BasePluginGUI.NEW_LINE);
            jTextArea.append(BasePluginGUI.NEW_LINE);
            jTextArea.append("Browse CQ's");
            jTextArea.append(BasePluginGUI.NEW_LINE);
            jTextArea.append("Click the 'Browse CQ' button to view the raw definition of the CQ's you have access to. This will take you to an HTML ");
            jTextArea.append("page that displays all of your CQ's in a table. ");
            jTextArea.append(BasePluginGUI.NEW_LINE);
            jTextArea.append("Alternatively, you can view an individual CQ definition from the statistics screen. ");
            jTextArea.append("Click on an individual CQ from the list shown and press ");
            jTextArea.append("the View CQ Definition button.  This will display the selected CQ in a form. ");
            jTextArea.append(BasePluginGUI.NEW_LINE);
            jTextArea.append(BasePluginGUI.NEW_LINE);
            jTextArea.append("Query");
            jTextArea.append(BasePluginGUI.NEW_LINE);
            jTextArea.append("If you just want to query the data and not install a CQ, click the Query button ");
            jTextArea.append(BasePluginGUI.NEW_LINE);
            jTextArea.append(BasePluginGUI.NEW_LINE);
            jTextArea.append("CQ Home");
            jTextArea.append(BasePluginGUI.NEW_LINE);
            jTextArea.append("Return to the CQ Home page by pressing the CQ Home button. ");
            jTextArea.setLineWrap(true);
            jTextArea.setWrapStyleWord(true);
            JScrollPane jScrollPane = new JScrollPane((Component)jTextArea);
            jScrollPane.setVerticalScrollBarPolicy(22);
            jScrollPane.setHorizontalScrollBarPolicy(31);
            jScrollPane.setPreferredSize(new Dimension(250, 250));
            jPanel.add("Center", (Component)jScrollPane);
            Font font2 = new Font("timesRoman", 0, 15);
            jTextArea.setFont(font2);
            JPanel jPanel3 = new JPanel();
            jPanel3.setLayout(new FlowLayout());
            this.closeButton = new JButton("Close");
            this.closeButton.setBackground(Color.red);
            this.closeButton.addActionListener((ActionListener)this);
            jPanel3.add((Component)this.closeButton);
            jPanel.add("South", (Component)jPanel3);
            this.help.setSize(640, 480);
        }
        return this.help;
    }

    private String getPassword() {
        return this.passwordField.getText();
    }

    private String getUser() {
        return this.userField.getText();
    }

    public void init() {
        this.logger = new CQLog();
        this.logger.setDebug(BasePluginGUI.DEBUG);
        this.initGUI();
        this.logger.debug("finished GUI init");
        this.initPlugin();
        Vector vector = this.plugin.getSources();
        int n = 0;
        while (n < vector.size()) {
            this.sourceComboBox.addItem((Object)vector.elementAt(n).toString());
            ++n;
        }
    }

    public void initGUI() {
        JPanel jPanel = (JPanel)this.getContentPane();
        jPanel.setLayout((LayoutManager)new BoxLayout((Container)jPanel, 1));
        jPanel.setBorder(BorderFactory.createEtchedBorder());
        jPanel.add(Box.createGlue());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new BoxLayout((Container)jPanel2, 1));
        jPanel.add((Component)jPanel2);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new BoxLayout((Container)jPanel3, 0));
        jPanel2.add((Component)jPanel3);
        this.statsButton = new JButton("System Status");
        this.statsButton.setBackground(Color.yellow);
        this.statsButton.addActionListener((ActionListener)this);
        jPanel3.add((Component)this.statsButton);
        this.traceButton = new JButton("Track CQ Execution");
        this.traceButton.setBackground(Color.yellow);
        this.traceButton.addActionListener((ActionListener)this);
        jPanel3.add((Component)this.traceButton);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new BoxLayout((Container)jPanel4, 0));
        jPanel2.add((Component)jPanel4);
        this.cqButton = new JButton("Install a new CQ");
        this.cqButton.setBackground(Color.orange);
        this.cqButton.addActionListener((ActionListener)this);
        jPanel4.add(Box.createHorizontalGlue());
        jPanel4.add((Component)this.cqButton);
        jPanel4.add(Box.createHorizontalGlue());
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new BoxLayout((Container)jPanel5, 0));
        jPanel.add(Box.createRigidArea((Dimension)new Dimension(0, 5)));
        jPanel.add((Component)jPanel5);
        jPanel.add(Box.createRigidArea((Dimension)new Dimension(0, 5)));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new GridLayout(2, 1));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new GridLayout(2, 1));
        JLabel jLabel = new JLabel("User ID: ");
        jPanel6.add((Component)jLabel);
        this.userField = new JTextField("DemoUser", 20);
        jPanel7.add((Component)this.userField);
        jPanel5.add(Box.createRigidArea((Dimension)new Dimension(50, 5)));
        jPanel5.add(Box.createHorizontalGlue());
        jPanel5.add((Component)jPanel6);
        jPanel5.add((Component)jPanel7);
        jPanel5.add(Box.createHorizontalGlue());
        jPanel5.add(Box.createRigidArea((Dimension)new Dimension(150, 5)));
        JLabel jLabel2 = new JLabel("Password: ");
        jPanel6.add((Component)jLabel2);
        this.passwordField = new JPasswordField("demouser");
        jPanel7.add((Component)this.passwordField);
        jPanel.add(Box.createVerticalGlue());
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new BoxLayout((Container)jPanel8, 0));
        this.sourceComboBox = new JComboBox();
        this.sourceComboBox.addActionListener((ActionListener)this);
        jPanel8.add(Box.createHorizontalGlue());
        jPanel8.add((Component)new JLabel("Select source: "));
        jPanel8.add((Component)this.sourceComboBox);
        jPanel8.add(Box.createHorizontalGlue());
        jPanel.add((Component)jPanel8);
        jPanel.add((Component)this.getWebButtonPanel());
        jPanel.add((Component)this.getControlButtonPanel());
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout((LayoutManager)new BoxLayout((Container)jPanel9, 0));
        jPanel.add((Component)jPanel9);
        this.helpButton = new JButton("Help");
        this.helpButton.setBackground(Color.green);
        this.helpButton.addActionListener((ActionListener)this);
        this.helpButton.setAlignmentY(0.5f);
        jPanel9.add((Component)this.helpButton);
        this.status = new JTextField("Status");
        this.status.setForeground(Color.blue);
        this.status.setBackground(Color.lightGray);
        this.status.setEditable(false);
        this.status.setAlignmentY(0.5f);
        jPanel9.add((Component)this.status);
        this.spinner = new Spinner();
        this.spinner.setAlignmentY(0.5f);
        jPanel9.add((Component)((Object)this.spinner));
    }

    public void initPlugin() {
        try {
            CQClusterImpl cQClusterImpl = null;
            if (this.propertyFile == null) {
                this.setDefaultProperties();
                cQClusterImpl = new CQClusterImpl();
            } else {
                cQClusterImpl = new CQClusterImpl(this.propertyFile);
            }
            this.plugin = new LocalContinualQueryPlugin(cQClusterImpl);
        }
        catch (Exception exception) {
            throw new NotInitializedException(exception.toString());
        }
    }

    public synchronized void initStats() {
        this.stats = new StatFrame(this.plugin, this.logger, "CQ System statistics");
        ((Window)((Object)this.stats)).pack();
        if (((Component)((Object)this.stats)).getSize().height < 480) {
            ((Component)((Object)this.stats)).setSize(new Dimension(Math.max(((Component)((Object)this.stats)).getSize().width, 640), 480));
        }
        if (this.showExecutionHistory) {
            this.stats.showExecutionHistory();
        } else {
            this.stats.showCurrentStats();
        }
        ((Window)((Object)this.stats)).show();
        this.spinner.stopSpinning();
        this.reset();
    }

    public void invalidUser() {
        Runnable runnable = new Runnable(this){
            /* synthetic */ LocalPluginGUI this$0;

            public void run() {
                LocalPluginGUI.access$invalidUser0(this.this$0);
            }
            {
                this.this$0 = localPluginGUI;
            }
        };
        SwingUtilities.invokeLater((Runnable)runnable);
    }

    private void invalidUser0() {
        this.reset0();
        this.status.setText("User name/password is invalid");
        this.spinner.stopSpinning();
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 1) {
            LocalPluginGUI.usage();
            System.exit(1);
        }
        LocalPluginGUI localPluginGUI = new LocalPluginGUI(stringArray[0]);
        ((Window)((Object)localPluginGUI)).pack();
        ((Component)((Object)localPluginGUI)).setSize(640, 480);
        ((Component)((Object)localPluginGUI)).setVisible(true);
    }

    private void newQuery() {
        if (this.plugin.validateUser(this.getUser(), this.getPassword())) {
            Runnable runnable = new Runnable(this){
                /* synthetic */ LocalPluginGUI this$0;

                public void run() {
                    this.this$0.status.setText("Initializing new CQ installation");
                }
                {
                    this.this$0 = localPluginGUI;
                }
            };
            SwingUtilities.invokeLater((Runnable)runnable);
            String string = (String)this.sourceComboBox.getSelectedItem();
            PluginCQManager pluginCQManager = null;
            pluginCQManager = string.equals("modsaf") ? new PluginCQManager(this.plugin, string, new ModSAFExamples(), this.logger) : (string.equals("jtav") ? new PluginCQManager(this.plugin, string, new JTAVExamples(), this.logger) : new PluginCQManager(this.plugin, string, new ModSAFExamples(), this.logger));
            pluginCQManager.begin(string, this.getUser(), this.getPassword());
            this.spinner.stopSpinning();
            this.reset();
        } else {
            this.invalidUser();
        }
    }

    public void reset() {
        Runnable runnable = new Runnable(this){
            /* synthetic */ LocalPluginGUI this$0;

            public void run() {
                LocalPluginGUI.access$reset0(this.this$0);
            }
            {
                this.this$0 = localPluginGUI;
            }
        };
        SwingUtilities.invokeLater((Runnable)runnable);
    }

    private void reset0() {
        this.status.setText("");
        this.statsButton.setEnabled(true);
        this.traceButton.setEnabled(true);
        this.cqButton.setEnabled(true);
    }

    protected void setDefaultProperties() {
        Properties properties = System.getProperties();
        ((Hashtable)properties).put("jdbcDriverClass", "oracle.jdbc.driver.OracleDriver");
        ((Hashtable)properties).put("dbConnectionString", "jdbc:oracle:thin:@129.95.40.15:1621:db");
        ((Hashtable)properties).put("dbUser", "cqmeta");
        ((Hashtable)properties).put("dbPassword", "lLatemqc");
        ((Hashtable)properties).put("contentQueryCGI", "http://129.95.40.15:8080/OpenCQDev/cgi-bin/installCQ_step2.cgi");
    }

    public static void usage() {
        System.out.println("Usage: LocalPluginGUI <properties file> ");
        System.out.println("Where <properties file> is the path of the file ");
        System.out.println("that contains the info for the cluster to run.");
        System.out.println("");
    }

    static void access$reset0(LocalPluginGUI localPluginGUI) {
        localPluginGUI.reset0();
    }

    static void access$newQuery(LocalPluginGUI localPluginGUI) {
        localPluginGUI.newQuery();
    }

    static void access$invalidUser0(LocalPluginGUI localPluginGUI) {
        localPluginGUI.invalidUser0();
    }
}

