/*
 * Decompiled with CFR 0.152.
 */
package ogi.cq.plugin.gui;

import com.sun.java.swing.BorderFactory;
import com.sun.java.swing.Box;
import com.sun.java.swing.BoxLayout;
import com.sun.java.swing.JApplet;
import com.sun.java.swing.JButton;
import com.sun.java.swing.JComboBox;
import com.sun.java.swing.JFrame;
import com.sun.java.swing.JLabel;
import com.sun.java.swing.JPanel;
import com.sun.java.swing.JPasswordField;
import com.sun.java.swing.JScrollPane;
import com.sun.java.swing.JTextArea;
import com.sun.java.swing.JTextField;
import com.sun.java.swing.SwingUtilities;
import com.sun.java.swing.text.JTextComponent;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import ogi.cq.gui.Spinner;
import ogi.cq.log.CQLog;
import ogi.cq.log.Log;
import ogi.cq.plugin.CQNotInstalledException;
import ogi.cq.plugin.CQServletPlugin;
import ogi.cq.plugin.IContinualQueryPlugin;
import ogi.cq.plugin.InvalidCQException;
import ogi.cq.plugin.NotInitializedException;
import ogi.cq.plugin.gui.DIOMExamples;
import ogi.cq.plugin.gui.Examples;
import ogi.cq.plugin.gui.LogPanel;
import ogi.cq.plugin.gui.ModSAFExamples;
import ogi.cq.plugin.gui.NotifyPanel;
import ogi.cq.plugin.gui.PluginApplet;
import ogi.cq.plugin.gui.QueryPanel;
import ogi.cq.plugin.gui.StopPanel;
import ogi.cq.plugin.gui.TestTriggerState;
import ogi.cq.plugin.gui.TriggerPanel;
import ogi.diom.util.GUI;

public class ExampleApplet
extends JApplet
implements ItemListener,
ActionListener {
    public static boolean DEBUG = true;
    protected Log logger;
    String source;
    IContinualQueryPlugin plugin;
    JButton helpButton;
    JButton closeButton;
    JFrame help;
    JTextField serverField;
    JTextField portField;
    JTextComponent userField;
    JPasswordField passwordField;
    private String server;
    private String port;
    private String servlet;
    JComboBox sourceComboBox;
    Examples examples;
    JPanel examplePanel;
    JComboBox chooseExampleComboBox;
    JTextArea queryDescriptionField;
    JTextArea triggerDescriptionField;
    JTextArea stopDescriptionField;
    JButton testButton;
    JButton installButton;
    JTextField status;
    Spinner spinner;
    QueryPanel queryTranslator;
    TriggerPanel triggerTranslator;
    StopPanel stopTranslator;
    NotifyPanel notifyTranslator;
    boolean showExecutionHistory;
    public static final String[] sourceList = new String[]{"modsaf", "diom"};
    public static final Examples[] exampleList = new Examples[]{new ModSAFExamples(), new DIOMExamples()};
    public static final String NEW_LINE = System.getProperty("line.separator");
    public static final int PASSWORD_LENGTH = 12;
    public static final int USERID_LENGTH = 10;

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.helpButton) {
            this.getHelp().setVisible(true);
        } else if (actionEvent.getSource() == this.closeButton) {
            this.help.setVisible(false);
        } else if (actionEvent.getSource() == this.testButton) {
            if (this.chooseExampleComboBox.getSelectedIndex() == 0) {
                this.status.setText("Choose Example first");
                return;
            }
            this.executeQuery();
        } else if (actionEvent.getSource() == this.installButton) {
            if (this.chooseExampleComboBox.getSelectedIndex() == 0) {
                this.status.setText("Choose Example first");
                return;
            }
            if (this.getUser().trim().equals("") || this.userField.getText().indexOf("@") <= 0) {
                System.out.println("You must enter a valid email address to install a CQ");
                this.status.setText("You must enter a valid email address to install a CQ");
                return;
            }
            this.status.setText("");
            boolean bl = this.validateUser();
            if (bl) {
                Thread thread = new Thread(new Runnable(this){
                    /* synthetic */ ExampleApplet this$0;

                    public void run() {
                        ExampleApplet.access$installCQ(this.this$0);
                    }
                    {
                        this.this$0 = exampleApplet;
                    }
                });
                thread.start();
            }
        }
    }

    private void executeQuery() {
        String string;
        String string2;
        String string3;
        String string4;
        this.spinner.startSpinning();
        TestTriggerState testTriggerState = new TestTriggerState();
        testTriggerState.setApplet(this);
        new LogPanel(testTriggerState, this.logger);
        QueryPanel queryPanel = new QueryPanel(testTriggerState, this.examples);
        int n = this.chooseExampleComboBox.getSelectedIndex() - 1;
        queryPanel.setExample(this.examples.getExample(n));
        String string5 = queryPanel.getSELECT();
        if (string5 == null) {
            string5 = "";
        }
        if ((string4 = queryPanel.getFROM()) == null) {
            string4 = "";
        }
        if ((string3 = queryPanel.getPredicates()) == null) {
            string3 = "";
        }
        if ((string2 = queryPanel.getGroupby()) == null) {
            string2 = "";
        }
        if ((string = queryPanel.getOrderby()) == null) {
            string = "";
        }
        StringBuffer stringBuffer = new StringBuffer("http://129.95.40.15:8080/OpenCQ/cgi-bin/query.cgi?");
        stringBuffer.append("dbname=");
        stringBuffer.append(this.source);
        stringBuffer.append("&select=");
        stringBuffer.append(URLEncoder.encode(string5));
        stringBuffer.append("&from=");
        stringBuffer.append(URLEncoder.encode(string4));
        stringBuffer.append("&where=");
        stringBuffer.append(URLEncoder.encode(string3));
        stringBuffer.append("&groupby=");
        stringBuffer.append(URLEncoder.encode(string2));
        stringBuffer.append("&orderby=");
        stringBuffer.append(URLEncoder.encode(string));
        System.out.println(stringBuffer);
        try {
            URL uRL = new URL(stringBuffer.toString());
            ((Applet)((Object)this)).getAppletContext().showDocument(uRL, "query");
        }
        catch (MalformedURLException malformedURLException) {
            this.logger.log(0, "\nInvalid URL:" + malformedURLException.toString());
        }
        this.spinner.stopSpinning();
    }

    private JPanel getExamplePanel() {
        try {
            if (this.examplePanel == null) {
                this.examplePanel = new JPanel();
                this.examplePanel.setLayout((LayoutManager)new BoxLayout((Container)this.examplePanel, 1));
                JPanel jPanel = new JPanel();
                jPanel.setLayout((LayoutManager)new BoxLayout((Container)jPanel, 0));
                this.chooseExampleComboBox = new JComboBox();
                this.chooseExampleComboBox.addItem((Object)"Select an example");
                int n = this.examples.getExampleCount();
                int n2 = 0;
                while (n2 < n) {
                    this.chooseExampleComboBox.addItem(this.examples.getExample(n2)[0]);
                    ++n2;
                }
                this.chooseExampleComboBox.addItemListener((ItemListener)this);
                jPanel.add(Box.createHorizontalGlue());
                jPanel.add((Component)this.chooseExampleComboBox);
                jPanel.add(Box.createHorizontalGlue());
                this.examplePanel.add((Component)jPanel);
                JPanel jPanel2 = new JPanel();
                jPanel2.setLayout(new GridBagLayout());
                Font font = new Font("dialog", 1, 14);
                JLabel jLabel = new JLabel("CQ Component  ");
                jLabel.setForeground(Color.black);
                jLabel.setFont(font);
                JLabel jLabel2 = new JLabel("CQ Component Description");
                jLabel2.setForeground(Color.black);
                jLabel2.setFont(font);
                GUI.add((Container)jPanel2, (Component)jLabel2, 2, 1, 5, 1, 1, 10, 50.0, 50.0);
                JLabel jLabel3 = new JLabel("Query: ");
                jLabel3.setForeground(Color.black);
                GUI.add((Container)jPanel2, (Component)jLabel3, 1, 2, 1, 1, 1, 10, 1.0, 50.0);
                this.queryDescriptionField = new JTextArea();
                this.queryDescriptionField.setForeground(Color.blue);
                this.queryDescriptionField.setWrapStyleWord(true);
                this.queryDescriptionField.setLineWrap(true);
                JScrollPane jScrollPane = new JScrollPane((Component)this.queryDescriptionField);
                GUI.add((Container)jPanel2, (Component)jScrollPane, 2, 2, 5, 3, 1, 10, 50.0, 50.0);
                JLabel jLabel4 = new JLabel("Trigger: ");
                jLabel4.setForeground(Color.black);
                GUI.add((Container)jPanel2, (Component)jLabel4, 1, 5, 1, 1, 1, 10, 1.0, 50.0);
                this.triggerDescriptionField = new JTextArea();
                this.triggerDescriptionField.setForeground(Color.blue);
                this.triggerDescriptionField.setWrapStyleWord(true);
                this.triggerDescriptionField.setLineWrap(true);
                JScrollPane jScrollPane2 = new JScrollPane((Component)this.triggerDescriptionField);
                GUI.add((Container)jPanel2, (Component)jScrollPane2, 2, 5, 5, 3, 1, 10, 50.0, 50.0);
                JLabel jLabel5 = new JLabel("Stop: ");
                jLabel5.setForeground(Color.black);
                GUI.add((Container)jPanel2, (Component)jLabel5, 1, 8, 1, 1, 1, 10, 1.0, 50.0);
                this.stopDescriptionField = new JTextArea();
                this.stopDescriptionField.setForeground(Color.blue);
                this.stopDescriptionField.setWrapStyleWord(true);
                this.stopDescriptionField.setLineWrap(true);
                JScrollPane jScrollPane3 = new JScrollPane((Component)this.stopDescriptionField);
                GUI.add((Container)jPanel2, (Component)jScrollPane3, 2, 8, 5, 1, 2, 10, 50.0, 50.0);
                this.examplePanel.add((Component)jPanel2);
            }
        }
        catch (Exception exception) {
            System.out.println("error in getExamplePanel: " + exception);
            exception.printStackTrace();
        }
        catch (Throwable throwable) {
            System.out.println("error in getExamplePanel: " + throwable);
            throwable.printStackTrace();
        }
        return this.examplePanel;
    }

    public JFrame getHelp() {
        if (this.help == null) {
            String string = "Help -- CQ_JTAV Plugin Applet";
            this.help = new JFrame(string);
            JPanel jPanel = (JPanel)this.help.getContentPane();
            jPanel.setLayout(new BorderLayout());
            Font font = new Font("timesRoman", 1, 20);
            JLabel jLabel = new JLabel(string);
            jLabel.setFont(font);
            jLabel.setForeground(Color.blue);
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new FlowLayout());
            jPanel2.add((Component)jLabel);
            jPanel.add("North", (Component)jPanel2);
            JTextArea jTextArea = new JTextArea();
            jTextArea.setBackground(Color.lightGray);
            jTextArea.setEditable(false);
            jTextArea.append("This form lets you install an example continual query. ");
            jTextArea.append("To receive notifications of updates, enter your email address ");
            jTextArea.append(NEW_LINE);
            jTextArea.append(NEW_LINE);
            jTextArea.append("The test button just sends the query to the CQ systsm.");
            jTextArea.append(NEW_LINE);
            jTextArea.append(NEW_LINE);
            jTextArea.append("The install button creates a new CQ for the given email address. If the email address is empty, CQ's cannot be installed.");
            jTextArea.setLineWrap(true);
            jTextArea.setWrapStyleWord(true);
            JScrollPane jScrollPane = new JScrollPane((Component)jTextArea);
            jScrollPane.setVerticalScrollBarPolicy(22);
            jScrollPane.setHorizontalScrollBarPolicy(31);
            jScrollPane.setPreferredSize(new Dimension(250, 250));
            jPanel.add("Center", (Component)jScrollPane);
            Font font2 = new Font("timesRoman", 0, 15);
            jTextArea.setFont(font2);
            JPanel jPanel3 = new JPanel();
            jPanel3.setLayout(new FlowLayout());
            this.closeButton = new JButton("Close");
            this.closeButton.setBackground(Color.red);
            this.closeButton.addActionListener((ActionListener)this);
            jPanel3.add((Component)this.closeButton);
            jPanel.add("South", (Component)jPanel3);
            this.help.setSize(640, 480);
        }
        return this.help;
    }

    private String getPassword() {
        int n = this.getUser().trim().length();
        n = Math.min(12, n);
        return this.getUser().substring(0, n);
    }

    public String getPort() {
        if (this.port == null) {
            this.port = ((Applet)((Object)this)).getParameter("port");
        }
        return this.port;
    }

    public String getServer() {
        if (this.server == null) {
            this.server = ((Applet)((Object)this)).getParameter("server");
        }
        return this.server;
    }

    public String getServlet() {
        if (this.servlet == null) {
            this.servlet = ((Applet)((Object)this)).getParameter("servlet");
        }
        return this.servlet;
    }

    private String getUser() {
        return this.userField.getText();
    }

    private String getUserID() {
        int n = this.getUser().trim().length();
        n = Math.min(10, n);
        String string = this.getUser().substring(0, n);
        int n2 = string.indexOf("@");
        StringBuffer stringBuffer = new StringBuffer(string.substring(0, n2));
        stringBuffer.append("_at_");
        if (n2 < string.length()) {
            stringBuffer.append(string.substring(n2 + 1));
        }
        String string2 = stringBuffer.toString();
        n = (string2 = string2.replace('.', '_')).length();
        if (n > 10) {
            string2 = string2.substring(0, 10);
        }
        return string2;
    }

    public void init() {
        String string;
        this.logger = new CQLog();
        this.logger.setDebug(DEBUG);
        this.source = string = ((Applet)((Object)this)).getParameter("examples");
        if (string != null) {
            this.examples = string.equalsIgnoreCase("modsaf") ? new ModSAFExamples() : new ModSAFExamples();
        } else {
            this.examples = new ModSAFExamples();
            this.source = "modsaf";
        }
        this.initGUI();
        this.logger.debug("finished GUI init");
        this.initPlugin();
    }

    public void initGUI() {
        JPanel jPanel = (JPanel)this.getContentPane();
        jPanel.setLayout((LayoutManager)new BoxLayout((Container)jPanel, 1));
        jPanel.setBorder(BorderFactory.createEtchedBorder());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new BoxLayout((Container)jPanel2, 0));
        this.sourceComboBox = new JComboBox();
        this.sourceComboBox.addItemListener((ItemListener)this);
        int n = 0;
        while (n < sourceList.length) {
            this.sourceComboBox.addItem((Object)sourceList[n]);
            ++n;
        }
        jPanel2.add(Box.createHorizontalGlue());
        jPanel2.add((Component)new JLabel("Select source: "));
        jPanel2.add((Component)this.sourceComboBox);
        jPanel2.add(Box.createHorizontalGlue());
        jPanel.add((Component)jPanel2);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new BoxLayout((Container)jPanel3, 1));
        jPanel.add((Component)jPanel3);
        JPanel jPanel4 = this.getExamplePanel();
        jPanel3.add((Component)jPanel4);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new BoxLayout((Container)jPanel5, 0));
        jPanel.add(Box.createRigidArea((Dimension)new Dimension(0, 5)));
        jPanel.add((Component)jPanel5);
        jPanel.add(Box.createRigidArea((Dimension)new Dimension(0, 5)));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new BoxLayout((Container)jPanel6, 1));
        JLabel jLabel = new JLabel("Email address");
        JLabel jLabel2 = new JLabel(" to notify: ");
        jPanel6.add((Component)jLabel);
        jPanel6.add((Component)jLabel2);
        jPanel5.add((Component)jPanel6);
        this.userField = new JTextField("", 20);
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new FlowLayout());
        jPanel7.add((Component)this.userField);
        jPanel5.add((Component)jPanel7);
        jPanel5.add(Box.createHorizontalGlue());
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new BoxLayout((Container)jPanel8, 0));
        jPanel.add((Component)jPanel8);
        this.testButton = new JButton("Test");
        this.testButton.setBackground(Color.yellow);
        this.testButton.addActionListener((ActionListener)this);
        jPanel8.add(Box.createHorizontalGlue());
        jPanel8.add((Component)this.testButton);
        this.installButton = new JButton("Install");
        this.installButton.setBackground(Color.orange);
        this.installButton.addActionListener((ActionListener)this);
        jPanel8.add((Component)this.installButton);
        jPanel8.add(Box.createHorizontalGlue());
        jPanel.add(Box.createVerticalGlue());
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout((LayoutManager)new BoxLayout((Container)jPanel9, 0));
        jPanel.add((Component)jPanel9);
        this.helpButton = new JButton("Help");
        this.helpButton.setBackground(Color.green);
        this.helpButton.addActionListener((ActionListener)this);
        this.helpButton.setAlignmentY(0.5f);
        jPanel9.add((Component)this.helpButton);
        this.status = new JTextField("Status");
        this.status.setForeground(Color.blue);
        this.status.setBackground(Color.lightGray);
        this.status.setEditable(false);
        this.status.setAlignmentY(0.5f);
        jPanel9.add((Component)this.status);
        this.spinner = new Spinner();
        this.spinner.setAlignmentY(0.5f);
        jPanel9.add((Component)((Object)this.spinner));
    }

    public void initPlugin() {
        try {
            this.plugin = new CQServletPlugin();
            String[] stringArray = new String[]{this.getServer(), this.getPort(), this.getServlet()};
            this.plugin.initialize(stringArray);
            this.plugin.load(null);
        }
        catch (Exception exception) {
            throw new NotInitializedException(exception.toString());
        }
    }

    private void installCQ() {
        this.spinner.startSpinning();
        JFrame jFrame = new JFrame("CQ installation log");
        JPanel jPanel = (JPanel)jFrame.getContentPane();
        jPanel.setLayout(new BorderLayout());
        TestTriggerState testTriggerState = new TestTriggerState();
        testTriggerState.setApplet(this);
        LogPanel logPanel = new LogPanel(testTriggerState, this.logger);
        jPanel.add("Center", (Component)((Object)logPanel));
        JButton jButton = new JButton("Close");
        jButton.setBackground(Color.red);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Container container = (Container)actionEvent.getSource();
                while (container.getParent() != null) {
                    container = container.getParent();
                }
                container.setVisible(false);
            }
        });
        JPanel jPanel2 = new JPanel();
        jPanel2.add((Component)jButton);
        jPanel.add("South", (Component)jPanel2);
        jFrame.setSize(640, 480);
        jFrame.setVisible(true);
        QueryPanel queryPanel = new QueryPanel(testTriggerState, this.examples);
        TriggerPanel triggerPanel = new TriggerPanel(testTriggerState, this.logger);
        StopPanel stopPanel = new StopPanel(testTriggerState, this.logger);
        NotifyPanel notifyPanel = new NotifyPanel(testTriggerState, this.logger);
        int n = this.chooseExampleComboBox.getSelectedIndex() - 1;
        queryPanel.setExample(this.examples.getExample(n));
        triggerPanel.setExample(this.examples.getExample(n));
        stopPanel.setExample(this.examples.getExample(n));
        notifyPanel.setExample(this.examples.getExample(n));
        String string = "Test CQ for " + this.getUser();
        String string2 = queryPanel.getSELECT();
        String string3 = queryPanel.getFROM();
        String string4 = queryPanel.getPredicates();
        String string5 = queryPanel.getGroupby();
        String string6 = queryPanel.getOrderby();
        String string7 = triggerPanel.getTriggerString();
        String string8 = stopPanel.getStopString();
        String string9 = notifyPanel.getNotifyConfig();
        try {
            this.plugin.installCQ(logPanel, this.source, this.getUserID(), this.getPassword(), string, string2, string3, string4, string5, string6, string7, triggerPanel.getContentTrigger(), string9, string8);
        }
        catch (InvalidCQException invalidCQException) {
            logPanel.log("\nInvalid CQ:" + invalidCQException.toString());
        }
        catch (CQNotInstalledException cQNotInstalledException) {
            logPanel.log("\nCQ Not Installed:" + cQNotInstalledException.toString());
        }
        this.spinner.stopSpinning();
    }

    public void invalidUser() {
        Runnable runnable = new Runnable(this){
            /* synthetic */ ExampleApplet this$0;

            public void run() {
                ExampleApplet.access$invalidUser0(this.this$0);
            }
            {
                this.this$0 = exampleApplet;
            }
        };
        SwingUtilities.invokeLater((Runnable)runnable);
    }

    private void invalidUser0() {
        this.reset0();
        this.status.setText("User name/password is invalid");
        this.spinner.stopSpinning();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        int n;
        if (itemEvent.getSource() == null) {
            return;
        }
        if (itemEvent.getSource() == this.chooseExampleComboBox) {
            n = this.chooseExampleComboBox.getSelectedIndex();
            if (n > 0 && n <= this.examples.getExampleCount()) {
                this.queryDescriptionField.setText((String)this.examples.getExample(--n)[1]);
                this.triggerDescriptionField.setText((String)this.examples.getExample(n)[2]);
                this.stopDescriptionField.setText((String)this.examples.getExample(n)[3]);
                this.status.setText("");
            } else if (n == 0) {
                this.queryDescriptionField.setText("");
                this.triggerDescriptionField.setText("");
                this.stopDescriptionField.setText("");
            }
        }
        if (itemEvent.getSource() == this.sourceComboBox && (n = this.sourceComboBox.getSelectedIndex()) >= 0 && n < sourceList.length) {
            this.source = sourceList[n];
            this.examples = exampleList[n];
            if (this.chooseExampleComboBox == null) {
                return;
            }
            this.chooseExampleComboBox.removeAllItems();
            this.chooseExampleComboBox.addItem((Object)"Select an example");
            int n2 = this.examples.getExampleCount();
            int n3 = 0;
            while (n3 < n2) {
                this.chooseExampleComboBox.addItem(this.examples.getExample(n3)[0]);
                ++n3;
            }
        }
    }

    public static void main(String[] stringArray) {
        PluginApplet pluginApplet = new PluginApplet();
        JFrame jFrame = new JFrame();
        jFrame.getContentPane().add((Component)((Object)pluginApplet));
        jFrame.pack();
        jFrame.setSize(640, 480);
        jFrame.setVisible(true);
    }

    private void registerUser(String string) {
        boolean bl = this.plugin.registerUser(this.getUserID(), this.getPassword(), "M.", "", "", string, "1y");
        System.out.println("result: " + bl);
    }

    public void reset() {
        Runnable runnable = new Runnable(this){
            /* synthetic */ ExampleApplet this$0;

            public void run() {
                ExampleApplet.access$reset0(this.this$0);
            }
            {
                this.this$0 = exampleApplet;
            }
        };
        SwingUtilities.invokeLater((Runnable)runnable);
    }

    private void reset0() {
        this.status.setText("");
    }

    public boolean validateUser() {
        boolean bl = this.plugin.validateUser(this.getUserID(), this.getPassword());
        if (!bl) {
            System.out.println("failed first try");
            this.registerUser(this.getUser().trim());
            bl = this.plugin.validateUser(this.getUserID(), this.getPassword());
        }
        if (!bl) {
            System.out.println("failed second try");
            this.status.setText("Unable to register user");
            bl = this.plugin.validateUser("dave", "test");
            System.out.println("validate dave: " + bl);
        }
        return bl;
    }

    static void access$reset0(ExampleApplet exampleApplet) {
        exampleApplet.reset0();
    }

    static void access$invalidUser0(ExampleApplet exampleApplet) {
        exampleApplet.invalidUser0();
    }

    static void access$installCQ(ExampleApplet exampleApplet) {
        exampleApplet.installCQ();
    }
}

