/*
 * Decompiled with CFR 0.152.
 */
package ogi.cq.plugin.gui;

import com.sun.java.swing.BorderFactory;
import com.sun.java.swing.Box;
import com.sun.java.swing.BoxLayout;
import com.sun.java.swing.JComboBox;
import com.sun.java.swing.JLabel;
import com.sun.java.swing.JPanel;
import com.sun.java.swing.JScrollPane;
import com.sun.java.swing.JSplitPane;
import com.sun.java.swing.JTabbedPane;
import com.sun.java.swing.JTextArea;
import com.sun.java.swing.JTextField;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import ogi.cq.log.Log;
import ogi.cq.plugin.gui.Examples;
import ogi.cq.plugin.gui.IQueryPanel;
import ogi.cq.plugin.gui.PluginState;
import ogi.cq.plugin.gui.QueryPanel;
import ogi.diom.util.GUI;

public class CQQueryPanel
extends QueryPanel {
    JTextArea triggerDescriptionField;
    JTextArea stopDescriptionField;

    public CQQueryPanel(PluginState pluginState, Examples examples) {
        super(pluginState, examples);
    }

    public CQQueryPanel(PluginState pluginState, Examples examples, Log log) {
        super(pluginState, examples, log);
    }

    public CQQueryPanel(PluginState pluginState, Examples examples, Log log, Color color, Font font) {
        super(pluginState, examples, log, color, font);
    }

    public String getCQName() {
        if (this.cqNameField != null) {
            return this.cqNameField.getText();
        }
        return "";
    }

    protected JPanel getCQNamePanel() {
        String string = "[CQ Name]: ";
        JLabel jLabel = new JLabel(string);
        Font font = new Font("timesRoman", 1, 14);
        jLabel.setFont(font);
        jLabel.setForeground(Color.black);
        this.cqNameField = new JTextField(40);
        this.cqNameField.setFont(this.localFont);
        this.cqNameField.setForeground(Color.blue);
        this.cqNameField.setBackground(Color.white);
        JPanel jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new BoxLayout((Container)jPanel, 0));
        jPanel.add((Component)jLabel);
        jPanel.add((Component)this.cqNameField);
        jPanel.add(Box.createHorizontalGlue());
        return jPanel;
    }

    protected JPanel getExamplePanel() {
        try {
            if (this.examplePanel == null) {
                this.examplePanel = new JPanel();
                this.examplePanel.setLayout((LayoutManager)new BoxLayout((Container)this.examplePanel, 1));
                JPanel jPanel = new JPanel();
                jPanel.setLayout((LayoutManager)new BoxLayout((Container)jPanel, 0));
                JLabel jLabel = new JLabel("Choose Example ");
                jLabel.setForeground(Color.black);
                jPanel.add((Component)jLabel);
                this.chooseExampleComboBox = new JComboBox();
                this.chooseExampleComboBox.addActionListener((ActionListener)this);
                this.chooseExampleComboBox.addItem((Object)"Select an example");
                int n = this.examples.getExampleCount();
                int n2 = 0;
                while (n2 < n) {
                    this.chooseExampleComboBox.addItem(this.examples.getExample(n2)[0]);
                    ++n2;
                }
                this.chooseExampleComboBox.addItemListener((ItemListener)this);
                jPanel.add((Component)this.chooseExampleComboBox);
                jPanel.add(Box.createHorizontalGlue());
                this.examplePanel.add((Component)jPanel);
                JPanel jPanel2 = new JPanel();
                jPanel2.setLayout(new GridBagLayout());
                Font font = new Font("dialog", 1, 14);
                JLabel jLabel2 = new JLabel("CQ Component  ");
                jLabel2.setForeground(Color.black);
                jLabel2.setFont(font);
                GUI.add((Container)jPanel2, (Component)jLabel2, 1, 1, 1, 1, 1, 10, 10.0, 50.0);
                JLabel jLabel3 = new JLabel("Description");
                jLabel3.setForeground(Color.black);
                jLabel3.setFont(font);
                GUI.add((Container)jPanel2, (Component)jLabel3, 2, 1, 5, 1, 1, 10, 50.0, 50.0);
                JLabel jLabel4 = new JLabel("Query: ");
                jLabel4.setForeground(Color.black);
                GUI.add((Container)jPanel2, (Component)jLabel4, 1, 2, 1, 1, 1, 10, 1.0, 50.0);
                this.queryDescriptionField = new JTextArea();
                this.queryDescriptionField.setForeground(Color.blue);
                this.queryDescriptionField.setWrapStyleWord(true);
                this.queryDescriptionField.setLineWrap(true);
                JScrollPane jScrollPane = new JScrollPane((Component)this.queryDescriptionField);
                GUI.add((Container)jPanel2, (Component)jScrollPane, 2, 2, 5, 3, 1, 10, 50.0, 50.0);
                JLabel jLabel5 = new JLabel("Trigger: ");
                jLabel5.setForeground(Color.black);
                GUI.add((Container)jPanel2, (Component)jLabel5, 1, 5, 1, 1, 1, 10, 1.0, 50.0);
                this.triggerDescriptionField = new JTextArea();
                this.triggerDescriptionField.setForeground(Color.blue);
                this.triggerDescriptionField.setWrapStyleWord(true);
                this.triggerDescriptionField.setLineWrap(true);
                JScrollPane jScrollPane2 = new JScrollPane((Component)this.triggerDescriptionField);
                GUI.add((Container)jPanel2, (Component)jScrollPane2, 2, 5, 5, 3, 1, 10, 50.0, 50.0);
                JLabel jLabel6 = new JLabel("Stop: ");
                jLabel6.setForeground(Color.black);
                GUI.add((Container)jPanel2, (Component)jLabel6, 1, 8, 1, 1, 1, 10, 1.0, 50.0);
                this.stopDescriptionField = new JTextArea();
                this.stopDescriptionField.setForeground(Color.blue);
                this.stopDescriptionField.setWrapStyleWord(true);
                this.stopDescriptionField.setLineWrap(true);
                JScrollPane jScrollPane3 = new JScrollPane((Component)this.stopDescriptionField);
                GUI.add((Container)jPanel2, (Component)jScrollPane3, 2, 8, 5, 1, 2, 10, 50.0, 50.0);
                this.examplePanel.add((Component)jPanel2);
            }
        }
        catch (Exception exception) {
            System.out.println("error in getExamplePanel: " + exception);
            exception.printStackTrace();
        }
        catch (Throwable throwable) {
            System.out.println("error in getExamplePanel: " + throwable);
            throwable.printStackTrace();
        }
        return this.examplePanel;
    }

    protected JPanel getHelpPanel() {
        try {
            if (this.helpPanel == null) {
                this.helpPanel = new JPanel();
                this.helpPanel.setLayout(new BorderLayout());
                JTextArea jTextArea = new JTextArea();
                jTextArea.setForeground(Color.blue);
                jTextArea.setWrapStyleWord(true);
                jTextArea.setLineWrap(true);
                JScrollPane jScrollPane = new JScrollPane((Component)jTextArea);
                jScrollPane.setVerticalScrollBarPolicy(22);
                this.helpPanel.add("Center", (Component)jScrollPane);
                jTextArea.append("To specify the data returned for a query:");
                jTextArea.append(IQueryPanel.NEW_LINE);
                jTextArea.append("-----------------------------------------");
                jTextArea.append(IQueryPanel.NEW_LINE);
                jTextArea.append("1) Select an object from the object list.");
                jTextArea.append(IQueryPanel.NEW_LINE);
                jTextArea.append("2) Select relevant attributes from the object property list.");
                jTextArea.append(IQueryPanel.NEW_LINE);
                jTextArea.append("3) Click the \">\" button to confirm your selection.");
                jTextArea.append(IQueryPanel.NEW_LINE);
                jTextArea.append(IQueryPanel.NEW_LINE);
                jTextArea.append(IQueryPanel.NEW_LINE);
                jTextArea.append("To specify the selection conditions for a query:");
                jTextArea.append(IQueryPanel.NEW_LINE);
                jTextArea.append("------------------------------------------------");
                jTextArea.append(IQueryPanel.NEW_LINE);
                jTextArea.append("1) Click the conditions tab.");
                jTextArea.append(IQueryPanel.NEW_LINE);
                jTextArea.append("2) Select relevant attributes from the object property list.");
                jTextArea.append(IQueryPanel.NEW_LINE);
                jTextArea.append("3) Select operator and value for that attribute.");
                jTextArea.append(IQueryPanel.NEW_LINE);
                jTextArea.append("4) For muliple attributes, click the AND button.");
                jTextArea.append(IQueryPanel.NEW_LINE);
                jTextArea.append("To correct a mistake, or change your entry, click the \"<\" button to go back one stage, or click the \"Clear\" button to remove all conditions");
            }
        }
        catch (Exception exception) {
            System.out.println("error in gethelpPanel: " + exception);
            exception.printStackTrace();
        }
        catch (Throwable throwable) {
            System.out.println("error in gethelpPanel: " + throwable);
            throwable.printStackTrace();
        }
        return this.helpPanel;
    }

    protected JPanel getResultFormatPanel() {
        String string = "[Query result format]: ";
        JLabel jLabel = new JLabel(string);
        jLabel.setForeground(Color.black);
        jLabel.setFont(this.localFont);
        jLabel.setAlignmentX(0.0f);
        this.resultFormatChoice = new JComboBox();
        this.resultFormatChoice.addItem((Object)"Differential result since last execution");
        this.resultFormatChoice.addItem((Object)"Current Query result");
        this.resultFormatChoice.setFont(this.localFont);
        this.resultFormatChoice.setForeground(Color.blue);
        this.resultFormatChoice.setBackground(Color.white);
        JPanel jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new BoxLayout((Container)jPanel, 0));
        jPanel.add((Component)jLabel);
        jPanel.add((Component)this.resultFormatChoice);
        jPanel.add(Box.createHorizontalGlue());
        return jPanel;
    }

    protected void init() {
        try {
            this.setLocalFont(new Font("timesRoman", 0, 14));
            ((Container)((Object)this)).setLayout((LayoutManager)new BoxLayout((Container)((Object)this), 1));
            ((Container)((Object)this)).setLayout((LayoutManager)new BoxLayout((Container)((Object)this), 1));
            this.setBorder(BorderFactory.createEtchedBorder());
            this.setBackground(Color.lightGray);
            this.titleLabel = new JLabel(this.getTitle());
            Font font = new Font("timesRoman", 1, 20);
            this.titleLabel.setFont(font);
            this.titleLabel.setForeground(Color.black);
            this.titleLabel.setBackground(this.backgroundColor);
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new FlowLayout());
            jPanel.add((Component)this.titleLabel);
            FontMetrics fontMetrics = ((Component)((Object)this)).getFontMetrics(font);
            int n = fontMetrics.getAscent() + fontMetrics.getDescent();
            jPanel.setMinimumSize(new Dimension(this.titleLabel.getMinimumSize().width, n));
            jPanel.setPreferredSize(new Dimension(this.titleLabel.getPreferredSize().width, n));
            jPanel.setMaximumSize(new Dimension(this.titleLabel.getMaximumSize().width, n * 2));
            ((Container)((Object)this)).add((Component)jPanel);
            ((Container)((Object)this)).add((Component)this.getCQNamePanel());
            this.getCQNamePanel().setAlignmentX(0.0f);
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new BorderLayout());
            ((Container)((Object)this)).add((Component)jPanel2);
            JTabbedPane jTabbedPane = new JTabbedPane();
            jTabbedPane.add("Select", (Component)this.getSelectPanel());
            jTabbedPane.add("Conditions", (Component)this.getWherePanel());
            JPanel jPanel3 = new JPanel();
            jPanel3.setLayout((LayoutManager)new BoxLayout((Container)jPanel3, 1));
            jPanel3.add(Box.createVerticalGlue());
            jPanel3.add((Component)this.getGroupByPanel());
            jPanel3.add(Box.createVerticalGlue());
            jPanel3.add((Component)this.getOrderByPanel());
            jPanel3.add(Box.createVerticalGlue());
            jPanel3.add((Component)this.getResultFormatPanel());
            jPanel3.add(Box.createVerticalGlue());
            jTabbedPane.add("Other", (Component)jPanel3);
            jTabbedPane.addTab("EXAMPLES", (Component)this.getExamplePanel());
            jTabbedPane.setBackgroundAt(3, Color.blue);
            jTabbedPane.setForegroundAt(3, Color.white);
            jTabbedPane.addTab("Help", (Component)this.getHelpPanel());
            jTabbedPane.setBackgroundAt(4, Color.green);
            JSplitPane jSplitPane = new JSplitPane(0, (Component)jTabbedPane, (Component)this.getFullQueryPanel());
            jSplitPane.setAlignmentX(0.0f);
            jPanel2.add("Center", (Component)jSplitPane);
        }
        catch (Exception exception) {
            this.logger.debug("QueryPanel init error: " + exception);
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        int n;
        if (itemEvent.getSource() == this.chooseExampleComboBox && (n = this.chooseExampleComboBox.getSelectedIndex()) > 0 && n <= this.examples.getExampleCount()) {
            this.queryDescriptionField.setText((String)this.examples.getExample(--n)[1]);
            this.triggerDescriptionField.setText((String)this.examples.getExample(n)[2]);
            this.stopDescriptionField.setText((String)this.examples.getExample(n)[3]);
            this.manager.setExample(this.examples.getExample(n));
        }
    }

    public void reset() {
        this.cqNameField.setText("");
        this.groupByField.setText("");
        this.orderByField.setText("");
        this.fromList.clear();
        this.whereVec.removeAllElements();
        this.currentState = 1;
        this.stateHistory.removeAllElements();
        this.chooseExampleComboBox.setSelectedIndex(0);
        this.queryDescriptionField.setText("");
        this.triggerDescriptionField.setText("");
        this.stopDescriptionField.setText("");
        this.selectModel.removeAllElements();
        this.updateFromList();
        this.updateQueryField();
    }

    public void setResultFormat(String string) {
        if (string != null && string.trim().equalsIgnoreCase("EXE")) {
            this.resultFormatChoice.setSelectedIndex(1);
        } else {
            this.resultFormatChoice.setSelectedIndex(0);
        }
    }
}

