/*
 * Decompiled with CFR 0.152.
 */
package ogi.cq.plugin.gui;

import com.sun.java.swing.BorderFactory;
import com.sun.java.swing.Box;
import com.sun.java.swing.BoxLayout;
import com.sun.java.swing.JFrame;
import com.sun.java.swing.JLabel;
import com.sun.java.swing.JPanel;
import com.sun.java.swing.JProgressBar;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.text.SimpleDateFormat;
import java.util.Date;
import ogi.cq.plugin.CQInfo;

public class CQProgressPanel
extends JPanel {
    CQInfo info;
    JLabel startDateLabel;
    JLabel endDateLabel;
    JLabel totalTriggerLabel;
    JLabel completedTriggerLabel;
    JProgressBar progressBar;
    JLabel percentLabel;
    int maxWidth = 640;
    int maxHeight = 120;
    private long totalTriggers;
    private long completedTriggers;
    SimpleDateFormat dateFormat = new SimpleDateFormat();
    private Date startDate;
    private Date endDate;

    public CQProgressPanel(CQInfo cQInfo) {
        this.info = cQInfo;
        this.init();
        this.initGUI();
        this.startDate = this.info.getStartDate();
        this.endDate = this.info.getEndDate();
        this.updateGUI();
    }

    public long getCompetedTriggers() {
        return this.completedTriggers;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public long getTotalTriggers() {
        return this.totalTriggers;
    }

    private void init() {
        int n = this.info.getInterval();
        if (n <= 0) {
            n = 300;
        }
        long l = this.info.getStartDate().getTime();
        long l2 = this.info.getEndDate().getTime();
        long l3 = l2 - l;
        int n2 = (int)(l3 / 1000L);
        int n3 = n2 / n;
        this.totalTriggers = n3;
        long cfr_ignored_0 = System.currentTimeMillis() - l;
        int n4 = n2 / 1000;
        int n5 = n4 / n;
    }

    private void initGUI() {
        ((Container)((Object)this)).setLayout((LayoutManager)new BoxLayout((Container)((Object)this), 1));
        this.setMaximumSize(new Dimension(this.maxWidth, this.maxHeight));
        JPanel jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new BoxLayout((Container)jPanel, 0));
        JLabel jLabel = new JLabel("Execution Status for CQ " + this.info.getId());
        Font font = new Font("timesRoman", 1, 20);
        jLabel.setFont(font);
        jLabel.setForeground(Color.red);
        jPanel.add(Box.createHorizontalGlue());
        jPanel.add((Component)jLabel);
        jPanel.add(Box.createHorizontalGlue());
        ((Container)((Object)this)).add((Component)jPanel);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new BoxLayout((Container)jPanel2, 0));
        ((Container)((Object)this)).add((Component)jPanel2);
        JLabel jLabel2 = new JLabel("Start: ");
        jLabel2.setForeground(Color.black);
        this.startDateLabel = new JLabel(this.dateFormat.format(this.info.getStartDate()));
        this.startDateLabel.setBorder(BorderFactory.createRaisedBevelBorder());
        jPanel2.add((Component)jLabel2);
        jPanel2.add((Component)this.startDateLabel);
        jPanel2.add(Box.createHorizontalGlue());
        jPanel2.add(Box.createHorizontalStrut((int)25));
        jPanel2.add(Box.createHorizontalGlue());
        JLabel jLabel3 = new JLabel("End: ");
        jLabel3.setForeground(Color.black);
        this.endDateLabel = new JLabel(this.dateFormat.format(this.info.getEndDate()));
        this.endDateLabel.setBorder(BorderFactory.createRaisedBevelBorder());
        jPanel2.add((Component)jLabel3);
        jPanel2.add((Component)this.endDateLabel);
        ((Container)((Object)this)).add(Box.createVerticalGlue());
        ((Container)((Object)this)).add(Box.createVerticalStrut((int)25));
        ((Container)((Object)this)).add(Box.createVerticalGlue());
        long l = this.info.getStartDate().getTime();
        long l2 = this.info.getEndDate().getTime();
        long l3 = l2 - l;
        int n = this.info.getInterval();
        double cfr_ignored_0 = (double)l3 / (double)n / 1000.0;
        long l4 = System.currentTimeMillis();
        long l5 = l4 - l;
        double d = (double)l5 / (double)n / 1000.0;
        int n2 = (int)Math.round((double)(100L * l5) / (double)l3);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new BoxLayout((Container)jPanel3, 0));
        ((Container)((Object)this)).add((Component)jPanel3);
        this.progressBar = new JProgressBar();
        this.progressBar.setMaximum(100);
        this.progressBar.setMinimum(0);
        this.progressBar.setValue(n2);
        jPanel3.add(Box.createHorizontalGlue());
        jPanel3.add((Component)this.progressBar);
        this.percentLabel = new JLabel();
        if (n2 < 0) {
            this.percentLabel.setText("0% complete");
        } else if (n2 > 100) {
            this.percentLabel.setText("100% complete");
        } else {
            this.percentLabel.setText(n2 + "% complete");
        }
        jPanel3.add(Box.createHorizontalStrut((int)5));
        jPanel3.add((Component)this.percentLabel);
        jPanel3.add(Box.createHorizontalGlue());
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new BoxLayout((Container)jPanel4, 0));
        ((Container)((Object)this)).add((Component)jPanel4);
        JLabel jLabel4 = new JLabel("Trigger Tests Required: ");
        this.totalTriggerLabel = new JLabel(String.valueOf(this.totalTriggers));
        if (d < 0.0) {
            d = 0.0;
        }
        JLabel jLabel5 = new JLabel("Trigger Tests Completed: ");
        this.completedTriggerLabel = new JLabel(String.valueOf(this.completedTriggers));
        jPanel4.add((Component)jLabel4);
        jPanel4.add((Component)this.totalTriggerLabel);
        jPanel4.add(Box.createHorizontalGlue());
        jPanel4.add((Component)jLabel5);
        jPanel4.add((Component)this.completedTriggerLabel);
    }

    public static void main(String[] stringArray) {
        Date date = new Date();
        date.setYear(date.getYear() - 1);
        Date date2 = new Date();
        date2.setYear(date2.getYear() + 1);
        CQInfo cQInfo = new CQInfo("1023", date, date2, 1000);
        CQProgressPanel cQProgressPanel = new CQProgressPanel(cQInfo);
        JFrame jFrame = new JFrame();
        jFrame.getContentPane().add((Component)((Object)cQProgressPanel));
        jFrame.pack();
        jFrame.show();
    }

    public void setCompetedTriggers(int n) {
        this.completedTriggers = n;
        this.updateGUI();
    }

    public void setCompetedTriggers(long l) {
        this.completedTriggers = l;
        this.updateGUI();
    }

    public void setEndDate(Date date) {
        this.endDate = date;
        this.updateGUI();
    }

    public void setStartDate(Date date) {
        this.startDate = date;
        this.updateGUI();
    }

    public void setTotalTriggers(int n) {
        this.totalTriggers = n;
        this.updateGUI();
    }

    public void setTotalTriggers(long l) {
        this.totalTriggers = l;
        this.updateGUI();
    }

    private void updateGUI() {
        if (this.startDate != null) {
            this.startDateLabel.setText(this.dateFormat.format(this.startDate));
        }
        if (this.endDate != null) {
            this.endDateLabel.setText(this.dateFormat.format(this.endDate));
        }
    }
}

