/*
 * Decompiled with CFR 0.152.
 */
package ogi.cq.plugin.gui;

import com.sun.java.swing.table.AbstractTableModel;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import ogi.cq.plugin.CQInfo;

public class CQInfoTableModel
extends AbstractTableModel {
    public static final int SOURCE = 0;
    public static final int ID = 1;
    public static final int INSTALL = 2;
    public static final int COMPLETED = 3;
    public static final int STATUS = 4;
    public static final int COLUMN_COUNT = 5;
    Vector cqinfo;
    Hashtable infoTable = new Hashtable();
    SimpleDateFormat dateFormat = new SimpleDateFormat();

    public CQInfoTableModel() {
        this.dateFormat.applyPattern("yyyy / MM / dd");
    }

    public CQInfoTableModel(Vector vector) {
        this();
        if (vector == null) {
            throw new IllegalArgumentException("Vector can't be null");
        }
        this.cqinfo = vector;
        int n = 0;
        while (n < this.cqinfo.size()) {
            CQInfo cQInfo = (CQInfo)this.cqinfo.elementAt(n);
            String string = cQInfo.getId();
            if (string == null) {
                throw new IllegalArgumentException("CQInfo ID can't be null");
            }
            this.infoTable.put(string, cQInfo);
            ++n;
        }
    }

    public void clear() {
        this.cqinfo = new Vector();
        this.fireTableRowsDeleted(0, 0);
    }

    public Class getColumnClass(int n) {
        return "".getClass();
    }

    public int getColumnCount() {
        return 5;
    }

    public String getColumnName(int n) {
        switch (n) {
            case 0: {
                return "Source";
            }
            case 1: {
                return "CQ ID";
            }
            case 2: {
                return "Install Date";
            }
            case 3: {
                return "Completed";
            }
            case 4: {
                return "Status";
            }
        }
        return "";
    }

    public Vector getCQInfo() {
        return this.cqinfo;
    }

    public CQInfo getCQInfo(String string) {
        return (CQInfo)this.infoTable.get(string);
    }

    public int getRowCount() {
        if (this.cqinfo != null) {
            return this.cqinfo.size();
        }
        return 0;
    }

    public Object getValueAt(int n, int n2) {
        CQInfo cQInfo = (CQInfo)this.cqinfo.elementAt(n);
        switch (n2) {
            case 0: {
                return cQInfo.getSources();
            }
            case 1: {
                return cQInfo.getId();
            }
            case 2: {
                Date date = cQInfo.getStartDate();
                return this.dateFormat.format(date);
            }
            case 3: {
                long l = cQInfo.getStartDate().getTime();
                long l2 = cQInfo.getEndDate().getTime();
                long l3 = l2 - l;
                long l4 = System.currentTimeMillis();
                long l5 = l4 - l;
                long l6 = 0L;
                if (l3 != 0L) {
                    l6 = Math.round((double)(100L * l5) / (double)l3);
                }
                String string = null;
                string = l6 < 0L ? "0%" : (l6 > 100L ? "100%" : l6 + "%");
                if (string.length() == 2) {
                    string = "  " + string;
                }
                if (string.length() == 3) {
                    string = " " + string;
                }
                return string;
            }
            case 4: {
                return String.valueOf(cQInfo.getStatus());
            }
        }
        return "";
    }

    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    public void setCQInfo(Vector vector) {
        this.cqinfo = vector;
        this.infoTable.clear();
        int n = 0;
        while (n < this.cqinfo.size()) {
            CQInfo cQInfo = (CQInfo)this.cqinfo.elementAt(n);
            String string = cQInfo.getId();
            if (string == null) {
                throw new IllegalArgumentException("CQInfo ID can't be null");
            }
            this.infoTable.put(string, cQInfo);
            ++n;
        }
        this.fireTableStructureChanged();
    }
}

