/*
 * Decompiled with CFR 0.152.
 */
package ogi.cq.plugin.gui;

import com.objectspace.jgl.OrderedMap;
import com.sun.java.swing.BorderFactory;
import com.sun.java.swing.Box;
import com.sun.java.swing.BoxLayout;
import com.sun.java.swing.JButton;
import com.sun.java.swing.JCheckBox;
import com.sun.java.swing.JFrame;
import com.sun.java.swing.JLabel;
import com.sun.java.swing.JPanel;
import com.sun.java.swing.JTabbedPane;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Vector;
import javachart.chart.AreaChart;
import javachart.chart.Background;
import javachart.chart.Chart;
import javachart.chart.Dataset;
import javachart.chart.Gc;
import javachart.chart.LineChart;
import ogi.cq.plugin.CQExecution;
import ogi.cq.plugin.CQInfo;
import ogi.cq.plugin.IContinualQueryPlugin;
import ogi.cq.plugin.gui.CQProgressPanel;
import ogi.cq.plugin.gui.GraphPanel;

public class CQHistoryPanel
extends JPanel
implements ActionListener {
    IContinualQueryPlugin plugin;
    String cqid;
    CQInfo info;
    CQProgressPanel infoPanel;
    double[] x;
    double[] y;
    double[] y1;
    double[] y2;
    double[] y3;
    double[] y4;
    double[] y5;
    double[] y6;
    double[] y7;
    double[] y8;
    JFrame parent;
    Vector history;
    String userId;
    JLabel userIDLabel;
    JTabbedPane tabPane;
    JPanel overviewChart;
    JPanel evalChart;
    JPanel systemChart;
    JPanel triggerChart;
    JPanel queryChart;
    JPanel notificationChart;
    JPanel externalChart;
    JPanel cpuLoadChart1;
    JPanel cpuLoadChart2;
    JPanel cpuLoadChart3;
    GraphPanel[] chartArray;
    JButton closeButton;
    JButton refreshButton;
    JButton colorButton;
    int currentColor = 0;
    JButton scaleButton;
    int currentScale = -1;
    JCheckBox threeDCheckbox;
    boolean twoD = true;
    public static final Color[] colors = new Color[]{Color.blue, Color.green, Color.black, Color.yellow, Color.pink, Color.orange, Color.red, Color.magenta, Color.cyan, Color.gray};
    public static final int[] scales = new int[]{10, 15, 20, 50, 100, 250, 500, 1000};
    public static final int DEFAULT_HISTORY_COUNT = 500;
    private int count = 500;

    public CQHistoryPanel(IContinualQueryPlugin iContinualQueryPlugin, String string, CQInfo cQInfo, int n, JFrame jFrame) {
        this.plugin = iContinualQueryPlugin;
        this.cqid = string;
        this.info = cQInfo;
        this.parent = jFrame;
        this.count = n;
        this.history = new Vector();
        this.init();
    }

    public CQHistoryPanel(IContinualQueryPlugin iContinualQueryPlugin, String string, CQInfo cQInfo, JFrame jFrame) {
        this(iContinualQueryPlugin, string, cQInfo, 500, jFrame);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        block14: {
            GraphPanel[] graphPanelArray;
            if (actionEvent.getSource() == this.closeButton) {
                this.parent.setVisible(false);
            } else if (actionEvent.getSource() == this.refreshButton) {
                System.out.println("Refresh information is unavailable");
            } else if (actionEvent.getSource() == this.threeDCheckbox) {
                this.twoD = this.threeDCheckbox.isSelected();
                graphPanelArray = this.getCharts();
                int n = 0;
                while (n < graphPanelArray.length) {
                    graphPanelArray[n].setThreeD(this.twoD);
                    this.setChartColors(graphPanelArray[n].getChart(), Color.black, colors[this.currentColor]);
                    ((Component)((Object)graphPanelArray[n])).repaint();
                    ++n;
                }
                GraphPanel graphPanel = (GraphPanel)this.getOverviewChart();
                graphPanel.setThreeD(this.twoD);
            }
            if (actionEvent.getSource() == this.colorButton) {
                this.currentColor = (this.currentColor + 1) % colors.length;
                graphPanelArray = this.getCharts();
                int n = 0;
                while (n < graphPanelArray.length) {
                    this.setChartColors(graphPanelArray[n].getChart(), Color.black, colors[this.currentColor]);
                    ((Component)((Object)graphPanelArray[n])).repaint();
                    ++n;
                }
            }
            if (actionEvent.getSource() != this.scaleButton) break block14;
            ++this.currentScale;
            if (this.currentScale > 0) {
                this.currentScale = -1;
                graphPanelArray = this.getCharts();
                int n = 0;
                while (n < graphPanelArray.length - 3) {
                    graphPanelArray[n].getChart().getYAxis().scale();
                    graphPanelArray[n].getChart().getYAxis().setAxisStart(0.0);
                    ((Component)((Object)graphPanelArray[n])).repaint();
                    ++n;
                }
            } else {
                double d = 10.0;
                GraphPanel graphPanel = (GraphPanel)this.getEvalChart();
                Chart chart = graphPanel.getChart();
                Dataset[] datasetArray = chart.getDatasets();
                int n = 0;
                while (n < datasetArray.length) {
                    if (datasetArray[n] != null) {
                        d = Math.max(d, datasetArray[n].maxY());
                    }
                    ++n;
                }
                d *= 1.1;
                d = Math.round(d);
                GraphPanel[] graphPanelArray2 = this.getCharts();
                int n2 = 0;
                while (n2 < graphPanelArray2.length - 3) {
                    chart = graphPanelArray2[n2].getChart();
                    chart.getYAxis().setAxisEnd(d);
                    chart.getYAxis().setAxisStart(0.0);
                    ((Component)((Object)graphPanelArray2[n2])).repaint();
                    ++n2;
                }
            }
        }
    }

    private void fiddleChart(Chart chart) {
        chart.setThreeD(false);
        Background background = chart.getBackground();
        background.setTitleColor(Color.blue);
        Gc gc = background.getGc();
        gc.setLineColor(Color.red);
        gc.setMarkerColor(Color.green);
        gc.setFillColor(Color.gray);
        chart.getXAxis().setTitleString("CQ Evaluation Number");
        chart.getYAxis().setLabelAngle(270);
        chart.getYAxis().setTitleRotated(true);
        chart.getYAxis().setAxisStart(Math.min(chart.getYAxis().getAxisStart(), 0.0));
        chart.getYAxis().scale();
        chart.getYAxis().setLabelPrecision(1);
        chart.getYAxis().setAutoScale(false);
        chart.getYAxis().setAxisStart(Math.min(chart.getYAxis().getAxisStart(), 0.0));
        chart.getYAxis().setNumMajTicks(4);
        chart.getYAxis().setMajTickLength(1);
        chart.getYAxis().setLabelAngle(90);
        chart.getXAxis().scale();
        chart.getXAxis().setAutoScale(false);
        chart.getXAxis().setAxisStart(0.0);
        chart.getXAxis().setMajTickLength(1);
    }

    public GraphPanel[] getCharts() {
        if (this.chartArray == null) {
            this.chartArray = new GraphPanel[9];
            this.chartArray[0] = (GraphPanel)this.getSystemChart();
            this.chartArray[1] = (GraphPanel)this.getEvalChart();
            this.chartArray[2] = (GraphPanel)this.getTriggerChart();
            this.chartArray[3] = (GraphPanel)this.getQueryChart();
            this.chartArray[4] = (GraphPanel)this.getExternalChart();
            this.chartArray[5] = (GraphPanel)this.getNotificationChart();
            this.chartArray[6] = (GraphPanel)this.getCPULoadChart1();
            this.chartArray[7] = (GraphPanel)this.getCPULoadChart2();
            this.chartArray[8] = (GraphPanel)this.getCPULoadChart3();
        }
        return this.chartArray;
    }

    public int getCount() {
        return this.count;
    }

    public JPanel getCPULoadChart1() {
        if (this.cpuLoadChart1 == null) {
            LineChart lineChart = new LineChart("CQ Trigger Execution History");
            this.cpuLoadChart1 = new GraphPanel((Chart)lineChart);
            Dataset dataset = new Dataset("CQ Trigger History", this.x, this.y6, lineChart.getGlobals());
            lineChart.addDataset(dataset);
            this.setChartColors((Chart)lineChart, Color.blue, Color.black);
            lineChart.getBackground().setTitleString("CPU Load average last minute");
            this.fiddleChart((Chart)lineChart);
        }
        return this.cpuLoadChart1;
    }

    public JPanel getCPULoadChart2() {
        if (this.cpuLoadChart2 == null) {
            LineChart lineChart = new LineChart("CQ Trigger Execution History");
            this.cpuLoadChart2 = new GraphPanel((Chart)lineChart);
            Dataset dataset = new Dataset("CQ Trigger History", this.x, this.y7, lineChart.getGlobals());
            lineChart.addDataset(dataset);
            this.setChartColors((Chart)lineChart, Color.blue, Color.black);
            lineChart.getBackground().setTitleString("CPU Load average last 5 minutes");
            this.fiddleChart((Chart)lineChart);
        }
        return this.cpuLoadChart2;
    }

    public JPanel getCPULoadChart3() {
        if (this.cpuLoadChart3 == null) {
            LineChart lineChart = new LineChart("CQ Trigger Execution History");
            this.cpuLoadChart3 = new GraphPanel((Chart)lineChart);
            Dataset dataset = new Dataset("CQ Trigger History", this.x, this.y8, lineChart.getGlobals());
            lineChart.addDataset(dataset);
            this.setChartColors((Chart)lineChart, Color.blue, Color.black);
            lineChart.getBackground().setTitleString("CPU Load average last 15 minutes");
            this.fiddleChart((Chart)lineChart);
        }
        return this.cpuLoadChart3;
    }

    public JPanel getEvalChart() {
        if (this.evalChart == null) {
            LineChart lineChart = new LineChart("CQ Execution History");
            this.evalChart = new GraphPanel((Chart)lineChart);
            Dataset dataset = new Dataset("CQ Evaluation History", this.x, this.y, lineChart.getGlobals());
            lineChart.addDataset(dataset);
            this.setChartColors((Chart)lineChart, Color.blue, Color.black);
            lineChart.getBackground().setTitleString("Total Time (msec)");
            this.fiddleChart((Chart)lineChart);
        }
        return this.evalChart;
    }

    public JPanel getExternalChart() {
        if (this.externalChart == null) {
            LineChart lineChart = new LineChart("CQ External Wrapper History");
            this.externalChart = new GraphPanel((Chart)lineChart);
            Dataset dataset = new Dataset("CQ Trigger History", this.x, this.y4, lineChart.getGlobals());
            lineChart.addDataset(dataset);
            this.setChartColors((Chart)lineChart, Color.blue, Color.black);
            lineChart.getBackground().setTitleString("External Wrapper Time (msec)");
            this.fiddleChart((Chart)lineChart);
        }
        return this.externalChart;
    }

    public JPanel getNotificationChart() {
        if (this.notificationChart == null) {
            LineChart lineChart = new LineChart("CQ Notification History");
            this.notificationChart = new GraphPanel((Chart)lineChart);
            Dataset dataset = new Dataset("CQ Evaluation History", this.x, this.y5, lineChart.getGlobals());
            lineChart.addDataset(dataset);
            this.setChartColors((Chart)lineChart, Color.blue, Color.black);
            lineChart.getBackground().setTitleString("Notification Time (msec)");
            this.fiddleChart((Chart)lineChart);
        }
        return this.notificationChart;
    }

    public JPanel getOverviewChart() {
        if (this.overviewChart == null) {
            AreaChart areaChart = new AreaChart("CQ Execution History Overview");
            this.overviewChart = new GraphPanel((Chart)areaChart);
            Dataset dataset = new Dataset("CQ System Time", this.x, this.y1, areaChart.getGlobals());
            dataset.getGc().setFillColor(Color.blue);
            Dataset dataset2 = new Dataset("CQ Trigger Time", this.x, this.y2, areaChart.getGlobals());
            dataset2.getGc().setFillColor(Color.green);
            Dataset dataset3 = new Dataset("CQ Query Time", this.x, this.y3, areaChart.getGlobals());
            dataset3.getGc().setFillColor(Color.red);
            Dataset dataset4 = new Dataset("CQ External Time", this.x, this.y4, areaChart.getGlobals());
            dataset4.getGc().setFillColor(Color.magenta);
            Dataset dataset5 = new Dataset("CQ Notification Time", this.x, this.y5, areaChart.getGlobals());
            dataset5.getGc().setFillColor(Color.cyan);
            areaChart.addDataSet("System overhead", this.y1);
            areaChart.addDataSet("External time", this.y4);
            areaChart.addDataSet("Trigger time", this.y2);
            areaChart.addDataSet("Query time", this.y3);
            areaChart.addDataSet("Notification time", this.y5);
            Dataset[] datasetArray = new Dataset[]{dataset, dataset2, dataset3, dataset4, dataset5};
            double d = dataset.maxY();
            d += dataset2.maxY();
            d += dataset3.maxY();
            d += dataset4.maxY();
            d += dataset5.maxY();
            areaChart.getBackground().setTitleString("Total Time (msec)");
            areaChart.setLegendVisible(true);
            areaChart.getLegend().setVerticalLayout(false);
            areaChart.getLegend().getLlX();
            areaChart.getLegend().getLlY();
            areaChart.getLegend().getUrX();
            areaChart.getLegend().setUrY();
            areaChart.getLegend().setLlX(0.0);
            areaChart.getLegend().setLlY(0.0);
            areaChart.setThreeD(false);
            Background background = areaChart.getBackground();
            background.setTitleColor(Color.blue);
            Gc gc = background.getGc();
            gc.setLineColor(Color.red);
            gc.setMarkerColor(Color.green);
            gc.setFillColor(Color.gray);
            areaChart.getXAxis().setTitleString("CQ Evaluation Number");
            areaChart.getYAxis().scale();
            areaChart.getYAxis().setLabelPrecision(1);
            areaChart.getYAxis().setAutoScale(false);
            areaChart.getYAxis().setAxisStart(Math.min(areaChart.getYAxis().getAxisStart(), 0.0));
            areaChart.getYAxis().setNumMajTicks(4);
            areaChart.getYAxis().setMajTickLength(1);
            areaChart.getYAxis().setLabelAngle(90);
            areaChart.getXAxis().scale();
            areaChart.getXAxis().setAutoScale(false);
            areaChart.getXAxis().setAxisStart(0.0);
            areaChart.getXAxis().setMajTickLength(1);
            areaChart.getXAxis().setNumMajTicks(10);
            areaChart.getXAxis().setLabelVis(false);
        }
        return this.overviewChart;
    }

    public JPanel getQueryChart() {
        if (this.queryChart == null) {
            LineChart lineChart = new LineChart("CQ Query History");
            this.queryChart = new GraphPanel((Chart)lineChart);
            Dataset dataset = new Dataset("CQ Query History", this.x, this.y3, lineChart.getGlobals());
            lineChart.addDataset(dataset);
            this.setChartColors((Chart)lineChart, Color.blue, Color.black);
            lineChart.getBackground().setTitleString("Query Time (msec)");
            this.fiddleChart((Chart)lineChart);
        }
        return this.queryChart;
    }

    public JPanel getSystemChart() {
        if (this.systemChart == null) {
            LineChart lineChart = new LineChart("CQ System overhead History");
            this.systemChart = new GraphPanel((Chart)lineChart);
            Dataset dataset = new Dataset("CQ System Overhead History", this.x, this.y1, lineChart.getGlobals());
            lineChart.addDataset(dataset);
            this.setChartColors((Chart)lineChart, Color.blue, Color.black);
            lineChart.getBackground().setTitleString("System overhead Time (msec)");
            this.fiddleChart((Chart)lineChart);
        }
        return this.systemChart;
    }

    public JPanel getTriggerChart() {
        if (this.triggerChart == null) {
            LineChart lineChart = new LineChart("CQ Trigger Execution History");
            this.triggerChart = new GraphPanel((Chart)lineChart);
            Dataset dataset = new Dataset("CQ Trigger History", this.x, this.y2, lineChart.getGlobals());
            lineChart.addDataset(dataset);
            this.setChartColors((Chart)lineChart, Color.blue, Color.black);
            lineChart.getBackground().setTitleString("Trigger Time (msec)");
            this.fiddleChart((Chart)lineChart);
        }
        return this.triggerChart;
    }

    private void init() {
        JPanel jPanel;
        ((Container)((Object)this)).setLayout((LayoutManager)new BoxLayout((Container)((Object)this), 1));
        this.infoPanel = new CQProgressPanel(this.info);
        this.infoPanel.setBorder(BorderFactory.createEtchedBorder());
        ((Container)((Object)this)).add((Component)((Object)this.infoPanel));
        this.initHistory();
        if (this.history != null && this.history.size() > 0) {
            this.tabPane = new JTabbedPane();
            ((Container)((Object)this)).add((Component)this.tabPane);
            jPanel = new JPanel();
            jPanel.setLayout((LayoutManager)new BoxLayout((Container)jPanel, 1));
            this.tabPane.add("Overview", (Component)jPanel);
            jPanel.add((Component)this.getOverviewChart());
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout((LayoutManager)new BoxLayout((Container)jPanel2, 1));
            this.tabPane.add("Page 1", (Component)jPanel2);
            jPanel2.add((Component)this.getEvalChart());
            jPanel2.add((Component)this.getSystemChart());
            JPanel jPanel3 = new JPanel();
            jPanel3.setLayout((LayoutManager)new BoxLayout((Container)jPanel3, 1));
            this.tabPane.add("Page 2", (Component)jPanel3);
            jPanel3.add((Component)this.getTriggerChart());
            jPanel3.add((Component)this.getQueryChart());
            JPanel jPanel4 = new JPanel();
            jPanel4.setLayout((LayoutManager)new BoxLayout((Container)jPanel4, 1));
            this.tabPane.add("Page 3", (Component)jPanel4);
            jPanel4.add((Component)this.getExternalChart());
            jPanel4.add((Component)this.getNotificationChart());
            JPanel jPanel5 = new JPanel();
            jPanel5.setLayout((LayoutManager)new BoxLayout((Container)jPanel5, 1));
            this.tabPane.add("CPU Load", (Component)jPanel5);
            jPanel5.add((Component)this.getCPULoadChart1());
            jPanel5.add((Component)this.getCPULoadChart2());
            jPanel5.add((Component)this.getCPULoadChart3());
        }
        jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new BoxLayout((Container)jPanel, 0));
        ((Container)((Object)this)).add((Component)jPanel);
        this.refreshButton = new JButton("Refresh");
        this.refreshButton.setBackground(Color.green);
        this.refreshButton.addActionListener((ActionListener)this);
        this.colorButton = new JButton("Color");
        this.colorButton.addActionListener((ActionListener)this);
        this.threeDCheckbox = new JCheckBox("3D");
        this.threeDCheckbox.setSelected(false);
        this.threeDCheckbox.addActionListener((ActionListener)this);
        this.scaleButton = new JButton("Scale");
        this.scaleButton.setBackground(Color.yellow);
        this.scaleButton.addActionListener((ActionListener)this);
        this.closeButton = new JButton("Close");
        this.closeButton.setBackground(Color.red);
        this.closeButton.addActionListener((ActionListener)this);
        jPanel.add((Component)this.colorButton);
        jPanel.add(Box.createHorizontalGlue());
        jPanel.add((Component)this.threeDCheckbox);
        jPanel.add(Box.createHorizontalGlue());
        jPanel.add((Component)this.scaleButton);
        jPanel.add(Box.createHorizontalGlue());
        jPanel.add((Component)this.closeButton);
        this.parent.getContentPane().add((Component)((Object)this));
        this.parent.setTitle("Execution history for CQ " + this.cqid);
        this.parent.pack();
        if (this.parent.getSize().width < 640) {
            this.parent.setSize(640, 600);
        }
    }

    private void initArrays() {
        OrderedMap orderedMap = new OrderedMap();
        int n = 0;
        while (n < this.history.size()) {
            CQExecution cQExecution = (CQExecution)this.history.elementAt(n);
            orderedMap.put((Object)new Integer(cQExecution.getEvaluationNumber()), (Object)cQExecution);
            ++n;
        }
        this.x = new double[this.history.size()];
        this.y = new double[this.history.size()];
        this.y1 = new double[this.history.size()];
        this.y2 = new double[this.history.size()];
        this.y3 = new double[this.history.size()];
        this.y4 = new double[this.history.size()];
        this.y5 = new double[this.history.size()];
        this.y6 = new double[this.history.size()];
        this.y7 = new double[this.history.size()];
        this.y8 = new double[this.history.size()];
        Enumeration enumeration = orderedMap.keys();
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            CQExecution cQExecution = (CQExecution)orderedMap.get(e);
            int n3 = (Integer)e;
            long l = cQExecution.getEvaluationStart();
            long l2 = cQExecution.getEvaluationEnd();
            this.x[n2] = n3;
            this.y[n2] = l <= 0L || l > l2 ? 0.0 : (double)(l2 - l);
            l = cQExecution.getTriggerStart();
            l2 = cQExecution.getTriggerEnd();
            this.y2[n2] = l <= 0L || l > l2 ? 0.0 : (double)(l2 - l);
            l = cQExecution.getQueryStart();
            l2 = cQExecution.getQueryEnd();
            this.y3[n2] = l <= 0L || l > l2 ? 0.0 : (double)(l2 - l);
            l = cQExecution.getExtTime();
            this.y4[n2] = l <= 0L ? 0.0 : (double)l;
            l = cQExecution.getNotifyStart();
            l2 = cQExecution.getNotifyEnd();
            this.y5[n2] = l <= 0L || l > l2 ? 0.0 : (double)(l2 - l);
            this.y1[n2] = this.y[n2] - this.y2[n2] - this.y3[n2] - this.y4[n2] - this.y5[n2];
            if (this.y1[n2] < 0.0) {
                this.y1[n2] = 0.0;
            }
            String string = cQExecution.getStartUpTime();
            double d = -1.0;
            double d2 = -1.0;
            double d3 = -1.0;
            int n4 = string.indexOf("load");
            try {
                int n5 = n4 + 13;
                int n6 = string.indexOf(",", n5);
                d = Double.valueOf(string.substring(n5, n6));
                n5 = n6 + 1;
                n6 = string.indexOf(",", n5);
                d2 = Double.valueOf(string.substring(n5, n6));
                n5 = n6 + 1;
                n6 = string.length();
                d3 = Double.valueOf(string.substring(n5, n6));
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println("error in parsing up time: " + numberFormatException);
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {}
            this.y6[n2] = d;
            this.y7[n2] = d2;
            this.y8[n2] = d3;
            ++n2;
        }
    }

    private void initHistory() {
        this.history = this.plugin.getIndividualCQHistory(this.cqid, this.count);
        try {
            CQExecution cQExecution = (CQExecution)this.history.elementAt(0);
            if (cQExecution != null) {
                this.userId = cQExecution.getUserId();
            }
        }
        catch (Exception exception) {}
        this.overviewChart = null;
        this.evalChart = null;
        this.systemChart = null;
        this.triggerChart = null;
        this.queryChart = null;
        this.notificationChart = null;
        this.externalChart = null;
        this.cpuLoadChart1 = null;
        this.cpuLoadChart2 = null;
        this.cpuLoadChart3 = null;
        if (this.history != null) {
            this.initArrays();
        }
    }

    private void setChartColors(Chart chart, Color color, Color color2) {
        Dataset[] datasetArray = chart.getDatasets();
        if (datasetArray != null) {
            int n = 0;
            while (n < datasetArray.length) {
                Dataset dataset = datasetArray[n];
                if (dataset != null) {
                    Gc gc = dataset.getGc();
                    if (gc == null) {
                        gc = new Gc(chart.getGlobals());
                        dataset.setGc(gc);
                    }
                    if (!this.twoD) {
                        gc.setLineColor(color2);
                        gc.setFillColor(color);
                    } else {
                        gc.setLineColor(color);
                        gc.setFillColor(color2);
                    }
                }
                ++n;
            }
        }
    }

    public void setCount(int n) {
        this.count = n;
    }
}

