/*
 * Decompiled with CFR 0.152.
 */
package ogi.cq.plugin.gui;

import com.sun.java.swing.BorderFactory;
import com.sun.java.swing.Box;
import com.sun.java.swing.BoxLayout;
import com.sun.java.swing.JButton;
import com.sun.java.swing.JFrame;
import com.sun.java.swing.JLabel;
import com.sun.java.swing.JPanel;
import com.sun.java.swing.JScrollPane;
import com.sun.java.swing.JTextArea;
import com.sun.java.swing.JTextField;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import ogi.cq.plugin.CQInfo;
import ogi.diom.util.GUI;

public class CQDefinitionPanel
extends JFrame
implements ActionListener {
    CQInfo info;
    JTextField id;
    JTextField name;
    JTextArea query;
    JTextArea trigger;
    JTextField stopDate;
    JTextField installDate;
    JButton closeButton;
    JButton helpButton;
    JButton helpCloseButton;
    JFrame help;
    SimpleDateFormat formater;
    public static final String NEW_LINE = System.getProperty("line.separator");

    public CQDefinitionPanel() {
        this.init();
    }

    public CQDefinitionPanel(String string) {
        super(string);
        this.init();
    }

    public CQDefinitionPanel(String string, CQInfo cQInfo) {
        this(string);
        this.setInfo(cQInfo);
    }

    public CQDefinitionPanel(CQInfo cQInfo) {
        this();
        this.setInfo(cQInfo);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.closeButton) {
            ((Component)((Object)this)).setVisible(false);
        } else if (actionEvent.getSource() == this.helpButton) {
            this.getHelp().setVisible(true);
        } else if (actionEvent.getSource() == this.helpCloseButton) {
            this.help.setVisible(false);
        }
    }

    public JFrame getHelp() {
        if (this.help == null) {
            String string = "Help -- CQ Definition";
            this.help = new JFrame(string);
            JPanel jPanel = (JPanel)this.help.getContentPane();
            jPanel.setLayout(new BorderLayout());
            Font font = new Font("timesRoman", 1, 20);
            JLabel jLabel = new JLabel(string);
            jLabel.setFont(font);
            jLabel.setForeground(Color.blue);
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new FlowLayout());
            jPanel2.add((Component)jLabel);
            jPanel.add("North", (Component)jPanel2);
            JTextArea jTextArea = new JTextArea();
            jTextArea.setBackground(Color.lightGray);
            jTextArea.setEditable(false);
            jTextArea.append("This window describes a continual query. ");
            jTextArea.append(NEW_LINE);
            jTextArea.append(NEW_LINE);
            jTextArea.append("There are six main parts to a CQ. First, there ");
            jTextArea.append("is the CQ ID.  This is system-assigned and unique.  ");
            jTextArea.append("Second, is the name.  This is user-defined and is not part of the CQ's internal semantics. ");
            jTextArea.append("Third is the query.  This is the information that the user is interested in monitoring. ");
            jTextArea.append("The trigger definition is fourth.  It can either be a content-based trigger or a time-based trigger. ");
            jTextArea.append("Time-based triggers look like a series of numbers separated by '&'.  These ");
            jTextArea.append("correspond to times that the query should be fired to check for new information. ");
            jTextArea.append("Content-based CQ's look somewhat like a query.  It specifies a condition based on ");
            jTextArea.append("data changing.  The query is fired when the content condition is satisfied. ");
            jTextArea.append("Next is the stop condition.  This is the date when the query will cease being fired. ");
            jTextArea.append("Finally, the install date is the date when the query was installed. ");
            jTextArea.append(NEW_LINE);
            jTextArea.append(NEW_LINE);
            jTextArea.append("For further information on what a CQ is and its semantics, please see ");
            jTextArea.append("the CQ home page at ");
            jTextArea.append(NEW_LINE);
            jTextArea.append("http://www.cse.ogi.edu/DISC/CQ ");
            jTextArea.setLineWrap(true);
            jTextArea.setWrapStyleWord(true);
            JScrollPane jScrollPane = new JScrollPane((Component)jTextArea);
            jScrollPane.setVerticalScrollBarPolicy(22);
            jScrollPane.setHorizontalScrollBarPolicy(31);
            jScrollPane.setPreferredSize(new Dimension(250, 250));
            jPanel.add("Center", (Component)jScrollPane);
            Font font2 = new Font("timesRoman", 0, 15);
            jTextArea.setFont(font2);
            JPanel jPanel3 = new JPanel();
            jPanel3.setLayout(new FlowLayout());
            this.helpCloseButton = new JButton("Close");
            this.helpCloseButton.setBackground(Color.red);
            this.helpCloseButton.addActionListener((ActionListener)this);
            jPanel3.add((Component)this.helpCloseButton);
            jPanel.add("South", (Component)jPanel3);
            this.help.setSize(640, 400);
        }
        return this.help;
    }

    public CQInfo getInfo() {
        return this.info;
    }

    private void init() {
        JPanel jPanel = (JPanel)this.getContentPane();
        jPanel.setLayout(new BorderLayout());
        JLabel jLabel = new JLabel("CQ Definition");
        jLabel.setForeground(Color.blue);
        Font font = new Font("timesRoman", 1, 20);
        jLabel.setFont(font);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout());
        jPanel2.add((Component)jLabel);
        jPanel.add("North", (Component)jPanel2);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridBagLayout());
        jPanel3.setBorder(BorderFactory.createEtchedBorder());
        jPanel.add("Center", (Component)jPanel3);
        JLabel jLabel2 = new JLabel("ID:");
        jLabel2.setForeground(Color.black);
        GUI.add((Container)jPanel3, (Component)jLabel2, 1, 1, 1, 1, 0, 17, 0.0, 25.0);
        this.id = new JTextField("");
        this.id.setForeground(Color.blue);
        this.id.setBackground(Color.white);
        GUI.add((Container)jPanel3, (Component)this.id, 2, 1, 1, 1, 2, 17, 10.0, 30.0);
        JLabel jLabel3 = new JLabel("Name:");
        jLabel3.setForeground(Color.black);
        GUI.add((Container)jPanel3, (Component)jLabel3, 1, 2, 1, 1, 0, 17, 0.0, 25.0);
        this.name = new JTextField("");
        this.name.setForeground(Color.blue);
        this.name.setBackground(Color.white);
        GUI.add((Container)jPanel3, (Component)this.name, 2, 2, 1, 1, 2, 17, 0.0, 30.0);
        JLabel jLabel4 = new JLabel("Query:");
        jLabel4.setForeground(Color.black);
        GUI.add((Container)jPanel3, (Component)jLabel4, 1, 3, 1, 1, 0, 17, 0.0, 25.0);
        this.query = new JTextArea("");
        this.query.setForeground(Color.blue);
        this.query.setBackground(Color.white);
        this.query.setLineWrap(true);
        this.query.setWrapStyleWord(true);
        JScrollPane jScrollPane = new JScrollPane((Component)this.query);
        jScrollPane.setVerticalScrollBarPolicy(22);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jScrollPane.setPreferredSize(new Dimension(250, 50));
        GUI.add((Container)jPanel3, (Component)jScrollPane, 2, 3, 1, 3, 2, 17, 0.0, 30.0);
        JLabel jLabel5 = new JLabel("Trigger:");
        jLabel5.setForeground(Color.black);
        GUI.add((Container)jPanel3, (Component)jLabel5, 1, 6, 1, 1, 0, 17, 0.0, 25.0);
        this.trigger = new JTextArea("");
        this.trigger.setForeground(Color.blue);
        this.trigger.setBackground(Color.white);
        this.trigger.setLineWrap(true);
        this.trigger.setWrapStyleWord(true);
        JScrollPane jScrollPane2 = new JScrollPane((Component)this.trigger);
        jScrollPane2.setVerticalScrollBarPolicy(22);
        jScrollPane2.setHorizontalScrollBarPolicy(31);
        jScrollPane2.setPreferredSize(new Dimension(250, 50));
        GUI.add((Container)jPanel3, (Component)jScrollPane2, 2, 6, 1, 3, 2, 17, 0.0, 30.0);
        JLabel jLabel6 = new JLabel("Stop:");
        jLabel6.setForeground(Color.black);
        GUI.add((Container)jPanel3, (Component)jLabel6, 1, 9, 1, 1, 0, 17, 0.0, 25.0);
        this.stopDate = new JTextField("");
        this.stopDate.setForeground(Color.blue);
        this.stopDate.setBackground(Color.white);
        GUI.add((Container)jPanel3, (Component)this.stopDate, 2, 9, 1, 1, 2, 17, 0.0, 30.0);
        JLabel jLabel7 = new JLabel("installDate:");
        jLabel7.setForeground(Color.black);
        GUI.add((Container)jPanel3, (Component)jLabel7, 1, 10, 1, 1, 0, 17, 0.0, 25.0);
        this.installDate = new JTextField("");
        this.installDate.setForeground(Color.blue);
        this.installDate.setBackground(Color.white);
        GUI.add((Container)jPanel3, (Component)this.installDate, 2, 10, 1, 1, 2, 17, 0.0, 30.0);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new BoxLayout((Container)jPanel4, 0));
        jPanel.add("South", (Component)jPanel4);
        this.helpButton = new JButton("Help");
        this.helpButton.setBackground(Color.green);
        this.helpButton.addActionListener((ActionListener)this);
        jPanel4.add((Component)this.helpButton);
        jPanel4.add(Box.createHorizontalGlue());
        this.closeButton = new JButton("Close");
        this.closeButton.setBackground(Color.red);
        this.closeButton.addActionListener((ActionListener)this);
        jPanel4.add((Component)this.closeButton);
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("test");
        jFrame.setContentPane((Container)((Object)new CQDefinitionPanel()));
        jFrame.pack();
        jFrame.show();
    }

    public void setInfo(CQInfo cQInfo) {
        this.info = cQInfo;
        if (cQInfo == null) {
            return;
        }
        this.id.setText(this.info.getId());
        this.name.setText(this.info.getName());
        this.query.setText(this.info.getQuery());
        this.trigger.setText(this.info.getTrigger());
        if (this.formater == null) {
            this.formater = new SimpleDateFormat();
        }
        this.stopDate.setText(this.formater.format(this.info.getEndDate()));
        this.installDate.setText(this.formater.format(this.info.getStartDate()));
        ((Frame)((Object)this)).setTitle("CQ Definition for " + this.info.getId());
    }
}

