/*
 * Decompiled with CFR 0.152.
 */
package ogi.cq.plugin.gui;

import ice.htmlbrowser.Browser;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Stack;

public class BrowserFrame
extends Frame
implements PropertyChangeListener,
ActionListener,
WindowListener {
    Browser document;
    Button closeButton;
    Button backButton;
    Button nextButton;
    Button reloadButton;
    Button goButton;
    TextField addressBar;
    Label status;
    private String location;
    Stack history;
    Stack future;
    int currentLoc;
    int backSize;
    int backLoc;
    int forwardSize;
    int forwardLoc;

    public BrowserFrame(String string) {
        super("Browser");
        this.location = string;
        this.history = new Stack();
        this.history.addElement(string);
        this.future = new Stack();
        this.initialize();
        this.addWindowListener(this);
        this.pack();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.closeButton) {
            ((Component)this).setVisible(false);
        } else if (actionEvent.getSource() == this.backButton) {
            if (this.history.size() > 1) {
                String string = (String)this.history.pop();
                this.future.push(string);
                this.nextButton.setEnabled(true);
                String string2 = null;
                if (this.history.size() > 0) {
                    string2 = (String)this.history.pop();
                }
                if (string2 != null) {
                    this.document.setCurrentLocation(string2);
                } else {
                    this.history.push(string);
                }
                if (this.history.size() < 2) {
                    this.backButton.setEnabled(false);
                }
            }
        } else if (actionEvent.getSource() == this.nextButton) {
            if (this.future.size() > 0) {
                String string = (String)this.future.pop();
                if (string != null) {
                    this.history.push(string);
                    this.document.setCurrentLocation(string);
                }
                if (this.future.size() < 1) {
                    this.nextButton.setEnabled(false);
                }
            }
        } else if (actionEvent.getSource() == this.reloadButton) {
            this.document.reload();
        } else if (actionEvent.getSource() == this.goButton) {
            this.setLocation(this.addressBar.getText());
        }
    }

    private Browser getDocument() {
        if (this.document == null) {
            this.document = new Browser();
            this.document.addPropertyChangeListener((PropertyChangeListener)this);
            if (this.location != null) {
                this.document.gotoLocation(this.location);
            }
        }
        return this.document;
    }

    public String getURL() {
        return this.location;
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        Panel panel = new Panel();
        panel.setLayout(new FlowLayout());
        panel.setBackground(Color.lightGray);
        this.backButton = new Button("< Back");
        this.backButton.setBackground(Color.white);
        this.backButton.addActionListener(this);
        this.backButton.setEnabled(false);
        panel.add(this.backButton);
        this.nextButton = new Button("Forward >");
        this.nextButton.setBackground(Color.white);
        this.nextButton.addActionListener(this);
        this.nextButton.setEnabled(false);
        panel.add(this.nextButton);
        this.reloadButton = new Button("Reload <>");
        this.reloadButton.setBackground(Color.white);
        this.reloadButton.addActionListener(this);
        panel.add(this.reloadButton);
        this.addressBar = new TextField("", 50);
        panel.add(this.addressBar);
        this.goButton = new Button("Go");
        this.goButton.setBackground(Color.green);
        this.goButton.addActionListener(this);
        panel.add(this.goButton);
        this.closeButton = new Button("Close");
        this.closeButton.setBackground(Color.red);
        this.closeButton.addActionListener(this);
        panel.add(this.closeButton);
        this.add("North", panel);
        this.add("Center", (Component)this.getDocument());
        Panel panel2 = new Panel();
        panel2.setLayout(new BorderLayout());
        panel2.setBackground(Color.lightGray);
        this.status = new Label("Status");
        panel2.add("Center", this.status);
        this.add("South", panel2);
    }

    public static void main(String[] stringArray) {
        new BrowserFrame("http://www.cse.ogi.edu/DISC/CQ");
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getSource() == this.getDocument()) {
            if (propertyChangeEvent.getPropertyName().equals("currentLocation")) {
                this.history.addElement(propertyChangeEvent.getNewValue());
                this.backButton.setEnabled(true);
                ((TextComponent)this.addressBar).setText(propertyChangeEvent.getNewValue().toString());
                ++this.currentLoc;
            } else if (propertyChangeEvent.getPropertyName().equals("statusString")) {
                this.status.setText(propertyChangeEvent.getNewValue().toString());
            }
        }
    }

    public void reload() {
        this.document.reload();
    }

    public void setLocation(String string) {
        this.location = string;
        this.document.setCurrentLocation(this.location);
        this.history.addElement(this.location);
        this.currentLoc = this.history.size() - 1;
        ((TextComponent)this.addressBar).setText(this.location);
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
        ((Component)this).setVisible(false);
    }

    public void windowClosing(WindowEvent windowEvent) {
        ((Component)this).setVisible(false);
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }
}

