/*
 * Decompiled with CFR 0.152.
 */
package ogi.cq.plugin.gui;

import com.sun.java.swing.BorderFactory;
import com.sun.java.swing.Box;
import com.sun.java.swing.BoxLayout;
import com.sun.java.swing.JButton;
import com.sun.java.swing.JComboBox;
import com.sun.java.swing.JFrame;
import com.sun.java.swing.JLabel;
import com.sun.java.swing.JPanel;
import com.sun.java.swing.JPasswordField;
import com.sun.java.swing.JScrollPane;
import com.sun.java.swing.JTextArea;
import com.sun.java.swing.JTextField;
import com.sun.java.swing.SwingUtilities;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import ogi.cq.cluster.CQClusterImpl;
import ogi.cq.gui.Spinner;
import ogi.cq.log.CQLog;
import ogi.cq.log.Log;
import ogi.cq.plugin.IContinualQueryPlugin;
import ogi.cq.plugin.LocalContinualQueryPlugin;
import ogi.cq.plugin.NotInitializedException;
import ogi.cq.plugin.gui.BrowserFrame;
import ogi.cq.plugin.gui.DIOMExamples;
import ogi.cq.plugin.gui.JTAVExamples;
import ogi.cq.plugin.gui.LocalPluginGUI;
import ogi.cq.plugin.gui.ModSAFExamples;
import ogi.cq.plugin.gui.PluginCQManager;
import ogi.cq.plugin.gui.PluginQueryManager;
import ogi.cq.plugin.gui.StatFrame;
import ogi.cq.plugin.gui.UpdateFrame;
import ogi.cq.plugin.gui.demo.Examples;
import ogi.cq.plugin.gui.demo.NoExamples;
import ogi.cq.time.Time;

public class BasePluginGUI
extends JFrame
implements ActionListener,
Time {
    public static boolean DEBUG = true;
    protected Log logger;
    protected String server;
    protected String port;
    protected String proxyHost;
    protected int proxyPort;
    IContinualQueryPlugin plugin;
    StatFrame stats;
    JPanel titlePanel;
    JButton connectButton;
    JButton statsButton;
    JButton traceButton;
    JButton helpButton;
    JButton closeButton;
    JFrame help;
    JTextField serverField;
    JTextField portField;
    JPanel cqPanel;
    JButton cqButton;
    JButton queryButton;
    JButton demoButton;
    JPanel userPanel;
    JTextField userField;
    JPasswordField passwordField;
    JComboBox sourceComboBox;
    JPanel webButtonPanel;
    JButton registerButton;
    JButton browseCQButton;
    JButton cqHomeButton;
    JPanel controlButtonPanel;
    JButton testButton;
    JButton closeGUIButton;
    JTextField status;
    Spinner spinner;
    JFrame confirmFrame;
    JButton okButton;
    JButton cancelButton;
    JFrame confirmFrame2;
    JButton okButton2;
    JButton cancelButton2;
    boolean showExecutionHistory;
    String propertyFile;
    BrowserFrame browser;
    UpdateFrame updateFrame;
    public static final String NEW_LINE = System.getProperty("line.separator");
    private static final String DEFAULT_USER = "AlpineUser";
    private static final String DEFAULT_PASS = "alpine";

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.connectButton) {
            this.initPlugin();
            this.connectButton.setEnabled(false);
            this.cqButton.setEnabled(true);
            this.statsButton.setEnabled(true);
        } else if (actionEvent.getSource() == this.helpButton) {
            this.getHelp().setVisible(true);
        } else if (actionEvent.getSource() == this.closeButton) {
            this.help.setVisible(false);
        } else if (actionEvent.getSource() == this.cancelButton) {
            this.getConfirmFrame().setVisible(false);
        } else if (actionEvent.getSource() == this.cancelButton2) {
            this.getConfirmFrame2().setVisible(false);
        } else if (actionEvent.getSource() == this.okButton) {
            this.getConfirmFrame().setVisible(false);
            this.status.setText("Validating User");
            this.spinner.startSpinning();
            Runnable runnable = new Runnable(this){
                /* synthetic */ BasePluginGUI this$0;

                public void run() {
                    BasePluginGUI.access$newCQ(this.this$0);
                }
                {
                    this.this$0 = basePluginGUI;
                }
            };
            Thread thread = new Thread(runnable);
            thread.start();
        } else if (actionEvent.getSource() == this.okButton2) {
            this.getConfirmFrame2().setVisible(false);
            this.status.setText("Validating User");
            this.spinner.startSpinning();
            Runnable runnable = new Runnable(this){
                /* synthetic */ BasePluginGUI this$0;

                public void run() {
                    BasePluginGUI.access$newDemo(this.this$0);
                }
                {
                    this.this$0 = basePluginGUI;
                }
            };
            Thread thread = new Thread(runnable);
            thread.start();
        } else if (actionEvent.getSource() == this.closeGUIButton) {
            this.getUpdateFrame().exit();
            System.exit(0);
        } else if (actionEvent.getSource() == this.registerButton) {
            this.registerButtonClicked();
        } else if (actionEvent.getSource() == this.browseCQButton) {
            this.browseButtonClicked();
        } else if (actionEvent.getSource() == this.testButton) {
            ((Window)((Object)this.getUpdateFrame())).show();
        } else if (actionEvent.getSource() == this.cqHomeButton) {
            this.cqHomeButtonClicked();
        } else if (actionEvent.getSource() == this.cqButton) {
            if (this.userField.getText().trim().equals("")) {
                this.status.setText("MUST set User ID to install CQ");
                return;
            }
            if (this.passwordField.getText().trim().equals("")) {
                this.status.setText("MUST set password to install CQ");
                return;
            }
            if (this.userField.getText().trim().equals(DEFAULT_USER)) {
                this.getConfirmFrame().show();
                return;
            }
            this.status.setText("Validating User");
            this.spinner.startSpinning();
            Runnable runnable = new Runnable(this){
                /* synthetic */ BasePluginGUI this$0;

                public void run() {
                    BasePluginGUI.access$newCQ(this.this$0);
                }
                {
                    this.this$0 = basePluginGUI;
                }
            };
            Thread thread = new Thread(runnable);
            thread.start();
        } else if (actionEvent.getSource() == this.demoButton) {
            if (this.userField.getText().trim().equals("")) {
                this.status.setText("MUST set User ID to install CQ");
                return;
            }
            if (this.passwordField.getText().trim().equals("")) {
                this.status.setText("MUST set password to install CQ");
                return;
            }
            if (this.userField.getText().trim().equals(DEFAULT_USER)) {
                this.getConfirmFrame2().show();
                return;
            }
            this.status.setText("Validating User");
            this.spinner.startSpinning();
            Runnable runnable = new Runnable(this){
                /* synthetic */ BasePluginGUI this$0;

                public void run() {
                    BasePluginGUI.access$newDemo(this.this$0);
                }
                {
                    this.this$0 = basePluginGUI;
                }
            };
            Thread thread = new Thread(runnable);
            thread.start();
        } else if (actionEvent.getSource() == this.queryButton) {
            this.status.setText("Validating User");
            this.spinner.startSpinning();
            Runnable runnable = new Runnable(this){
                /* synthetic */ BasePluginGUI this$0;

                public void run() {
                    BasePluginGUI.access$newQuery(this.this$0);
                }
                {
                    this.this$0 = basePluginGUI;
                }
            };
            Thread thread = new Thread(runnable);
            thread.start();
        } else if (actionEvent.getSource() == this.statsButton) {
            if (this.stats == null) {
                this.statsButton.setEnabled(false);
                this.traceButton.setEnabled(false);
                this.status.setText("Retrieving statistics");
                this.spinner.startSpinning();
                Runnable runnable = new Runnable(this){
                    /* synthetic */ BasePluginGUI this$0;

                    public void run() {
                        this.this$0.initStats();
                    }
                    {
                        this.this$0 = basePluginGUI;
                    }
                };
                Thread thread = new Thread(runnable);
                thread.start();
                this.showExecutionHistory = false;
                return;
            }
            ((Window)((Object)this.stats)).show();
            this.stats.showCurrentStats();
        } else if (actionEvent.getSource() == this.traceButton) {
            if (this.stats == null) {
                this.statsButton.setEnabled(false);
                this.traceButton.setEnabled(false);
                this.status.setText("Retrieving statistics");
                this.spinner.startSpinning();
                Runnable runnable = new Runnable(this){
                    /* synthetic */ BasePluginGUI this$0;

                    public void run() {
                        this.this$0.initStats();
                    }
                    {
                        this.this$0 = basePluginGUI;
                    }
                };
                Thread thread = new Thread(runnable);
                thread.start();
                this.showExecutionHistory = true;
                return;
            }
            ((Window)((Object)this.stats)).show();
            this.stats.showExecutionHistory();
        }
    }

    protected void browseButtonClicked() {
        this.getBrowserFrame(System.getProperties().getProperty("cq.url.browse"));
    }

    protected void cqHomeButtonClicked() {
        this.getBrowserFrame(System.getProperties().getProperty("cq.url.cqHome"));
    }

    private BrowserFrame getBrowserFrame(String string) {
        if (this.browser == null) {
            this.browser = new BrowserFrame(string);
            ((Component)this.browser).setSize(800, 600);
        } else {
            this.browser.setLocation(string);
        }
        this.browser.show();
        return this.browser;
    }

    protected JFrame getConfirmFrame() {
        if (this.confirmFrame == null) {
            this.confirmFrame = new JFrame("Confirm Default Login");
            JPanel jPanel = (JPanel)this.confirmFrame.getContentPane();
            jPanel.setLayout((LayoutManager)new BoxLayout((Container)jPanel, 1));
            jPanel.setBorder(BorderFactory.createEtchedBorder());
            jPanel.add(Box.createRigidArea((Dimension)new Dimension(5, 5)));
            jPanel.add((Component)new JLabel("Are you sure you want to log in as the default user?"));
            jPanel.add((Component)new JLabel("To receive notifications you must register and log in with your user ID."));
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new FlowLayout());
            jPanel.add((Component)jPanel2);
            this.okButton = new JButton("Install CQ with default userid");
            this.okButton.setBackground(Color.green);
            this.okButton.addActionListener((ActionListener)this);
            jPanel2.add((Component)this.okButton);
            this.cancelButton = new JButton("Cancel");
            this.cancelButton.setBackground(Color.red);
            this.cancelButton.addActionListener((ActionListener)this);
            jPanel2.add((Component)this.cancelButton);
            this.confirmFrame.pack();
        }
        return this.confirmFrame;
    }

    protected JFrame getConfirmFrame2() {
        if (this.confirmFrame2 == null) {
            this.confirmFrame2 = new JFrame("Confirm Default Login");
            JPanel jPanel = (JPanel)this.confirmFrame2.getContentPane();
            jPanel.setLayout((LayoutManager)new BoxLayout((Container)jPanel, 1));
            jPanel.setBorder(BorderFactory.createEtchedBorder());
            jPanel.add(Box.createRigidArea((Dimension)new Dimension(5, 5)));
            jPanel.add((Component)new JLabel("Are you sure you want to log in as the default user?"));
            jPanel.add((Component)new JLabel("To receive notifications you must register and log in with your user ID."));
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new FlowLayout());
            jPanel.add((Component)jPanel2);
            this.okButton2 = new JButton("Install CQ with default userid");
            this.okButton2.setBackground(Color.green);
            this.okButton2.addActionListener((ActionListener)this);
            jPanel2.add((Component)this.okButton2);
            this.cancelButton2 = new JButton("Cancel");
            this.cancelButton2.setBackground(Color.red);
            this.cancelButton2.addActionListener((ActionListener)this);
            jPanel2.add((Component)this.cancelButton2);
            this.confirmFrame2.pack();
        }
        return this.confirmFrame2;
    }

    protected JPanel getControlButtonPanel() {
        if (this.controlButtonPanel == null) {
            this.controlButtonPanel = new JPanel();
            this.controlButtonPanel.setLayout((LayoutManager)new BoxLayout((Container)this.controlButtonPanel, 0));
            this.testButton = new JButton("Data Update");
            this.testButton.addActionListener((ActionListener)this);
            this.controlButtonPanel.add((Component)this.testButton);
            this.controlButtonPanel.add(Box.createHorizontalGlue());
            this.controlButtonPanel.add((Component)this.getWebButtonPanel());
            this.controlButtonPanel.add(Box.createHorizontalGlue());
            this.closeGUIButton = new JButton("Close");
            this.closeGUIButton.setBackground(Color.red);
            this.closeGUIButton.addActionListener((ActionListener)this);
            this.controlButtonPanel.add((Component)this.closeGUIButton);
        }
        return this.controlButtonPanel;
    }

    protected JPanel getCQPanel() {
        if (this.cqPanel == null) {
            this.cqPanel = new JPanel();
            this.cqPanel.setLayout((LayoutManager)new BoxLayout((Container)this.cqPanel, 1));
            this.cqPanel.setBorder(BorderFactory.createEtchedBorder());
            this.cqPanel.add(Box.createRigidArea((Dimension)new Dimension(5, 5)));
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new FlowLayout());
            this.sourceComboBox = new JComboBox();
            this.sourceComboBox.addActionListener((ActionListener)this);
            jPanel.add(Box.createRigidArea((Dimension)new Dimension(5, 5)));
            jPanel.add((Component)new JLabel("Select source: "));
            jPanel.add((Component)this.sourceComboBox);
            jPanel.add(Box.createHorizontalGlue());
            this.cqPanel.add((Component)jPanel);
            this.cqButton = new JButton("Install a new CQ");
            this.cqButton.setBackground(Color.orange);
            this.cqButton.addActionListener((ActionListener)this);
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout((LayoutManager)new BoxLayout((Container)jPanel2, 0));
            jPanel2.add(Box.createRigidArea((Dimension)new Dimension(5, 5)));
            jPanel2.add((Component)this.cqButton);
            this.demoButton = new JButton("Demo CQs");
            this.demoButton.setBackground(Color.cyan);
            this.demoButton.addActionListener((ActionListener)this);
            jPanel2.add(Box.createRigidArea((Dimension)new Dimension(5, 5)));
            jPanel2.add((Component)this.demoButton);
            jPanel2.add(Box.createHorizontalGlue());
            this.queryButton = new JButton("Source Query");
            this.queryButton.setBackground(Color.orange);
            this.queryButton.addActionListener((ActionListener)this);
            jPanel2.add((Component)this.queryButton);
            jPanel2.add(Box.createRigidArea((Dimension)new Dimension(5, 5)));
            this.cqPanel.add((Component)jPanel2);
            this.cqPanel.add(Box.createRigidArea((Dimension)new Dimension(5, 5)));
            this.cqPanel.add(Box.createRigidArea((Dimension)new Dimension(0, 5)));
            this.cqPanel.add((Component)this.getUserPanel());
            this.cqPanel.add(Box.createRigidArea((Dimension)new Dimension(0, 5)));
            this.cqPanel.add(Box.createVerticalGlue());
        }
        return this.cqPanel;
    }

    public JFrame getHelp() {
        if (this.help == null) {
            String string = "Help -- CQ_JTAV Plugin Applet";
            this.help = new JFrame(string);
            JPanel jPanel = (JPanel)this.help.getContentPane();
            jPanel.setLayout(new BorderLayout());
            Font font = new Font("timesRoman", 1, 20);
            JLabel jLabel = new JLabel(string);
            jLabel.setFont(font);
            jLabel.setForeground(Color.blue);
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new FlowLayout());
            jPanel2.add((Component)jLabel);
            jPanel.add("North", (Component)jPanel2);
            JTextArea jTextArea = new JTextArea();
            jTextArea.setEditable(false);
            jTextArea.append("You can install a continual query with the default ");
            jTextArea.append("user name and password, however, if you wish ");
            jTextArea.append("to receive notifications of updates, you must first register and log in with your ");
            jTextArea.append("own CQ System userid.");
            jTextArea.append(NEW_LINE);
            jTextArea.append(NEW_LINE);
            jTextArea.append("System Status");
            jTextArea.append(NEW_LINE);
            jTextArea.append("To view the current CQ system status, click the 'System Status' button. ");
            jTextArea.append("This will display the current number of CQ's in the system, and a list of the active CQ's");
            jTextArea.append(NEW_LINE);
            jTextArea.append(NEW_LINE);
            jTextArea.append("Track CQ Execution");
            jTextArea.append(NEW_LINE);
            jTextArea.append("The history statistics of the CQ system are available via the 'Track CQ Execution' button. ");
            jTextArea.append("This shows graphs depicting the CQ load history");
            jTextArea.append(NEW_LINE);
            jTextArea.append(NEW_LINE);
            jTextArea.append("Install a new CQ");
            jTextArea.append(NEW_LINE);
            jTextArea.append("To install a new CQ, click the 'Install a new CQ' button. ");
            jTextArea.append("This will display a screen that allows you to enter a query and trigger; alternatively, the user interface ");
            jTextArea.append("allows you to directly type in the query and trigger definition. ");
            jTextArea.append(NEW_LINE);
            jTextArea.append(NEW_LINE);
            jTextArea.append("Data Update");
            jTextArea.append(NEW_LINE);
            jTextArea.append("To automatically update the database, causing changes and subsequent notifications, click the \"Help\" button and follow the instructions on the window that pops up. ");
            jTextArea.append(NEW_LINE);
            jTextArea.append(NEW_LINE);
            jTextArea.append("Register");
            jTextArea.append(NEW_LINE);
            jTextArea.append("To register, simply click the register button on the applet.  Fill in the HTML form ");
            jTextArea.append("and submit it.  ");
            jTextArea.append("That is it.  You will then be registered -- you can install CQ\u2019s and ");
            jTextArea.append("receive notifications for the updates you specify.");
            jTextArea.append(NEW_LINE);
            jTextArea.append(NEW_LINE);
            jTextArea.append("Browse CQ's");
            jTextArea.append(NEW_LINE);
            jTextArea.append("Click the 'Browse CQ' button to view the raw definition of the CQ's you have access to. This will take you to an HTML ");
            jTextArea.append("page that displays all of your CQ's in a table. ");
            jTextArea.append(NEW_LINE);
            jTextArea.append("Alternatively, you can view an individual CQ definition from the statistics screen. ");
            jTextArea.append("Click on an individual CQ from the list shown and press ");
            jTextArea.append("the View CQ Definition button.  This will display the selected CQ in a form. ");
            jTextArea.append(NEW_LINE);
            jTextArea.append(NEW_LINE);
            jTextArea.append("CQ Home");
            jTextArea.append(NEW_LINE);
            jTextArea.append("Return to the CQ Home page by pressing the CQ Home button. ");
            jTextArea.append(NEW_LINE);
            jTextArea.append(NEW_LINE);
            jTextArea.append("Close");
            jTextArea.append(NEW_LINE);
            jTextArea.append("To end the CQ client program, press the \"Close\" button. ");
            jTextArea.setLineWrap(true);
            jTextArea.setWrapStyleWord(true);
            JScrollPane jScrollPane = new JScrollPane((Component)jTextArea);
            jScrollPane.setVerticalScrollBarPolicy(22);
            jScrollPane.setHorizontalScrollBarPolicy(31);
            jScrollPane.setPreferredSize(new Dimension(250, 250));
            jPanel.add("Center", (Component)jScrollPane);
            Font font2 = new Font("timesRoman", 0, 15);
            jTextArea.setFont(font2);
            JPanel jPanel3 = new JPanel();
            jPanel3.setLayout(new FlowLayout());
            this.closeButton = new JButton("Close");
            this.closeButton.setBackground(Color.red);
            this.closeButton.addActionListener((ActionListener)this);
            jPanel3.add((Component)this.closeButton);
            jPanel.add("South", (Component)jPanel3);
            this.help.setSize(640, 480);
        }
        return this.help;
    }

    private String getPassword() {
        return this.passwordField.getText();
    }

    public String getPort() {
        return this.port;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public String getServer() {
        return this.server;
    }

    protected JPanel getTitlePanel() {
        if (this.titlePanel == null) {
            this.titlePanel = new JPanel();
            this.titlePanel.setLayout(new FlowLayout());
            JLabel jLabel = new JLabel("DARPA ALP CQ Plugin");
            Font font = new Font("serif", 1, 30);
            jLabel.setFont(font);
            jLabel.setForeground(Color.red);
            this.titlePanel.add((Component)jLabel);
        }
        return this.titlePanel;
    }

    private UpdateFrame getUpdateFrame() {
        if (this.updateFrame == null) {
            this.updateFrame = new UpdateFrame(this.plugin);
            this.updateFrame.setServer(this.getServer());
            this.updateFrame.setPort(this.getPort());
            this.updateFrame.setProxy(this.getProxyHost());
            this.updateFrame.setProxyPort(this.getProxyPort());
        }
        return this.updateFrame;
    }

    public String getUpdateServlet() {
        return System.getProperties().getProperty("cq.url.updateServlet");
    }

    private String getUser() {
        return this.userField.getText();
    }

    protected JPanel getUserPanel() {
        if (this.userPanel == null) {
            this.userPanel = new JPanel();
            this.userPanel.setLayout((LayoutManager)new BoxLayout((Container)this.userPanel, 0));
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new GridLayout(2, 1));
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new GridLayout(2, 1));
            JLabel jLabel = new JLabel("User ID: ");
            jPanel.add((Component)jLabel);
            this.userField = new JTextField(DEFAULT_USER, 20);
            jPanel2.add((Component)this.userField);
            this.userPanel.add(Box.createRigidArea((Dimension)new Dimension(5, 5)));
            this.userPanel.add((Component)jPanel);
            this.userPanel.add((Component)jPanel2);
            this.userPanel.add(Box.createHorizontalGlue());
            this.userPanel.add(Box.createRigidArea((Dimension)new Dimension(150, 5)));
            JLabel jLabel2 = new JLabel("Password: ");
            jPanel.add((Component)jLabel2);
            this.passwordField = new JPasswordField(DEFAULT_PASS);
            jPanel2.add((Component)this.passwordField);
        }
        return this.userPanel;
    }

    protected JPanel getWebButtonPanel() {
        if (this.webButtonPanel == null) {
            this.webButtonPanel = new JPanel();
            this.webButtonPanel.setLayout((LayoutManager)new BoxLayout((Container)this.webButtonPanel, 0));
            this.registerButton = new JButton("Register");
            this.registerButton.addActionListener((ActionListener)this);
            this.webButtonPanel.add(Box.createHorizontalGlue());
            this.webButtonPanel.add((Component)this.registerButton);
            this.webButtonPanel.add(Box.createHorizontalGlue());
            this.browseCQButton = new JButton("Browse CQ's");
            this.browseCQButton.addActionListener((ActionListener)this);
            this.webButtonPanel.add((Component)this.browseCQButton);
            this.webButtonPanel.add(Box.createHorizontalGlue());
            this.cqHomeButton = new JButton("CQ Home");
            this.cqHomeButton.addActionListener((ActionListener)this);
            this.webButtonPanel.add((Component)this.cqHomeButton);
            this.webButtonPanel.add(Box.createHorizontalGlue());
        }
        return this.webButtonPanel;
    }

    public void init() {
        this.logger = new CQLog();
        this.logger.setDebug(DEBUG);
        this.initGUI();
        this.logger.debug("finished GUI init");
        this.initPlugin();
        Vector vector = this.plugin.getSources();
        int n = 0;
        while (n < vector.size()) {
            this.sourceComboBox.addItem((Object)vector.elementAt(n).toString());
            ++n;
        }
    }

    public void initGUI() {
        JPanel jPanel = (JPanel)this.getContentPane();
        jPanel.setLayout((LayoutManager)new BoxLayout((Container)jPanel, 1));
        jPanel.setBorder(BorderFactory.createEtchedBorder());
        jPanel.add(Box.createGlue());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new BoxLayout((Container)jPanel2, 1));
        jPanel.add((Component)jPanel2);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new BoxLayout((Container)jPanel3, 0));
        jPanel2.add((Component)jPanel3);
        this.statsButton = new JButton("System Status");
        this.statsButton.setBackground(Color.yellow);
        this.statsButton.addActionListener((ActionListener)this);
        jPanel3.add((Component)this.statsButton);
        this.traceButton = new JButton("Track CQ Execution");
        this.traceButton.setBackground(Color.yellow);
        this.traceButton.addActionListener((ActionListener)this);
        jPanel3.add((Component)this.traceButton);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new BoxLayout((Container)jPanel4, 0));
        jPanel2.add((Component)jPanel4);
        this.cqButton = new JButton("Install a new CQ");
        this.cqButton.setBackground(Color.orange);
        this.cqButton.addActionListener((ActionListener)this);
        jPanel4.add(Box.createHorizontalGlue());
        jPanel4.add((Component)this.cqButton);
        jPanel4.add(Box.createHorizontalGlue());
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new BoxLayout((Container)jPanel5, 0));
        jPanel.add(Box.createRigidArea((Dimension)new Dimension(0, 5)));
        jPanel.add((Component)jPanel5);
        jPanel.add(Box.createRigidArea((Dimension)new Dimension(0, 5)));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new GridLayout(2, 1));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new GridLayout(2, 1));
        JLabel jLabel = new JLabel("User ID: ");
        jPanel6.add((Component)jLabel);
        this.userField = new JTextField("DemoUser", 20);
        jPanel7.add((Component)this.userField);
        jPanel5.add(Box.createRigidArea((Dimension)new Dimension(50, 5)));
        jPanel5.add(Box.createHorizontalGlue());
        jPanel5.add((Component)jPanel6);
        jPanel5.add((Component)jPanel7);
        jPanel5.add(Box.createHorizontalGlue());
        jPanel5.add(Box.createRigidArea((Dimension)new Dimension(150, 5)));
        JLabel jLabel2 = new JLabel("Password: ");
        jPanel6.add((Component)jLabel2);
        this.passwordField = new JPasswordField("demouser");
        jPanel7.add((Component)this.passwordField);
        jPanel.add(Box.createVerticalGlue());
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new BoxLayout((Container)jPanel8, 0));
        this.sourceComboBox = new JComboBox();
        this.sourceComboBox.addActionListener((ActionListener)this);
        jPanel8.add(Box.createHorizontalGlue());
        jPanel8.add((Component)new JLabel("Select source: "));
        jPanel8.add((Component)this.sourceComboBox);
        jPanel8.add(Box.createHorizontalGlue());
        jPanel.add((Component)jPanel8);
        jPanel.add((Component)this.getWebButtonPanel());
        jPanel.add((Component)this.getControlButtonPanel());
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout((LayoutManager)new BoxLayout((Container)jPanel9, 0));
        jPanel.add((Component)jPanel9);
        this.helpButton = new JButton("Help");
        this.helpButton.setBackground(Color.green);
        this.helpButton.addActionListener((ActionListener)this);
        this.helpButton.setAlignmentY(0.5f);
        jPanel9.add((Component)this.helpButton);
        this.status = new JTextField("Status");
        this.status.setForeground(Color.blue);
        this.status.setBackground(Color.lightGray);
        this.status.setEditable(false);
        this.status.setAlignmentY(0.5f);
        jPanel9.add((Component)this.status);
        this.spinner = new Spinner();
        this.spinner.setAlignmentY(0.5f);
        jPanel9.add((Component)((Object)this.spinner));
    }

    public void initPlugin() {
        try {
            CQClusterImpl cQClusterImpl = null;
            if (this.propertyFile == null) {
                this.setDefaultProperties();
                cQClusterImpl = new CQClusterImpl();
            } else {
                cQClusterImpl = new CQClusterImpl(this.propertyFile);
            }
            this.plugin = new LocalContinualQueryPlugin(cQClusterImpl);
        }
        catch (Exception exception) {
            throw new NotInitializedException(exception.toString());
        }
    }

    public synchronized void initStats() {
        this.stats = new StatFrame(this.plugin, this.logger, "CQ System statistics");
        ((Window)((Object)this.stats)).pack();
        if (((Component)((Object)this.stats)).getSize().height < 480) {
            ((Component)((Object)this.stats)).setSize(new Dimension(Math.max(((Component)((Object)this.stats)).getSize().width, 640), 480));
        }
        if (this.showExecutionHistory) {
            this.stats.showExecutionHistory();
        } else {
            this.stats.showCurrentStats();
        }
        ((Window)((Object)this.stats)).show();
        this.spinner.stopSpinning();
        this.reset();
    }

    public void invalidUser() {
        Runnable runnable = new Runnable(this){
            /* synthetic */ BasePluginGUI this$0;

            public void run() {
                BasePluginGUI.access$invalidUser0(this.this$0);
            }
            {
                this.this$0 = basePluginGUI;
            }
        };
        SwingUtilities.invokeLater((Runnable)runnable);
    }

    private void invalidUser0() {
        this.reset0();
        this.status.setText("User name/password is invalid");
        this.spinner.stopSpinning();
    }

    public static String loadProperties(String string) {
        try {
            Properties properties = new Properties(System.getProperties());
            properties.load(new BufferedInputStream(new FileInputStream(string)));
            System.setProperties(properties);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return new String("ERROR:  Could not open: " + string);
        }
        catch (IOException iOException) {
            return new String("loadProperties " + iOException);
        }
        return null;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 1) {
            BasePluginGUI.usage();
            System.exit(1);
        }
        LocalPluginGUI localPluginGUI = new LocalPluginGUI(stringArray[0]);
        ((Window)((Object)localPluginGUI)).pack();
        ((Component)((Object)localPluginGUI)).setSize(640, 4800);
        ((Component)((Object)localPluginGUI)).setVisible(true);
    }

    private void newCQ() {
        if (this.plugin.validateUser(this.getUser(), this.getPassword())) {
            Runnable runnable = new Runnable(this){
                /* synthetic */ BasePluginGUI this$0;

                public void run() {
                    this.this$0.status.setText("Initializing new CQ installation");
                }
                {
                    this.this$0 = basePluginGUI;
                }
            };
            SwingUtilities.invokeLater((Runnable)runnable);
            String string = (String)this.sourceComboBox.getSelectedItem();
            PluginCQManager pluginCQManager = null;
            pluginCQManager = string.equals("modsaf") ? new PluginCQManager(this.plugin, string, new ModSAFExamples(), this.logger) : (string.equals("jtav") ? new PluginCQManager(this.plugin, string, new JTAVExamples(), this.logger) : (string.equals("diom") ? new PluginCQManager(this.plugin, string, new DIOMExamples(), this.logger) : new PluginCQManager(this.plugin, string, new ModSAFExamples(), this.logger)));
            pluginCQManager.begin(string, this.getUser(), this.getPassword());
            this.spinner.stopSpinning();
            this.reset();
        } else {
            this.invalidUser();
        }
    }

    private void newDemo() {
        if (this.plugin.validateUser(this.getUser(), this.getPassword())) {
            Runnable runnable = new Runnable(this){
                /* synthetic */ BasePluginGUI this$0;

                public void run() {
                    this.this$0.status.setText("Initializing new DEMO CQ installation");
                }
                {
                    this.this$0 = basePluginGUI;
                }
            };
            SwingUtilities.invokeLater((Runnable)runnable);
            String string = (String)this.sourceComboBox.getSelectedItem();
            ogi.cq.plugin.gui.demo.PluginCQManager pluginCQManager = null;
            Examples examples = null;
            try {
                Class<?> clazz = Class.forName("ogi.cq.plugin.gui.demo." + string.toUpperCase() + "Examples");
                Constructor<?> constructor = clazz.getConstructor(null);
                examples = (Examples)constructor.newInstance(null);
            }
            catch (InvocationTargetException invocationTargetException) {
                System.out.println("Invocation target exception in creating examples for source: " + string);
                examples = new NoExamples();
            }
            catch (IllegalAccessException illegalAccessException) {
                System.out.println("Illegal access in creating examples for source: " + string);
                examples = new NoExamples();
            }
            catch (InstantiationException instantiationException) {
                System.out.println("Examples could not be instantiated for source: " + string);
                examples = new NoExamples();
            }
            catch (NoSuchMethodException noSuchMethodException) {
                System.out.println("Examples could not be created for source: " + string);
                examples = new NoExamples();
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.out.println("Examples not found for source: " + string);
                examples = new NoExamples();
            }
            pluginCQManager = new ogi.cq.plugin.gui.demo.PluginCQManager(this.plugin, string, examples, this.logger);
            pluginCQManager.begin(string, this.getUser(), this.getPassword());
            this.spinner.stopSpinning();
            this.reset();
        } else {
            this.invalidUser();
        }
    }

    private void newQuery() {
        Runnable runnable = new Runnable(this){
            /* synthetic */ BasePluginGUI this$0;

            public void run() {
                this.this$0.status.setText("Initializing new Query frame");
            }
            {
                this.this$0 = basePluginGUI;
            }
        };
        SwingUtilities.invokeLater((Runnable)runnable);
        String string = (String)this.sourceComboBox.getSelectedItem();
        PluginQueryManager pluginQueryManager = null;
        pluginQueryManager = string.equals("modsaf") ? new PluginQueryManager(this.plugin, string, new ModSAFExamples(), this.logger) : (string.equals("jtav") ? new PluginQueryManager(this.plugin, string, new JTAVExamples(), this.logger) : (string.equals("diom") ? new PluginQueryManager(this.plugin, string, new DIOMExamples(), this.logger) : new PluginQueryManager(this.plugin, string, new ModSAFExamples(), this.logger)));
        pluginQueryManager.begin(string);
        this.spinner.stopSpinning();
        this.reset();
    }

    protected void queryButtonClicked() {
        this.getBrowserFrame(System.getProperties().getProperty("cq.url.query"));
    }

    protected void registerButtonClicked() {
        this.getBrowserFrame(System.getProperty("cq.url.register"));
    }

    public void reset() {
        Runnable runnable = new Runnable(this){
            /* synthetic */ BasePluginGUI this$0;

            public void run() {
                BasePluginGUI.access$reset0(this.this$0);
            }
            {
                this.this$0 = basePluginGUI;
            }
        };
        SwingUtilities.invokeLater((Runnable)runnable);
    }

    private void reset0() {
        this.status.setText("");
        this.statsButton.setEnabled(true);
        this.traceButton.setEnabled(true);
        this.cqButton.setEnabled(true);
    }

    protected void setDefaultProperties() {
        Properties properties = System.getProperties();
        ((Hashtable)properties).put("contentQueryCGI", "http://129.95.40.15:8080/OpenCQ/cgi-bin/installCQ_step2.cgi");
        ((Hashtable)properties).put("cq.url.register", "http://chinook.cse.ogi.edu:8080/OpenCQ/html/register.html");
        ((Hashtable)properties).put("cq.url.browse", "http://chinook.cse.ogi.edu:8080/OpenCQ/html/browseCQ.html");
        ((Hashtable)properties).put("cq.url.query", "http://chinook.cse.ogi.edu:8080/OpenCQ/html/query.html");
        ((Hashtable)properties).put("cq.url.cqHome", "http://www.cse.ogi.edu/DISC/CQ/");
        ((Hashtable)properties).put("cq.url.update", "http://www.cse.ogi.edu/DISC/CQ/");
        ((Hashtable)properties).put("cq.url.endUpdate", "http://www.cse.ogi.edu/DISC/CQ/");
        ((Hashtable)properties).put("cq.url.updateServlet", "UpdateServlet");
    }

    public void setPort(String string) {
        this.port = string;
    }

    public void setProxyHost(String string) {
        this.proxyHost = string;
    }

    public void setProxyPort(int n) {
        this.proxyPort = n;
    }

    public void setServer(String string) {
        this.server = string;
    }

    public static void usage() {
        System.out.println("Usage: LocalPluginGUI <properties file> ");
        System.out.println("Where <properties file> is the path of the file ");
        System.out.println("that contains the info for the cluster to run.");
        System.out.println("");
    }

    static void access$reset0(BasePluginGUI basePluginGUI) {
        basePluginGUI.reset0();
    }

    static void access$newCQ(BasePluginGUI basePluginGUI) {
        basePluginGUI.newCQ();
    }

    static void access$newQuery(BasePluginGUI basePluginGUI) {
        basePluginGUI.newQuery();
    }

    static void access$invalidUser0(BasePluginGUI basePluginGUI) {
        basePluginGUI.invalidUser0();
    }

    static void access$newDemo(BasePluginGUI basePluginGUI) {
        basePluginGUI.newDemo();
    }
}

