/*
 * Decompiled with CFR 0.152.
 */
package ogi.cq.plugin;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Hashtable;
import java.util.Vector;
import ogi.cq.cluster.ClusterLog;
import ogi.cq.log.Log;
import ogi.cq.plugin.CQNotInstalledException;
import ogi.cq.plugin.CQUpdateEvent;
import ogi.cq.plugin.CQUpdateListener;
import ogi.cq.plugin.ContinualQueryCluster;
import ogi.cq.plugin.IContinualQueryPlugin;
import ogi.cq.plugin.InvalidCQException;
import ogi.cq.plugin.StringLog;
import ogi.cq.query.CQ;

public class LocalContinualQueryPlugin
implements IContinualQueryPlugin,
ClusterLog {
    private int state = 0;
    private ContinualQueryCluster cluster;
    private Vector updateListeners;
    private Hashtable schema;
    private Hashtable columns;
    private Hashtable columnTypes;
    private Hashtable relations;
    private Vector sources;
    private Vector triggerOperators;
    private Vector queryOperators;
    private Vector cqInfo;
    private Log logger;
    StringLog stringLog;
    String host;
    String port;

    public LocalContinualQueryPlugin(ContinualQueryCluster continualQueryCluster) {
        this.cluster = continualQueryCluster;
        this.columns = new Hashtable();
        this.columnTypes = new Hashtable();
    }

    public synchronized void addCQUpdateListener(CQUpdateListener cQUpdateListener) {
        if (cQUpdateListener == null) {
            return;
        }
        if (this.updateListeners.contains(cQUpdateListener)) {
            return;
        }
        this.updateListeners.addElement(cQUpdateListener);
    }

    public boolean deleteCQ(String string, String string2, String string3) {
        try {
            return this.cluster.deleteCQ(string, string2, string3, 0);
        }
        catch (Exception exception) {
            System.out.println("error in deleting CQ: " + exception);
            exception.printStackTrace();
            return false;
        }
    }

    protected void fireCQUpdated(String string, String string2) {
        Vector vector;
        LocalContinualQueryPlugin localContinualQueryPlugin = this;
        synchronized (localContinualQueryPlugin) {
            vector = (Vector)this.updateListeners.clone();
        }
        int n = vector.size();
        if (n == 0) {
            return;
        }
        CQUpdateEvent cQUpdateEvent = new CQUpdateEvent(this, string, string2);
        int n2 = 0;
        while (n2 < n) {
            CQUpdateListener cQUpdateListener = (CQUpdateListener)vector.elementAt(n2);
            if (cQUpdateListener != null) {
                cQUpdateListener.updateCQ(cQUpdateEvent);
            }
            ++n2;
        }
    }

    public String formQuery(String string, String string2, String string3, String string4, String string5, String string6) {
        return null;
    }

    public Vector getAttributes(String string, String string2) {
        Vector vector;
        if (string2 == null || string == null || string2.trim().equals("") || string.trim().equals("")) {
            return new Vector();
        }
        string2 = string2.trim().toUpperCase();
        Hashtable<String, Vector> hashtable = (Hashtable<String, Vector>)this.columns.get(string);
        if (hashtable == null) {
            hashtable = new Hashtable<String, Vector>();
        }
        if ((vector = (Vector)hashtable.get(string2)) == null) {
            try {
                Vector vector2 = this.cluster.getAttributes(string, string2);
                if (vector2 != null) {
                    hashtable.put(string2, vector2);
                    this.columns.put(string, hashtable);
                }
                return vector2;
            }
            catch (Exception exception) {
                System.out.println("remote plugin couldn't get attributes: " + exception);
                exception.printStackTrace();
                return new Vector();
            }
        }
        return vector;
    }

    public Vector getAttributeTypes(String string, String string2) {
        Vector vector;
        if (string2 == null || string == null || string2.trim().equals("") || string.trim().equals("")) {
            return new Vector();
        }
        string2 = string2.trim().toUpperCase();
        Hashtable<String, Vector> hashtable = (Hashtable<String, Vector>)this.columnTypes.get(string);
        if (hashtable == null) {
            hashtable = new Hashtable<String, Vector>();
        }
        if ((vector = (Vector)hashtable.get(string2)) == null) {
            try {
                Vector vector2 = this.cluster.getAttributes(string, string2);
                if (vector2 != null) {
                    hashtable.put(string2, vector2);
                    this.columnTypes.put(string, hashtable);
                }
                return vector2;
            }
            catch (Exception exception) {
                System.out.println("remote plugin couldn't get attributes: " + exception);
                exception.printStackTrace();
                return new Vector();
            }
        }
        return vector;
    }

    public String getCQ(String string, String string2, String string3) {
        try {
            return this.cluster.getCQ(string, string2, string3);
        }
        catch (Exception exception) {
            System.out.println("error in getting CQ: " + exception);
            exception.printStackTrace();
            return null;
        }
    }

    public Vector getCQHistory() {
        try {
            Vector vector = this.cluster.getCQHistory();
            return vector;
        }
        catch (Exception exception) {
            this.logger.log(0, "Error in getting CQ History");
            System.out.println("plugin. getCQHistory FAILED");
            return new Vector();
        }
    }

    public Vector getCQInfo() {
        if (this.cqInfo == null) {
            try {
                this.cqInfo = this.cluster.getCQInfo();
            }
            catch (Exception exception) {
                System.out.println("error in getting cq info: " + exception);
            }
        }
        return this.cqInfo;
    }

    public String getHost() {
        if (this.host == null) {
            try {
                this.host = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException unknownHostException) {
                System.out.println("Unknown host: " + unknownHostException);
            }
        }
        return this.host;
    }

    public Vector getIndividualCQHistory(String string, int n) {
        try {
            Vector vector = this.cluster.getIndividualCQHistory(string, n);
            return vector;
        }
        catch (Exception exception) {
            this.logger.log(0, "Error in getting CQ History");
            System.out.println("plugin. getCQHistory FAILED");
            return new Vector();
        }
    }

    public Log getLog() {
        return this.logger;
    }

    public String getPort() {
        return "";
    }

    public Vector getQueryOperators() {
        Vector vector = null;
        if (this.queryOperators != null) {
            return this.queryOperators;
        }
        try {
            vector = this.cluster.getQueryOperators();
        }
        catch (Exception exception) {
            System.out.println("error in getting relations: " + exception);
            exception.printStackTrace();
        }
        if (vector != null) {
            this.queryOperators = vector;
            return vector;
        }
        return new Vector();
    }

    public Vector getRelations(String string) {
        Vector vector;
        Vector vector2 = null;
        if (this.relations != null && (vector = (Vector)this.relations.get(string)) != null) {
            return vector;
        }
        try {
            vector2 = this.cluster.getRelations(string);
        }
        catch (Exception exception) {
            System.out.println("error in getting relations: " + exception);
            exception.printStackTrace();
        }
        if (vector2 != null) {
            if (this.relations != null) {
                this.relations.put(string, vector2);
            }
            return vector2;
        }
        return new Vector();
    }

    public Vector getSchema(String string) {
        Vector vector;
        Vector vector2 = null;
        if (this.schema != null && (vector = (Vector)this.schema.get(string)) != null) {
            return vector;
        }
        try {
            vector2 = this.cluster.getSchema(string);
        }
        catch (Exception exception) {
            System.out.println("error in getting schema: " + exception);
        }
        if (this.schema != null) {
            this.schema.put(string, vector2);
        }
        return vector2;
    }

    public Vector getSources() {
        Vector vector = null;
        if (this.sources != null) {
            return this.sources;
        }
        try {
            vector = this.cluster.getSources();
        }
        catch (Exception exception) {
            System.out.println("error in getting relations: " + exception);
            exception.printStackTrace();
        }
        if (vector != null) {
            this.sources = vector;
            return vector;
        }
        return new Vector();
    }

    public int getState() {
        return this.state;
    }

    public Vector getTriggerOperators() {
        Vector vector = null;
        if (this.triggerOperators != null) {
            return this.triggerOperators;
        }
        try {
            vector = this.cluster.getTriggerOperators();
        }
        catch (Exception exception) {
            System.out.println("error in getting relations: " + exception);
            exception.printStackTrace();
        }
        if (vector != null) {
            this.triggerOperators = vector;
            return vector;
        }
        return new Vector();
    }

    public void halt() {
        this.state = 2;
    }

    public void initialize(Object object) {
        this.state = 1;
    }

    public String installCQ(StringLog stringLog, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, boolean bl, String string11, String string12) throws InvalidCQException, CQNotInstalledException {
        this.stringLog = stringLog;
        System.out.println("ContinualQueryPlugin installCQ (2)");
        try {
            String string13 = this.cluster.installCQ(this, string, string2, string3, string4, string5, string6, string7, string8, string9, string10, bl, CQ.getCQNotificationConfiguration(new Hashtable()), string12);
            if (string13.indexOf("error") >= 0) {
                throw new CQNotInstalledException(string13);
            }
            return string13;
        }
        catch (Exception exception) {
            System.out.println("error in installing CQ: " + exception);
            exception.printStackTrace();
            throw new CQNotInstalledException(exception.toString());
        }
    }

    public Vector listCQ(String string) {
        return null;
    }

    public void load(Object object) {
        this.state = 2;
    }

    public void log(String string) {
        if (this.stringLog != null) {
            this.stringLog.log(string);
        }
    }

    public void notifyCQUpdate(String string, String string2) {
        this.fireCQUpdated(string, string2);
    }

    public boolean registerUser(String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        try {
            return this.cluster.registerUser(string, string2, string3, string4, string5, string6, string7);
        }
        catch (Exception exception) {
            System.out.println("error in getting relations: " + exception);
            exception.printStackTrace();
            return false;
        }
    }

    public synchronized void removeCQUpdateListener(CQUpdateListener cQUpdateListener) {
        this.updateListeners.removeElement(cQUpdateListener);
    }

    public void resume() {
        this.state = 4;
    }

    public void setLog(Log log) {
        this.logger = log;
    }

    public void setState(int n) {
        this.state = n;
    }

    public void start() {
    }

    public void stop() {
        this.state = 2;
    }

    public void suspend() {
        this.state = 3;
    }

    public void unload() {
    }

    public boolean validateUser(String string, String string2) {
        try {
            return this.cluster.validateUser(string, string2);
        }
        catch (Exception exception) {
            System.out.println("error in getting relations: " + exception);
            exception.printStackTrace();
            return false;
        }
    }
}

