/*
 * Decompiled with CFR 0.152.
 */
package ogi.cq.plugin;

import java.net.InetAddress;
import java.rmi.Naming;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Vector;
import ogi.cq.cluster.ClusterLog;
import ogi.cq.plugin.CQRemotePlugin;
import ogi.cq.plugin.ContinualQueryCluster;
import ogi.cq.plugin.IContinualQueryPlugin;
import ogi.cq.plugin.InvalidCQException;
import ogi.cq.plugin.NotInitializedException;
import ogi.cq.plugin.StringLog;

public class CQRemotePluginImpl
extends UnicastRemoteObject
implements CQRemotePlugin,
ClusterLog,
Remote {
    private String host;
    private String port;
    private String service = "/CQCluster";
    private IContinualQueryPlugin parent;
    private ContinualQueryCluster cluster;
    StringLog stringLog;

    public CQRemotePluginImpl() throws RemoteException {
    }

    public CQRemotePluginImpl(IContinualQueryPlugin iContinualQueryPlugin) throws RemoteException {
        this.parent = iContinualQueryPlugin;
    }

    public boolean deleteCQ(String string, String string2, String string3) throws RemoteException {
        return false;
    }

    public Vector getAttributes(String string, String string2) throws RemoteException {
        return this.cluster.getAttributes(string, string2);
    }

    public Vector getAttributeTypes(String string, String string2) throws RemoteException {
        return this.cluster.getAttributeTypes(string, string2);
    }

    public String getCQ(String string, String string2, String string3) throws RemoteException {
        return this.cluster.getCQ(string, string2, string3);
    }

    public Vector getCQHistory() throws RemoteException {
        Vector vector = this.cluster.getCQHistory();
        return vector;
    }

    public Vector getCQInfo() throws RemoteException {
        return this.cluster.getCQInfo();
    }

    public String getHost() throws RemoteException {
        return this.host;
    }

    public Vector getIndividualCQHistory(String string, int n) throws RemoteException {
        Vector vector = this.cluster.getIndividualCQHistory(string, n);
        return vector;
    }

    public String getPort() throws RemoteException {
        return this.port;
    }

    public Vector getQueryOperators() throws RemoteException {
        return this.cluster.getQueryOperators();
    }

    public Vector getRelations(String string) throws RemoteException {
        return this.cluster.getRelations(string);
    }

    public Vector getSchema(String string) throws RemoteException {
        return this.cluster.getSchema(string);
    }

    public Vector getSources() throws RemoteException {
        return this.cluster.getSources();
    }

    public Vector getTriggerOperators() throws RemoteException {
        return this.cluster.getTriggerOperators();
    }

    public void initialize(Object object) {
        if (!(object instanceof String[])) {
            throw new NotInitializedException("Invalid initialization parameters");
        }
        String[] stringArray = (String[])object;
        if (stringArray.length < 1) {
            throw new NotInitializedException("Initialization parameters too short");
        }
        this.host = stringArray[0];
        if (stringArray.length > 1) {
            this.port = stringArray[1];
        }
    }

    public String installCQ(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, boolean bl, String string11, String string12) throws RemoteException, InvalidCQException {
        System.out.println("CQRemotePluginImpl installCQ (1)");
        return this.cluster.installCQ(this, string, string2, string3, string4, string5, string6, string7, string8, string9, string10, bl, string11, string12);
    }

    public String installCQ(StringLog stringLog, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, boolean bl, String string11, String string12) throws RemoteException, InvalidCQException {
        System.out.println("CQRemotePluginImpl installCQ (2)");
        this.stringLog = stringLog;
        return this.cluster.installCQ(this, string, string2, string3, string4, string5, string6, string7, string8, string9, string10, bl, string11, string12);
    }

    public Vector listCQ(String string) throws RemoteException {
        return this.cluster.listCQ(string);
    }

    public void load(Object object) {
        if (this.host == null) {
            throw new NotInitializedException("Plugin not initialized");
        }
        try {
            ContinualQueryCluster continualQueryCluster = null;
            String string = InetAddress.getByName(this.host).getHostAddress();
            String string2 = null;
            string2 = this.port == null ? "//" + string + this.service : "//" + string + ":" + this.port + this.service;
            this.cluster = continualQueryCluster = (ContinualQueryCluster)Naming.lookup(string2);
            UnicastRemoteObject.exportObject(this);
        }
        catch (Exception exception) {
            System.out.println("error in connecting to server: " + exception);
        }
    }

    public void log(String string) {
        if (this.stringLog != null) {
            this.stringLog.log(string);
        }
    }

    public void notifyCQUpdate(String string, String string2) throws RemoteException {
        this.parent.notifyCQUpdate(string, string2);
    }

    public void printLogText(String string) {
        if (this.stringLog != null) {
            this.stringLog.log(string);
        }
    }

    public boolean registerUser(String string, String string2, String string3, String string4, String string5, String string6, String string7) throws RemoteException {
        return this.cluster.registerUser(string, string2, string3, string4, string5, string6, string7);
    }

    public void unload() {
    }

    public boolean validateUser(String string, String string2) throws RemoteException {
        return this.cluster.validateUser(string, string2);
    }
}

