/*
 * Decompiled with CFR 0.152.
 */
package ogi.cq.plugin;

import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.Date;
import java.util.StringTokenizer;
import ogi.diom.util.Base64;

public class CQArchiveInfo
implements Serializable {
    private String userID;
    private String id;
    private String sources;
    private String type;
    private Date startDate;
    private Date endDate;
    private String endType;
    private int triggerCount;
    private int queryCount;
    private int notificationCount;

    public static CQArchiveInfo fromWebString(String string) {
        String string2;
        CQArchiveInfo cQArchiveInfo = new CQArchiveInfo();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        if (stringTokenizer.hasMoreTokens()) {
            cQArchiveInfo.id = string2 = stringTokenizer.nextToken();
        }
        if (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            try {
                cQArchiveInfo.startDate = new Date(Long.parseLong(string2));
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println("error in getting start date for CQ: " + cQArchiveInfo.id);
                cQArchiveInfo.startDate = new Date(0L);
            }
        }
        if (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            try {
                cQArchiveInfo.endDate = new Date(Long.parseLong(string2));
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println("error in getting end date for CQ: " + cQArchiveInfo.id);
                cQArchiveInfo.endDate = new Date(0L);
            }
        }
        if (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            cQArchiveInfo.userID = Base64.decode(string2);
        }
        if (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            cQArchiveInfo.type = Base64.decode(string2);
        }
        if (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            cQArchiveInfo.sources = Base64.decode(string2);
        }
        if (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            cQArchiveInfo.endType = Base64.decode(string2);
        }
        if (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            try {
                cQArchiveInfo.triggerCount = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println("error in getting trigger count for CQ: " + cQArchiveInfo.id);
                cQArchiveInfo.triggerCount = 0;
            }
        }
        if (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            try {
                cQArchiveInfo.queryCount = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println("error in getting query count for CQ: " + cQArchiveInfo.id);
                cQArchiveInfo.queryCount = 0;
            }
        }
        if (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            try {
                cQArchiveInfo.notificationCount = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println("error in getting notify count for CQ: " + cQArchiveInfo.id);
                cQArchiveInfo.notificationCount = 0;
            }
        }
        return cQArchiveInfo;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public String getEndType() {
        return this.endType;
    }

    public String getId() {
        return this.id;
    }

    public int getNotificationCount() {
        return this.notificationCount;
    }

    public int getQueryCount() {
        return this.queryCount;
    }

    public String getSources() {
        return this.sources;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public int getTriggerCount() {
        return this.triggerCount;
    }

    public String getType() {
        return this.type;
    }

    public String getUserID() {
        return this.userID;
    }

    public void setEndDate(Date date) {
        this.endDate = date;
    }

    public void setEndType(String string) {
        this.endType = string;
    }

    public void setId(String string) {
        this.id = string;
    }

    public void setNotificationCount(int n) {
        this.notificationCount = n;
    }

    public void setQueryCount(int n) {
        this.queryCount = n;
    }

    public void setSources(String string) {
        this.sources = string;
    }

    public void setStartDate(Date date) {
        this.startDate = date;
    }

    public void setTriggerCount(int n) {
        this.triggerCount = n;
    }

    public void setType(String string) {
        this.type = string;
    }

    public void setUserID(String string) {
        this.userID = string;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\nCQ: ");
        stringBuffer.append(this.id);
        stringBuffer.append("\n");
        stringBuffer.append(this.startDate.toString());
        stringBuffer.append("\n");
        stringBuffer.append(this.endDate.toString());
        return stringBuffer.toString();
    }

    public String toWebString() {
        StringWriter stringWriter = new StringWriter();
        this.toWebString(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }

    public void toWebString(PrintWriter printWriter) {
        if (this.id != null && !this.id.trim().equals("")) {
            printWriter.print(this.id);
        } else {
            printWriter.print(" ");
        }
        printWriter.print("|");
        if (this.startDate != null) {
            printWriter.print(this.startDate.getTime());
        } else {
            printWriter.print(" ");
        }
        printWriter.print("|");
        if (this.endDate != null) {
            printWriter.print(this.endDate.getTime());
        } else {
            printWriter.print(" ");
        }
        printWriter.print("|");
        if (this.userID != null && !this.userID.trim().equals("")) {
            printWriter.print(Base64.encode(this.userID));
        } else {
            printWriter.print(" ");
        }
        printWriter.print("|");
        if (this.type != null && !this.type.trim().equals("")) {
            printWriter.print(Base64.encode(this.type));
        } else {
            printWriter.print(" ");
        }
        printWriter.print("|");
        if (this.sources != null && !this.sources.trim().equals("")) {
            printWriter.print(Base64.encode(this.sources));
        } else {
            printWriter.print(" ");
        }
        printWriter.print("|");
        if (this.endType != null && !this.endType.trim().equals("")) {
            printWriter.print(Base64.encode(this.endType));
        } else {
            printWriter.print(" ");
        }
        printWriter.print("|");
        printWriter.print(this.triggerCount);
        printWriter.print("|");
        printWriter.print(this.queryCount);
        printWriter.print("|");
        printWriter.println(this.notificationCount);
    }
}

