/*
 * Decompiled with CFR 0.152.
 */
package ogi.cq.log;

import com.sun.java.swing.BorderFactory;
import com.sun.java.swing.Box;
import com.sun.java.swing.BoxLayout;
import com.sun.java.swing.JButton;
import com.sun.java.swing.JFrame;
import com.sun.java.swing.JLabel;
import com.sun.java.swing.JPanel;
import com.sun.java.swing.JScrollPane;
import com.sun.java.swing.JTextArea;
import com.sun.java.swing.JTextField;
import com.sun.java.swing.SwingUtilities;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.Observable;
import java.util.Vector;
import ogi.cq.gui.Spinner;
import ogi.cq.log.LogModel;
import ogi.cq.log.LogView;
import ogi.cq.util.Pair;

public class CQLogView
extends JFrame
implements LogView,
ActionListener,
Serializable {
    LogModel model;
    int currentLogLevel = 0;
    String titleString = "Log";
    Color backgroundColor;
    JPanel borderPanel1;
    JTextArea logField;
    JScrollPane textScroller;
    JButton upButton;
    JButton downButton;
    JTextField logLevelField;
    JTextField status;
    Spinner spinner;
    JButton closeButton;
    Vector components;
    static final String[] indentArray = new String[]{"", "   ", "     ", "       ", "         ", "           ", "             ", "               ", "                 ", "                   "};
    boolean debugging = false;

    public CQLogView(LogModel logModel, Color color) {
        this(logModel, "Log", color);
    }

    public CQLogView(LogModel logModel, String string, Color color) {
        super(string);
        if (logModel == null) {
            throw new IllegalArgumentException("Null model");
        }
        this.model = logModel;
        ((Observable)((Object)this.model)).addObserver(this);
        this.titleString = string == null ? "Log" : string;
        this.backgroundColor = color == null ? Color.lightGray : color;
        this.init();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.upButton) {
            this.upButton_Clicked();
        }
        if (actionEvent.getSource() == this.downButton) {
            this.downButton_Clicked();
        }
        if (actionEvent.getSource() == this.closeButton) {
            this.closeButton_Clicked();
        }
    }

    private void adjustScrollHeight() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.components.size()) {
            n += ((Component)this.components.elementAt((int)n3)).getPreferredSize().height;
            n2 += ((Component)this.components.elementAt((int)n3)).getMaximumSize().height;
            ++n3;
        }
        this.textScroller.setMaximumSize(new Dimension(((Component)((Object)this)).getSize().width, Math.max(((Component)((Object)this)).getSize().height - n2, ((Component)((Object)this)).getSize().height - n)));
        this.textScroller.setPreferredSize(new Dimension(((Component)((Object)this)).getSize().width, ((Component)((Object)this)).getSize().height - n));
    }

    void closeButton_Clicked() {
        try {
            this.spinner.startSpinning();
            this.debug("log view frame:  close button clicked");
            ((Component)((Object)this)).setVisible(false);
            this.spinner.stopSpinning();
        }
        catch (Exception exception) {
            this.debug("log viewer.close exception: " + exception);
        }
    }

    public void debug(String string) {
        if (this.debugging) {
            System.err.println(string);
        }
    }

    void downButton_Clicked() {
        try {
            this.spinner.startSpinning();
            this.debug("Log View Frame: down button clicked");
            --this.currentLogLevel;
            if (this.currentLogLevel < 0) {
                this.currentLogLevel = 9;
            }
            this.logLevelField.setText(String.valueOf(this.currentLogLevel));
            Runnable runnable = new Runnable(this){
                /* synthetic */ CQLogView this$0;

                public void run() {
                    CQLogView.access$refresh(this.this$0);
                }
                {
                    this.this$0 = cQLogView;
                }
            };
            SwingUtilities.invokeLater((Runnable)runnable);
            this.spinner.stopSpinning();
        }
        catch (Exception exception) {
            this.debug("log viewer.down exception: " + exception);
        }
    }

    void init() {
        this.components = new Vector();
        if (this.backgroundColor == null) {
            this.backgroundColor = Color.lightGray;
        }
        JPanel jPanel = (JPanel)this.getContentPane();
        jPanel.setLayout(new BorderLayout());
        ((Component)((Object)this)).setBackground(this.backgroundColor);
        jPanel.setBackground(this.backgroundColor);
        ((Component)((Object)this)).setSize(640, 480);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new BoxLayout((Container)jPanel2, 0));
        jPanel2.setBackground(this.backgroundColor);
        jPanel.add("North", (Component)jPanel2);
        JLabel jLabel = new JLabel(this.titleString);
        Font font = new Font("timesRoman", 1, 24);
        jLabel.setFont(font);
        jLabel.setForeground(Color.black);
        jPanel2.add(Box.createHorizontalGlue());
        jPanel2.add((Component)jLabel);
        jPanel2.add(Box.createHorizontalGlue());
        this.components.addElement(jPanel2);
        this.borderPanel1 = new JPanel();
        this.borderPanel1.setBorder(BorderFactory.createEtchedBorder());
        this.borderPanel1.setLayout(new BorderLayout());
        this.borderPanel1.setBackground(this.backgroundColor);
        jPanel.add("Center", (Component)this.borderPanel1);
        this.logField = new JTextArea();
        this.logField.setForeground(Color.blue);
        this.logField.setBackground(Color.lightGray);
        this.textScroller = new JScrollPane((Component)this.logField);
        this.textScroller.setHorizontalScrollBarPolicy(32);
        this.textScroller.setVerticalScrollBarPolicy(22);
        this.borderPanel1.add("Center", (Component)this.textScroller);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout());
        jPanel3.setBackground(this.backgroundColor);
        jPanel3.setAlignmentX(0.5f);
        jPanel3.setAlignmentY(0.5f);
        this.borderPanel1.add("South", (Component)jPanel3);
        JLabel jLabel2 = new JLabel("Log Level:");
        jLabel2.setForeground(Color.black);
        jLabel2.setAlignmentX(0.5f);
        jLabel2.setAlignmentY(0.5f);
        jPanel3.add((Component)jLabel2);
        this.logLevelField = new JTextField("0", 3);
        this.logLevelField.setBorder(BorderFactory.createEtchedBorder());
        this.logLevelField.setMaximumSize(new Dimension(25, this.logLevelField.getMaximumSize().height));
        this.logLevelField.setAlignmentX(0.5f);
        this.logLevelField.setAlignmentY(0.5f);
        this.logLevelField.setEditable(false);
        this.logLevelField.setForeground(Color.blue);
        this.logLevelField.setBackground(Color.gray);
        jPanel3.add((Component)this.logLevelField);
        this.upButton = new JButton("+");
        this.upButton.addActionListener((ActionListener)this);
        jPanel3.add((Component)this.upButton);
        this.downButton = new JButton("-");
        this.downButton.addActionListener((ActionListener)this);
        jPanel3.add((Component)this.downButton);
        jPanel3.setMaximumSize(new Dimension(jPanel3.getMaximumSize().width, Math.max(Math.max(jLabel2.getMaximumSize().height, this.logLevelField.getMaximumSize().height), Math.max(this.downButton.getMaximumSize().height, this.upButton.getMaximumSize().height))));
        this.components.addElement(jPanel3);
        JPanel jPanel4 = new JPanel();
        jPanel4.setBorder(BorderFactory.createEtchedBorder());
        jPanel4.setLayout((LayoutManager)new BoxLayout((Container)jPanel4, 1));
        jPanel.add("South", (Component)jPanel4);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new BoxLayout((Container)jPanel5, 0));
        jPanel4.add((Component)jPanel5);
        this.components.addElement(jPanel4);
        this.status = new JTextField("");
        this.status.setBorder(BorderFactory.createEtchedBorder());
        this.status.setEditable(false);
        this.status.setBackground(Color.lightGray);
        this.status.setForeground(Color.red);
        jPanel5.add((Component)this.status);
        this.spinner = new Spinner();
        this.spinner.setBorder(BorderFactory.createEtchedBorder());
        ((Component)((Object)this.spinner)).setBackground(Color.lightGray);
        ((Component)((Object)this.spinner)).setForeground(Color.red);
        jPanel5.add((Component)((Object)this.spinner));
        this.closeButton = new JButton("Close");
        this.closeButton.setBackground(Color.red);
        this.closeButton.setAlignmentX(0.5f);
        this.closeButton.setAlignmentY(0.5f);
        this.closeButton.addActionListener((ActionListener)this);
        jPanel4.add((Component)this.closeButton);
        this.components.addElement(jPanel4);
        ((Frame)((Object)this)).setTitle(this.titleString);
        this.adjustScrollHeight();
    }

    public void invalidate() {
        super.invalidate();
        this.adjustScrollHeight();
    }

    public void level(int n) {
        try {
            this.spinner.startSpinning();
            this.currentLogLevel = n;
            if (this.currentLogLevel < 0) {
                this.currentLogLevel = 0;
            }
            if (this.currentLogLevel > 9) {
                this.currentLogLevel = 9;
            }
            Runnable runnable = new Runnable(this){
                /* synthetic */ CQLogView this$0;

                public void run() {
                    CQLogView.access$refresh(this.this$0);
                }
                {
                    this.this$0 = cQLogView;
                }
            };
            SwingUtilities.invokeLater((Runnable)runnable);
            this.spinner.stopSpinning();
        }
        catch (Exception exception) {
            this.debug("log viewer.up exception: " + exception);
        }
    }

    private void refresh() {
        try {
            this.logLevelField.setText(String.valueOf(this.currentLogLevel));
            Vector vector = this.model.getLog(this.currentLogLevel);
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while (n < vector.size()) {
                int n2 = (Integer)((Pair)vector.elementAt(n)).getLeft();
                String string = (String)((Pair)vector.elementAt(n)).getRight();
                stringBuffer.append(indentArray[n2]);
                stringBuffer.append(string);
                stringBuffer.append("\n");
                ++n;
            }
            this.logField.setText(stringBuffer.toString());
        }
        catch (Exception exception) {
            this.debug("Log viewer.refresh exception: " + exception);
        }
    }

    public void setDebug(boolean bl) {
        this.debugging = bl;
    }

    void upButton_Clicked() {
        try {
            this.spinner.startSpinning();
            this.debug("Log View frame: up button clicked");
            ++this.currentLogLevel;
            if (this.currentLogLevel > 9) {
                this.currentLogLevel = 0;
            }
            Runnable runnable = new Runnable(this){
                /* synthetic */ CQLogView this$0;

                public void run() {
                    CQLogView.access$refresh(this.this$0);
                }
                {
                    this.this$0 = cQLogView;
                }
            };
            SwingUtilities.invokeLater((Runnable)runnable);
            this.spinner.stopSpinning();
        }
        catch (Exception exception) {
            this.debug("log viewer.up exception: " + exception);
        }
    }

    public void update(Observable observable, Object object) {
        try {
            if (observable == this.model) {
                Runnable runnable = new Runnable(this){
                    /* synthetic */ CQLogView this$0;

                    public void run() {
                        CQLogView.access$refresh(this.this$0);
                    }
                    {
                        this.this$0 = cQLogView;
                    }
                };
                SwingUtilities.invokeLater((Runnable)runnable);
            }
        }
        catch (Exception exception) {
            System.out.println("CQLogView update error:" + exception);
        }
    }

    public void validate() {
        this.adjustScrollHeight();
        super.validate();
    }

    static void access$refresh(CQLogView cQLogView) {
        cQLogView.refresh();
    }
}

