/*
 * Decompiled with CFR 0.152.
 */
package ogi.cq.log;

import java.awt.Color;
import java.io.Serializable;
import ogi.cq.log.CQLogModel;
import ogi.cq.log.CQLogView;
import ogi.cq.log.Log;
import ogi.cq.log.LogModel;
import ogi.cq.log.LogView;

public class CQLog
implements Log,
Serializable {
    int currentLevel = 0;
    LogModel model;
    LogView view;
    boolean debugging = false;
    public static final int MAX_LOG_LEVEL = 9;
    public static final int MIN_LOG_LEVEL = 0;

    public CQLog() {
        this(Color.lightGray);
    }

    public CQLog(Color color) {
        this("Log", color);
    }

    public CQLog(String string) {
        this(string, null);
    }

    public CQLog(String string, Color color) {
        this.model = new CQLogModel();
        this.view = new CQLogView(this.model, string, color);
    }

    public CQLog(LogModel logModel, LogView logView) {
        this.model = logModel;
        this.view = logView;
    }

    public void debug(Object object) {
        if (this.debugging) {
            if (object instanceof String) {
                System.err.println("|" + (String)object + "|");
            } else {
                System.err.println("|" + object.toString() + "|");
            }
        }
    }

    public boolean getDebug() {
        return this.debugging;
    }

    public void hide() {
        this.view.hide();
    }

    public void level(int n) {
        this.view.level(n);
    }

    public synchronized void log(int n, String string) {
        this.currentLevel = n;
        this.model.log(n, string);
    }

    public void log(String string) {
        this.log(this.currentLevel, string);
    }

    public void setDebug(boolean bl) {
        this.debugging = bl;
        this.model.setDebug(bl);
        this.view.setDebug(bl);
    }

    public void show() {
        this.view.show();
    }
}

