/*
 * Decompiled with CFR 0.152.
 */
package ogi.cq.gui;

import com.sun.java.swing.JButton;
import com.sun.java.swing.JComboBox;
import com.sun.java.swing.JFrame;
import com.sun.java.swing.JLabel;
import com.sun.java.swing.JPanel;
import com.sun.java.swing.JTextField;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Event;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Panel;
import java.awt.Window;
import ogi.cq.entity.User;
import ogi.cq.gui.InfoDialog;
import ogi.cq.gui.InfoDialogCallback;
import ogi.cq.gui.RegisterCallback;
import ogi.cq.gui.Spinner;
import ogi.cq.log.Log;
import ogi.cq.server.DatabaseAdapter;
import ogi.diom.util.GUI;

public class RegisterFrame
extends JFrame
implements InfoDialogCallback {
    public static final int REGISTER = 10;
    RegisterCallback callback;
    DatabaseAdapter DB;
    Log logger;
    JPanel borderPanel;
    JPanel labelPanel;
    JPanel fieldPanel;
    JPanel explainPanel;
    JLabel titleLabel;
    JComboBox titleChoice;
    JLabel idLabel;
    JTextField idField;
    JLabel firstNameLabel;
    JTextField firstNameField;
    JLabel lastNameLabel;
    JTextField lastNameField;
    JLabel emailLabel;
    JTextField emailField;
    JLabel passwordLabel;
    JTextField passwordField;
    JLabel password2Label;
    JTextField password2Field;
    JPanel controlPanel;
    JTextField status;
    Spinner spinner;
    JButton cancelButton;
    JButton registerButton;
    Color backgroundColor;

    public RegisterFrame(DatabaseAdapter databaseAdapter, RegisterCallback registerCallback, String string, Log log) {
        this(databaseAdapter, registerCallback, log, null);
        ((Frame)((Object)this)).setTitle(string);
    }

    public RegisterFrame(DatabaseAdapter databaseAdapter, RegisterCallback registerCallback, String string, Log log, Color color) {
        this(databaseAdapter, registerCallback, log, color);
        ((Frame)((Object)this)).setTitle(string);
    }

    public RegisterFrame(DatabaseAdapter databaseAdapter, RegisterCallback registerCallback, Log log) {
        this(databaseAdapter, registerCallback, log, null);
    }

    public RegisterFrame(DatabaseAdapter databaseAdapter, RegisterCallback registerCallback, Log log, Color color) {
        try {
            this.logger = log;
            this.backgroundColor = color;
            this.init();
            this.callback = registerCallback;
            this.DB = databaseAdapter;
        }
        catch (NullPointerException nullPointerException) {
            System.out.println("Register.new exception: " + nullPointerException);
        }
    }

    void cancelButton_Clicked(Event event) {
        this.callback.registerCallback(this, 1);
        ((Component)((Object)this)).setVisible(false);
    }

    public void clear() {
        this.firstNameField.setText("");
        this.lastNameField.setText("");
        this.idField.setText("");
        this.passwordField.setText("");
        this.password2Field.setText("");
    }

    public void clearPassword() {
        this.passwordField.setText("");
        this.password2Field.setText("");
    }

    public boolean handleEvent(Event event) {
        if (event.id == 201) {
            ((Component)((Object)this)).setVisible(false);
            return true;
        }
        if (event.target == this.registerButton && event.id == 1001) {
            this.registerButton_Clicked(event);
            return true;
        }
        if (event.target == this.cancelButton && event.id == 1001) {
            this.cancelButton_Clicked(event);
            return true;
        }
        return super.handleEvent(event);
    }

    public void infoDialogCallback() {
        ((Component)((Object)this)).setVisible(false);
    }

    private void init() {
        if (this.backgroundColor == null) {
            this.backgroundColor = Color.lightGray;
        }
        this.log(3, "beginning construction of registration frame");
        Font font = new Font("timesRoman", 1, 13);
        Font font2 = new Font("timesRoman", 2, 13);
        this.getContentPane().setLayout(new GridBagLayout());
        ((Component)((Object)this)).setSize(((Container)((Object)this)).getInsets().left + ((Container)((Object)this)).getInsets().right + 530, ((Container)((Object)this)).getInsets().top + ((Container)((Object)this)).getInsets().bottom + 570);
        ((Component)((Object)this)).setBackground(this.backgroundColor);
        Panel panel = new Panel();
        panel.setLayout(new GridBagLayout());
        panel.setBackground(this.backgroundColor);
        GUI.addComponent(this.getContentPane(), panel, 1, 0, 5, 1, 1, 10, 10.0, 5.0);
        JLabel jLabel = new JLabel("User Registration");
        Font font3 = new Font("timesRoman", 1, 24);
        jLabel.setFont(font3);
        GUI.addComponent(panel, (Component)jLabel, 1, 1, 1, 1, 0, 10, 10.0, 1.0);
        this.borderPanel = new JPanel();
        this.borderPanel.setBackground(this.backgroundColor);
        this.borderPanel.setLayout(new GridBagLayout());
        GUI.addComponent(this.getContentPane(), (Component)this.borderPanel, 1, 1, 2, 1, 1, 10, 5.0, 100.0);
        this.labelPanel = new JPanel();
        this.labelPanel.setLayout(new GridBagLayout());
        this.labelPanel.setBackground(this.backgroundColor);
        GUI.addComponent((Container)this.borderPanel, (Component)this.labelPanel, 1, 1, 1, 1, 1, 10, 5.0, 1.0);
        this.fieldPanel = new JPanel();
        this.fieldPanel.setLayout(new GridBagLayout());
        this.fieldPanel.setBackground(this.backgroundColor);
        GUI.addComponent((Container)this.borderPanel, (Component)this.fieldPanel, 2, 1, 1, 1, 1, 10, 5.0, 1.0);
        this.explainPanel = new JPanel();
        this.explainPanel.setLayout(new GridBagLayout());
        this.explainPanel.setBackground(this.backgroundColor);
        GUI.addComponent((Container)this.borderPanel, (Component)this.explainPanel, 3, 1, 1, 1, 1, 10, 5.0, 1.0);
        this.idLabel = new JLabel("Choose a Login Name:");
        this.idLabel.setFont(font);
        GUI.addComponent((Container)this.labelPanel, (Component)this.idLabel, 1, 1, 1, 1, 0, 10, 1.0, 1.0);
        this.idField = new JTextField();
        this.idField.setForeground(Color.blue);
        this.idField.setBackground(Color.lightGray);
        GUI.addComponent((Container)this.fieldPanel, (Component)this.idField, 1, 1, 1, 1, 2, 10, 5.0, 1.0);
        JLabel jLabel2 = new JLabel("Will be used as your ID");
        jLabel2.setFont(font2);
        GUI.addComponent((Container)this.explainPanel, (Component)jLabel2, 1, 1, 1, 1, 0, 10, 1.0, 1.0);
        this.passwordLabel = new JLabel("Choose your password:");
        this.passwordLabel.setFont(font);
        GUI.addComponent((Container)this.labelPanel, (Component)this.passwordLabel, 1, 2, 1, 1, 0, 10, 1.0, 1.0);
        this.passwordField = new JTextField();
        this.passwordField.setForeground(Color.lightGray);
        this.passwordField.setBackground(Color.lightGray);
        GUI.addComponent((Container)this.fieldPanel, (Component)this.passwordField, 1, 2, 1, 1, 2, 10, 5.0, 1.0);
        JLabel jLabel3 = new JLabel("");
        GUI.addComponent((Container)this.explainPanel, (Component)jLabel3, 1, 2, 1, 1, 0, 10, 1.0, 1.0);
        JLabel jLabel4 = new JLabel("Your password should be at least 4");
        jLabel4.setFont(font2);
        GUI.addComponent((Container)this.explainPanel, (Component)jLabel4, 1, 3, 1, 1, 0, 10, 1.0, 1.0);
        JLabel jLabel5 = new JLabel("characters long, and no more than 12");
        jLabel5.setFont(font2);
        GUI.addComponent((Container)this.explainPanel, (Component)jLabel5, 1, 4, 1, 1, 0, 10, 1.0, 1.0);
        JLabel jLabel6 = new JLabel("characters long.");
        jLabel6.setFont(font2);
        GUI.addComponent((Container)this.explainPanel, (Component)jLabel6, 1, 5, 1, 1, 0, 10, 1.0, 1.0);
        this.password2Label = new JLabel("Confirm your password:");
        this.password2Label.setFont(font);
        GUI.addComponent((Container)this.labelPanel, (Component)this.password2Label, 1, 6, 1, 1, 0, 10, 1.0, 1.0);
        this.password2Field = new JTextField();
        this.password2Field.setForeground(Color.lightGray);
        this.password2Field.setBackground(Color.lightGray);
        GUI.addComponent((Container)this.fieldPanel, (Component)this.password2Field, 1, 6, 1, 1, 2, 10, 5.0, 1.0);
        this.titleLabel = new JLabel("Title:");
        this.titleLabel.setFont(font);
        GUI.addComponent((Container)this.labelPanel, (Component)this.titleLabel, 1, 7, 1, 1, 0, 10, 1.0, 1.0);
        this.titleChoice = new JComboBox();
        this.titleChoice.setForeground(Color.blue);
        this.titleChoice.setBackground(Color.lightGray);
        this.titleChoice.addItem((Object)"Mr.");
        this.titleChoice.addItem((Object)"Ms.");
        this.titleChoice.addItem((Object)"Mrs.");
        this.titleChoice.addItem((Object)"Miss");
        this.titleChoice.addItem((Object)"M.");
        this.titleChoice.addItem((Object)"Dr.");
        this.titleChoice.addItem((Object)"Professor");
        this.titleChoice.setSelectedIndex(0);
        GUI.addComponent((Container)this.fieldPanel, (Component)this.titleChoice, 1, 7, 1, 1, 2, 10, 5.0, 1.0);
        JLabel jLabel7 = new JLabel("");
        GUI.addComponent((Container)this.explainPanel, (Component)jLabel7, 1, 6, 1, 1, 0, 10, 1.0, 1.0);
        JLabel jLabel8 = new JLabel("");
        GUI.addComponent((Container)this.explainPanel, (Component)jLabel8, 1, 7, 1, 1, 0, 10, 1.0, 1.0);
        JLabel jLabel9 = new JLabel("");
        GUI.addComponent((Container)this.explainPanel, (Component)jLabel9, 1, 8, 1, 1, 0, 10, 1.0, 1.0);
        JLabel jLabel10 = new JLabel("Your full name will be sent with");
        jLabel10.setFont(font2);
        GUI.addComponent((Container)this.explainPanel, (Component)jLabel10, 1, 9, 1, 1, 0, 10, 1.0, 1.0);
        JLabel jLabel11 = new JLabel("all later mail messages");
        jLabel11.setFont(font2);
        GUI.addComponent((Container)this.explainPanel, (Component)jLabel11, 1, 10, 1, 1, 0, 10, 1.0, 1.0);
        JLabel jLabel12 = new JLabel("");
        GUI.addComponent((Container)this.explainPanel, (Component)jLabel12, 1, 11, 1, 1, 0, 10, 1.0, 1.0);
        JLabel jLabel13 = new JLabel("");
        GUI.addComponent((Container)this.explainPanel, (Component)jLabel13, 1, 12, 1, 1, 0, 10, 1.0, 1.0);
        JLabel jLabel14 = new JLabel("");
        GUI.addComponent((Container)this.explainPanel, (Component)jLabel14, 1, 13, 1, 1, 0, 10, 1.0, 1.0);
        this.firstNameLabel = new JLabel("First Name:");
        this.firstNameLabel.setFont(font);
        GUI.addComponent((Container)this.labelPanel, (Component)this.firstNameLabel, 1, 8, 1, 1, 0, 10, 1.0, 1.0);
        this.firstNameField = new JTextField();
        this.firstNameField.setForeground(Color.blue);
        this.firstNameField.setBackground(Color.lightGray);
        GUI.addComponent((Container)this.fieldPanel, (Component)this.firstNameField, 1, 8, 1, 1, 2, 10, 5.0, 1.0);
        this.lastNameLabel = new JLabel("Last Name:");
        this.lastNameLabel.setFont(font);
        GUI.addComponent((Container)this.labelPanel, (Component)this.lastNameLabel, 1, 9, 1, 1, 0, 10, 1.0, 1.0);
        this.lastNameField = new JTextField();
        this.lastNameField.setForeground(Color.blue);
        this.lastNameField.setBackground(Color.lightGray);
        GUI.addComponent((Container)this.fieldPanel, (Component)this.lastNameField, 1, 9, 1, 1, 2, 10, 5.0, 1.0);
        this.emailLabel = new JLabel("Email Address:");
        this.emailLabel.setFont(font);
        GUI.addComponent((Container)this.labelPanel, (Component)this.emailLabel, 1, 10, 1, 1, 0, 10, 1.0, 1.0);
        this.emailField = new JTextField();
        this.emailField.setForeground(Color.blue);
        this.emailField.setBackground(Color.lightGray);
        GUI.addComponent((Container)this.fieldPanel, (Component)this.emailField, 1, 10, 1, 1, 2, 10, 5.0, 1.0);
        this.controlPanel = new JPanel();
        this.controlPanel.setLayout(new GridBagLayout());
        GUI.addComponent(this.getContentPane(), (Component)this.controlPanel, 1, 2, 2, 1, 1, 10, 1.0, 10.0);
        this.status = new JTextField("");
        this.status.setEditable(false);
        this.status.setBackground(Color.lightGray);
        this.status.setForeground(Color.red);
        GUI.addComponent((Container)this.controlPanel, (Component)this.status, 1, 1, 4, 1, 2, 10, 100.0, 1.0);
        this.spinner = new Spinner();
        ((Component)((Object)this.spinner)).setBackground(Color.lightGray);
        ((Component)((Object)this.spinner)).setForeground(Color.red);
        GUI.addComponent((Container)this.controlPanel, (Component)((Object)this.spinner), 5, 1, 1, 1, 0, 13, 1.0, 1.0);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.setForeground(Color.black);
        this.cancelButton.setBackground(Color.red);
        GUI.addComponent((Container)this.controlPanel, (Component)this.cancelButton, 1, 2, 2, 1, 1, 10, 50.0, 10.0);
        this.registerButton = new JButton("Register");
        this.registerButton.setForeground(Color.black);
        this.registerButton.setBackground(Color.yellow);
        GUI.addComponent((Container)this.controlPanel, (Component)this.registerButton, 3, 2, 2, 1, 1, 10, 50.0, 10.0);
        this.idField.requestFocus();
        ((Frame)((Object)this)).setTitle("Registration Dialog");
        this.log(3, "finished construction of registration frame");
    }

    public void log(int n, String string) {
        if (this.logger != null) {
            this.logger.log(n, string);
        }
    }

    void registerButton_Clicked(Event event) {
        this.log(0, "in register button clicked");
        this.spinner.startSpinning();
        if (!this.passwordField.getText().trim().equals(this.password2Field.getText().trim())) {
            this.log(2, "Unmatched passwords");
            this.status.setText("Passwords do not match.  Please re-enter");
            InfoDialog infoDialog = new InfoDialog("Passwords do not match.  Please re-enter", this);
            ((Dialog)((Object)infoDialog)).show();
            this.passwordField.setText("");
            this.password2Field.setText("");
            return;
        }
        if (this.lastNameField.getText().equals("")) {
            this.log(2, "Empty last name field");
            this.status.setText("Last name must be entered");
            InfoDialog infoDialog = new InfoDialog("Last name must be entered", this);
            ((Dialog)((Object)infoDialog)).show();
            return;
        }
        if (this.emailField.getText().equals("")) {
            this.log(2, "Empty email field");
            this.status.setText("Email address must be entered");
            InfoDialog infoDialog = new InfoDialog("Email address must be entered", this);
            ((Dialog)((Object)infoDialog)).show();
            return;
        }
        if (this.idField.getText().equals("")) {
            this.log(2, "Empty ID field");
            this.status.setText("Login ID must be entered");
            InfoDialog infoDialog = new InfoDialog("Login ID must be entered", this);
            ((Dialog)((Object)infoDialog)).show();
            return;
        }
        if (this.passwordField.getText().equals("") || this.passwordField.getText().trim().length() < 4) {
            this.log(2, "Bad password");
            this.status.setText("Password must be at least 4 characters long");
            InfoDialog infoDialog = new InfoDialog("Password must be at least 4 characters long", this);
            ((Dialog)((Object)infoDialog)).show();
            return;
        }
        this.log(0, "passed checks");
        User user = new User(null, null);
        user.setPrefix(this.titleChoice.getSelectedItem().toString());
        user.setName(String.valueOf(this.firstNameField.getText()) + " " + this.lastNameField.getText());
        user.setEmail(this.emailField.getText());
        user.setId(this.idField.getText());
        user.setPassword(this.passwordField.getText());
        this.log(0, "created user");
        String string = this.DB.register(user, this.firstNameField.getText().trim(), this.lastNameField.getText().trim());
        this.log(0, "sent registration");
        this.log(0, "results = " + string);
        String string2 = System.getProperty("line.separator");
        if (string.indexOf("PASS") < 0 && string.indexOf("Thank") < 0) {
            this.log(1, "Failed registration" + string2 + string);
            InfoDialog infoDialog = new InfoDialog("Registration failed: " + string2 + string, this, this);
            ((Dialog)((Object)infoDialog)).show();
        }
        this.log(0, "before callback");
        this.callback.registerCallback(this, 0);
        this.log(0, "after callback");
        ((Component)((Object)this)).setVisible(false);
        this.spinner.stopSpinning();
        ((Window)((Object)this)).dispose();
    }

    public void setLog(Log log) {
        this.logger = log;
    }
}

