/*
 * Decompiled with CFR 0.152.
 */
package ogi.cq.gui;

import com.sun.java.swing.BorderFactory;
import com.sun.java.swing.BoxLayout;
import com.sun.java.swing.JButton;
import com.sun.java.swing.JFrame;
import com.sun.java.swing.JLabel;
import com.sun.java.swing.JPanel;
import com.sun.java.swing.JTextField;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import ogi.cq.gui.ManagerState;
import ogi.cq.gui.Spinner;
import ogi.cq.gui.StatePanel;
import ogi.cq.log.Log;
import ogi.cq.log.OutLog;
import ogi.diom.util.GUI;

public class Manager
implements ActionListener {
    ManagerState state;
    JFrame frame;
    String frameTitle;
    Log logger;
    StatePanel[] statePanels;
    Object auxillaryObject;
    String titleString;
    Color backgroundColor;
    JPanel borderPanel1;
    JPanel cardPanel;
    JPanel[] panels;
    JPanel controlPanel;
    JTextField status;
    Spinner spinner;
    JButton startButton;
    JButton previousButton;
    JButton nextButton;
    JButton finishButton;
    JButton cancelButton;
    JButton resetButton;
    JButton logButton;

    public Manager(Object object, ManagerState managerState, String string) {
        this(object, managerState, null, string);
    }

    public Manager(Object object, ManagerState managerState, Log log, String string) {
        this.logger = log;
        if (this.logger == null) {
            System.out.println(" log is null -- switch to sysout");
            this.logger = new OutLog();
        }
        this.auxillaryObject = object;
        this.state = managerState;
        this.frameTitle = string;
        try {
            JPanel[] jPanelArray = this.state.getPanels();
            int n = 0;
            while (n < jPanelArray.length) {
                ++n;
            }
            this.panels = jPanelArray;
            this.frame = new JFrame(this.frameTitle);
            this.init();
            this.state.setManager(this);
            this.setPanel(this.state.current());
            this.frame.invalidate();
            this.frame.validate();
            this.frame.pack();
        }
        catch (Exception exception) {
            System.out.println("Manager.new error: " + exception);
        }
    }

    public Manager(ManagerState managerState, String string) {
        this(null, managerState, null, string);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.finishButton) {
            this.finishButton();
        } else if (actionEvent.getSource() == this.startButton) {
            this.startButton();
        } else if (actionEvent.getSource() == this.nextButton) {
            this.nextButton();
        } else if (actionEvent.getSource() == this.previousButton) {
            this.previousButton();
        } else if (actionEvent.getSource() == this.resetButton) {
            this.resetButton();
        } else if (actionEvent.getSource() == this.logButton) {
            if (this.logger != null) {
                this.logger.show();
            }
        } else if (actionEvent.getSource() == this.cancelButton) {
            this.cancelButton();
        }
    }

    public void cancelButton() {
        this.state.cancelButton();
        this.frame.setVisible(false);
        this.frame.dispose();
    }

    public void debug(String string) {
        if (this.logger != null) {
            this.logger.debug(string);
        } else {
            System.err.println(string);
        }
    }

    public void disableFinish() {
        this.finishButton.setEnabled(false);
        this.finishButton.setBackground(Color.lightGray);
    }

    public void disableNext() {
        this.nextButton.setEnabled(false);
        this.nextButton.setBackground(Color.lightGray);
    }

    public void disablePrevious() {
        this.previousButton.setEnabled(false);
        this.previousButton.setBackground(Color.lightGray);
    }

    public void disableReset() {
        this.resetButton.setEnabled(false);
        this.resetButton.setBackground(Color.lightGray);
    }

    public void disableStart() {
        this.startButton.setEnabled(false);
        this.startButton.setBackground(Color.lightGray);
    }

    public void enableFinish() {
        this.finishButton.setBackground(Color.orange);
        this.finishButton.setEnabled(true);
    }

    public void enableNext() {
        this.nextButton.setBackground(Color.yellow);
        this.nextButton.setEnabled(true);
    }

    public void enablePrevious() {
        this.previousButton.setBackground(Color.yellow);
        this.previousButton.setEnabled(true);
    }

    public void enableReset() {
        this.resetButton.setBackground(Color.orange);
        this.resetButton.setEnabled(true);
    }

    public void enableStart() {
        this.startButton.setBackground(Color.orange);
        this.startButton.setEnabled(true);
    }

    public void finishButton() {
        this.state.finishButton();
    }

    public Object getAuxillaryObject() {
        this.debug("auxillary object = " + (this.auxillaryObject == null ? "null" : this.auxillaryObject.toString()));
        return this.auxillaryObject;
    }

    public JFrame getFrame() {
        return this.frame;
    }

    public Log getLog() {
        return this.logger;
    }

    public ManagerState getState() {
        return this.state;
    }

    public void hide() {
        this.frame.setVisible(false);
    }

    private void init() {
        try {
            if (this.backgroundColor == null) {
                this.backgroundColor = Color.lightGray;
            }
            this.frame.getContentPane().setLayout(new GridBagLayout());
            this.frame.setSize(this.frame.getInsets().left + this.frame.getInsets().right + 530, this.frame.getInsets().top + this.frame.getInsets().bottom + 620);
            this.frame.getContentPane().setBackground(this.backgroundColor);
            Panel panel = new Panel();
            panel.setLayout(new GridBagLayout());
            panel.setBackground(this.backgroundColor);
            GUI.addComponent(this.frame.getContentPane(), panel, 1, 1, 5, 1, 0, 10, 0.0, 0.0);
            JLabel jLabel = new JLabel(this.titleString);
            Font font = new Font("timesRoman", 1, 16);
            jLabel.setFont(font);
            GUI.addComponent(panel, (Component)jLabel, 1, 1, 1, 1, 0, 10, 10.0, 1.0);
            this.borderPanel1 = new JPanel();
            this.borderPanel1.setBorder(BorderFactory.createEtchedBorder());
            this.borderPanel1.setLayout(new BorderLayout());
            GUI.addComponent(this.frame.getContentPane(), (Component)this.borderPanel1, 1, 2, 5, 1, 1, 10, 100.0, 100.0);
            this.cardPanel = new JPanel();
            CardLayout cardLayout = new CardLayout();
            this.cardPanel.setLayout(cardLayout);
            this.borderPanel1.add("Center", (Component)this.cardPanel);
            int n = 0;
            while (n < this.panels.length) {
                this.cardPanel.add((Component)this.panels[n], String.valueOf(n));
                ++n;
            }
            this.controlPanel = new JPanel();
            this.controlPanel.setLayout((LayoutManager)new BoxLayout((Container)this.controlPanel, 1));
            this.borderPanel1.add("South", (Component)this.controlPanel);
            Font font2 = new Font("timesRoman", 1, 14);
            JPanel jPanel = new JPanel();
            jPanel.setLayout((LayoutManager)new BoxLayout((Container)jPanel, 0));
            this.controlPanel.add((Component)jPanel);
            this.logButton = new JButton("Log");
            this.logButton.setAlignmentX(0.0f);
            this.logButton.setAlignmentY(0.5f);
            this.logButton.setBackground(Color.lightGray);
            this.logButton.setForeground(Color.black);
            this.logButton.setFont(font2);
            this.logButton.addActionListener((ActionListener)this);
            jPanel.add((Component)this.logButton);
            this.status = new JTextField("");
            this.status.setAlignmentX(0.0f);
            this.status.setAlignmentY(0.5f);
            this.status.setEditable(false);
            this.status.setBackground(Color.lightGray);
            this.status.setForeground(Color.red);
            jPanel.add((Component)this.status);
            this.spinner = new Spinner();
            this.spinner.setAlignmentX(0.0f);
            this.spinner.setAlignmentY(0.5f);
            jPanel.add((Component)((Object)this.spinner));
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout((LayoutManager)new BoxLayout((Container)jPanel2, 0));
            this.controlPanel.add((Component)jPanel2);
            this.cancelButton = new JButton("Cancel");
            this.cancelButton.setBackground(Color.red);
            this.cancelButton.setFont(font2);
            this.cancelButton.addActionListener((ActionListener)this);
            jPanel2.add((Component)this.cancelButton);
            this.resetButton = new JButton("Reset");
            this.resetButton.setBackground(Color.orange);
            this.resetButton.setFont(font2);
            this.resetButton.addActionListener((ActionListener)this);
            jPanel2.add((Component)this.resetButton);
            this.startButton = new JButton("<<- Start");
            this.startButton.setBackground(Color.yellow);
            this.startButton.setFont(font2);
            this.startButton.addActionListener((ActionListener)this);
            jPanel2.add((Component)this.startButton);
            this.previousButton = new JButton("<- Previous");
            this.previousButton.setBackground(Color.yellow);
            this.previousButton.setFont(font2);
            this.previousButton.addActionListener((ActionListener)this);
            jPanel2.add((Component)this.previousButton);
            this.nextButton = new JButton("Next ->");
            this.nextButton.setBackground(Color.yellow);
            this.nextButton.setFont(font2);
            this.nextButton.addActionListener((ActionListener)this);
            jPanel2.add((Component)this.nextButton);
            this.finishButton = new JButton("Finish");
            this.finishButton.setBackground(Color.orange);
            this.finishButton.setFont(font2);
            this.finishButton.addActionListener((ActionListener)this);
            jPanel2.add((Component)this.finishButton);
            this.setTitle(this.frame);
        }
        catch (Exception exception) {
            System.out.println("ManagerFrame init error: " + exception);
        }
    }

    public void lastPanel() {
        CardLayout cardLayout = (CardLayout)this.cardPanel.getLayout();
        try {
            cardLayout.last((Container)this.cardPanel);
        }
        catch (Exception exception) {
            System.out.println("ManagerFrame.lastPanel error: " + exception);
        }
    }

    public void log(int n, String string) {
        if (this.logger != null) {
            this.logger.log(n, string);
        } else {
            System.out.println(string);
        }
    }

    public void nextButton() {
        this.state.nextButton();
    }

    public void nextPanel() {
        CardLayout cardLayout = (CardLayout)this.cardPanel.getLayout();
        try {
            cardLayout.next((Container)this.cardPanel);
            this.cardPanel.repaint();
            cardLayout.layoutContainer((Container)this.cardPanel);
            cardLayout.invalidateLayout((Container)this.cardPanel);
        }
        catch (Exception exception) {
            System.out.println("ManagerFrame.nextPanel error: " + exception);
        }
    }

    public void previousButton() {
        this.state.previousButton();
    }

    public void previousPanel() {
        CardLayout cardLayout = (CardLayout)this.cardPanel.getLayout();
        try {
            cardLayout.previous((Container)this.cardPanel);
        }
        catch (Exception exception) {
            System.out.println("ManagerFrame.previousPanel error: " + exception);
        }
    }

    public void reset() {
        this.state.reset();
    }

    public void resetButton() {
        this.state.reset();
    }

    public void run() {
    }

    public void setAuxillaryObject(Object object) {
        this.auxillaryObject = object;
        if (object != null) {
            this.debug("aux obj = " + object);
        }
    }

    public void setLocalFont(Font font) {
        this.state.setLocalFont(font);
    }

    public void setLog(Log log) {
        this.logger = log;
    }

    public void setPanel(int n) {
        CardLayout cardLayout = (CardLayout)this.cardPanel.getLayout();
        try {
            cardLayout.first((Container)this.cardPanel);
            int n2 = 0;
            while (n2 < n) {
                cardLayout.next((Container)this.cardPanel);
                ++n2;
            }
        }
        catch (Exception exception) {
            System.out.println("ManagerFrame.setPanel error: " + exception);
        }
    }

    public void setSize(int n, int n2) {
        this.frame.setSize(n, n2);
    }

    public void setStatus(String string) {
        System.out.println(string);
        this.status.setText(string);
    }

    public void setTitle(JFrame jFrame) {
        this.state.setTitle(jFrame);
    }

    public void setVisible(boolean bl) {
        this.frame.setVisible(bl);
    }

    public void show() {
        this.frame.setVisible(true);
    }

    public void startButton() {
        this.state.startButton();
    }

    public void startPanel() {
        CardLayout cardLayout = (CardLayout)this.cardPanel.getLayout();
        try {
            cardLayout.first((Container)this.cardPanel);
        }
        catch (Exception exception) {
            System.out.println("ManagerFrame.startPanel error: " + exception);
        }
    }

    public void startSpinner() {
        this.spinner.startSpinning();
    }

    public void stopSpinner() {
        this.spinner.stopSpinning();
    }
}

