/*
 * Decompiled with CFR 0.152.
 */
package ogi.cq.gui;

import com.sun.java.swing.JButton;
import com.sun.java.swing.JFrame;
import com.sun.java.swing.JLabel;
import com.sun.java.swing.JPanel;
import com.sun.java.swing.JTextField;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Event;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagLayout;
import ogi.cq.entity.User;
import ogi.cq.gui.InfoDialog;
import ogi.cq.gui.LoginCallback;
import ogi.cq.gui.Spinner;
import ogi.cq.log.Log;
import ogi.cq.server.DatabaseAdapter;
import ogi.cq.util.ThreadedMethodInvoker;
import ogi.diom.util.GUI;

public class LoginFrame
extends JFrame {
    DatabaseAdapter DB;
    LoginCallback callback;
    int button;
    JPanel borderPanel1;
    JPanel borderPanel2;
    JLabel idLabel;
    JTextField idField;
    JLabel passwordLabel;
    JTextField passwordField;
    JPanel controlPanel;
    JTextField status;
    Spinner spinner;
    JButton loginButton;
    JButton registerButton;
    JButton cancelButton;
    Color backgroundColor;
    Log logger;

    public LoginFrame(DatabaseAdapter databaseAdapter, LoginCallback loginCallback, int n, Log log) {
        this.DB = databaseAdapter;
        this.callback = loginCallback;
        this.logger = log;
        this.init();
        this.button = n;
    }

    public LoginFrame(DatabaseAdapter databaseAdapter, LoginCallback loginCallback, int n, Log log, Color color) {
        this.DB = databaseAdapter;
        this.callback = loginCallback;
        this.logger = log;
        this.backgroundColor = color;
        this.init();
        this.button = n;
    }

    void cancelButton_Clicked(Event event) {
        try {
            this.spinner.startSpinning();
            this.callback.loginCallback(this, null, this.button, 2);
            ((Component)((Object)this)).setVisible(false);
            this.spinner.stopSpinning();
        }
        catch (Exception exception) {
            System.out.println("login exception: " + exception);
        }
    }

    public void clearPassword() {
        this.passwordField.setText("");
    }

    public boolean handleEvent(Event event) {
        if (event.target == this.loginButton && event.id == 1001) {
            this.loginButton_Clicked(event);
            return true;
        }
        if (event.target == this.registerButton && event.id == 1001) {
            this.registerButton_Clicked(event);
            return true;
        }
        if (event.target == this.cancelButton && event.id == 1001) {
            this.cancelButton_Clicked(event);
            return true;
        }
        return super.handleEvent(event);
    }

    void init() {
        if (this.backgroundColor == null) {
            this.backgroundColor = Color.lightGray;
        }
        this.log(4, "beginning construction of login frame");
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().setBackground(this.backgroundColor);
        ((Component)((Object)this)).setSize(((Container)((Object)this)).getInsets().left + ((Container)((Object)this)).getInsets().right + 530, ((Container)((Object)this)).getInsets().top + ((Container)((Object)this)).getInsets().bottom + 570);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBackground(this.backgroundColor);
        GUI.addComponent(this.getContentPane(), (Component)jPanel, 1, 0, 5, 1, 1, 10, 10.0, 5.0);
        JLabel jLabel = new JLabel("Please log in");
        Font font = new Font("timesRoman", 1, 24);
        jLabel.setFont(font);
        GUI.addComponent((Container)jPanel, (Component)jLabel, 1, 1, 1, 1, 0, 10, 10.0, 1.0);
        this.borderPanel1 = new JPanel();
        this.borderPanel1.setLayout(new GridBagLayout());
        GUI.addComponent(this.getContentPane(), (Component)this.borderPanel1, 1, 1, 10, 1, 1, 10, 100.0, 60.0);
        this.idLabel = new JLabel("ID:");
        GUI.addComponent((Container)this.borderPanel1, (Component)this.idLabel, 1, 1, 1, 1, 0, 17, 1.0, 1.0);
        this.idField = new JTextField();
        this.idField.setForeground(Color.blue);
        this.idField.setBackground(Color.lightGray);
        GUI.addComponent((Container)this.borderPanel1, (Component)this.idField, 2, 1, 10, 1, 2, 10, 100.0, 1.0);
        this.passwordLabel = new JLabel("Password:");
        GUI.addComponent((Container)this.borderPanel1, (Component)this.passwordLabel, 1, 2, 1, 1, 0, 17, 1.0, 1.0);
        this.passwordField = new JTextField();
        this.passwordField.setForeground(Color.lightGray);
        this.passwordField.setBackground(Color.lightGray);
        GUI.addComponent((Container)this.borderPanel1, (Component)this.passwordField, 2, 2, 10, 1, 2, 10, 100.0, 1.0);
        JLabel jLabel2 = new JLabel("");
        GUI.addComponent(this.getContentPane(), (Component)jLabel2, 1, 2, 10, 1, 1, 10, 100.0, 100.0);
        this.controlPanel = new JPanel();
        this.controlPanel.setLayout(new GridBagLayout());
        GUI.addComponent(this.getContentPane(), (Component)this.controlPanel, 1, 3, 10, 1, 1, 10, 1.0, 10.0);
        this.status = new JTextField("");
        this.status.setEditable(false);
        this.status.setBackground(Color.lightGray);
        this.status.setForeground(Color.red);
        GUI.addComponent((Container)this.controlPanel, (Component)this.status, 1, 1, 6, 1, 2, 10, 100.0, 1.0);
        this.spinner = new Spinner();
        ((Component)((Object)this.spinner)).setBackground(Color.lightGray);
        ((Component)((Object)this.spinner)).setForeground(Color.red);
        GUI.addComponent((Container)this.controlPanel, (Component)((Object)this.spinner), 7, 1, 1, 1, 0, 13, 1.0, 1.0);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.setBackground(Color.red);
        GUI.addComponent((Container)this.controlPanel, (Component)this.cancelButton, 1, 2, 2, 1, 1, 10, 1.0, 5.0);
        this.registerButton = new JButton("Register");
        this.registerButton.setBackground(Color.orange);
        GUI.addComponent((Container)this.controlPanel, (Component)this.registerButton, 3, 2, 2, 1, 1, 10, 1.0, 5.0);
        this.loginButton = new JButton("Login");
        this.loginButton.setBackground(Color.green);
        GUI.addComponent((Container)this.controlPanel, (Component)this.loginButton, 5, 2, 2, 1, 1, 10, 1.0, 5.0);
        this.idField.requestFocus();
        ((Frame)((Object)this)).setTitle("Login Dialog");
        this.log(4, "finished construction of login frame");
    }

    public void log(int n, String string) {
        if (this.logger != null) {
            this.logger.log(n, string);
        }
    }

    public void login() {
        this.loginButton.setEnabled(false);
        this.spinner.startSpinning();
        this.status.setText("Verifing user ID for " + this.idField.getText());
        try {
            this.log(3, "checking password for " + this.idField.getText());
            if (this.DB == null) {
                this.spinner.stopSpinning();
                this.status.setText("Connection not established");
                return;
            }
            boolean bl = false;
            try {
                bl = this.DB.checkID(this.idField.getText(), this.passwordField.getText());
            }
            catch (Exception exception) {
                System.out.println("Error in loginButton(DB.checkID()): " + exception);
            }
            if (bl) {
                this.log(4, "password valid");
                User user = new User(this.idField.getText(), this.passwordField.getText());
                ((Component)((Object)this)).setVisible(false);
                this.callback.loginCallback(this, user, this.button, 0);
            } else {
                this.log(4, "password INVALID");
                ((Dialog)((Object)new InfoDialog("Login Failed", this))).show();
                ((Component)((Object)this)).setVisible(false);
                this.callback.loginCallback(this, null, this.button, 2);
            }
        }
        catch (Exception exception) {
            System.out.println("login frame:loginButton_clicked Exception: " + exception);
        }
        this.spinner.stopSpinning();
        this.status.setText("");
        this.loginButton.setEnabled(true);
    }

    void loginButton_Clicked(Event event) {
        ThreadedMethodInvoker threadedMethodInvoker = new ThreadedMethodInvoker((Object)this, "login");
        threadedMethodInvoker.start();
    }

    void registerButton_Clicked(Event event) {
        try {
            this.spinner.startSpinning();
            this.callback.loginCallback(this, null, this.button, 10);
            ((Component)((Object)this)).setVisible(false);
            this.spinner.stopSpinning();
        }
        catch (Exception exception) {
            System.out.println("login exception: " + exception);
        }
    }

    public void setButton(int n) {
        this.button = n;
    }

    public void setLog(Log log) {
        this.logger = log;
    }
}

