/*
 * Decompiled with CFR 0.152.
 */
package ogi.cq.gui;

import com.sun.java.swing.JButton;
import com.sun.java.swing.JFrame;
import com.sun.java.swing.JLabel;
import com.sun.java.swing.JPanel;
import com.sun.java.swing.JTextField;
import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Event;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Window;
import java.net.InetAddress;
import java.rmi.Naming;
import ogi.cq.entity.User;
import ogi.cq.gui.LoginCallback;
import ogi.cq.gui.LoginFrame;
import ogi.cq.gui.Manager;
import ogi.cq.gui.RegisterCallback;
import ogi.cq.gui.RegisterFrame;
import ogi.cq.gui.Spinner;
import ogi.cq.gui.UnfinishedState;
import ogi.cq.log.CQLog;
import ogi.cq.log.Log;
import ogi.cq.server.AccessFactory;
import ogi.cq.server.DBaccess;
import ogi.cq.server.DatabaseAdapter;
import ogi.cq.server.DatabaseAdapterImpl;
import ogi.diom.util.DIOMEvent;
import ogi.diom.util.GUI;

public class Home
extends JFrame
implements RegisterCallback,
LoginCallback {
    protected DatabaseAdapter DB;
    protected Applet applet;
    protected static String CQurl = "http://www.cse.ogi.edu/DISC/CQ/html/";
    protected static String CQserver = "http://chinook.cse.ogi.edu:8080/CQ/html/";
    protected static String CQoracle = "http://chinook.cse.ogi.edu:10090/oracle";
    protected User user;
    protected Log logger;
    protected LoginFrame login;
    protected RegisterFrame registrar;
    protected Font localFont = new Font("TimesRoman", 1, 24);
    protected String str = "Welcome to the CQ Bibliography Server";
    protected Thread thread;
    protected String titleString = "Continual Query Services";
    protected String subtitleString = "Generic System";
    protected JPanel userPanel;
    protected JPanel browsePanel;
    protected JPanel sourcePanel;
    protected JButton loginButton;
    protected JButton registerButton;
    protected JButton updateUserButton;
    protected JButton newQueryButton;
    protected JButton browseButton;
    protected JButton browseQueriesButton;
    protected JButton newSourceButton;
    protected JButton browseSourcesButton;
    protected JButton updateSourceButton;
    protected JPanel controlPanel;
    protected JButton exitButton;
    protected JButton logButton;
    protected JTextField status;
    protected Spinner spinner;
    protected Color backgroundColor;
    protected static final int LOGIN = 0;
    protected static final int REGISTER = 1;
    protected static final int UPDATE_USER = 2;
    protected static final int NEW_QUERY = 3;
    protected static final int BROWSE = 4;
    protected static final int BROWSE_QUERIES = 5;
    protected static final int NEW_SOURCE = 6;
    protected static final int BROWSE_SOURCES = 7;
    protected static final int UPDATE_SOURCE = 8;
    public static final boolean DEBUG = true;

    protected Home() {
        this.newLog();
    }

    public Home(Applet applet) {
        this();
        this.applet = applet;
        this.init();
        this.DB = new DatabaseAdapterImpl();
        this.logger.debug("after DBImpl: ");
        this.DB.setApplet(this.applet);
        this.DB.setLog(this.logger);
        if (applet == null || this.applet == null) {
            this.logger.debug("null applet");
        }
        try {
            int n = 0;
            try {
                n = Integer.parseInt(this.applet.getParameter("Server"));
                this.logger.debug("port of Bib server is " + n);
            }
            catch (Exception exception) {
                this.logger.debug("Error in getting port of Bib server");
            }
            AccessFactory accessFactory = null;
            String string = InetAddress.getByName(this.applet.getCodeBase().getHost()).getHostAddress();
            accessFactory = n == 0 ? (AccessFactory)Naming.lookup("//" + string + "/BibServer") : (AccessFactory)Naming.lookup("//" + string + ":" + n + "/BibServer");
            DBaccess dBaccess = null;
            try {
                dBaccess = accessFactory.getAccess();
                this.logger.debug("created new DBaccess");
            }
            catch (Exception exception) {
                this.logger.debug("Error in creating new DBaccess ");
                this.status.setText("Error in connecting to Server");
            }
            this.logger.debug("after access: ");
            this.logger.debug("access: " + dBaccess.toString());
            this.DB.setDB(dBaccess);
        }
        catch (Exception exception) {
            this.logger.debug("error in connecting to server: " + exception);
        }
    }

    public Home(Applet applet, String string) {
        this(applet);
        ((Frame)((Object)this)).setTitle(string);
    }

    protected void browseButton_Clicked(Event event) {
        this.status.setText("home: Browse button clicked...");
    }

    protected void browseQueriesButton_Clicked(Event event) {
        this.status.setText("home: Browse installed CQ's...");
    }

    protected void browseSourcesButton_Clicked(Event event) {
        this.status.setText("Browse sources...");
    }

    public void eventOccurred(DIOMEvent dIOMEvent) {
        this.spinner.startSpinning();
        if (dIOMEvent.getTarget() instanceof User) {
            this.user = (User)dIOMEvent.getTarget();
            this.logger.log(3, String.valueOf(this.user == null ? "No one" : this.user.getId()) + " is the current user");
            this.spinner.stopSpinning();
            int n = (Integer)dIOMEvent.getArg();
            this.logger.log(String.valueOf(this.user == null ? "No one" : this.user.getId()) + " is now logged in");
            switch (n) {
                case 0: {
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    this.updateUserButton_Clicked(new Event(dIOMEvent.getTarget(), dIOMEvent.getEvent(), dIOMEvent.getTarget()));
                    break;
                }
                case 3: {
                    this.newQueryButton_Clicked(new Event(dIOMEvent.getTarget(), dIOMEvent.getEvent(), dIOMEvent.getTarget()));
                    break;
                }
                case 4: {
                    this.browseButton_Clicked(new Event(dIOMEvent.getTarget(), dIOMEvent.getEvent(), dIOMEvent.getTarget()));
                    break;
                }
                case 5: {
                    this.browseQueriesButton_Clicked(new Event(dIOMEvent.getTarget(), dIOMEvent.getEvent(), dIOMEvent.getTarget()));
                    break;
                }
                case 6: {
                    this.newSourceButton_Clicked(new Event(dIOMEvent.getTarget(), dIOMEvent.getEvent(), dIOMEvent.getTarget()));
                    break;
                }
                case 7: {
                    this.browseSourcesButton_Clicked(new Event(dIOMEvent.getTarget(), dIOMEvent.getEvent(), dIOMEvent.getTarget()));
                    break;
                }
                case 8: {
                    this.updateSourceButton_Clicked(new Event(dIOMEvent.getTarget(), dIOMEvent.getEvent(), dIOMEvent.getTarget()));
                    break;
                }
            }
            return;
        }
        if (dIOMEvent.getTarget() == this.login && dIOMEvent.getEvent() == 10) {
            this.spinner.stopSpinning();
            this.registerButton_Clicked(new Event(dIOMEvent, dIOMEvent.getEvent(), dIOMEvent.getTarget()));
        }
        this.spinner.stopSpinning();
    }

    protected void exitButton_Clicked(Event event) {
        try {
            this.status.setText("Exitting...");
            this.spinner.startSpinning();
            this.logger.debug("Home: EXIT button clicked");
            if (this.applet == null) {
                this.spinner.stopSpinning();
                System.exit(1);
            } else {
                ((Component)((Object)this)).setVisible(false);
                ((Window)((Object)this)).dispose();
            }
        }
        catch (Exception exception) {
            this.logger.debug("Home.exit exception: " + exception);
        }
    }

    protected String getSubtitleString() {
        return this.subtitleString;
    }

    protected String getTitleString() {
        return this.titleString;
    }

    public boolean handleEvent(Event event) {
        if (event.id == 201) {
            ((Component)((Object)this)).setVisible(false);
            if (this.applet == null) {
                System.exit(1);
            }
            return true;
        }
        if (event.target == this.loginButton && event.id == 1001) {
            this.loginButton_Clicked(event, 0);
            return true;
        }
        if (event.target == this.registerButton && event.id == 1001) {
            this.registerButton_Clicked(event);
            return true;
        }
        if (event.target == this.updateUserButton && event.id == 1001) {
            this.updateUserButton_Clicked(event);
            return true;
        }
        if (event.target == this.browseButton && event.id == 1001) {
            this.browseButton_Clicked(event);
            return true;
        }
        if (event.target == this.browseQueriesButton && event.id == 1001) {
            this.browseQueriesButton_Clicked(event);
            return true;
        }
        if (event.target == this.newSourceButton && event.id == 1001) {
            this.newSourceButton_Clicked(event);
            return true;
        }
        if (event.target == this.browseSourcesButton && event.id == 1001) {
            this.browseSourcesButton_Clicked(event);
            return true;
        }
        if (event.target == this.updateSourceButton && event.id == 1001) {
            this.updateSourceButton_Clicked(event);
            return true;
        }
        if (event.target == this.newQueryButton && event.id == 1001) {
            this.newQueryButton_Clicked(event);
            return true;
        }
        if (event.target == this.logButton && event.id == 1001) {
            this.logButton_Clicked(event);
            return true;
        }
        if (event.target == this.exitButton && event.id == 1001) {
            this.exitButton_Clicked(event);
            return true;
        }
        return super.handleEvent(event);
    }

    protected void init() {
        try {
            if (this.backgroundColor == null) {
                this.backgroundColor = Color.lightGray;
            }
            this.getContentPane().setLayout(new GridBagLayout());
            this.getContentPane().setSize(((Container)((Object)this)).getInsets().left + ((Container)((Object)this)).getInsets().right + 580, ((Container)((Object)this)).getInsets().top + ((Container)((Object)this)).getInsets().bottom + 480);
            this.getContentPane().setBackground(this.backgroundColor);
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new GridBagLayout());
            jPanel.setBackground(this.backgroundColor);
            GUI.addComponent(this.getContentPane(), (Component)jPanel, 0, 0, 7, 1, 1, 10, 1.0, 1.0);
            JLabel jLabel = new JLabel("");
            GUI.addComponent((Container)jPanel, (Component)jLabel, 1, 0, 1, 1, 0, 10, 10.0, 1.0);
            JLabel jLabel2 = new JLabel(this.getTitleString());
            jLabel2.setBackground(this.backgroundColor);
            jLabel2.setForeground(Color.red);
            Font font = new Font("timesRoman", 1, 34);
            jLabel2.setFont(font);
            GUI.addComponent((Container)jPanel, (Component)jLabel2, 1, 1, 1, 1, 0, 10, 10.0, 1.0);
            JLabel jLabel3 = new JLabel(this.getSubtitleString());
            jLabel3.setBackground(this.backgroundColor);
            jLabel3.setForeground(Color.blue);
            Font font2 = new Font("timesRoman", 3, 30);
            jLabel3.setFont(font2);
            GUI.addComponent((Container)jPanel, (Component)jLabel3, 1, 2, 1, 1, 0, 10, 10.0, 1.0);
            JLabel jLabel4 = new JLabel("");
            GUI.addComponent((Container)jPanel, (Component)jLabel4, 1, 3, 1, 1, 1, 15, 0.0, 100.0);
            Font font3 = new Font("timesRoman", 1, 14);
            this.userPanel = new JPanel();
            this.userPanel.setLayout(new GridBagLayout());
            GUI.addComponent(this.getContentPane(), (Component)this.userPanel, 1, 1, 2, 1, 1, 10, 1.0, 20.0);
            this.loginButton = new JButton("Log In");
            this.loginButton.setBackground(Color.green);
            this.loginButton.setFont(font3);
            GUI.addComponent((Container)this.userPanel, (Component)this.loginButton, 1, 1, 1, 1, 1, 10, 1.0, 1.0);
            this.registerButton = new JButton("Register");
            this.registerButton.setBackground(Color.green);
            this.registerButton.setFont(font3);
            GUI.addComponent((Container)this.userPanel, (Component)this.registerButton, 1, 2, 1, 1, 1, 10, 1.0, 1.0);
            this.updateUserButton = new JButton("Update User Information");
            this.updateUserButton.setBackground(Color.green);
            this.updateUserButton.setFont(font3);
            GUI.addComponent((Container)this.userPanel, (Component)this.updateUserButton, 1, 3, 1, 1, 1, 10, 1.0, 1.0);
            this.browsePanel = new JPanel();
            this.browsePanel.setLayout(new GridBagLayout());
            GUI.addComponent(this.getContentPane(), (Component)this.browsePanel, 3, 1, 2, 1, 1, 10, 1.0, 10.0);
            this.newQueryButton = new JButton("Install Continual Query");
            this.newQueryButton.setBackground(Color.yellow);
            this.newQueryButton.setFont(font3);
            GUI.addComponent((Container)this.browsePanel, (Component)this.newQueryButton, 1, 1, 1, 1, 1, 10, 1.0, 1.0);
            this.browseButton = new JButton("Standard Query");
            this.browseButton.setBackground(Color.yellow);
            this.browseButton.setFont(font3);
            GUI.addComponent((Container)this.browsePanel, (Component)this.browseButton, 1, 2, 1, 1, 1, 10, 1.0, 1.0);
            this.browseQueriesButton = new JButton("View Installed CQs");
            this.browseQueriesButton.setBackground(Color.yellow);
            this.browseQueriesButton.setFont(font3);
            GUI.addComponent((Container)this.browsePanel, (Component)this.browseQueriesButton, 1, 3, 1, 1, 1, 10, 1.0, 1.0);
            this.sourcePanel = new JPanel();
            this.sourcePanel.setLayout(new GridBagLayout());
            GUI.addComponent(this.getContentPane(), (Component)this.sourcePanel, 5, 1, 2, 1, 1, 10, 1.0, 10.0);
            this.newSourceButton = new JButton("Add New Source");
            this.newSourceButton.setBackground(Color.orange);
            this.newSourceButton.setFont(font3);
            GUI.addComponent((Container)this.sourcePanel, (Component)this.newSourceButton, 1, 1, 1, 1, 1, 10, 1.0, 1.0);
            this.browseSourcesButton = new JButton("Browse Sources");
            this.browseSourcesButton.setBackground(Color.orange);
            this.browseSourcesButton.setFont(font3);
            GUI.addComponent((Container)this.sourcePanel, (Component)this.browseSourcesButton, 1, 2, 1, 1, 1, 10, 1.0, 1.0);
            this.updateSourceButton = new JButton("Update Source");
            this.updateSourceButton.setBackground(Color.orange);
            this.updateSourceButton.setFont(font3);
            GUI.addComponent((Container)this.sourcePanel, (Component)this.updateSourceButton, 1, 3, 1, 1, 1, 10, 1.0, 1.0);
            this.controlPanel = new JPanel();
            this.controlPanel.setLayout(new GridBagLayout());
            GUI.addComponent(this.getContentPane(), (Component)this.controlPanel, 1, 3, 10, 1, 1, 10, 1.0, 10.0);
            this.logButton = new JButton("Log");
            this.logButton.setBackground(this.backgroundColor);
            this.logButton.setFont(font3);
            GUI.addComponent((Container)this.controlPanel, (Component)this.logButton, 1, 1, 1, 1, 2, 10, 1.0, 10.0);
            this.status = new JTextField("");
            this.status.setEditable(false);
            this.status.setBackground(Color.lightGray);
            this.status.setForeground(Color.red);
            GUI.addComponent((Container)this.controlPanel, (Component)this.status, 2, 1, 3, 1, 2, 10, 100.0, 1.0);
            this.spinner = new Spinner();
            ((Component)((Object)this.spinner)).setBackground(Color.lightGray);
            ((Component)((Object)this.spinner)).setForeground(Color.red);
            GUI.addComponent((Container)this.controlPanel, (Component)((Object)this.spinner), 5, 1, 1, 1, 0, 13, 1.0, 10.0);
            this.exitButton = new JButton("Exit");
            this.exitButton.setBackground(Color.red);
            this.exitButton.setFont(font3);
            GUI.addComponent((Container)this.controlPanel, (Component)this.exitButton, 1, 2, 10, 2, 1, 10, 1.0, 10.0);
            ((Frame)((Object)this)).setTitle("CQ Bibliographic Information System");
            this.logger.debug("Finished Home init");
        }
        catch (Exception exception) {
            this.logger.debug("error in Home init: " + exception.getMessage());
            exception.printStackTrace();
        }
    }

    public void log(int n, String string) {
        if (this.logger != null) {
            this.logger.log(n, string);
        }
    }

    public void log(String string) {
        if (this.logger != null) {
            this.logger.log(string);
        }
    }

    protected void logButton_Clicked(Event event) {
        this.spinner.startSpinning();
        this.logger.debug("Home: LOG button clicked");
        this.logger.show();
        this.spinner.stopSpinning();
    }

    protected void loginButton_Clicked(Event event, int n) {
        this.logger.log(4, "new user -- old user erased");
        try {
            this.status.setText("Beginning Login process...");
            this.spinner.startSpinning();
            this.logger.debug("CQ Home: login button clicked");
            if (this.login == null) {
                this.login = new LoginFrame(this.DB, this, n, this.logger);
            }
            this.login.clearPassword();
            this.login.setButton(n);
            ((Window)((Object)this.login)).show();
            this.spinner.stopSpinning();
            this.status.setText("");
        }
        catch (Exception exception) {
            this.logger.debug("Home.login exception: " + exception);
        }
    }

    public void loginCallback(LoginFrame loginFrame, User user, int n, int n2) {
        this.spinner.startSpinning();
        if (n2 == 1) {
            this.spinner.stopSpinning();
            this.registerButton_Clicked(new Event((Object)loginFrame, n, user));
            return;
        }
        this.logger.log(3, String.valueOf(user == null ? "No one" : user.getId()) + " is the current user");
        this.spinner.stopSpinning();
        int n3 = n;
        this.logger.log(String.valueOf(user == null ? "No one" : user.getId()) + " is now logged in");
        switch (n3) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                this.updateUserButton_Clicked(new Event((Object)loginFrame, n, user));
                break;
            }
            case 3: {
                this.newQueryButton_Clicked(new Event((Object)loginFrame, n, user));
                break;
            }
            case 4: {
                this.browseButton_Clicked(new Event((Object)loginFrame, n, user));
                break;
            }
            case 5: {
                this.browseQueriesButton_Clicked(new Event((Object)loginFrame, n, user));
                break;
            }
            case 6: {
                this.newSourceButton_Clicked(new Event((Object)loginFrame, n, user));
                break;
            }
            case 7: {
                this.browseSourcesButton_Clicked(new Event((Object)loginFrame, n, user));
                break;
            }
            case 8: {
                this.updateSourceButton_Clicked(new Event((Object)loginFrame, n, user));
                break;
            }
        }
        this.spinner.stopSpinning();
    }

    protected void newLog() {
        try {
            this.logger = new CQLog("Home Log");
            this.logger.debug("new log");
            this.logger.setDebug(true);
        }
        catch (Exception exception) {
            this.logger.debug("Error in creating log: " + exception);
        }
    }

    protected void newQueryButton_Clicked(Event event) {
        this.status.setText("new Query button clicked");
    }

    protected void newSourceButton_Clicked(Event event) {
        this.status.setText("new Source button clicked");
    }

    protected void registerButton_Clicked(Event event) {
        this.logger.log("Register new user");
        try {
            this.status.setText("Register new user...");
            this.spinner.startSpinning();
            this.logger.debug("CQ Home: register button clicked");
            if (this.registrar == null) {
                this.registrar = new RegisterFrame(this.DB, this, this.logger);
            }
            this.registrar.clearPassword();
            ((Window)((Object)this.registrar)).show();
            this.spinner.stopSpinning();
            this.status.setText("");
        }
        catch (Exception exception) {
            this.logger.debug("Home.register exception: " + exception);
        }
    }

    public void registerCallback(RegisterFrame registerFrame, int n) {
    }

    protected void setTitle() {
        Panel panel = new Panel();
        panel.setLayout(new GridBagLayout());
        panel.setBackground(this.backgroundColor);
        GUI.addComponent((Container)((Object)this), panel, 0, 0, 7, 1, 1, 10, 1.0, 1.0);
        Label label = new Label("");
        GUI.addComponent(panel, label, 1, 0, 1, 1, 0, 10, 10.0, 1.0);
        Label label2 = new Label("Continual Query Services");
        label2.setBackground(this.backgroundColor);
        label2.setForeground(Color.red);
        Font font = new Font("timesRoman", 1, 34);
        label2.setFont(font);
        GUI.addComponent(panel, label2, 1, 1, 1, 1, 0, 10, 10.0, 1.0);
        Label label3 = new Label("Bibliographic Information System");
        label3.setBackground(this.backgroundColor);
        label3.setForeground(Color.blue);
        Font font2 = new Font("timesRoman", 3, 30);
        label3.setFont(font2);
        GUI.addComponent(panel, label3, 1, 2, 1, 1, 0, 10, 10.0, 1.0);
        Label label4 = new Label("");
        GUI.addComponent(panel, label4, 1, 3, 1, 1, 1, 15, 0.0, 100.0);
    }

    protected void updateSourceButton_Clicked(Event event) {
        this.status.setText("new update source button clicked");
    }

    protected void updateUserButton_Clicked(Event event) {
        try {
            this.status.setText("Update user information...");
            this.spinner.startSpinning();
            this.logger.debug("CQ Home: new Query button clicked");
            if (this.user == null) {
                this.spinner.stopSpinning();
                this.loginButton_Clicked(event, 2);
                if (this.user == null) {
                    return;
                }
            }
            Manager manager = new Manager(this.user, new UnfinishedState(), "Unfinished");
            manager.show();
            this.spinner.stopSpinning();
            this.status.setText("");
        }
        catch (Exception exception) {
            this.logger.debug("Home.updateUser exception: " + exception);
        }
    }
}

