/*
 * Decompiled with CFR 0.152.
 */
package ogi.cq.gui;

import com.sun.java.swing.BorderFactory;
import com.sun.java.swing.Box;
import com.sun.java.swing.BoxLayout;
import com.sun.java.swing.JLabel;
import com.sun.java.swing.JPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.LayoutManager;
import ogi.cq.gui.ManagerState;
import ogi.cq.gui.StatePanel;
import ogi.cq.log.Log;

public class GenericStatePanel
extends JPanel
implements StatePanel {
    protected Log logger;
    protected ManagerState state;
    protected Font localFont;
    protected Color backgroundColor;
    protected String titleString = "Generic Panel";
    protected JPanel titlePanel;
    protected JLabel titleLabel;
    public static final boolean DEBUG = true;

    public JPanel getJPanel() {
        return this;
    }

    public Log getLog() {
        return this.logger;
    }

    public String getTitle() {
        return this.titleString;
    }

    protected void init() {
        try {
            this.setLocalFont(new Font("timesRoman", 0, 14));
            ((Container)((Object)this)).setLayout((LayoutManager)new BoxLayout((Container)((Object)this), 1));
            this.setBorder(BorderFactory.createEtchedBorder());
            this.setBackground(Color.lightGray);
            this.titleLabel = new JLabel(this.getTitle());
            Font font = new Font("timesRoman", 1, 20);
            this.titleLabel.setFont(font);
            this.titleLabel.setForeground(Color.black);
            this.titleLabel.setBackground(this.backgroundColor);
            JPanel jPanel = new JPanel();
            jPanel.setLayout((LayoutManager)new BoxLayout((Container)jPanel, 0));
            jPanel.add(Box.createGlue());
            jPanel.add((Component)this.titleLabel);
            jPanel.add(Box.createGlue());
            FontMetrics fontMetrics = ((Component)((Object)this)).getFontMetrics(font);
            int n = fontMetrics.getAscent() + fontMetrics.getDescent();
            jPanel.setMinimumSize(new Dimension(this.titleLabel.getMinimumSize().width, n));
            jPanel.setPreferredSize(new Dimension(this.titleLabel.getPreferredSize().width, n));
            jPanel.setMaximumSize(new Dimension(this.titleLabel.getMaximumSize().width, n * 2));
            ((Container)((Object)this)).add((Component)jPanel);
        }
        catch (Exception exception) {
            this.logger.debug("GenericStatePanel init error: " + exception);
        }
    }

    public void log(int n, String string) {
        if (this.logger != null) {
            this.logger.log(n, string);
            int n2 = 0;
            while (n2 < n) {
                this.logger.debug(" ");
                ++n2;
            }
            this.logger.debug(string);
        }
    }

    public void reset() {
    }

    public void setBackground(Color color) {
        if (color == null) {
            return;
        }
        this.backgroundColor = color;
        super.setBackground(color);
    }

    public void setLocalFont(Font font) {
        if (font == null) {
            return;
        }
        this.localFont = font;
        this.titleLabel.setFont(font);
        super.setFont(font);
    }

    public void setLog(Log log) {
        if (log != null) {
            this.logger = log;
        }
    }

    public void setState(ManagerState managerState) {
        this.state = managerState;
    }

    public void switchFrom() {
    }

    public void switchTo() {
        ((Container)((Object)this)).invalidate();
        ((Container)((Object)this)).validate();
    }
}

