/*
 * Decompiled with CFR 0.152.
 */
package ogi.cq.gui;

import com.sun.java.swing.JApplet;
import com.sun.java.swing.JFrame;
import com.sun.java.swing.JPanel;
import java.awt.Color;
import java.awt.Font;
import java.awt.Frame;
import java.awt.MenuBar;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.net.URL;
import ogi.cq.gui.InvalidStateChangeException;
import ogi.cq.gui.Manager;
import ogi.cq.gui.ManagerState;
import ogi.cq.gui.StatePanel;
import ogi.cq.log.Log;

public class GenericState
implements ManagerState,
ActionListener {
    protected JApplet applet;
    protected StatePanel[] panels;
    protected int currentPanel = 1;
    protected Manager manager;
    protected Log logger;

    public void actionPerformed(ActionEvent actionEvent) {
    }

    public void cancelButton() {
    }

    protected void changeStateAfter() {
    }

    protected void changeStateBefore() throws InvalidStateChangeException {
    }

    public int current() {
        return this.currentPanel;
    }

    public void debug(String string) {
        if (this.logger != null) {
            this.logger.debug(string);
        } else {
            System.err.println(string);
        }
    }

    public void disableFinish() {
        this.manager.disableFinish();
    }

    public void disableNext() {
        this.manager.disableNext();
    }

    public void disablePrevious() {
        this.manager.disablePrevious();
    }

    public void disableReset() {
        this.manager.disableReset();
    }

    public void disableStart() {
        this.manager.disableStart();
    }

    public void enableFinish() {
        this.manager.enableFinish();
    }

    public void enableNext() {
        this.manager.enableNext();
    }

    public void enablePrevious() {
        this.manager.enablePrevious();
    }

    public void enableReset() {
        this.manager.enableReset();
    }

    public void enableStart() {
        this.manager.enableStart();
    }

    public void finishButton() {
        if (this.currentPanel >= this.panels.length - 1) {
            return;
        }
        try {
            this.changeStateBefore();
        }
        catch (InvalidStateChangeException invalidStateChangeException) {
            return;
        }
        this.panels[this.currentPanel].switchFrom();
        this.currentPanel = this.panels.length - 1;
        this.enablePrevious();
        this.enableStart();
        this.disableNext();
        this.disableFinish();
        this.panels[this.currentPanel].switchTo();
        this.manager.lastPanel();
        this.changeStateAfter();
    }

    public JApplet getApplet() {
        return this.applet;
    }

    public Object getAuxillaryObject() {
        return this.manager.getAuxillaryObject();
    }

    public JFrame getFrame() {
        return this.manager.getFrame();
    }

    public MenuBar getMenuBar() {
        return null;
    }

    public JPanel[] getPanels() {
        JPanel[] jPanelArray = new JPanel[this.panels.length];
        int n = 0;
        while (n < this.panels.length) {
            jPanelArray[n] = (JPanel)this.panels[n];
            ++n;
        }
        return jPanelArray;
    }

    public void help(String string) {
        StringBuffer stringBuffer = new StringBuffer(this.applet.getCodeBase().toString());
        stringBuffer.append("/help/");
        stringBuffer.append(string);
        try {
            URL uRL = new URL(stringBuffer.toString());
            this.applet.getAppletContext().showDocument(uRL, "help");
        }
        catch (MalformedURLException malformedURLException) {
            this.logger.debug("bad URL in help");
        }
        catch (NullPointerException nullPointerException) {
            this.logger.debug("null pointer: did you start from an applet?");
        }
    }

    protected void init() {
    }

    public void log(int n, String string) {
        if (this.logger != null) {
            this.logger.log(n, string);
        } else {
            System.err.println(string);
        }
    }

    public void nextButton() {
        if (this.currentPanel >= this.panels.length - 1) {
            return;
        }
        try {
            this.changeStateBefore();
        }
        catch (InvalidStateChangeException invalidStateChangeException) {
            return;
        }
        if (this.currentPanel >= 0) {
            this.enablePrevious();
            this.enableStart();
        }
        this.panels[this.currentPanel].switchFrom();
        ++this.currentPanel;
        if (this.currentPanel >= this.panels.length - 1) {
            this.currentPanel = this.panels.length - 1;
        }
        if (this.currentPanel == this.panels.length - 1) {
            this.disableNext();
            this.disableFinish();
        }
        this.panels[this.currentPanel].switchTo();
        this.manager.nextPanel();
        this.changeStateAfter();
    }

    public void previousButton() {
        if (this.currentPanel == 0) {
            return;
        }
        try {
            this.changeStateBefore();
        }
        catch (InvalidStateChangeException invalidStateChangeException) {
            return;
        }
        if (this.currentPanel <= this.panels.length - 1) {
            this.enableNext();
            this.enableFinish();
        }
        this.panels[this.currentPanel].switchFrom();
        --this.currentPanel;
        if (this.currentPanel <= 0) {
            this.currentPanel = 0;
        }
        if (this.currentPanel == 0) {
            this.disablePrevious();
            this.disableStart();
        }
        this.panels[this.currentPanel].switchTo();
        this.manager.previousPanel();
        this.changeStateAfter();
    }

    public void reset() {
        this.currentPanel = 0;
        this.panels[this.currentPanel].switchTo();
        this.manager.startPanel();
        int n = 0;
        while (n < this.panels.length) {
            this.panels[n].reset();
            ++n;
        }
    }

    public void setApplet(JApplet jApplet) {
        this.applet = jApplet;
    }

    public void setAuxillaryObject(Object object) {
        this.manager.setAuxillaryObject(object);
    }

    public void setBackground(Color color) {
        if (color == null) {
            return;
        }
        if (this.panels != null) {
            int n = 0;
            while (n < this.panels.length) {
                this.panels[n].setBackground(color);
                ++n;
            }
        }
    }

    public void setLocalFont(Font font) {
        if (font == null) {
            return;
        }
        if (this.panels != null) {
            int n = 0;
            while (n < this.panels.length) {
                this.panels[n].setLocalFont(font);
                ++n;
            }
        }
    }

    public void setLog(Log log) {
        if (log != null) {
            this.logger = log;
        }
    }

    public void setManager(Manager manager) {
        try {
            this.manager = manager;
            if (this.manager == null) {
                return;
            }
            if (this.logger != null) {
                this.manager.setLog(this.logger);
            }
            this.manager.setPanel(this.currentPanel);
            if (this.currentPanel == 0) {
                this.disablePrevious();
                this.disableStart();
            }
        }
        catch (Exception exception) {
            System.out.println("GenericState.setManager error: " + exception);
        }
    }

    public void setMenuBar(MenuBar menuBar) {
    }

    public void setStatus(String string) {
        if (this.manager != null && string != null) {
            this.manager.setStatus(string);
        }
    }

    public void setTitle(JFrame jFrame) {
        jFrame.setTitle("Generic State");
    }

    public void setTitle(Frame frame) {
        frame.setTitle("Generic State");
    }

    public void showLocalURL(String string) {
        if (this.applet == null) {
            return;
        }
        if (string == null) {
            return;
        }
        try {
            URL uRL = new URL(this.applet.getCodeBase() + string);
            this.applet.getAppletContext().showDocument(uRL, "CQ");
        }
        catch (MalformedURLException malformedURLException) {
            this.log(2, "Tried to view incorrectly formed URL: " + string);
        }
        catch (Exception exception) {
            this.log(2, "Tried to view URL, but there was an error: " + exception);
        }
    }

    public void showURL(String string) {
        if (this.applet == null) {
            return;
        }
        if (string == null) {
            return;
        }
        try {
            URL uRL = new URL(string);
            this.applet.getAppletContext().showDocument(uRL, "CQ");
        }
        catch (MalformedURLException malformedURLException) {
            this.log(2, "Tried to view incorrectly formed URL: " + string);
        }
        catch (Exception exception) {
            this.log(2, "Tried to view URL, but there was an error: " + exception);
        }
    }

    public void startButton() {
        if (this.currentPanel == 0) {
            return;
        }
        try {
            this.changeStateBefore();
        }
        catch (InvalidStateChangeException invalidStateChangeException) {
            return;
        }
        this.panels[this.currentPanel].switchFrom();
        this.currentPanel = 0;
        this.disablePrevious();
        this.disableStart();
        this.enableNext();
        this.enableFinish();
        this.panels[this.currentPanel].switchTo();
        this.manager.startPanel();
        this.changeStateAfter();
    }

    public void startSpinner() {
        this.manager.startSpinner();
    }

    public void stopSpinner() {
        this.manager.stopSpinner();
    }
}

