/*
 * Decompiled with CFR 0.152.
 */
package ogi.cq.cluster;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.URLEncoder;
import java.rmi.RemoteException;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import ogi.cq.cluster.CQClusterImpl;
import ogi.cq.cluster.ClusterOutLog;
import ogi.cq.plugin.CQArchiveInfo;
import ogi.cq.plugin.CQExecution;
import ogi.cq.plugin.CQInfo;
import ogi.cq.plugin.InvalidCQException;

public class ClusterServlet
extends HttpServlet {
    private static int sleepTime = 100;
    private String service = "/CQCluster";
    private CQClusterImpl cluster;
    public static final int DEFAULT_HISTORY_SIZE = 500;

    public void destroy() {
        super.destroy();
    }

    public void doAction(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        try {
            Serializable serializable;
            int n;
            Vector vector;
            String string = httpServletRequest.getParameter("action");
            String string2 = httpServletRequest.getParameter("userid");
            String string3 = httpServletRequest.getParameter("pword");
            String string4 = httpServletRequest.getParameter("source");
            String string5 = httpServletRequest.getParameter("cqid");
            String string6 = httpServletRequest.getParameter("relation");
            String string7 = httpServletRequest.getParameter("cqName");
            String string8 = httpServletRequest.getParameter("select");
            String string9 = httpServletRequest.getParameter("from");
            String string10 = httpServletRequest.getParameter("where");
            String string11 = httpServletRequest.getParameter("groupBy");
            String string12 = httpServletRequest.getParameter("orderBy");
            String string13 = httpServletRequest.getParameter("trigger");
            String string14 = httpServletRequest.getParameter("triggerType");
            String string15 = httpServletRequest.getParameter("notify");
            String string16 = httpServletRequest.getParameter("stop");
            PrintWriter printWriter = new PrintWriter((OutputStream)httpServletResponse.getOutputStream(), true);
            httpServletResponse.setContentType("text/plain");
            if (string == null || string.trim().equals("")) {
                printWriter.println("ERROR: must specify action");
                printWriter.println(" <br>action: " + string);
                printWriter.println("<br>userid:  " + string2);
                printWriter.println(" <br>pword: " + string3);
                printWriter.println(" <br>source: " + string4);
                printWriter.println(" <br>cqid: " + string5);
                printWriter.println(" <br>relation: " + string6);
                printWriter.println(" <br>cqName: " + string7);
                printWriter.println(" <br>select: " + string8);
                printWriter.println(" <br>from: " + string9);
                printWriter.println(" <br>where: " + string10);
                printWriter.println(" <br>groupBy: " + string11);
                printWriter.println(" <br>orderBy: " + string12);
                printWriter.println(" <br>trigger: " + string13);
                printWriter.println(" <br>triggerType: " + string14);
                printWriter.println(" <br>notify: " + string15);
                printWriter.println(" <br>stop: " + string16);
                return;
            }
            if (string.trim().equalsIgnoreCase("getAttributes")) {
                this.getAttributes(httpServletRequest, printWriter);
            } else if (string.trim().equalsIgnoreCase("getAttributeTypes")) {
                this.getAttributeTypes(httpServletRequest, printWriter);
            }
            if (string.trim().equalsIgnoreCase("getCQHistory")) {
                vector = this.cluster.getCQHistory();
                n = 0;
                while (n < vector.size()) {
                    serializable = (CQArchiveInfo)vector.elementAt(n);
                    if (serializable != null) {
                        ((CQArchiveInfo)serializable).toWebString(printWriter);
                    }
                    ++n;
                }
            }
            if (string.trim().equalsIgnoreCase("getCQInfo")) {
                vector = this.cluster.getCQInfo();
                if (vector == null) {
                    System.out.println("WARNING CQINFO vec is null");
                }
                n = 0;
                while (n < vector.size()) {
                    serializable = (CQInfo)vector.elementAt(n);
                    if (serializable != null) {
                        ((CQInfo)serializable).toWebString(printWriter);
                    } else {
                        System.out.println("p is null)");
                    }
                    ++n;
                }
            }
            if (string.trim().equalsIgnoreCase("getIndividualCQHistory")) {
                this.getIndividualCQHistory(httpServletRequest, printWriter);
            }
            if (string.trim().equalsIgnoreCase("getQueryOperators")) {
                vector = this.cluster.getQueryOperators();
                n = 0;
                while (n < vector.size()) {
                    printWriter.println(vector.elementAt(n));
                    ++n;
                }
            }
            if (string.trim().equalsIgnoreCase("getTriggerOperators")) {
                vector = this.cluster.getTriggerOperators();
                n = 0;
                while (n < vector.size()) {
                    printWriter.println(vector.elementAt(n));
                    ++n;
                }
            }
            if (string.trim().equalsIgnoreCase("getSources")) {
                this.getSources(printWriter);
            }
            if (string.trim().equalsIgnoreCase("getRelations")) {
                if (string4 == null || string4.trim().equals("")) {
                    printWriter.println("ERROR: must specify source when requesting attirbutes");
                    return;
                }
                vector = this.cluster.getRelations(string4);
                n = 0;
                while (n < vector.size()) {
                    printWriter.println(vector.elementAt(n));
                    ++n;
                }
            }
            if (string.trim().equalsIgnoreCase("getSchema")) {
                printWriter.println("schema info not supported");
            }
            if (string.trim().equalsIgnoreCase("installCQ")) {
                this.installCQ(httpServletRequest, printWriter);
            }
            if (string.trim().equalsIgnoreCase("formQuery")) {
                this.formQuery(httpServletRequest, printWriter);
            }
            if (string.trim().equalsIgnoreCase("listCQ")) {
                if (string2 == null || string2.trim().equals("")) {
                    printWriter.println("ERROR: must specify userid when requesting CQ listing for user");
                    return;
                }
                printWriter.println("lsit CQ not currently supported");
            }
            if (string.trim().equalsIgnoreCase("validateUser")) {
                if (string2 == null || string2.trim().equals("")) {
                    printWriter.println("ERROR: must specify userid when validating user");
                    return;
                }
                if (string3 == null || string3.trim().equals("")) {
                    printWriter.println("ERROR: must specify password when validating user");
                    return;
                }
                if (this.cluster.validateUser(string2, string3)) {
                    printWriter.println("success");
                } else {
                    printWriter.println("failed to validate user: " + string2);
                }
            }
            if (string.trim().equalsIgnoreCase("registerUser")) {
                this.registerUser(httpServletRequest, printWriter);
            }
            printWriter.flush();
        }
        catch (Exception exception) {
            System.out.println("error: " + exception);
            exception.printStackTrace();
        }
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.doAction(httpServletRequest, httpServletResponse);
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.doAction(httpServletRequest, httpServletResponse);
    }

    private void formQuery(HttpServletRequest httpServletRequest, PrintWriter printWriter) throws RemoteException {
        System.out.println("ClusterServlet formQuery ()");
        String string = httpServletRequest.getParameter("source");
        String string2 = httpServletRequest.getParameter("query");
        if (string == null || string.trim().equals("")) {
            printWriter.println("ERROR: must specify source when submitting query");
            return;
        }
        if (string2 == null || string2.trim().equals("")) {
            printWriter.println("ERROR: must specify query clause when submitting query");
            return;
        }
        StringBuffer stringBuffer = new StringBuffer(System.getProperty("QUERYSERVLET"));
        stringBuffer.append("?login=");
        stringBuffer.append(string);
        stringBuffer.append("&query=");
        stringBuffer.append(URLEncoder.encode(string2));
        stringBuffer.append("&type=htmldelay");
        printWriter.println(stringBuffer);
        System.out.println(stringBuffer);
    }

    private void getAttributes(HttpServletRequest httpServletRequest, PrintWriter printWriter) throws RemoteException {
        String string = httpServletRequest.getParameter("source");
        String string2 = httpServletRequest.getParameter("relation");
        System.out.println("get attributes: " + string + ", " + string2);
        if (string == null || string.trim().equals("")) {
            printWriter.println("ERROR: must specify source when requesting attirbutes");
            return;
        }
        if (string2 == null || string2.trim().equals("")) {
            printWriter.println("ERROR: must specify relation when requesting attirbutes");
            return;
        }
        Vector vector = this.cluster.getAttributes(string.trim(), string2.trim());
        int n = 0;
        while (n < vector.size()) {
            printWriter.println(vector.elementAt(n));
            ++n;
        }
    }

    private void getAttributeTypes(HttpServletRequest httpServletRequest, PrintWriter printWriter) throws RemoteException {
        String string = httpServletRequest.getParameter("source");
        String string2 = httpServletRequest.getParameter("relation");
        System.out.println("get attribute types: " + string + ", " + string2);
        if (string == null || string.trim().equals("")) {
            printWriter.println("ERROR: must specify source when requesting attirbutes");
            return;
        }
        if (string2 == null || string2.trim().equals("")) {
            printWriter.println("ERROR: must specify relation when requesting attirbutes");
            return;
        }
        Vector vector = this.cluster.getAttributeTypes(string.trim(), string2.trim());
        int n = 0;
        while (n < vector.size()) {
            printWriter.println(vector.elementAt(n));
            ++n;
        }
    }

    private void getIndividualCQHistory(HttpServletRequest httpServletRequest, PrintWriter printWriter) {
        String string = httpServletRequest.getParameter("cqid");
        String string2 = httpServletRequest.getParameter("count");
        if (string == null || string.trim().equals("")) {
            printWriter.println("ERROR: must specify cqid when requesting history");
            return;
        }
        int n = 500;
        try {
            n = Integer.parseInt(string2);
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (NumberFormatException numberFormatException) {}
        Vector vector = this.cluster.getIndividualCQHistory(string.trim(), n);
        int n2 = 0;
        while (n2 < vector.size()) {
            CQExecution cQExecution = (CQExecution)vector.elementAt(n2);
            cQExecution.toWebString(printWriter);
            ++n2;
        }
    }

    public String getServletInfo() {
        return "ALP/CQ Cluster Servlet";
    }

    private void getSources(PrintWriter printWriter) throws RemoteException {
        Vector vector = this.cluster.getSources();
        int n = 0;
        while (n < vector.size()) {
            printWriter.println(vector.elementAt(n));
            ++n;
        }
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        try {
            String string;
            String string2;
            String string3 = this.getInitParameter("propertyFile");
            if (string3 == null || string3.trim().equals("")) {
                string3 = "cqconfig.ini";
            }
            if ((string2 = this.getInitParameter("propertyFilePath")) == null || string2.trim().equals("")) {
                string2 = System.getProperty("server.root");
                string = System.getProperty("file.separator");
                string2 = String.valueOf(string2) + string + ".." + string + string3;
            }
            System.out.println("prop file: " + string2);
            string = ClusterServlet.loadProperties(string2);
            System.out.println(string);
            StringBuffer stringBuffer = new StringBuffer("http://");
            stringBuffer.append(InetAddress.getLocalHost().getHostAddress());
            stringBuffer.append(":");
            stringBuffer.append(System.getProperty("CQSRVPORT"));
            stringBuffer.append("/servlet/");
            StringBuffer stringBuffer2 = new StringBuffer(stringBuffer.toString());
            stringBuffer2.append(System.getProperty("INSTALLSERVLET"));
            System.out.println("CQ INSTALL PATH: " + stringBuffer2);
            ((Hashtable)System.getProperties()).put("INSTALLPATH", stringBuffer2.toString());
            System.out.println("CQ INSTALL PATH: " + System.getProperty("INSTALLPATH"));
            StringBuffer stringBuffer3 = new StringBuffer(stringBuffer.toString());
            stringBuffer3.append(System.getProperty("QUERYSERVLET"));
            System.out.println("QueryServlet: " + stringBuffer3);
            ((Hashtable)System.getProperties()).put("QUERYSERVLET", stringBuffer3.toString());
            System.out.println("QueryServlet: " + System.getProperty("QUERYSERVLET"));
            StringBuffer stringBuffer4 = new StringBuffer(stringBuffer.toString());
            stringBuffer4.append(System.getProperty("BROWSESERVLET"));
            System.out.println("BrowseServlet: " + stringBuffer4);
            ((Hashtable)System.getProperties()).put("BROWSESERVLET", stringBuffer4.toString());
            System.out.println("BrowseServlet: " + System.getProperty("BROWSESERVLET"));
            StringBuffer stringBuffer5 = new StringBuffer(stringBuffer.toString());
            stringBuffer5.append(System.getProperty("DELETESERVLET"));
            System.out.println("DeleteServlet: " + stringBuffer5);
            ((Hashtable)System.getProperties()).put("DELETESERVLET", stringBuffer5.toString());
            System.out.println("deleteServlet: " + System.getProperty("DELETESERVLET"));
            this.cluster = new CQClusterImpl();
            System.out.println(" 14 finished init Cluster servlet");
        }
        catch (Exception exception) {
            System.out.println("error in init ClusterServlet: " + exception);
            exception.printStackTrace();
        }
    }

    private void installCQ(HttpServletRequest httpServletRequest, PrintWriter printWriter) throws RemoteException {
        System.out.println("ClusterServlet installCQ ()");
        String string = httpServletRequest.getParameter("userid");
        String string2 = httpServletRequest.getParameter("pword");
        String string3 = httpServletRequest.getParameter("source");
        httpServletRequest.getParameter("cqid");
        httpServletRequest.getParameter("relation");
        String string4 = httpServletRequest.getParameter("cqName");
        String string5 = httpServletRequest.getParameter("select");
        String string6 = httpServletRequest.getParameter("from");
        String string7 = httpServletRequest.getParameter("where");
        String string8 = httpServletRequest.getParameter("groupBy");
        String string9 = httpServletRequest.getParameter("orderBy");
        String string10 = httpServletRequest.getParameter("trigger");
        String string11 = httpServletRequest.getParameter("triggerType");
        String string12 = httpServletRequest.getParameter("notify");
        String string13 = httpServletRequest.getParameter("stop");
        if (string == null || string.trim().equals("")) {
            printWriter.println("ERROR: must specify userid when installing CQ");
            return;
        }
        if (string2 == null || string2.trim().equals("")) {
            printWriter.println("ERROR: must specify password when installing CQ");
            return;
        }
        if (string3 == null || string3.trim().equals("")) {
            printWriter.println("ERROR: must specify source when installing CQ");
            return;
        }
        if (string5 == null || string5.trim().equals("")) {
            printWriter.println("ERROR: must specify select clause when installing CQ");
            return;
        }
        if (string6 == null || string6.trim().equals("")) {
            printWriter.println("ERROR: must specify from clause when installing CQ");
            return;
        }
        if (string7 == null) {
            string7 = "";
        }
        if (string9 == null) {
            string9 = "";
        }
        if (string8 == null) {
            string8 = "";
        }
        if (string10 == null || string10.trim().equals("")) {
            printWriter.println("ERROR: must specify trigger when installing CQ");
            return;
        }
        if (string11 == null || string11.trim().equals("")) {
            printWriter.println("ERROR: must specify trigger type when installing CQ");
            return;
        }
        if (string12 == null) {
            string12 = "";
        }
        if (string13 == null || string13.trim().equals("")) {
            printWriter.println("ERROR: must specify stop when installing CQ");
            return;
        }
        boolean bl = true;
        if (string11.equalsIgnoreCase("T")) {
            bl = false;
        }
        try {
            this.cluster.installCQ(new ClusterOutLog(printWriter), string3, string, string2, string4, string5, string6, string7, string8, string9, string10, bl, string12, string13);
        }
        catch (InvalidCQException invalidCQException) {
            printWriter.print("Invalid CQ: " + invalidCQException.toString());
        }
        string3 = string3.toUpperCase().trim();
    }

    public static String loadProperties(String string) {
        try {
            Properties properties = new Properties(System.getProperties());
            properties.load(new BufferedInputStream(new FileInputStream(string)));
            System.setProperties(properties);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return new String("ERROR:  Could not open: " + string);
        }
        catch (IOException iOException) {
            return new String("loadProperties " + iOException);
        }
        return null;
    }

    private void registerUser(HttpServletRequest httpServletRequest, PrintWriter printWriter) throws RemoteException {
        String string = httpServletRequest.getParameter("userid");
        String string2 = httpServletRequest.getParameter("pword");
        String string3 = httpServletRequest.getParameter("title");
        String string4 = httpServletRequest.getParameter("fname");
        String string5 = httpServletRequest.getParameter("lname");
        String string6 = httpServletRequest.getParameter("email");
        String string7 = httpServletRequest.getParameter("duration");
        if (string == null || string.trim().equals("")) {
            printWriter.println("ERROR: must specify userid when registering user");
            return;
        }
        if (string2 == null || string2.trim().equals("")) {
            printWriter.println("ERROR: must specify password when registering user");
            return;
        }
        if (string6 == null || string6.trim().equals("")) {
            printWriter.println("ERROR: must specify password when registering user");
            return;
        }
        if (string3 == null) {
            string3 = "";
        }
        if (string4 == null) {
            string4 = "";
        }
        if (string5 == null) {
            string5 = "";
        }
        if (string7 == null) {
            string7 = "1y";
        }
        if (this.cluster.registerUser(string, string2, string3, string4, string5, string6, string7)) {
            printWriter.println("success");
        } else {
            printWriter.println("failed to register user: " + string);
        }
    }
}

