/*
 * Decompiled with CFR 0.152.
 */
package ogi.cq.cluster;

import java.io.BufferedInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.rmi.Naming;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import ogi.cq.cluster.ClusterLog;
import ogi.cq.cluster.SourceInfo;
import ogi.cq.plugin.CQArchiveInfo;
import ogi.cq.plugin.CQExecution;
import ogi.cq.plugin.CQInfo;
import ogi.cq.plugin.CQRemotePlugin;
import ogi.cq.plugin.ContinualQueryCluster;
import ogi.cq.plugin.IContinualQueryPlugin;
import ogi.cq.plugin.InvalidCQException;
import ogi.cq.plugin.gui.demo.ExampleUpdate;
import ogi.cq.plugin.gui.demo.Examples;
import ogi.cq.plugin.gui.demo.JTAVExamples;
import ogi.cq.plugin.gui.demo.NoExamples;
import ogi.cq.query.CQ;
import ogi.cq.query.ContentQuery;
import ogi.cq.query.TimeQuery;
import ogi.diom.util.URLUtils;

public class CQClusterImpl
extends UnicastRemoteObject
implements ContinualQueryCluster {
    private String host;
    private int port;
    private Hashtable pluginMap;
    private Hashtable sourceMap;
    private Hashtable demoUpdateMap = new Hashtable();
    public static final String CQ_SOURCE_TABLE = "CQ_SOURCE";
    private static final String source_query = "select * from CQ_SOURCE";
    private static final String cq_info_query = "select * from CQ_INFO ";
    private static final String cq_history_query = "select * from CQ_INFO_HISTORY";
    private static final String queryOperator_query = "select * from queryOperators";
    private static final String triggerOperator_query = "select * from triggerOperators";
    public static final String CURRENT_CQ_COUNT = "select count(*) from CQ_INFO";
    public static final String TOTAL_CQ_COUNT = "select count(*) from CQ_ARCHIVE";
    public static final String MIN_DATE = "select min(start_date) from CQ_ARCHIVE";
    public static final String CQ_ARCHIVE = "select * from CQ_ARCHIVE";
    public static final String CQ_ARCHIVE_DATES = "select startdate, enddate from CQ_ARCHIVE";
    public static final String TRIGGER_SUM = "select sum(triggercnt) from CQ_ARCHIVE";
    public static final String QUERY_SUM = "select sum(querycnt) from CQ_ARCHIVE";
    public static final String NOTIFICATION_SUM = "select sum(notificationcnt) from CQ_ARCHIVE";
    public static final String COUNT_EVAL_DETAIL = "select count(*) from CQ_EVALDETAIL where cqid ='";
    public static final String CQ_EVAL_DETAIL_QUERY = "select * from CQ_EVALDETAIL where cqid ='";
    public static final String VALIDATE_USER_QUERY = "select passwd from user_info where id ='";
    public static final String REGISTER_USER = "insert into user_info (ID, PASSWD, TITLE, FIRSTNAME, LASTNAME, EMAILADDR, SUBDATE, SUBDURATION) values (?, ?, ?, ?, ?, ?, sysdate, ?)";
    private String jdbcDriverClass;
    private String dbConnectionString;
    private String dbUser;
    private String dbPassword;
    private String contentQueryCGI;

    public CQClusterImpl() throws RemoteException {
        this((String)null);
    }

    public CQClusterImpl(String string) throws RemoteException {
        String string2;
        this.pluginMap = new Hashtable();
        this.sourceMap = new Hashtable();
        if (string != null && !string.trim().equals("") && (string2 = CQClusterImpl.loadProperties(string)) != null) {
            System.out.println(string2);
            System.exit(1);
        }
        this.initializeProperties();
        try {
            this.initDB();
        }
        catch (Exception exception) {
            System.out.println("error in initializing connection to DB: " + exception);
            exception.printStackTrace();
        }
    }

    public void addCQMap(String string, CQRemotePlugin cQRemotePlugin) {
        if (this.pluginMap == null) {
            this.pluginMap = new Hashtable();
        }
        if (!string.equals("CQID")) {
            this.pluginMap.put(string, cQRemotePlugin);
        }
    }

    public boolean deleteCQ(String string, String string2, String string3, int n) throws RemoteException {
        System.out.println("delete CQ: " + string + ", " + string2 + ", " + string3);
        System.out.println("Cluster deleteCQ ()");
        StringBuffer stringBuffer = new StringBuffer(System.getProperty("DELETESERVLET"));
        stringBuffer.append("?userid=");
        stringBuffer.append(URLEncoder.encode(string));
        stringBuffer.append("&passwd=");
        stringBuffer.append(URLEncoder.encode(string2));
        stringBuffer.append("&cqid=");
        stringBuffer.append(URLEncoder.encode(string3));
        stringBuffer.append("&action=");
        switch (n) {
            case 0: {
                stringBuffer.append("DELETE");
                break;
            }
            case 2: {
                stringBuffer.append("DEMODELETE");
                break;
            }
            default: {
                stringBuffer.append("DELETE");
            }
        }
        System.out.println(stringBuffer);
        boolean bl = false;
        try {
            URLUtils.get(new URL(stringBuffer.toString()));
            bl = true;
        }
        catch (MalformedURLException malformedURLException) {
            System.out.println("Error in deleting CQ: " + malformedURLException);
            malformedURLException.printStackTrace();
        }
        return bl;
    }

    public Vector getAttributes(String string, String string2) throws RemoteException {
        SourceInfo sourceInfo;
        System.out.println("get Relations: ");
        string = string.trim();
        if (this.sourceMap == null || this.sourceMap.size() == 0) {
            this.getSources();
        }
        if ((sourceInfo = (SourceInfo)this.sourceMap.get(string)) != null) {
            return sourceInfo.getAttributes(string2);
        }
        return new Vector();
    }

    public Vector getAttributeTypes(String string, String string2) throws RemoteException {
        SourceInfo sourceInfo;
        System.out.println("get Relations: ");
        string = string.trim();
        if (this.sourceMap == null || this.sourceMap.size() == 0) {
            this.getSources();
        }
        if ((sourceInfo = (SourceInfo)this.sourceMap.get(string)) != null) {
            return sourceInfo.getAttributeTypes(string2);
        }
        return new Vector();
    }

    public String getCQ(String string, String string2, String string3) throws RemoteException {
        return null;
    }

    public Vector getCQHistory() {
        System.out.println("cluster.getCQHistory()");
        Vector vector = new Vector();
        Vector<CQArchiveInfo> vector2 = new Vector<CQArchiveInfo>();
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            connection = this.getMetaConnection();
            System.out.println("made connection");
            statement = connection.createStatement();
            resultSet = statement.executeQuery(CQ_ARCHIVE_DATES);
            int n = 0;
            System.out.println("results:" + vector);
            while (resultSet.next()) {
                ++n;
                CQArchiveInfo cQArchiveInfo = new CQArchiveInfo();
                vector2.addElement(cQArchiveInfo);
                String string = resultSet.getString("STARTDATE");
                cQArchiveInfo.setStartDate(this.stringToDate(string));
                String string2 = resultSet.getString("ENDDATE");
                cQArchiveInfo.setEndDate(this.stringToDate(string2));
            }
            System.out.println("total count: " + n);
            resultSet.close();
            statement.close();
            connection.close();
        }
        catch (Exception exception) {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (statement != null) {
                    statement.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception exception2) {}
            System.out.println("error in getting CQHistory: " + exception);
            exception.printStackTrace();
        }
        System.out.println("retrieved info from db");
        return vector2;
    }

    public Vector getCQInfo() {
        System.out.println("getCQInfo();");
        Vector<CQInfo> vector = new Vector<CQInfo>();
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            try {
                connection = this.getMetaConnection();
                statement = connection.createStatement();
                resultSet = statement.executeQuery(cq_info_query);
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                Vector<String> vector2 = new Vector<String>(resultSetMetaData.getColumnCount());
                int n = 1;
                while (n <= resultSetMetaData.getColumnCount()) {
                    vector2.addElement(resultSetMetaData.getColumnName(n));
                    ++n;
                }
                while (resultSet.next()) {
                    Vector<Object> vector3 = new Vector<Object>(resultSetMetaData.getColumnCount());
                    int n2 = 1;
                    while (n2 <= resultSetMetaData.getColumnCount()) {
                        Object object = resultSet.getObject(n2);
                        if (object == null) {
                            object = "";
                        }
                        vector3.addElement(object);
                        ++n2;
                    }
                    CQInfo cQInfo = new CQInfo(vector2, vector3);
                    vector.addElement(cQInfo);
                }
                resultSet.close();
                statement.close();
                connection.close();
            }
            catch (Exception exception) {
                System.out.println("error in getting CQInfo: " + exception);
                exception.printStackTrace();
            }
        }
        catch (Throwable throwable) {
            Object var5_14 = null;
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (statement != null) {
                    statement.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception exception) {}
            throw throwable;
        }
        Object var5_15 = null;
        try {
            if (resultSet != null) {
                resultSet.close();
            }
            if (statement != null) {
                statement.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
        catch (Exception exception) {}
        return vector;
    }

    public Vector getIndividualCQHistory(String string, int n) {
        System.out.println("cluster.getIndividualCQHistory()");
        new Vector();
        Vector<CQExecution> vector = new Vector<CQExecution>();
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            connection = this.getMetaConnection();
            System.out.println("made connection");
            statement = connection.createStatement();
            resultSet = statement.executeQuery(COUNT_EVAL_DETAIL + string + "'");
            resultSet.next();
            int n2 = resultSet.getInt(1);
            System.out.println("trigger execution count: " + n2);
            int n3 = 0;
            int n4 = 1;
            if (n2 > n) {
                double d = (double)n2 / (double)n;
                if (d < 2.0) {
                    n3 = n2 - n;
                } else {
                    n4 = n2 / n;
                    n3 = (int)Math.round((double)n * (d - (double)n4));
                }
            }
            resultSet = statement.executeQuery(CQ_EVAL_DETAIL_QUERY + string + "' ORDER BY EVALNUM");
            int n5 = 0;
            while (resultSet.next()) {
                if (++n5 < n3 || n5 % n4 != 0) continue;
                CQExecution cQExecution = new CQExecution();
                vector.addElement(cQExecution);
                cQExecution.setUserId(resultSet.getString("USERID"));
                cQExecution.setId(resultSet.getString("CQID"));
                cQExecution.setEvaluationNumber((int)resultSet.getDouble("EVALNUM"));
                cQExecution.setEvaluationStart(resultSet.getDouble("EVALSTART"));
                cQExecution.setEvaluationEnd(resultSet.getDouble("EVALEND"));
                cQExecution.setTriggerStatus((int)resultSet.getDouble("TRIGSTAT"));
                cQExecution.setTriggerStart(resultSet.getDouble("TRIGSTART"));
                cQExecution.setTriggerEnd(resultSet.getDouble("TRIGEND"));
                cQExecution.setQueryStatus((int)resultSet.getDouble("QUERYSTAT"));
                cQExecution.setQueryStart(resultSet.getDouble("QUERYSTART"));
                cQExecution.setQueryEnd(resultSet.getDouble("QUERYEND"));
                cQExecution.setNotifyStatus((int)resultSet.getDouble("NOTIFYSTAT"));
                cQExecution.setNotifyStart(resultSet.getDouble("NOTIFYSTART"));
                cQExecution.setNotifyEnd(resultSet.getDouble("NOTIFYEND"));
                cQExecution.setExtTime(resultSet.getDouble("EXTTIME"));
                cQExecution.setStartUpTime(resultSet.getString("STARTUTIME"));
                cQExecution.setEndUpTime(resultSet.getString("ENDUTIME"));
            }
            System.out.println("total count: " + n5);
            resultSet.close();
            statement.close();
            connection.close();
        }
        catch (Exception exception) {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (statement != null) {
                    statement.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception exception2) {}
            System.out.println("error in getting CQHistory: " + exception);
            exception.printStackTrace();
        }
        return vector;
    }

    private Connection getMetaConnection() throws SQLException {
        Connection connection = DriverManager.getConnection(this.dbConnectionString, this.dbUser, this.dbPassword);
        return connection;
    }

    public Vector getQueryOperators() throws RemoteException {
        System.out.println("get QueryOperators: ");
        Vector<String> vector = new Vector<String>();
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            connection = this.getMetaConnection();
            statement = connection.createStatement();
            resultSet = statement.executeQuery(queryOperator_query);
            while (resultSet.next()) {
                String string = resultSet.getString(1);
                vector.addElement(string);
            }
            System.out.println("results:" + vector);
            resultSet.close();
            statement.close();
            connection.close();
        }
        catch (Exception exception) {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (statement != null) {
                    statement.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception exception2) {}
            System.out.println("error in getting query operators: " + exception);
            exception.printStackTrace();
        }
        return vector;
    }

    public Vector getRelations(String string) throws RemoteException {
        SourceInfo sourceInfo;
        System.out.println("get Relations: ");
        string = string.trim();
        if (this.sourceMap == null || this.sourceMap.size() == 0) {
            this.getSources();
        }
        if ((sourceInfo = (SourceInfo)this.sourceMap.get(string)) != null) {
            return sourceInfo.getRelations();
        }
        return new Vector();
    }

    public Vector getSchema(String string) throws RemoteException {
        System.out.println("get Schema");
        Vector<Object> vector = new Vector<Object>();
        Vector vector2 = this.getRelations(string);
        int n = 0;
        while (n < vector2.size()) {
            String string2 = (String)vector2.elementAt(n);
            Vector vector3 = this.getAttributes(string, string2);
            vector.addElement(string2);
            vector.addElement(vector3);
            ++n;
        }
        return vector;
    }

    public Vector getSources() throws RemoteException {
        Enumeration enumeration;
        Vector vector = new Vector();
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        if (this.sourceMap == null || this.sourceMap.size() == 0) {
            if (this.sourceMap == null) {
                this.sourceMap = new Hashtable();
            }
            System.out.println("get sources: ");
            try {
                try {
                    connection = DriverManager.getConnection(this.dbConnectionString, this.dbUser, this.dbPassword);
                    statement = connection.createStatement();
                    String string = source_query;
                    System.out.println("Source query: " + string);
                    resultSet = statement.executeQuery(string);
                    Vector vector2 = SourceInfo.initializeFromDB(resultSet);
                    int n = 0;
                    while (n < vector2.size()) {
                        SourceInfo sourceInfo = (SourceInfo)vector2.elementAt(n);
                        System.out.println(sourceInfo.getName());
                        this.sourceMap.put(sourceInfo.getName(), sourceInfo);
                        ++n;
                    }
                    resultSet.close();
                    statement.close();
                    connection.close();
                }
                catch (Exception exception) {
                    System.out.println("error in relation query: " + exception);
                    exception.printStackTrace();
                }
            }
            catch (Throwable throwable) {
                Object var5_11 = null;
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                    if (statement != null) {
                        statement.close();
                    }
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (Exception exception) {}
                throw throwable;
            }
            enumeration = null;
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (statement != null) {
                    statement.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception exception) {}
        }
        enumeration = this.sourceMap.keys();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        return vector;
    }

    public Vector getTriggerOperators() throws RemoteException {
        System.out.println("get triggerOperators: ");
        Vector<String> vector = new Vector<String>();
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            connection = DriverManager.getConnection(this.dbConnectionString, this.dbUser, this.dbPassword);
            statement = connection.createStatement();
            resultSet = statement.executeQuery(triggerOperator_query);
            while (resultSet.next()) {
                String string = resultSet.getString(1);
                vector.addElement(string);
            }
            System.out.println("results:" + vector);
            resultSet.close();
            statement.close();
            connection.close();
        }
        catch (Exception exception) {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (statement != null) {
                    statement.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception exception2) {}
            System.out.println("error in getting query operators: " + exception);
            exception.printStackTrace();
        }
        return vector;
    }

    private void initDB() {
        System.out.println("init");
        try {
            Class.forName(this.jdbcDriverClass).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.out.println("Error: unable to load Oracle driver: " + classNotFoundException);
            classNotFoundException.printStackTrace();
        }
        catch (InstantiationException instantiationException) {
            System.out.println("Error: unable to load Oracle driver: " + instantiationException);
            instantiationException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            System.out.println("Error: unable to load Oracle driver: " + illegalAccessException);
            illegalAccessException.printStackTrace();
        }
        System.out.println("init end");
        System.out.println("finished initDB");
    }

    private void initializeProperties() {
        this.jdbcDriverClass = System.getProperty("METADBDRIVER");
        this.dbConnectionString = System.getProperty("METADBCONNSTR");
        this.dbUser = System.getProperty("CQDBLOGIN");
        this.dbPassword = System.getProperty("CQPASS");
        this.contentQueryCGI = System.getProperty("INSTALLPATH");
        if (this.jdbcDriverClass == null || this.jdbcDriverClass.trim().equals("") || this.dbConnectionString == null || this.dbConnectionString.trim().equals("") || this.dbUser == null || this.dbUser.trim().equals("") || this.dbPassword == null || this.dbPassword.trim().equals("") || this.contentQueryCGI == null || this.contentQueryCGI.trim().equals("")) {
            System.out.println("Properties not all defined, failed to initialize");
        }
        System.out.println(this.jdbcDriverClass);
        System.out.println(this.dbConnectionString);
        System.out.println(this.dbUser);
        System.out.println(this.dbPassword);
        System.out.println(this.contentQueryCGI);
    }

    public String installCQ(ClusterLog clusterLog, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, boolean bl, String string11, String string12) throws InvalidCQException, RemoteException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        System.out.println("CQClusterImpl install CQ: ");
        System.out.println(string2);
        System.out.println("source: " + string);
        System.out.println("cq Name: " + string4);
        System.out.println("select: " + string5);
        System.out.println("from: " + string6);
        System.out.println("where: " + string7);
        System.out.println("orderBy: " + string8);
        System.out.println("groupBy: " + string9);
        System.out.println("trigger: " + string10);
        System.out.println("notify: " + string11);
        System.out.println("stop: " + string12);
        System.out.println("Checking for example queries");
        Examples examples = null;
        if (string.equalsIgnoreCase("JTAV")) {
            examples = new JTAVExamples();
        } else {
            try {
                String string13 = "ogi.cq.plugin.gui.demo." + string.toUpperCase() + "Examples";
                System.out.println(string13);
                object5 = Class.forName(string13);
                Constructor<?> constructor = ((Class)object5).getConstructor(null);
                examples = (Examples)constructor.newInstance(null);
                System.out.println("found example list");
            }
            catch (InvocationTargetException invocationTargetException) {
                System.out.println("Invocation target exception in creating examples for source: " + string);
                invocationTargetException.printStackTrace();
                examples = new NoExamples();
            }
            catch (IllegalAccessException illegalAccessException) {
                System.out.println("Illegal access in creating examples for source: " + string);
                illegalAccessException.printStackTrace();
                examples = new NoExamples();
            }
            catch (InstantiationException instantiationException) {
                System.out.println("Examples could not be instantiated for source: " + string);
                instantiationException.printStackTrace();
                examples = new NoExamples();
            }
            catch (NoSuchMethodException noSuchMethodException) {
                System.out.println("Examples could not be created for source: " + string);
                noSuchMethodException.printStackTrace();
                examples = new NoExamples();
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.out.println("Examples not found for source: " + string);
                classNotFoundException.printStackTrace();
                examples = new NoExamples();
            }
            catch (Exception exception) {
                System.out.println("Examples exception for: " + string);
                exception.printStackTrace();
                examples = new NoExamples();
            }
        }
        System.out.println("Example count: " + examples.getExampleCount());
        boolean bl2 = false;
        object5 = null;
        int n = 0;
        while (n < examples.getExampleCount()) {
            object5 = ((String)examples.getExample(n)[0]).trim();
            System.out.println("look at example: " + (String)object5);
            if (string4.trim().equalsIgnoreCase((String)object5)) {
                System.out.println("found cooresponding example");
                object4 = null;
                try {
                    object3 = "ogi.cq.plugin.gui.demo." + string.toUpperCase() + "ExampleUpdate" + n;
                    System.out.println((String)object3);
                    object2 = Class.forName((String)object3);
                    object = ((Class)object2).getConstructor(null);
                    object4 = (ExampleUpdate)((Constructor)object).newInstance(null);
                    System.out.println(this.getSources());
                    System.out.println(this.sourceMap);
                    object4.setSourceInfo((SourceInfo)this.sourceMap.get(string));
                    object4.setCluster(this);
                    try {
                        object4.setMetaConnection(this.getMetaConnection());
                    }
                    catch (SQLException sQLException) {
                        System.out.println("error in setting meta connection: " + sQLException);
                    }
                }
                catch (InvocationTargetException invocationTargetException) {
                    System.out.println("Invocation target exception in creating examples for source: " + string);
                }
                catch (IllegalAccessException illegalAccessException) {
                    System.out.println("Illegal access in creating examples for source: " + string);
                }
                catch (InstantiationException instantiationException) {
                    System.out.println("Examples could not be instantiated for source: " + string);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    System.out.println("Examples could not be created for source: " + string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    System.out.println("Examples not found for source: " + string);
                }
                if (object4 != null) {
                    object3 = (ExampleUpdate)this.demoUpdateMap.get(object5);
                    if (object3 != null) {
                        System.out.println("found old updater");
                        object3.stop();
                    }
                    this.demoUpdateMap.put(object5, object4);
                    System.out.println("start new updater");
                    object4.start();
                } else {
                    System.out.println("error in starting example updater: NULL");
                }
                bl2 = true;
                break;
            }
            ++n;
        }
        if (bl2) {
            System.out.println("Found an example updater");
        } else {
            System.out.println("No example updater found");
        }
        System.out.println("FINISHED with EXAMPLE dohickey");
        clusterLog.log("\n<b>Installing CQ for: ");
        clusterLog.log("\n    User ID: ");
        clusterLog.log(string2);
        clusterLog.log("</b>");
        clusterLog.log("\n<br>\n");
        clusterLog.log("\nFormatting CQ... ");
        clusterLog.log("\n<br>\n");
        System.out.println("\nFormatting CQ... ");
        CQ cQ = null;
        cQ = bl ? new ContentQuery() : new TimeQuery();
        cQ.setName(string4);
        cQ.setSource(string);
        cQ.setContentTrigger(bl);
        cQ.setUser(string2);
        cQ.setPassword(string3);
        cQ.setSelect(string5);
        System.out.println("set select");
        cQ.setFrom(string6);
        cQ.setWhere(string7);
        cQ.setTrigger(string10);
        cQ.setStop(string12);
        if (string11 != null && !string11.trim().equals("")) {
            cQ.setNotifyConfig(string11);
        }
        System.out.println("finished set query");
        System.out.println(this.contentQueryCGI);
        System.out.println(cQ.getContent());
        try {
            System.out.println("run Install CQ");
            object4 = new GregorianCalendar();
            object3 = "" + (((Calendar)object4).get(2) + 1) + "-" + ((Calendar)object4).get(5) + "-" + ((Calendar)object4).get(1);
            object2 = "" + ((Calendar)object4).get(11) + ":" + ((Calendar)object4).get(12) + ":" + ((Calendar)object4).get(13);
            clusterLog.log("\nCQ Installation Date/Time:  " + (String)object3 + "  " + (String)object2 + "\n");
            clusterLog.log("\n<br>\n");
            try {
                String string14;
                Object object6;
                Object object7;
                System.out.println(this.contentQueryCGI);
                System.out.println(cQ.getContent());
                object = this.contentQueryCGI;
                String string15 = cQ.getContent();
                StringBuffer stringBuffer = null;
                String string16 = ((String)object).replace('\r', ' ').replace('\n', ' ').replace('\t', ' ').trim();
                String string17 = string15.replace('\r', ' ').replace('\n', ' ').replace('\t', ' ').trim();
                StringBuffer stringBuffer2 = new StringBuffer(string16);
                int n2 = 0;
                while (n2 < stringBuffer2.length()) {
                    if (stringBuffer2.charAt(n2) < '\n') {
                        stringBuffer2.setCharAt(n2, ' ');
                    }
                    ++n2;
                }
                string16 = stringBuffer2.toString().trim();
                stringBuffer2 = new StringBuffer(string17);
                n2 = 0;
                while (n2 < stringBuffer2.length()) {
                    if (stringBuffer2.charAt(n2) < '\n') {
                        stringBuffer2.setCharAt(n2, ' ');
                    }
                    ++n2;
                }
                string17 = stringBuffer2.toString().trim();
                try {
                    object7 = new URL(string16);
                    URLConnection uRLConnection = ((URL)object7).openConnection();
                    uRLConnection.setDoOutput(true);
                    uRLConnection.setDoInput(true);
                    uRLConnection.setUseCaches(false);
                    uRLConnection.setAllowUserInteraction(true);
                    uRLConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                    DataOutputStream dataOutputStream = new DataOutputStream(uRLConnection.getOutputStream());
                    dataOutputStream.writeBytes(string17);
                    dataOutputStream.close();
                    object6 = new InputStreamReader(uRLConnection.getInputStream());
                    LineNumberReader lineNumberReader = new LineNumberReader((Reader)object6);
                    stringBuffer = new StringBuffer();
                    string14 = lineNumberReader.readLine();
                    while (string14 != null) {
                        clusterLog.log(string14);
                        System.out.println(string14);
                        stringBuffer.append(string14);
                        stringBuffer.append('\n');
                        string14 = lineNumberReader.readLine();
                    }
                    ((InputStreamReader)object6).close();
                }
                catch (MalformedURLException malformedURLException) {
                    throw new MalformedURLException("[URLUtils]Error in retrieving post results: " + malformedURLException);
                }
                catch (Exception exception) {
                    System.out.println("[URLUtils]Error in retrieving post results:" + exception);
                }
                object7 = stringBuffer.toString();
                clusterLog.log("\n<br>\n");
                clusterLog.log("\n\nReturned from installation");
                clusterLog.log("\n<br>\n");
                int n3 = ((String)object7).indexOf("<!--RESULTURL:");
                int n4 = n3 + "<!--RESULTURL:".length();
                object6 = ((String)object7).substring(n4).trim();
                int n5 = -1;
                if (n3 >= 0) {
                    n5 = ((String)object6).indexOf("-->");
                }
                string14 = "error in installing CQ";
                if (n3 >= 0 && n5 > 0) {
                    clusterLog.log("\n  Discovered result url: ");
                    clusterLog.log("\n<br>\n");
                    string14 = ((String)object6).substring(0, n5);
                    string14 = CQClusterImpl.stripQuotes(string14);
                    clusterLog.log(string14);
                    clusterLog.log("\n<br>\n");
                }
                int n6 = ((String)object7).indexOf("<!--CQID:");
                int n7 = n6 + "<!--CQID:".length();
                System.out.println("ID index: " + n6);
                String string18 = ((String)object7).substring(n7).trim();
                int n8 = string18.indexOf("-->");
                String string19 = "CQID";
                if (n7 >= 0) {
                    string19 = n8 > 0 ? string18.substring(0, n8) : string18;
                    clusterLog.log("\n  Discovered CQ ID: ");
                    clusterLog.log(string19);
                    clusterLog.log("\n<br>\n");
                }
                StringBuffer stringBuffer3 = new StringBuffer();
                stringBuffer3.append("['");
                stringBuffer3.append(string19);
                stringBuffer3.append("', url('");
                stringBuffer3.append(string14);
                stringBuffer3.append("')]");
                int n9 = ((String)object7).indexOf("<!--ERROR:");
                int n10 = n9 + "<!--ERROR:".length();
                string18 = ((String)object7).substring(n10).trim();
                int n11 = string18.indexOf("-->");
                String string20 = null;
                if (n9 >= 0 && n11 > 0) {
                    clusterLog.log("\n  Error in installing CQ: ");
                    string20 = string18.substring(0, n11);
                    clusterLog.log(string20);
                    clusterLog.log("\n<br>\n");
                    System.out.println("\n  Error in installing CQ: ");
                    System.out.println(string20);
                }
                clusterLog.log("\n<hr>");
                if (string20 == null && !string14.equals("error in installing CQ")) {
                    clusterLog.log("\n\nCongradulations!!!  Your CQ has been installed.\n");
                    clusterLog.log("\nClick the Finish button to view results");
                } else {
                    clusterLog.log("\n\nCQ installation did not complete successfully.\n");
                }
                clusterLog.log("\n<br>\n");
            }
            catch (MalformedURLException malformedURLException) {
                System.out.println("mue Error: " + malformedURLException);
            }
            catch (Exception exception) {
                System.out.println("Error: " + exception);
            }
            return "Success";
        }
        catch (Exception exception) {
            System.out.println("error in installing CQ: " + exception);
            exception.printStackTrace();
            return "Failure";
        }
    }

    public Vector listCQ(String string) throws RemoteException {
        System.out.println("NOT IMPLEMENTED: list cq for: " + string);
        return new Vector();
    }

    public static String loadProperties(String string) {
        try {
            Properties properties = new Properties(System.getProperties());
            properties.load(new BufferedInputStream(new FileInputStream(string)));
            System.setProperties(properties);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return new String("ERROR:  Could not open: " + string);
        }
        catch (IOException iOException) {
            return new String("loadProperties " + iOException);
        }
        return null;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 3) {
            CQClusterImpl.usage();
            System.exit(0);
        }
        try {
            String string = stringArray[0];
            int n = Integer.parseInt(stringArray[1]);
            System.out.println("RMIport = " + n);
            System.out.println(" 4");
            CQClusterImpl cQClusterImpl = new CQClusterImpl(stringArray[2]);
            System.out.println(" 5");
            System.out.println(" 7");
            InetAddress inetAddress = InetAddress.getByName(string);
            Naming.rebind("//" + inetAddress.getHostAddress() + ":" + n + "/CQCluster", cQClusterImpl);
            System.out.println("/CQCluster bound in registry at port " + n);
            System.out.println(" 8");
        }
        catch (Exception exception) {
            System.out.println("error: " + exception);
            System.out.println("Invalid port number: " + stringArray[0]);
            System.out.println("error: " + exception);
            System.exit(0);
        }
    }

    public void notifyCQUpdate(String string, String string2) throws RemoteException {
        System.out.println("Cq update: " + string + ", " + string2);
        IContinualQueryPlugin iContinualQueryPlugin = (IContinualQueryPlugin)this.pluginMap.get(string);
        if (iContinualQueryPlugin != null) {
            iContinualQueryPlugin.notifyCQUpdate(string, string2);
            System.out.println("plugin update: " + string + ", " + string2);
        }
    }

    public boolean registerUser(String string, String string2, String string3, String string4, String string5, String string6, String string7) throws RemoteException {
        System.out.println("cluster.registerUser()");
        boolean bl = false;
        Connection connection = null;
        Statement statement = null;
        Statement statement2 = null;
        ResultSet resultSet = null;
        try {
            connection = this.getMetaConnection();
            System.out.println("made connection");
            statement = connection.createStatement();
            resultSet = statement.executeQuery(VALIDATE_USER_QUERY + string + "'");
            while (resultSet.next()) {
                String string8 = resultSet.getString("PASSWD");
                if (!string8.trim().equals(string2.trim())) continue;
                bl = true;
                break;
            }
            resultSet.close();
            statement.close();
            if (!bl) {
                statement2 = connection.prepareStatement(REGISTER_USER);
                statement2.setString(1, string);
                statement2.setString(2, string2);
                statement2.setString(3, string3);
                statement2.setString(4, string4);
                statement2.setString(5, string5);
                statement2.setString(6, string6);
                statement2.setString(7, string7);
                bl = statement2.execute();
                statement2.close();
            }
            connection.close();
        }
        catch (Exception exception) {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (statement != null) {
                    statement.close();
                }
                if (statement2 != null) {
                    statement2.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception exception2) {}
            System.out.println("error in registering user: " + exception);
            exception.printStackTrace();
        }
        return bl;
    }

    private Date stopStringToDate(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "- :");
        String string2 = stringTokenizer.nextToken();
        String string3 = stringTokenizer.nextToken();
        String string4 = stringTokenizer.nextToken();
        String string5 = stringTokenizer.nextToken();
        String string6 = stringTokenizer.nextToken();
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.set(2, Integer.parseInt(string2) - 1);
        gregorianCalendar.set(5, Integer.parseInt(string3));
        gregorianCalendar.set(1, Integer.parseInt(string4));
        int n = Integer.parseInt(string5);
        gregorianCalendar.set(10, n);
        if (n < 12) {
            gregorianCalendar.set(9, 0);
        } else {
            gregorianCalendar.set(9, 1);
        }
        gregorianCalendar.set(12, Integer.parseInt(string6));
        return gregorianCalendar.getTime();
    }

    private Date stringToDate(String string) {
        if (string == null) {
            return new Date();
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "- :");
        String string2 = null;
        if (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
        }
        String string3 = null;
        if (stringTokenizer.hasMoreTokens()) {
            string3 = stringTokenizer.nextToken();
        }
        String string4 = null;
        if (stringTokenizer.hasMoreTokens()) {
            string4 = stringTokenizer.nextToken();
        }
        String string5 = null;
        if (stringTokenizer.hasMoreTokens()) {
            string5 = stringTokenizer.nextToken();
        }
        String string6 = null;
        if (stringTokenizer.hasMoreTokens()) {
            string6 = stringTokenizer.nextToken();
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        if (string3 != null) {
            gregorianCalendar.set(2, Integer.parseInt(string3) - 1);
        }
        if (string4 != null) {
            gregorianCalendar.set(5, Integer.parseInt(string4));
        }
        if (string2 != null) {
            gregorianCalendar.set(1, Integer.parseInt(string2));
        }
        if (string5 != null) {
            int n = Integer.parseInt(string5);
            gregorianCalendar.set(10, n);
            if (n < 12) {
                gregorianCalendar.set(9, 0);
            } else {
                gregorianCalendar.set(9, 1);
            }
        }
        if (string6 != null) {
            gregorianCalendar.set(12, Integer.parseInt(string6));
        }
        return gregorianCalendar.getTime();
    }

    public static String stripQuotes(String string) {
        String string2 = string.replace('\'', ' ');
        string2 = string2.replace('\"', ' ');
        string2 = string2.trim();
        return string2;
    }

    public static void usage() {
        System.out.println("Usage: CQClusterImpl <host> <RMIport> <property File>");
        System.out.println("Where <RMIport> is the port of the RMI Server");
        System.out.println("in which the wrapper runs.");
        System.out.println("and <host> is the computer on which the RMI Server runs.");
        System.out.println("<Property File> is the file that contains a list of parameters");
        System.out.println("that this program needs to run.");
        System.out.println("");
        System.out.println("Properties:");
        System.out.println("DBDRIVER:    class name of JDBC driver to access CQ metadata");
        System.out.println("DBCONNSTR:   JDBC connection string to access CQ metadata");
        System.out.println("dbUser:             user name used to connect to CQ metadata DB");
        System.out.println("dbPassword:         password used to connect to CQ metadata DB");
        System.out.println("contentQueryCGI:    URL of CQ installation script");
    }

    public boolean validateUser(String string, String string2) throws RemoteException {
        System.out.println("cluster.validateUser()");
        boolean bl = false;
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            connection = this.getMetaConnection();
            System.out.println("made connection");
            statement = connection.createStatement();
            resultSet = statement.executeQuery(VALIDATE_USER_QUERY + string + "'");
            while (resultSet.next()) {
                String string3 = resultSet.getString("PASSWD");
                if (!string3.trim().equals(string2.trim())) continue;
                bl = true;
                break;
            }
            resultSet.close();
            statement.close();
            connection.close();
        }
        catch (Exception exception) {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (statement != null) {
                    statement.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception exception2) {}
            System.out.println("error in getting validating user: " + exception);
            exception.printStackTrace();
        }
        return bl;
    }
}

