/*
 * Decompiled with CFR 0.152.
 */
package ogi.cq.alp.install;

import java.awt.Component;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.util.StringTokenizer;
import java.util.Vector;
import ogi.cq.alp.install.ConfigListener;
import ogi.cq.alp.install.EditConfig;
import ogi.cq.alp.install.TaskEvent;
import ogi.cq.alp.install.TaskIO;
import ogi.cq.alp.install.TaskListener;
import ogi.cq.log.Log;

public class PlainTaskExecuter
implements Runnable,
ConfigListener,
TaskListener {
    String name;
    String action;
    Vector appendix;
    Vector listeners;
    private Log logger;
    String url;
    static Class class$java$lang$String;

    public PlainTaskExecuter(String string, String string2) {
        this.name = string;
        this.action = string2;
        this.appendix = new Vector();
        this.listeners = new Vector();
    }

    public void addTaskListener(TaskListener taskListener) {
        if (taskListener == null) {
            return;
        }
        if (this.listeners.contains(taskListener)) {
            return;
        }
        this.listeners.addElement(taskListener);
    }

    public void append(String string) {
        this.logger.log(String.valueOf(this.name) + ": " + string);
        this.appendix.addElement(string);
    }

    public void configSaved(EditConfig editConfig) {
        System.out.println("CONFIG SAVED");
        this.fireTaskFinished(false);
        this.append("Finished configuring file");
    }

    protected void fireTaskFinished(boolean bl) {
        Vector vector;
        PlainTaskExecuter plainTaskExecuter = this;
        synchronized (plainTaskExecuter) {
            vector = (Vector)this.listeners.clone();
        }
        int n = vector.size();
        if (n == 0) {
            return;
        }
        TaskEvent taskEvent = new TaskEvent(this);
        taskEvent.setFailed(bl);
        int n2 = 0;
        while (n2 < n) {
            TaskListener taskListener = (TaskListener)vector.elementAt(n2);
            taskListener.taskFinished(taskEvent);
            ++n2;
        }
    }

    public String getAction() {
        return this.action;
    }

    public Log getLogger() {
        return this.logger;
    }

    public String getName() {
        return this.name;
    }

    public void removeTaskListener(TaskListener taskListener) {
        if (taskListener == null) {
            return;
        }
        this.listeners.removeElement(taskListener);
    }

    public void run() {
        if (this.action.toLowerCase().trim().startsWith("editconfig:")) {
            this.action = this.action.substring("editconfig:".length()).trim();
            System.out.println("ACTION: " + this.action);
            String string = this.action.substring(0, this.action.indexOf(" ")).trim();
            String string2 = this.action.substring(this.action.indexOf(" ")).trim();
            System.out.println("DEFAULT: " + string);
            System.out.println("CONFIG: " + string2);
            EditConfig editConfig = new EditConfig(string);
            editConfig.setConfigFile(string2);
            editConfig.addConfigListener(this);
            ((Component)((Object)editConfig)).setVisible(true);
        } else if (this.action.toLowerCase().trim().startsWith("execute:")) {
            this.action = this.action.substring("execute:".length());
            System.out.println("ACTION: " + this.action);
            this.runFile(this.action);
        } else if (this.action.toLowerCase().trim().startsWith("javaio:")) {
            this.action = this.action.substring("javaio:".length());
            System.out.println("ACTION: " + this.action);
            this.runJavaIO(this.action);
        } else if (this.action.toLowerCase().trim().startsWith("java:")) {
            this.action = this.action.substring("java:".length());
            System.out.println("ACTION: " + this.action);
            this.runJava(this.action);
        } else if (this.action.toLowerCase().trim().startsWith("pause:")) {
            this.action = this.action.substring("pause:".length());
            System.out.println("ACTION: PAUSE " + this.action);
            int n = 0;
            try {
                n = Integer.parseInt(this.action.trim());
                Thread.sleep(n);
                this.fireTaskFinished(false);
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println("num error: " + numberFormatException);
                this.fireTaskFinished(true);
            }
            catch (InterruptedException interruptedException) {
                this.fireTaskFinished(false);
            }
        } else {
            System.out.println("Unknown Action: " + this.action);
            this.append("Unknown action: " + this.action);
            this.fireTaskFinished(true);
        }
    }

    public void runFile(String string) {
        string = string.trim();
        boolean bl = true;
        Vector<String> vector = new Vector<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        while (stringTokenizer.hasMoreTokens()) {
            vector.addElement(stringTokenizer.nextToken());
        }
        if (vector.size() == 0) {
            this.append("action is empty for command: " + string);
            return;
        }
        String[] stringArray = new String[vector.size()];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = (String)vector.elementAt(n);
            ++n;
        }
        DataInputStream dataInputStream = null;
        InputStreamReader inputStreamReader = null;
        try {
            int n2;
            this.append("\nStarting Command: " + string + "...\n");
            Process process = Runtime.getRuntime().exec(stringArray);
            dataInputStream = new DataInputStream(process.getInputStream());
            inputStreamReader = new InputStreamReader(dataInputStream);
            char[] cArray = new char[4096];
            while ((n2 = inputStreamReader.read(cArray)) != -1) {
                String string2 = new String(cArray, 0, n2);
                this.append("\n");
                this.append(string2);
            }
            this.append("\nFinished Command: " + string + "\n\n");
            bl = false;
        }
        catch (IOException iOException) {
            System.err.println("SubProcess: run: " + iOException);
            iOException.printStackTrace();
            this.append("\nCommand \"" + string + "\" Failed: " + iOException);
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            iOException.printStackTrace(printWriter);
            this.append(stringWriter.toString());
            bl = true;
        }
        try {
            if (dataInputStream != null) {
                dataInputStream.close();
            }
        }
        catch (IOException iOException) {
            System.err.println("SubProcess:  Trying to close datainput");
        }
        this.fireTaskFinished(bl);
    }

    public void runJava(String string) {
        Vector<String> vector = new Vector<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        while (stringTokenizer.hasMoreTokens()) {
            vector.addElement(stringTokenizer.nextToken());
        }
        if (vector.size() == 0) {
            this.append("action is empty: " + string);
            return;
        }
        String string2 = (String)vector.elementAt(0);
        Object[] objectArray = new String[vector.size() - 1];
        int n = 1;
        while (n < objectArray.length + 1) {
            objectArray[n - 1] = (String)vector.elementAt(n);
            ++n;
        }
        try {
            Class<?> clazz = Class.forName(string2);
            Class[] classArray = new Class[objectArray.length];
            int n2 = 0;
            while (n2 < objectArray.length) {
                Class<?> clazz2 = class$java$lang$String;
                if (clazz2 == null) {
                    try {
                        clazz2 = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[n2] = clazz2;
                ++n2;
            }
            Constructor<?> constructor = clazz.getConstructor(classArray);
            Runnable runnable = (Runnable)constructor.newInstance(objectArray);
            runnable.run();
        }
        catch (Throwable throwable) {
            System.err.println("SubProcess: run Java class: " + throwable);
        }
    }

    public void runJavaIO(String string) {
        Vector<String> vector = new Vector<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        while (stringTokenizer.hasMoreTokens()) {
            vector.addElement(stringTokenizer.nextToken());
        }
        if (vector.size() == 0) {
            this.append("action is empty: " + string);
            return;
        }
        String string2 = (String)vector.elementAt(0);
        Object[] objectArray = new String[vector.size() - 1];
        int n = 1;
        while (n < objectArray.length + 1) {
            objectArray[n - 1] = (String)vector.elementAt(n);
            ++n;
        }
        try {
            Class<?> clazz = Class.forName(string2);
            Class[] classArray = new Class[objectArray.length];
            int n2 = 0;
            while (n2 < objectArray.length) {
                Class<?> clazz2 = class$java$lang$String;
                if (clazz2 == null) {
                    try {
                        clazz2 = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[n2] = clazz2;
                ++n2;
            }
            Constructor<?> constructor = clazz.getConstructor(classArray);
            TaskIO taskIO = (TaskIO)constructor.newInstance(objectArray);
            StringWriter stringWriter = new StringWriter();
            taskIO.setOut(new PrintWriter(stringWriter));
            taskIO.setTaskListener(this);
            taskIO.setLog(this.logger);
            taskIO.run();
            this.append(stringWriter.toString());
        }
        catch (Exception exception) {
            System.err.println("SubProcess: run Java class: " + exception);
            exception.printStackTrace();
        }
    }

    public void setLogger(Log log) {
        this.logger = log;
    }

    public void taskFinished(TaskEvent taskEvent) {
        this.append(taskEvent.getSource().toString());
        if (taskEvent.getFailed()) {
            System.out.println("TASK failed");
        } else {
            this.append("Finished Task\n");
        }
        this.fireTaskFinished(taskEvent.getFailed());
    }
}

