/*
 * Decompiled with CFR 0.152.
 */
package ogi.cq.alp.install;

import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Hashtable;
import java.util.Vector;
import ogi.cq.alp.install.PlainTaskExecuter;
import ogi.cq.alp.install.TaskEvent;
import ogi.cq.alp.install.TaskListener;
import ogi.cq.log.Log;
import ogi.cq.log.OutLog;

public class JavaScript
implements TaskListener {
    public static final String DEFAULT_PROPERTIES = "configScript";
    public static final String DEFAULT_LOG = "script.log";
    Hashtable description = new Hashtable();
    private Vector configLines = new Vector();
    boolean[] finishedTask;
    Hashtable tasks;
    Hashtable results;
    Hashtable taskMap = new Hashtable();
    int taskCount = 0;
    Log logger;
    boolean beginning = true;
    int completed = 0;
    int timeout;
    int nextTask = 0;
    int totalTasks = 0;
    public static final int DEFAULT_TIMEOUT = 1000;

    public JavaScript(String string) {
        this(string, DEFAULT_LOG);
    }

    public JavaScript(String string, String string2) {
        this.loadScript(string);
        this.initialize();
        try {
            this.logger = new OutLog(new PrintWriter((Writer)new FileWriter(string2), true));
        }
        catch (Exception exception) {
            System.out.println("Failed to create log");
            this.logger = new OutLog();
        }
        this.beginning = false;
        this.runNextTask();
    }

    private void addTask(String string, String string2) {
        if (this.tasks == null) {
            this.tasks = new Hashtable();
        }
        this.tasks.put(string, string2);
        if (this.results == null) {
            this.results = new Hashtable();
        }
        ++this.taskCount;
    }

    protected void executeTask(int n) {
        if (n >= 0 && n < this.finishedTask.length) {
            String string = this.configLines.elementAt(n).toString();
            int n2 = string.indexOf("=");
            String string2 = string.substring(0, n2).trim();
            String string3 = (String)this.tasks.get(string2);
            System.out.println(string3);
            if (string3 == null) {
                System.out.println("error in getting task for " + string2);
            }
            if (!this.finishedTask[n]) {
                PlainTaskExecuter plainTaskExecuter = new PlainTaskExecuter(string2, string3);
                plainTaskExecuter.addTaskListener(this);
                plainTaskExecuter.setLogger(this.logger);
                this.taskMap.put(plainTaskExecuter, new Integer(n));
                Thread thread = new Thread(plainTaskExecuter);
                thread.start();
            } else {
                System.out.println("\nTask already completed");
            }
        }
    }

    protected int getNextTask() {
        int n = this.nextTask++;
        return n;
    }

    private void initialize() {
    }

    public void loadScript(String string) {
        System.out.println("load script from: " + string);
        try {
            LineNumberReader lineNumberReader = new LineNumberReader(new FileReader(string));
            if (lineNumberReader == null) {
                System.out.println("null reader");
            }
            StringBuffer stringBuffer = new StringBuffer();
            String string2 = lineNumberReader.readLine();
            if (string2 != null && string2.trim().startsWith("pause")) {
                String string3 = string2.trim().substring(string2.trim().indexOf(":") + 1);
                try {
                    this.timeout = Integer.parseInt(string3);
                }
                catch (NumberFormatException numberFormatException) {
                    this.timeout = 1000;
                }
                string2 = lineNumberReader.readLine();
            } else {
                this.timeout = 1000;
            }
            int n = -1;
            while (string2 != null) {
                ++n;
                string2 = string2.trim();
                int n2 = string2.indexOf("=");
                if (string2.startsWith("#") || string2.equals("") || n2 <= 0) {
                    if (string2.startsWith("#")) {
                        stringBuffer.append(string2.substring(1));
                        stringBuffer.append('\n');
                    } else if (n2 <= 0) {
                        stringBuffer.append(string2);
                    }
                    string2 = lineNumberReader.readLine();
                    continue;
                }
                this.configLines.addElement(string2);
                String string4 = string2.substring(0, n2).trim();
                String string5 = string2.substring(n2 + 1).trim();
                this.addTask(string4, string5);
                this.description.put(string4, stringBuffer.toString());
                stringBuffer.setLength(0);
                string2 = lineNumberReader.readLine();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("File " + string + " not found: " + fileNotFoundException);
        }
        catch (IOException iOException) {
            System.out.println("IO Exception in loading properties: " + iOException);
        }
        this.finishedTask = new boolean[this.configLines.size()];
    }

    public static void main(String[] stringArray) {
        try {
            String string = DEFAULT_PROPERTIES;
            String string2 = DEFAULT_LOG;
            if (stringArray.length > 0) {
                string = stringArray[0];
            }
            if (stringArray.length > 1) {
                string2 = stringArray[1];
            }
            new JavaScript(string, string2);
        }
        catch (Throwable throwable) {
            System.err.println("Exception occurred in main() of ConfigGUI");
            throwable.printStackTrace(System.out);
        }
    }

    protected void runAllTasks() {
        int n = 0;
        while (n < this.finishedTask.length) {
            if (!this.finishedTask[n]) {
                this.executeTask(n);
            }
            ++n;
        }
    }

    protected void runNextTask() {
        int n = this.getNextTask();
        System.out.println(n);
        this.executeTask(n);
    }

    public void taskFinished(TaskEvent taskEvent) {
        if (taskEvent.getFailed()) {
            System.out.println("Task failed");
        } else {
            System.out.println("Task succeeded");
            Object object = taskEvent.getSource();
            Integer n = (Integer)this.taskMap.get(object);
            this.finishedTask[n.intValue()] = true;
            this.completed = n;
            try {
                Thread.sleep(this.timeout);
            }
            catch (Exception exception) {}
            this.runNextTask();
        }
    }
}

