/*
 * Decompiled with CFR 0.152.
 */
package ogi.cq.alp.install;

import com.sun.java.swing.BorderFactory;
import com.sun.java.swing.Box;
import com.sun.java.swing.BoxLayout;
import com.sun.java.swing.JButton;
import com.sun.java.swing.JDialog;
import com.sun.java.swing.JFrame;
import com.sun.java.swing.JLabel;
import com.sun.java.swing.JPanel;
import com.sun.java.swing.JScrollPane;
import com.sun.java.swing.JSplitPane;
import com.sun.java.swing.JTable;
import com.sun.java.swing.JTextArea;
import com.sun.java.swing.JTextField;
import com.sun.java.swing.event.CaretEvent;
import com.sun.java.swing.event.CaretListener;
import com.sun.java.swing.event.ListSelectionEvent;
import com.sun.java.swing.event.ListSelectionListener;
import com.sun.java.swing.table.DefaultTableModel;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import ogi.cq.alp.install.ConfigListener;

public class EditConfig
extends JFrame
implements ListSelectionListener,
ActionListener,
CaretListener {
    ConfigListener listener;
    public static final String DEFAULT_PROPERTIES = "defaults.ini";
    public static final String CONFIG_PROPERTIES = "config.ini";
    Hashtable description = new Hashtable();
    private String configFile = "config.ini";
    private Properties defaultProperties;
    private Vector lines = new Vector();
    private Vector configLines = new Vector();
    Vector configPanelVector = new Vector();
    Vector valueFieldVector = new Vector();
    JPanel titlePanel;
    JPanel cardPanel;
    JPanel cardControlPanel;
    JPanel descriptionLabelPanel;
    JPanel descriptionPanel;
    JPanel buttonPanel;
    private JButton startButton = null;
    private JButton previousButton = null;
    private JButton nextButton = null;
    private JButton summaryButton = null;
    private JButton ivjCancelButton = null;
    private JLabel ivjDescriptionLabel = null;
    private JPanel ivjJFrameContentPane = null;
    private JLabel titleLabel = null;
    private JScrollPane ivjJScrollPane1 = null;
    private JButton ivjOkButton = null;
    private JTable ivjScrollPaneTable = null;
    private JTextArea ivjDescriptionField = null;
    private JButton ivjResetButton = null;
    JDialog exitDialog;
    JButton okExitButton;
    JButton cancelExitButton;
    boolean saved = false;
    int componentCount;
    int currentCard;

    public EditConfig(String string) {
        this(string, "Configuration Initialization");
    }

    public EditConfig(String string, String string2) {
        super(string2);
        this.loadDefaults(string);
        this.initialize();
        this.resetToDefaults();
        this.setDescription();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.getResetButton()) {
            this.connEtoC1();
        }
        if (actionEvent.getSource() == this.getCancelButton()) {
            if (this.saved) {
                this.exit();
            } else {
                this.getExitDialog().show();
            }
        }
        if (actionEvent.getSource() == this.getOkButton()) {
            this.connEtoC3();
        }
        if (actionEvent.getSource() == this.getStartButton()) {
            this.startButtonClicked();
        }
        if (actionEvent.getSource() == this.getPreviousButton()) {
            this.previousButtonClicked();
        }
        if (actionEvent.getSource() == this.getNextButton()) {
            this.nextButtonClicked();
        }
        if (actionEvent.getSource() == this.getSummaryButton()) {
            this.summaryButtonClicked();
        }
        if (actionEvent.getSource() == this.okExitButton) {
            this.getExitDialog().setVisible(false);
            this.exit();
        }
        if (actionEvent.getSource() == this.cancelExitButton) {
            this.getExitDialog().setVisible(false);
        }
    }

    public void addConfigListener(ConfigListener configListener) {
        this.listener = configListener;
    }

    public void caretUpdate(CaretEvent caretEvent) {
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.getScrollPaneTable().getModel();
        int n = 0;
        while (n < this.valueFieldVector.size()) {
            defaultTableModel.setValueAt((Object)((JTextField)this.valueFieldVector.elementAt(n)).getText(), n, 1);
            ++n;
        }
    }

    private void connEtoC1() {
        try {
            this.resetToDefaults();
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void connEtoC2() {
        try {
            this.exit();
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void connEtoC3() {
        try {
            this.saveFile();
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    public void exit() {
        ((Component)((Object)this)).setVisible(false);
    }

    protected void fireConfigurationSaved() {
        this.listener.configSaved(this);
    }

    private JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            try {
                this.buttonPanel = new JPanel();
                this.buttonPanel.setName("Button Panel");
                this.buttonPanel.setLayout((LayoutManager)new BoxLayout((Container)this.buttonPanel, 0));
                this.getButtonPanel().add(Box.createHorizontalGlue());
                this.getButtonPanel().add((Component)this.getOkButton());
                this.getButtonPanel().add(Box.createHorizontalGlue());
                this.getButtonPanel().add((Component)this.getResetButton());
                this.getButtonPanel().add(Box.createHorizontalGlue());
                this.getButtonPanel().add((Component)this.getCancelButton());
                this.getButtonPanel().add(Box.createHorizontalGlue());
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.buttonPanel;
    }

    private JButton getCancelButton() {
        if (this.ivjCancelButton == null) {
            try {
                this.ivjCancelButton = new JButton();
                this.ivjCancelButton.setName("CancelButton");
                this.ivjCancelButton.setText("Close");
                this.ivjCancelButton.setBackground(new Color(255, 0, 0));
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjCancelButton;
    }

    private JPanel getCardControlPanel() {
        if (this.cardControlPanel == null) {
            try {
                this.cardControlPanel = new JPanel();
                this.cardControlPanel.setName("CardControlPanel");
                this.cardControlPanel.setLayout((LayoutManager)new BoxLayout((Container)this.cardControlPanel, 0));
                this.getCardControlPanel().add((Component)this.getStartButton());
                this.getCardControlPanel().add(Box.createHorizontalGlue());
                this.getCardControlPanel().add((Component)this.getPreviousButton());
                this.getCardControlPanel().add(Box.createHorizontalGlue());
                this.getCardControlPanel().add((Component)this.getNextButton());
                this.getCardControlPanel().add(Box.createHorizontalGlue());
                this.getCardControlPanel().add((Component)this.getSummaryButton());
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.cardControlPanel;
    }

    private JPanel getCardPanel() {
        if (this.cardPanel == null) {
            try {
                this.cardPanel = new JPanel();
                this.cardPanel.setName("JFrameContentPane");
                this.cardPanel.setLayout(new CardLayout());
                int n = 0;
                while (n < this.configLines.size()) {
                    JPanel jPanel = this.getConfigPanel(n);
                    this.cardPanel.add((Component)jPanel, "Config" + n);
                    ++n;
                }
                this.cardPanel.add((Component)this.getJScrollPane1(), "Summary");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.cardPanel;
    }

    public String getConfigFile() {
        return this.configFile;
    }

    private JPanel getConfigPanel(int n) {
        int n2;
        this.configPanelVector.ensureCapacity(n);
        int n3 = n2 = this.configPanelVector.size();
        while (n3 <= n) {
            this.configPanelVector.addElement(null);
            ++n3;
        }
        JPanel jPanel = (JPanel)this.configPanelVector.elementAt(n);
        if (jPanel == null) {
            try {
                jPanel = new JPanel();
                jPanel.setName("JFrameContentPane");
                jPanel.setLayout((LayoutManager)new BoxLayout((Container)jPanel, 1));
                jPanel.setBorder(BorderFactory.createEtchedBorder());
                jPanel.add(Box.createRigidArea((Dimension)new Dimension(0, 30)));
                JPanel jPanel2 = new JPanel();
                jPanel2.setLayout((LayoutManager)new BoxLayout((Container)jPanel2, 0));
                jPanel.add((Component)jPanel2);
                JPanel jPanel3 = new JPanel();
                jPanel3.setLayout((LayoutManager)new BoxLayout((Container)jPanel3, 1));
                JPanel jPanel4 = new JPanel();
                jPanel4.setLayout((LayoutManager)new BoxLayout((Container)jPanel4, 1));
                jPanel2.add((Component)jPanel3);
                jPanel2.add(Box.createRigidArea((Dimension)new Dimension(10, 0)));
                jPanel2.add((Component)jPanel4);
                JLabel jLabel = new JLabel("Property Name: ");
                jLabel.setForeground(Color.black);
                jPanel3.add((Component)jLabel);
                jPanel3.add(Box.createRigidArea((Dimension)new Dimension(0, 10)));
                int n4 = (Integer)this.configLines.elementAt(n);
                String string = this.lines.elementAt(n4).toString();
                String string2 = string.substring(0, string.indexOf("="));
                JLabel jLabel2 = new JLabel(string2);
                jLabel2.setForeground(Color.black);
                jLabel2.setAlignmentX(0.0f);
                jPanel4.add((Component)jLabel2);
                jPanel4.add(Box.createRigidArea((Dimension)new Dimension(0, 10)));
                JLabel jLabel3 = new JLabel("Value: ");
                jLabel3.setForeground(Color.black);
                jPanel3.add((Component)jLabel3);
                JTextField jTextField = this.getValueField(n);
                jTextField.setAlignmentX(0.0f);
                jPanel4.add((Component)jTextField);
                this.configPanelVector.setElementAt(jPanel, n);
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return jPanel;
    }

    public Properties getDefaultProperties() {
        return this.defaultProperties;
    }

    private JTextArea getDescriptionField() {
        if (this.ivjDescriptionField == null) {
            try {
                this.ivjDescriptionField = new JTextArea("");
                this.ivjDescriptionField.setName("DescriptionField");
                this.ivjDescriptionField.setEditable(false);
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjDescriptionField;
    }

    private JLabel getDescriptionLabel() {
        if (this.ivjDescriptionLabel == null) {
            try {
                this.ivjDescriptionLabel = new JLabel();
                this.ivjDescriptionLabel.setName("DescriptionLabel");
                this.ivjDescriptionLabel.setText("Description");
                this.ivjDescriptionLabel.setFont(new Font("sansserif", 1, 20));
                this.ivjDescriptionLabel.setForeground(new Color(0, 0, 0));
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjDescriptionLabel;
    }

    private JPanel getDescriptionLabelPanel() {
        if (this.descriptionLabelPanel == null) {
            try {
                this.descriptionLabelPanel = new JPanel();
                this.descriptionLabelPanel.setName("descriptionLabelPanel");
                this.descriptionLabelPanel.setLayout(new FlowLayout());
                this.getDescriptionLabelPanel().add((Component)this.getDescriptionLabel());
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.descriptionLabelPanel;
    }

    private JPanel getDescriptionPanel() {
        if (this.descriptionPanel == null) {
            try {
                this.descriptionPanel = new JPanel();
                this.descriptionPanel.setName("DescriptionPanel");
                this.descriptionPanel.setLayout((LayoutManager)new BoxLayout((Container)this.descriptionPanel, 1));
                this.getDescriptionPanel().add((Component)this.getDescriptionLabelPanel());
                JScrollPane jScrollPane = new JScrollPane((Component)this.getDescriptionField());
                this.getDescriptionPanel().add((Component)jScrollPane);
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.descriptionPanel;
    }

    private JDialog getExitDialog() {
        if (this.exitDialog == null) {
            try {
                this.exitDialog = new JDialog();
                this.exitDialog.setName("ExitDialog");
                this.exitDialog.setDefaultCloseOperation(2);
                this.exitDialog.setModal(true);
                this.exitDialog.setTitle("Exit Dialog");
                JPanel jPanel = new JPanel();
                jPanel.setName("JPanel2");
                jPanel.setLayout(new BorderLayout());
                JLabel jLabel = new JLabel();
                jLabel.setName("ExitLabel");
                jLabel.setText("You have not saved. Do you really want to exit? Editting is not complete.");
                jPanel.add((Component)jLabel, "Center");
                JPanel jPanel2 = new JPanel();
                jPanel2.setLayout(new FlowLayout());
                this.okExitButton = new JButton();
                this.okExitButton.setText("OK");
                this.okExitButton.addActionListener((ActionListener)this);
                jPanel2.add((Component)this.okExitButton);
                this.cancelExitButton = new JButton();
                this.cancelExitButton.setText("Cancel");
                this.cancelExitButton.addActionListener((ActionListener)this);
                jPanel2.add((Component)this.cancelExitButton);
                jPanel.add((Component)jPanel2, "South");
                this.getExitDialog().setContentPane((Container)jPanel);
                this.exitDialog.pack();
            }
            catch (Exception exception) {
                System.out.println("Error in get Exit dialog: " + exception);
                exception.printStackTrace();
            }
        }
        return this.exitDialog;
    }

    private JPanel getJFrameContentPane() {
        if (this.ivjJFrameContentPane == null) {
            try {
                this.ivjJFrameContentPane = new JPanel();
                this.ivjJFrameContentPane.setName("JFrameContentPane");
                this.ivjJFrameContentPane.setLayout((LayoutManager)new BoxLayout((Container)this.ivjJFrameContentPane, 1));
                this.getJFrameContentPane().add((Component)this.getTitlePanel());
                this.getJFrameContentPane().add((Component)this.getCardControlPanel());
                JPanel jPanel = new JPanel();
                jPanel.setLayout(new BorderLayout());
                JSplitPane jSplitPane = new JSplitPane(0, true, (Component)this.getCardPanel(), (Component)this.getDescriptionPanel());
                jPanel.add("Center", (Component)jSplitPane);
                this.getJFrameContentPane().add((Component)jPanel);
                this.getJFrameContentPane().add((Component)this.getButtonPanel());
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjJFrameContentPane;
    }

    private JScrollPane getJScrollPane1() {
        if (this.ivjJScrollPane1 == null) {
            try {
                this.ivjJScrollPane1 = new JScrollPane();
                this.ivjJScrollPane1.setName("JScrollPane1");
                this.ivjJScrollPane1.setVerticalScrollBarPolicy(22);
                this.ivjJScrollPane1.setHorizontalScrollBarPolicy(32);
                this.getJScrollPane1().setViewportView((Component)this.getScrollPaneTable());
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjJScrollPane1;
    }

    private JButton getNextButton() {
        if (this.nextButton == null) {
            try {
                this.nextButton = new JButton();
                this.nextButton.setName("nextButton");
                this.nextButton.setText("Next");
                this.nextButton.setBackground(Color.cyan);
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.nextButton;
    }

    private JButton getOkButton() {
        if (this.ivjOkButton == null) {
            try {
                this.ivjOkButton = new JButton();
                this.ivjOkButton.setName("OkButton");
                this.ivjOkButton.setText("Save");
                this.ivjOkButton.setBackground(new Color(0, 204, 0));
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjOkButton;
    }

    private JButton getPreviousButton() {
        if (this.previousButton == null) {
            try {
                this.previousButton = new JButton();
                this.previousButton.setName("previousButton");
                this.previousButton.setText("Previous");
                this.previousButton.setBackground(Color.cyan);
                this.previousButton.setEnabled(false);
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.previousButton;
    }

    private JButton getResetButton() {
        if (this.ivjResetButton == null) {
            try {
                this.ivjResetButton = new JButton();
                this.ivjResetButton.setName("ResetButton");
                this.ivjResetButton.setText("Reset");
                this.ivjResetButton.setBackground(new Color(255, 255, 0));
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjResetButton;
    }

    private JTable getScrollPaneTable() {
        if (this.ivjScrollPaneTable == null) {
            try {
                this.ivjScrollPaneTable = new JTable();
                this.ivjScrollPaneTable.setName("ScrollPaneTable");
                this.getJScrollPane1().setColumnHeaderView((Component)this.ivjScrollPaneTable.getTableHeader());
                this.getJScrollPane1().getViewport().setBackingStoreEnabled(true);
                this.ivjScrollPaneTable.setAutoCreateColumnsFromModel(false);
                this.ivjScrollPaneTable.setAutoCreateColumnsFromModel(true);
                this.ivjScrollPaneTable.getSelectionModel().addListSelectionListener((ListSelectionListener)this);
                DefaultTableModel defaultTableModel = (DefaultTableModel)this.ivjScrollPaneTable.getModel();
                defaultTableModel.addColumn((Object)"Property");
                defaultTableModel.addColumn((Object)"Value");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjScrollPaneTable;
    }

    private JButton getStartButton() {
        if (this.startButton == null) {
            try {
                this.startButton = new JButton();
                this.startButton.setName("StartButton");
                this.startButton.setText("Start");
                this.startButton.setBackground(Color.cyan);
                this.startButton.setEnabled(false);
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.startButton;
    }

    private JButton getSummaryButton() {
        if (this.summaryButton == null) {
            try {
                this.summaryButton = new JButton();
                this.summaryButton.setName("summaryButton");
                this.summaryButton.setText("Summary");
                this.summaryButton.setBackground(Color.cyan);
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.summaryButton;
    }

    private JLabel getTitleLabel() {
        if (this.titleLabel == null) {
            try {
                this.titleLabel = new JLabel();
                this.titleLabel.setName("JLabel1");
                this.titleLabel.setFont(new Font("sansserif", 1, 24));
                this.titleLabel.setText("Configuration Initialization");
                this.titleLabel.setForeground(new Color(0, 0, 0));
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.titleLabel;
    }

    private JPanel getTitlePanel() {
        if (this.titlePanel == null) {
            try {
                this.titlePanel = new JPanel();
                this.titlePanel.setName("TitlePanel");
                this.titlePanel.setLayout(new FlowLayout());
                this.titlePanel.add((Component)this.getTitleLabel());
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.titlePanel;
    }

    private JTextField getValueField(int n) {
        int n2;
        this.valueFieldVector.ensureCapacity(n);
        int n3 = n2 = this.valueFieldVector.size();
        while (n3 <= n) {
            this.valueFieldVector.addElement(null);
            ++n3;
        }
        JTextField jTextField = (JTextField)this.valueFieldVector.elementAt(n);
        if (jTextField == null) {
            try {
                jTextField = new JTextField();
                int n4 = (Integer)this.configLines.elementAt(n);
                String string = this.lines.elementAt(n4).toString();
                int n5 = string.indexOf("=");
                String string2 = null;
                if (n5 > 0 && string.length() > n5 + 1) {
                    string2 = string.substring(n5 + 1);
                }
                jTextField.setText(string2);
                jTextField.addCaretListener((CaretListener)this);
                this.valueFieldVector.setElementAt(jTextField, n);
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return jTextField;
    }

    private void handleException(Throwable throwable) {
    }

    private void initConnections() {
        this.getResetButton().addActionListener((ActionListener)this);
        this.getCancelButton().addActionListener((ActionListener)this);
        this.getOkButton().addActionListener((ActionListener)this);
        this.getStartButton().addActionListener((ActionListener)this);
        this.getPreviousButton().addActionListener((ActionListener)this);
        this.getNextButton().addActionListener((ActionListener)this);
        this.getSummaryButton().addActionListener((ActionListener)this);
    }

    private void initialize() {
        ((Component)((Object)this)).setName("EditConfig");
        this.setDefaultCloseOperation(2);
        this.setContentPane((Container)this.getJFrameContentPane());
        this.initConnections();
        this.componentCount = this.getCardPanel().getComponentCount();
        this.currentCard = 0;
        this.setDescription();
        ((Window)((Object)this)).pack();
    }

    protected void loadDefaults(String string) {
        this.setDefaultProperties(this.loadProperties(string));
    }

    public Properties loadProperties(String string) {
        try {
            LineNumberReader lineNumberReader = new LineNumberReader(new FileReader(string));
            if (lineNumberReader == null) {
                System.out.println("null reader");
            }
            StringBuffer stringBuffer = new StringBuffer();
            String string2 = lineNumberReader.readLine();
            int n = -1;
            while (string2 != null) {
                ++n;
                string2 = string2.trim();
                int n2 = string2.indexOf("=");
                if (string2.startsWith("#") || string2.equals("") || n2 <= 0) {
                    this.lines.addElement(string2);
                    if (string2.startsWith("#")) {
                        stringBuffer.append(string2.substring(0));
                        stringBuffer.append('\n');
                    } else if (!string2.equals("")) {
                        stringBuffer.append(string2);
                        stringBuffer.append('\n');
                    }
                    string2 = lineNumberReader.readLine();
                    continue;
                }
                String string3 = null;
                if (string2.startsWith("*")) {
                    this.lines.addElement(string2.substring(1));
                    this.configLines.addElement(new Integer(n));
                    string3 = string2.substring(1, n2).trim();
                } else {
                    this.lines.addElement(string2);
                    string3 = string2.substring(0, n2).trim();
                }
                this.description.put(string3, stringBuffer.toString());
                stringBuffer.setLength(0);
                string2 = lineNumberReader.readLine();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("File " + string + " not found: " + fileNotFoundException);
        }
        catch (IOException iOException) {
            System.out.println("IO Exception in loading properties: " + iOException);
        }
        return null;
    }

    public static void main(String[] stringArray) {
        try {
            String string = DEFAULT_PROPERTIES;
            if (stringArray.length > 0) {
                string = stringArray[0];
            }
            EditConfig editConfig = new EditConfig(string);
            ((Component)((Object)editConfig)).setVisible(true);
            if (stringArray.length > 1) {
                editConfig.setConfigFile(stringArray[1]);
            }
        }
        catch (Throwable throwable) {
            System.err.println("Exception occurred in main() of EditConfig");
            throwable.printStackTrace(System.out);
        }
    }

    private void nextButtonClicked() {
        ((CardLayout)this.getCardPanel().getLayout()).next((Container)this.getCardPanel());
        this.currentCard = (this.currentCard + 1) % this.componentCount;
        this.setDescription();
        if (this.currentCard == this.componentCount - 1) {
            this.getNextButton().setEnabled(false);
            this.getSummaryButton().setEnabled(false);
        }
        this.getStartButton().setEnabled(true);
        this.getPreviousButton().setEnabled(true);
    }

    private void previousButtonClicked() {
        ((CardLayout)this.getCardPanel().getLayout()).previous((Container)this.getCardPanel());
        this.currentCard = (this.currentCard - 1) % this.componentCount;
        if (this.currentCard < 0) {
            this.currentCard += this.componentCount;
        }
        this.setDescription();
        if (this.currentCard == 0) {
            this.getStartButton().setEnabled(false);
            this.getPreviousButton().setEnabled(false);
        }
        this.getNextButton().setEnabled(true);
        this.getSummaryButton().setEnabled(true);
    }

    protected void resetToDefaults() {
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.getScrollPaneTable().getModel();
        while (defaultTableModel.getRowCount() > 0) {
            defaultTableModel.removeRow(0);
        }
        int n = 0;
        while (n < this.configLines.size()) {
            Vector<String> vector = new Vector<String>(2);
            int n2 = (Integer)this.configLines.elementAt(n);
            String string = this.lines.elementAt(n2).toString();
            String string2 = string.substring(0, string.indexOf("="));
            String string3 = string.substring(string.indexOf("=") + 1);
            vector.addElement(string2);
            vector.addElement(string3);
            System.out.println(vector);
            defaultTableModel.addRow(vector);
            ++n;
        }
    }

    public void saveFile() {
        try {
            FileWriter fileWriter = new FileWriter(this.configFile, false);
            PrintWriter printWriter = new PrintWriter((Writer)fileWriter, true);
            DefaultTableModel defaultTableModel = (DefaultTableModel)this.getScrollPaneTable().getModel();
            int n = 0;
            while (n < defaultTableModel.getRowCount()) {
                int n2 = (Integer)this.configLines.elementAt(n);
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(defaultTableModel.getValueAt(n, 0).toString().trim());
                stringBuffer.append(" = ");
                stringBuffer.append(defaultTableModel.getValueAt(n, 1).toString().trim());
                this.lines.setElementAt(stringBuffer, n2);
                ++n;
            }
            n = 0;
            while (n < this.lines.size()) {
                printWriter.println(this.lines.elementAt(n).toString());
                ++n;
            }
            fileWriter.close();
            this.saved = true;
            this.fireConfigurationSaved();
            this.exit();
        }
        catch (IOException iOException) {
            System.out.println("error occurred while writing file: " + iOException);
        }
    }

    public void setConfigFile(String string) {
        this.configFile = string;
    }

    public void setDefaultProperties(Properties properties) {
        this.defaultProperties = new Properties();
        if (properties != null) {
            Enumeration<?> enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                if (string.toLowerCase().endsWith("_description")) {
                    String string2 = string.substring(0, string.lastIndexOf("_"));
                    System.out.println(string2);
                    this.description.put(string2, properties.getProperty(string));
                    continue;
                }
                ((Hashtable)this.defaultProperties).put(string, properties.getProperty(string));
            }
        }
    }

    protected void setDescription() {
        if (this.currentCard < this.configLines.size()) {
            int n = (Integer)this.configLines.elementAt(this.currentCard);
            String string = this.lines.elementAt(n).toString();
            String string2 = string.substring(0, string.indexOf("=")).trim();
            System.out.println("NAME: |" + string2 + "|");
            String string3 = (String)this.description.get(string2);
            System.out.println("DESC: " + string3);
            if (string3 != null) {
                this.getDescriptionField().setText(string3);
            } else {
                this.getDescriptionField().setText("");
            }
        } else {
            this.getDescriptionField().setText("");
        }
    }

    private void startButtonClicked() {
        ((CardLayout)this.getCardPanel().getLayout()).first((Container)this.getCardPanel());
        this.currentCard = 0;
        this.setDescription();
        this.getStartButton().setEnabled(false);
        this.getPreviousButton().setEnabled(false);
        this.getNextButton().setEnabled(true);
        this.getSummaryButton().setEnabled(true);
    }

    private void summaryButtonClicked() {
        ((CardLayout)this.getCardPanel().getLayout()).last((Container)this.getCardPanel());
        this.currentCard = this.componentCount;
        this.setDescription();
        this.getStartButton().setEnabled(true);
        this.getPreviousButton().setEnabled(true);
        this.getNextButton().setEnabled(false);
        this.getSummaryButton().setEnabled(false);
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        int n = listSelectionEvent.getFirstIndex();
        System.out.println(n);
        if (n >= 0) {
            String string = (String)((DefaultTableModel)this.getScrollPaneTable().getModel()).getValueAt(n, 0);
            String string2 = (String)this.description.get(string);
            this.getDescriptionField().setText(string2);
        } else {
            this.getDescriptionField().setText("");
        }
    }
}

