/*
 * Decompiled with CFR 0.152.
 */
package ogi.cq.alp.install;

import com.sun.java.swing.BoxLayout;
import com.sun.java.swing.DefaultListModel;
import com.sun.java.swing.JButton;
import com.sun.java.swing.JCheckBox;
import com.sun.java.swing.JDialog;
import com.sun.java.swing.JFrame;
import com.sun.java.swing.JLabel;
import com.sun.java.swing.JList;
import com.sun.java.swing.JPanel;
import com.sun.java.swing.JScrollPane;
import com.sun.java.swing.JSplitPane;
import com.sun.java.swing.JTabbedPane;
import com.sun.java.swing.JTextArea;
import com.sun.java.swing.JTextField;
import com.sun.java.swing.ListModel;
import com.sun.java.swing.event.ListSelectionEvent;
import com.sun.java.swing.event.ListSelectionListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Hashtable;
import java.util.Vector;
import ogi.cq.alp.install.TaskEvent;
import ogi.cq.alp.install.TaskExecuter;
import ogi.cq.alp.install.TaskListener;
import ogi.cq.gui.InfoDialog;
import ogi.cq.gui.Spinner;
import ogi.cq.log.Log;
import ogi.cq.log.OutLog;

public class ConfigGUI
extends JFrame
implements ActionListener,
ListSelectionListener,
TaskListener {
    public static final String DEFAULT_PROPERTIES = "configScript";
    Hashtable description = new Hashtable();
    private Vector configLines = new Vector();
    boolean[] finishedTask;
    Hashtable tasks;
    Hashtable results;
    Hashtable taskMap = new Hashtable();
    int taskCount = 0;
    Log logger;
    JPanel mainPanel;
    JPanel titlePanel;
    JPanel taskPanel;
    JList taskList;
    JTextArea taskDescription;
    JPanel resultPanel;
    JTabbedPane resultTab;
    JPanel buttonPanel;
    JButton nextButton;
    JButton backButton;
    JButton checkButton;
    JButton cancelButton;
    JPanel contiguousPanel;
    JCheckBox contCheck;
    JPanel statusPanel;
    JTextField status;
    Spinner spinner;
    JDialog exitDialog;
    JButton okExitButton;
    JButton cancelExitButton;
    boolean beginning = true;
    int completed = 0;
    int timeout;
    public static final int DEFAULT_TIMEOUT = 1000;

    public ConfigGUI(String string) {
        this(string, "CQ Configuration");
    }

    public ConfigGUI(String string, String string2) {
        super(string2);
        this.loadScript(string);
        this.initialize();
        ((Component)((Object)this)).setSize(640, 480);
        try {
            this.logger = new OutLog(new PrintWriter((Writer)new FileWriter("config.log"), true));
        }
        catch (Exception exception) {
            System.out.println("Failed to create log");
            this.logger = new OutLog();
        }
        this.beginning = false;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.nextButton) {
            this.runNextTask();
        } else if (actionEvent.getSource() == this.backButton) {
            this.previous();
        } else if (actionEvent.getSource() == this.checkButton) {
            this.checkTasks();
        } else if (actionEvent.getSource() == this.cancelButton) {
            boolean bl = false;
            int n = 0;
            while (n < this.finishedTask.length) {
                if (!this.finishedTask[n]) {
                    bl = true;
                    break;
                }
                ++n;
            }
            if (!bl) {
                this.finish();
            } else {
                this.getExitDialog().show();
            }
        } else if (actionEvent.getSource() == this.okExitButton) {
            ((Component)((Object)this)).setVisible(false);
            ((Window)((Object)this)).dispose();
            System.exit(0);
        } else if (actionEvent.getSource() == this.cancelExitButton) {
            this.getExitDialog().setVisible(false);
        }
    }

    private void addTask(String string, String string2) {
        if (this.tasks == null) {
            this.tasks = new Hashtable();
        }
        this.tasks.put(string, string2);
        if (this.results == null) {
            this.results = new Hashtable();
        }
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JTextArea jTextArea = new JTextArea();
        JScrollPane jScrollPane = new JScrollPane((Component)jTextArea);
        jPanel.add((Component)jScrollPane, "Center");
        this.results.put(string, jTextArea);
        ++this.taskCount;
        this.getResultPanel();
        this.resultTab.add("Task " + this.taskCount, (Component)jPanel);
    }

    protected void checkTasks() {
        boolean bl = false;
        int n = 0;
        while (n < this.finishedTask.length) {
            if (!this.finishedTask[n]) {
                ((Dialog)((Object)new InfoDialog("Task " + (n + 1) + "has not been finished", this))).show();
                bl = true;
                break;
            }
            ++n;
        }
        if (!bl) {
            this.finish();
        }
    }

    protected void executeTask(int n) {
        if (n >= 0 && n < this.finishedTask.length) {
            String string = this.configLines.elementAt(n).toString();
            int n2 = string.indexOf("=");
            String string2 = string.substring(0, n2).trim();
            String string3 = (String)this.tasks.get(string2);
            System.out.println(string3);
            JTextArea jTextArea = (JTextArea)this.results.get(string2);
            if (jTextArea == null) {
                System.out.println("error in getting description for " + string2);
            }
            if (string3 == null) {
                System.out.println("error in getting task for " + string2);
            }
            if (!this.finishedTask[n]) {
                this.nextButton.setEnabled(false);
                TaskExecuter taskExecuter = new TaskExecuter(string2, string3, jTextArea);
                taskExecuter.addTaskListener(this);
                taskExecuter.setLogger(this.logger);
                this.taskMap.put(taskExecuter, new Integer(n));
                Thread thread = new Thread(taskExecuter);
                thread.start();
            } else {
                jTextArea.append("\nTask already completed");
            }
        }
    }

    protected void finish() {
        ((Dialog)((Object)new InfoDialog("All tasks completed", this))).show();
        ((Component)((Object)this)).setVisible(false);
        ((Window)((Object)this)).dispose();
        System.exit(0);
    }

    private JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            try {
                this.buttonPanel = new JPanel();
                this.buttonPanel.setName("buttonPanel");
                this.buttonPanel.setLayout(new FlowLayout());
                this.cancelButton = new JButton("Cancel");
                this.cancelButton.addActionListener((ActionListener)this);
                this.cancelButton.setBackground(Color.red);
                this.buttonPanel.add((Component)this.cancelButton);
                this.backButton = new JButton("Back");
                this.backButton.addActionListener((ActionListener)this);
                this.backButton.setEnabled(false);
                this.buttonPanel.add((Component)this.backButton);
                this.nextButton = new JButton("Next");
                this.nextButton.addActionListener((ActionListener)this);
                this.nextButton.setBackground(Color.green);
                this.buttonPanel.add((Component)this.nextButton);
                this.checkButton = new JButton("Finish");
                this.checkButton.addActionListener((ActionListener)this);
                this.checkButton.setBackground(Color.orange);
                this.checkButton.setEnabled(false);
                this.buttonPanel.add((Component)this.checkButton);
            }
            catch (Throwable throwable) {
                System.out.println("error in getting button panel: " + throwable);
            }
        }
        return this.buttonPanel;
    }

    private JPanel getContiguousPanel() {
        if (this.contiguousPanel == null) {
            try {
                this.contiguousPanel = new JPanel();
                this.contiguousPanel.setName("contiguousPanel");
                this.contiguousPanel.setLayout(new FlowLayout());
                this.contCheck = new JCheckBox("Standard Install (uncheck to proceed step by step)");
                this.contCheck.getModel().setSelected(true);
                this.contiguousPanel.add((Component)this.contCheck);
            }
            catch (Throwable throwable) {
                System.out.println("error in getting contiguous panel: " + throwable);
            }
        }
        return this.contiguousPanel;
    }

    private JDialog getExitDialog() {
        if (this.exitDialog == null) {
            try {
                this.exitDialog = new JDialog();
                this.exitDialog.setName("ExitDialog");
                this.exitDialog.setDefaultCloseOperation(2);
                this.exitDialog.setModal(true);
                this.exitDialog.setTitle("Exit Dialog");
                JPanel jPanel = new JPanel();
                jPanel.setName("JPanel2");
                jPanel.setLayout(new BorderLayout());
                JLabel jLabel = new JLabel();
                jLabel.setName("ExitLabel");
                jLabel.setText("Do you really want to exit? You will need to configure JCQ later for it to run properly.");
                jPanel.add((Component)jLabel, "Center");
                JPanel jPanel2 = new JPanel();
                jPanel2.setLayout(new FlowLayout());
                this.okExitButton = new JButton();
                this.okExitButton.setText("OK");
                this.okExitButton.addActionListener((ActionListener)this);
                jPanel2.add((Component)this.okExitButton);
                this.cancelExitButton = new JButton();
                this.cancelExitButton.setText("Cancel");
                this.cancelExitButton.addActionListener((ActionListener)this);
                jPanel2.add((Component)this.cancelExitButton);
                jPanel.add((Component)jPanel2, "South");
                this.getExitDialog().setContentPane((Container)jPanel);
                this.exitDialog.pack();
            }
            catch (Exception exception) {
                System.out.println("Error in get Exit dialog: " + exception);
                exception.printStackTrace();
            }
        }
        return this.exitDialog;
    }

    private JPanel getJFrameContentPane() {
        if (this.mainPanel == null) {
            try {
                this.mainPanel = new JPanel();
                this.mainPanel.setName("JFrameContentPane");
                this.mainPanel.setLayout(new BorderLayout());
                this.mainPanel.add((Component)this.getTitlePanel(), "North");
                JSplitPane jSplitPane = new JSplitPane(0, (Component)this.getTaskPanel(), (Component)this.getResultPanel());
                this.mainPanel.add((Component)jSplitPane, "Center");
                JPanel jPanel = new JPanel();
                jPanel.setLayout(new BorderLayout());
                jPanel.add((Component)this.getContiguousPanel(), "North");
                jPanel.add((Component)this.getButtonPanel(), "Center");
                jPanel.add((Component)this.getStatusPanel(), "South");
                this.mainPanel.add((Component)jPanel, "South");
            }
            catch (Throwable throwable) {
                System.out.println("error in creating main content panel");
            }
        }
        return this.mainPanel;
    }

    private JPanel getResultPanel() {
        if (this.resultPanel == null) {
            try {
                this.resultPanel = new JPanel();
                this.resultPanel.setName("resultPanel");
                this.resultPanel.setLayout(new BorderLayout());
                this.resultPanel.add((Component)new JLabel("Result of configuration task"), "North");
                this.resultTab = new JTabbedPane();
                this.resultPanel.add((Component)this.resultTab, "Center");
            }
            catch (Throwable throwable) {
                System.out.println("error in getting result panel: " + throwable);
            }
        }
        return this.resultPanel;
    }

    private JPanel getStatusPanel() {
        if (this.statusPanel == null) {
            try {
                this.statusPanel = new JPanel();
                this.statusPanel.setName("statusPanel");
                this.statusPanel.setLayout((LayoutManager)new BoxLayout((Container)this.statusPanel, 0));
                this.status = new JTextField("status");
                this.status.setBackground(Color.lightGray);
                this.status.setEditable(false);
                this.statusPanel.add((Component)this.status);
                this.spinner = new Spinner();
                this.statusPanel.add((Component)((Object)this.spinner));
            }
            catch (Throwable throwable) {
                System.out.println("error in getting status panel: " + throwable);
            }
        }
        return this.statusPanel;
    }

    private JPanel getTaskPanel() {
        if (this.taskPanel == null) {
            try {
                String string;
                String string2;
                JPanel jPanel = new JPanel();
                jPanel.setLayout(new BorderLayout());
                JLabel jLabel = new JLabel("Task List");
                Font font = new Font("serif", 1, 20);
                jLabel.setFont(font);
                jLabel.setForeground(Color.blue);
                jPanel.add((Component)jLabel, "North");
                this.taskList = new JList();
                this.taskList.setModel((ListModel)new DefaultListModel());
                this.taskList.addListSelectionListener((ListSelectionListener)this);
                int n = 0;
                while (n < this.configLines.size()) {
                    string2 = this.configLines.elementAt(n).toString();
                    string = string2.substring(0, string2.indexOf("=")).trim();
                    string = n + 1 + ") " + string;
                    ((DefaultListModel)this.taskList.getModel()).addElement((Object)string);
                    ++n;
                }
                this.taskList.getSelectionModel().setSelectionInterval(0, 0);
                jPanel.add((Component)this.taskList, "Center");
                JPanel jPanel2 = new JPanel();
                jPanel2.setLayout(new BorderLayout());
                string2 = new JLabel("Task Description");
                string2.setFont(font);
                ((Component)((Object)string2)).setForeground(Color.blue);
                jPanel2.add((Component)((Object)string2), "North");
                this.taskDescription = new JTextArea();
                jPanel2.add((Component)this.taskDescription, "Center");
                string = new JSplitPane(1, (Component)jPanel, (Component)jPanel2);
                this.taskPanel = new JPanel();
                this.taskPanel.setLayout(new BorderLayout());
                this.taskPanel.add((Component)((Object)string), "Center");
                this.taskPanel.setName("taskPanel");
            }
            catch (Throwable throwable) {
                System.out.println("error in getting task panel: " + throwable);
            }
        }
        return this.taskPanel;
    }

    private JPanel getTitlePanel() {
        if (this.titlePanel == null) {
            try {
                this.titlePanel = new JPanel();
                this.titlePanel.setName("TitlePanel");
                this.titlePanel.setLayout(new FlowLayout());
                Font font = new Font("sansserif", 1, 36);
                JLabel jLabel = new JLabel("CQ Configuration");
                jLabel.setFont(font);
                jLabel.setForeground(Color.black);
                this.titlePanel.add((Component)jLabel);
            }
            catch (Throwable throwable) {
                System.out.println("error in getting title panel: " + throwable);
            }
        }
        return this.titlePanel;
    }

    private void initialize() {
        ((Component)((Object)this)).setName("Configuration Script");
        this.setDefaultCloseOperation(2);
        this.setContentPane((Container)this.getJFrameContentPane());
        this.setDescription(0);
    }

    public void loadScript(String string) {
        System.out.println("load script from: " + string);
        try {
            LineNumberReader lineNumberReader = new LineNumberReader(new FileReader(string));
            if (lineNumberReader == null) {
                System.out.println("null reader");
            }
            StringBuffer stringBuffer = new StringBuffer();
            String string2 = lineNumberReader.readLine();
            if (string2 != null && string2.trim().startsWith("pause")) {
                String string3 = string2.trim().substring(string2.trim().indexOf(":") + 1);
                try {
                    this.timeout = Integer.parseInt(string3);
                }
                catch (NumberFormatException numberFormatException) {
                    this.timeout = 1000;
                }
                string2 = lineNumberReader.readLine();
            } else {
                this.timeout = 1000;
            }
            int n = -1;
            while (string2 != null) {
                ++n;
                string2 = string2.trim();
                int n2 = string2.indexOf("=");
                if (string2.startsWith("#") || string2.equals("") || n2 <= 0) {
                    if (string2.startsWith("#")) {
                        stringBuffer.append(string2.substring(1));
                        stringBuffer.append('\n');
                    } else if (n2 <= 0) {
                        stringBuffer.append(string2);
                    }
                    string2 = lineNumberReader.readLine();
                    continue;
                }
                this.configLines.addElement(string2);
                String string4 = string2.substring(0, n2).trim();
                String string5 = string2.substring(n2 + 1).trim();
                this.addTask(string4, string5);
                this.description.put(string4, stringBuffer.toString());
                stringBuffer.setLength(0);
                string2 = lineNumberReader.readLine();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("File " + string + " not found: " + fileNotFoundException);
        }
        catch (IOException iOException) {
            System.out.println("IO Exception in loading properties: " + iOException);
        }
        this.finishedTask = new boolean[this.configLines.size()];
    }

    public static void main(String[] stringArray) {
        try {
            String string = DEFAULT_PROPERTIES;
            if (stringArray.length > 0) {
                string = stringArray[0];
            }
            ConfigGUI configGUI = new ConfigGUI(string);
            ((Component)((Object)configGUI)).setVisible(true);
        }
        catch (Throwable throwable) {
            System.err.println("Exception occurred in main() of ConfigGUI");
            throwable.printStackTrace(System.out);
        }
    }

    protected void previous() {
        int n = this.taskList.getSelectedIndex();
        if (n > 0) {
            --n;
        } else {
            this.backButton.setEnabled(false);
        }
        this.checkButton.setEnabled(false);
        this.taskList.setSelectedIndex(n);
        this.setDescription(n);
    }

    protected void runAllTasks() {
        int n = 0;
        while (n < this.finishedTask.length) {
            if (!this.finishedTask[n]) {
                this.executeTask(n);
            }
            ++n;
        }
    }

    protected void runNextTask() {
        int n = this.taskList.getSelectedIndex();
        System.out.println(n);
        if (n < 0) {
            return;
        }
        this.nextButton.setEnabled(false);
        this.executeTask(n);
        try {
            if (n + 1 < this.taskList.getModel().getSize()) {
                this.taskList.setSelectedIndex(n + 1);
                this.nextButton.setEnabled(false);
                this.setDescription(n + 1);
                this.backButton.setEnabled(true);
            } else {
                this.taskList.setSelectedIndex(-1);
                this.nextButton.setEnabled(false);
                this.setDescription(-1);
                this.backButton.setEnabled(false);
                this.checkButton.setEnabled(true);
            }
        }
        catch (Exception exception) {
            System.out.println("error: " + exception);
        }
        this.resultTab.setSelectedIndex(n);
    }

    protected void setDescription(int n) {
        if (n >= 0 && n < this.configLines.size()) {
            String string = this.configLines.elementAt(n).toString();
            String string2 = string.substring(0, string.indexOf("=")).trim();
            String string3 = (String)this.description.get(string2);
            if (string3 != null) {
                this.taskDescription.setText(string3);
            } else {
                this.taskDescription.setText("");
            }
        } else {
            this.taskDescription.setText("");
        }
    }

    public void taskFinished(TaskEvent taskEvent) {
        if (taskEvent.getFailed()) {
            System.out.println("Task failed");
            int n = this.taskList.getSelectedIndex();
            n = n > 0 ? --n : this.taskList.getModel().getSize() - 1;
            this.taskList.setSelectedIndex(n);
            this.setDescription(n);
            this.backButton.setEnabled(true);
            this.checkButton.setEnabled(false);
        } else {
            System.out.println("Task succeeded");
            Object object = taskEvent.getSource();
            Integer n = (Integer)this.taskMap.get(object);
            this.finishedTask[n.intValue()] = true;
            this.completed = n;
            this.nextButton.setEnabled(true);
            if (this.contCheck.getModel().isSelected()) {
                if (n + 1 < this.taskList.getModel().getSize()) {
                    this.taskList.setSelectedIndex(n + 1);
                } else {
                    this.taskList.setSelectedIndex(-1);
                }
                try {
                    Thread.sleep(this.timeout);
                }
                catch (Exception exception) {}
                this.runNextTask();
            }
        }
        this.nextButton.setEnabled(true);
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (!this.beginning) {
            int n = listSelectionEvent.getFirstIndex();
            if (n >= 0) {
                String string = ((DefaultListModel)this.taskList.getModel()).getElementAt(n).toString().trim();
                string = string.substring(string.indexOf(")") + 1).trim();
                String string2 = (String)this.description.get(string);
                this.taskDescription.setText(string2);
            } else {
                this.taskDescription.setText("");
            }
            if (n > 0) {
                this.backButton.setEnabled(true);
                this.checkButton.setEnabled(false);
                this.nextButton.setEnabled(true);
            } else {
                this.backButton.setEnabled(false);
                if (n == 0) {
                    this.checkButton.setEnabled(false);
                } else {
                    this.checkButton.setEnabled(true);
                    this.nextButton.setEnabled(false);
                }
            }
            this.resultTab.setSelectedIndex(n);
        }
    }
}

