/*
 * Decompiled with CFR 0.152.
 */
package ogi.cq.alp.install;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.util.Properties;

public class AppendFile {
    private static void append(String string, String string2) {
        LineNumberReader lineNumberReader;
        PrintWriter printWriter;
        try {
            printWriter = new PrintWriter(new FileWriter(string, true));
        }
        catch (IOException iOException) {
            System.out.println("Error in opening " + string + " for writing; skipping file: " + iOException);
            return;
        }
        try {
            lineNumberReader = new LineNumberReader(new FileReader(string2));
        }
        catch (IOException iOException) {
            System.out.println("Error in opening " + string2 + " for reading; skipping file: " + iOException);
            return;
        }
        if (printWriter == null || lineNumberReader == null) {
            System.out.println("Error in opening files: " + string + " OR " + string2);
            return;
        }
        try {
            String string3 = lineNumberReader.readLine();
            while (string3 != null) {
                printWriter.println(string3);
                string3 = lineNumberReader.readLine();
            }
            printWriter.flush();
        }
        catch (IOException iOException) {
            System.out.println("Error in appending " + string2 + " to " + string + ": " + iOException);
            return;
        }
    }

    private static void appendFiles(Properties properties) {
        int n = 1;
        String string = properties.getProperty("FILE" + n);
        String string2 = properties.getProperty("APPEND" + n);
        while (string != null && !string.trim().equals("") && string2 != null && !string2.trim().equals("")) {
            AppendFile.append(string, string2);
            string = properties.getProperty("FILE" + ++n);
            string2 = properties.getProperty("APPEND" + n);
        }
    }

    public static Properties loadProperties(String string) {
        Properties properties = null;
        try {
            properties = new Properties(System.getProperties());
            properties.load(new BufferedInputStream(new FileInputStream(string)));
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("ERROR:  Could not open: " + string);
            return null;
        }
        catch (IOException iOException) {
            System.out.println("loadProperties " + iOException);
            return null;
        }
        return properties;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 1) {
            AppendFile.usage();
            System.exit(0);
        }
        Properties properties = AppendFile.loadProperties(stringArray[0]);
        AppendFile.appendFiles(properties);
    }

    public static void usage() {
        System.out.println("Usage: AppendFile  <property File>");
        System.out.println("<Property File> is the file that contains a list of files");
        System.out.println("to append to, and the file to be appended.");
        System.out.println("");
        System.out.println("Example Properties:");
        System.out.println("FILE1:    file.text");
        System.out.println("APPEND1:  file.append");
        System.out.println("FILE2:    /home/user/smith/.cshrc");
        System.out.println("APPEND2:  /tmp/progenv.csh");
    }
}

