/*
 * Decompiled with CFR 0.152.
 */
package gnu.starlight.util;

public class Base64 {
    private static char[] alphabet = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=".toCharArray();
    private static byte[] codes = new byte[256];

    static {
        int n = 0;
        while (n < 256) {
            Base64.codes[n] = -1;
            ++n;
        }
        n = 65;
        while (n <= 90) {
            Base64.codes[n] = (byte)(n - 65);
            ++n;
        }
        n = 97;
        while (n <= 122) {
            Base64.codes[n] = (byte)(26 + n - 97);
            ++n;
        }
        n = 48;
        while (n <= 57) {
            Base64.codes[n] = (byte)(52 + n - 48);
            ++n;
        }
        Base64.codes[43] = 62;
        Base64.codes[47] = 63;
    }

    public static byte[] decode(char[] cArray) {
        int n = (cArray.length + 3) / 4 * 3;
        if (cArray.length > 0 && cArray[cArray.length - 1] == '=') {
            --n;
        }
        if (cArray.length > 1 && cArray[cArray.length - 2] == '=') {
            --n;
        }
        byte[] byArray = new byte[n];
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n5 < cArray.length) {
            byte by = codes[cArray[n5] & 0xFF];
            if (by >= 0) {
                n3 <<= 6;
                n3 |= by;
                if ((n2 += 6) >= 8) {
                    byArray[n4++] = (byte)(n3 >> (n2 -= 8) & 0xFF);
                }
            }
            ++n5;
        }
        if (n4 != byArray.length) {
            throw new Error("miscalculated data length!");
        }
        return byArray;
    }

    public static char[] encode(byte[] byArray) {
        char[] cArray = new char[(byArray.length + 2) / 3 * 4];
        int n = 0;
        int n2 = 0;
        while (n < byArray.length) {
            boolean bl = false;
            boolean bl2 = false;
            int n3 = 0xFF & byArray[n];
            n3 <<= 8;
            if (n + 1 < byArray.length) {
                n3 |= 0xFF & byArray[n + 1];
                bl2 = true;
            }
            n3 <<= 8;
            if (n + 2 < byArray.length) {
                n3 |= 0xFF & byArray[n + 2];
                bl = true;
            }
            cArray[n2 + 3] = alphabet[bl ? n3 & 0x3F : 64];
            cArray[n2 + 2] = alphabet[bl2 ? (n3 >>= 6) & 0x3F : 64];
            cArray[n2 + 1] = alphabet[(n3 >>= 6) & 0x3F];
            cArray[n2 + 0] = alphabet[(n3 >>= 6) & 0x3F];
            n += 3;
            n2 += 4;
        }
        return cArray;
    }
}

