/*
 * Decompiled with CFR 0.152.
 */
package gnu.regexp.util;

import gnu.regexp.RE;
import gnu.regexp.REException;
import gnu.regexp.REMatch;

public class Tests {
    private Tests() {
    }

    private static void check(REMatch rEMatch, String string, int n) {
        if (rEMatch == null || !rEMatch.toString().equals(string)) {
            System.out.print("Failed");
        } else {
            System.out.print("Passed");
        }
        System.out.println(" test #" + n);
    }

    public static void main(String[] stringArray) throws REException {
        RE rE = new RE("(.*)z");
        Tests.check(rE.getMatch("xxz"), "xxz", 1);
        rE = new RE(".*z");
        Tests.check(rE.getMatch("xxz"), "xxz", 2);
        rE = new RE("(x|xy)z");
        Tests.check(rE.getMatch("xz"), "xz", 3);
        Tests.check(rE.getMatch("xyz"), "xyz", 4);
        rE = new RE("(x)+z");
        Tests.check(rE.getMatch("xxz"), "xxz", 5);
        rE = new RE("abc");
        Tests.check(rE.getMatch("xyzabcdef"), "abc", 6);
        rE = new RE("^start.*end$");
        Tests.check(rE.getMatch("start here and go to the end"), "start here and go to the end", 7);
        rE = new RE("(x|xy)+z");
        Tests.check(rE.getMatch("xxyz"), "xxyz", 8);
        rE = new RE("type=([^ \t]+)[ \t]+exts=([^ \t\n\r]+)");
        Tests.check(rE.getMatch("type=text/html  exts=htm,html"), "type=text/html  exts=htm,html", 9);
        rE = new RE("(x)\\1");
        Tests.check(rE.getMatch("zxxz"), "xx", 10);
        rE = new RE("(x*)(y)\\2\\1");
        Tests.check(rE.getMatch("xxxyyxx"), "xxyyxx", 11);
        rE = new RE("[-go]+");
        Tests.check(rE.getMatch("go-go"), "go-go", 12);
        rE = new RE("[\\w-]+");
        Tests.check(rE.getMatch("go-go"), "go-go", 13);
        rE = new RE("^start.*?end");
        Tests.check(rE.getMatch("start here and end in the middle, not the very end"), "start here and end", 14);
        rE = new RE("\\d\\s\\w\\n\\r");
        Tests.check(rE.getMatch("  9\tX\n\r  "), "9\tX\n\r", 15);
        rE = new RE("zow", 2);
        Tests.check(rE.getMatch("ZoW"), "ZoW", 16);
        rE = new RE("(\\d+)\\D*(\\d+)\\D*(\\d)+");
        Tests.check(rE.getMatch("size--10 by 20 by 30 feet"), "10 by 20 by 30", 17);
        rE = new RE("(ab)(.*?)(d)");
        REMatch rEMatch = rE.getMatch("abcd");
        Tests.check(rEMatch, "abcd", 18);
        System.out.println(String.valueOf(rEMatch.toString(2).equals("c") ? "Pass" : "Fail") + "ed test #19");
    }
}

