/*
 * Decompiled with CFR 0.152.
 */
package com.objectspace.jgl.algorithms;

import com.objectspace.jgl.Array;
import com.objectspace.jgl.BinaryPredicate;
import com.objectspace.jgl.Container;
import com.objectspace.jgl.ForwardIterator;
import com.objectspace.jgl.Range;
import com.objectspace.jgl.Sequence;
import com.objectspace.jgl.algorithms.IteratorIterator;
import com.objectspace.jgl.algorithms.IteratorPredicate;
import com.objectspace.jgl.algorithms.xHashComparator;

public final class Sorting {
    static final int stlThreshold = 16;
    Sequence base;
    BinaryPredicate comparator;

    private Sorting() {
    }

    private Sorting(ForwardIterator forwardIterator, ForwardIterator forwardIterator2, BinaryPredicate binaryPredicate) {
        if (!forwardIterator.isCompatibleWith(forwardIterator2)) {
            throw new IllegalArgumentException("iterators not compatible");
        }
        if (!(forwardIterator.getContainer() instanceof Sequence)) {
            throw new IllegalArgumentException("iterator containers must be a Sequence");
        }
        this.base = (Sequence)forwardIterator.getContainer();
        this.comparator = binaryPredicate;
        int n = this.base.start().distance(forwardIterator);
        int n2 = this.base.start().distance(forwardIterator2);
        this.quickSortLoop(n, n2);
        this.finalInsertionSort(n, n2);
    }

    void finalInsertionSort(int n, int n2) {
        if (n2 - n > 16) {
            int n3 = n + 16;
            int n4 = n + 1;
            while (n4 < n3) {
                this.linearInsert(n, n4);
                ++n4;
            }
            n4 = n3;
            while (n4 < n2) {
                this.unguardedLinearInsert(n4, this.base.at(n4));
                ++n4;
            }
        } else {
            int n5 = n + 1;
            while (n5 < n2) {
                this.linearInsert(n, n5);
                ++n5;
            }
        }
    }

    public static Range iterSort(Container container) {
        return Sorting.iterSort(container.start(), container.finish());
    }

    public static Range iterSort(Container container, BinaryPredicate binaryPredicate) {
        return Sorting.iterSort(container.start(), container.finish(), binaryPredicate);
    }

    public static Range iterSort(ForwardIterator forwardIterator, ForwardIterator forwardIterator2) {
        return Sorting.iterSort(forwardIterator, forwardIterator2, new xHashComparator());
    }

    public static Range iterSort(ForwardIterator forwardIterator, ForwardIterator forwardIterator2, BinaryPredicate binaryPredicate) {
        if (!forwardIterator.isCompatibleWith(forwardIterator2)) {
            throw new IllegalArgumentException("iterators not compatible");
        }
        int n = forwardIterator.distance(forwardIterator2);
        Array array = new Array();
        array.ensureCapacity(n);
        ForwardIterator forwardIterator3 = (ForwardIterator)forwardIterator.clone();
        while (!forwardIterator3.equals(forwardIterator2)) {
            array.pushBack(forwardIterator3.clone());
            forwardIterator3.advance();
        }
        Sorting.sort(array, new IteratorPredicate(binaryPredicate));
        return new Range(new IteratorIterator(array.start(), forwardIterator.getContainer()), new IteratorIterator(array.finish(), forwardIterator.getContainer()));
    }

    void linearInsert(int n, int n2) {
        Object object = this.base.at(n2);
        if (this.comparator.execute(object, this.base.at(n))) {
            int n3 = n2;
            while (n3 > n) {
                this.base.put(n3, this.base.at(n3 - 1));
                --n3;
            }
            this.base.put(n, object);
        } else {
            this.unguardedLinearInsert(n2, object);
        }
    }

    void quickSortLoop(int n, int n2) {
        while (n2 - n > 16) {
            Object object = this.base.at(n);
            Object object2 = this.base.at(n + (n2 - n) / 2);
            Object object3 = this.base.at(n2 - 1);
            Object object4 = this.comparator.execute(object, object2) ? (this.comparator.execute(object2, object3) ? object2 : (this.comparator.execute(object, object3) ? object3 : object)) : (this.comparator.execute(object, object3) ? object : (this.comparator.execute(object2, object3) ? object3 : object2));
            int n3 = n;
            int n4 = n2;
            while (true) {
                if (this.comparator.execute(this.base.at(n3), object4)) {
                    ++n3;
                    continue;
                }
                --n4;
                while (this.comparator.execute(object4, this.base.at(n4))) {
                    --n4;
                }
                if (n3 >= n4) break;
                Object object5 = this.base.at(n3);
                this.base.put(n3++, this.base.at(n4));
                this.base.put(n4, object5);
            }
            if (n3 - n >= n2 - n3) {
                this.quickSortLoop(n3, n2);
                n2 = n3;
                continue;
            }
            this.quickSortLoop(n, n3);
            n = n3;
        }
    }

    public static void sort(ForwardIterator forwardIterator, ForwardIterator forwardIterator2) {
        Sorting.sort(forwardIterator, forwardIterator2, new xHashComparator());
    }

    public static void sort(ForwardIterator forwardIterator, ForwardIterator forwardIterator2, BinaryPredicate binaryPredicate) {
        new Sorting(forwardIterator, forwardIterator2, binaryPredicate);
    }

    public static void sort(Sequence sequence) {
        Sorting.sort(sequence.start(), sequence.finish(), new xHashComparator());
    }

    public static void sort(Sequence sequence, BinaryPredicate binaryPredicate) {
        Sorting.sort(sequence.start(), sequence.finish(), binaryPredicate);
    }

    void unguardedLinearInsert(int n, Object object) {
        int n2 = n - 1;
        while (this.comparator.execute(object, this.base.at(n2))) {
            this.base.put(n--, this.base.at(n2--));
        }
        this.base.put(n, object);
    }
}

